/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.glue;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.metastore.TableInfo;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergMetadata;
import io.trino.plugin.iceberg.TableStatisticsWriter;
import io.trino.plugin.iceberg.catalog.BaseTrinoCatalogTest;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.glue.GlueIcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.glue.IcebergGlueCatalogConfig;
import io.trino.plugin.iceberg.catalog.glue.TrinoGlueCatalog;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.MaterializedViewNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TypeManager;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingNames;
import io.trino.type.InternalTypeManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.services.glue.GlueClient;

public class TestTrinoGlueCatalog
extends BaseTrinoCatalogTest {
    private static final Logger LOG = Logger.get(TestTrinoGlueCatalog.class);

    @Override
    protected TrinoCatalog createTrinoCatalog(boolean useUniqueTableLocations) {
        return this.createGlueTrinoCatalog(useUniqueTableLocations, false);
    }

    private TrinoCatalog createGlueTrinoCatalog(boolean useUniqueTableLocations, boolean useSystemSecurity) {
        GlueClient glueClient = GlueClient.create();
        IcebergGlueCatalogConfig catalogConfig = new IcebergGlueCatalogConfig();
        return new TrinoGlueCatalog(new CatalogName("catalog_name"), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, (TypeManager)new TestingTypeManager(), catalogConfig.isCacheTableMetadata(), (IcebergTableOperationsProvider)new GlueIcebergTableOperationsProvider(InternalTypeManager.TESTING_TYPE_MANAGER, catalogConfig, (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new GlueMetastoreStats(), glueClient), "test", glueClient, new GlueMetastoreStats(), useSystemSecurity, Optional.empty(), useUniqueTableLocations, new IcebergConfig().isHideMaterializedViewStorageTable(), MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonLowercaseGlueDatabase() {
        String databaseName = "testNonLowercaseDatabase" + TestingNames.randomNameSuffix();
        String trinoSchemaName = databaseName.toLowerCase(Locale.ENGLISH);
        GlueClient glueClient = GlueClient.create();
        glueClient.createDatabase(database -> database.databaseInput(input -> input.name(databaseName)));
        try {
            TrinoCatalog catalog = this.createTrinoCatalog(false);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.namespaceExists(SESSION, databaseName)).as("catalog.namespaceExists(databaseName)", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.namespaceExists(SESSION, trinoSchemaName)).as("catalog.namespaceExists(trinoSchemaName)", new Object[0])).isTrue();
            ((ListAssert)((ListAssert)Assertions.assertThat((List)catalog.listNamespaces(SESSION)).as("catalog.listNamespaces", new Object[0])).doesNotContain((Object[])new String[]{databaseName})).contains((Object[])new String[]{trinoSchemaName});
            IcebergMetadata icebergMetadata = new IcebergMetadata(TestingPlannerContext.PLANNER_CONTEXT.getTypeManager(), CatalogHandle.fromId((String)"iceberg:NORMAL:v12345"), JsonCodec.jsonCodec(CommitTaskData.class), catalog, (connectorIdentity, fileIoProperties) -> {
                throw new UnsupportedOperationException();
            }, new TableStatisticsWriter(new NodeVersion("test-version")), Optional.empty(), false, string -> false, (ExecutorService)MoreExecutors.newDirectExecutorService(), MoreExecutors.directExecutor(), (ExecutorService)MoreExecutors.newDirectExecutorService());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)icebergMetadata.schemaExists(SESSION, databaseName)).as("icebergMetadata.schemaExists(databaseName)", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)icebergMetadata.schemaExists(SESSION, trinoSchemaName)).as("icebergMetadata.schemaExists(trinoSchemaName)", new Object[0])).isTrue();
            ((ListAssert)((ListAssert)Assertions.assertThat((List)icebergMetadata.listSchemaNames(SESSION)).as("icebergMetadata.listSchemaNames", new Object[0])).doesNotContain((Object[])new String[]{databaseName})).contains((Object[])new String[]{trinoSchemaName});
        }
        finally {
            glueClient.deleteDatabase(delete -> delete.name(databaseName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateMaterializedViewWithSystemSecurity() {
        TrinoCatalog glueTrinoCatalog = this.createGlueTrinoCatalog(false, true);
        String namespace = "test_create_mv_" + TestingNames.randomNameSuffix();
        String table = "materialized_view_name";
        SchemaTableName viewName = new SchemaTableName(namespace, table);
        ImmutableMap properties = ImmutableMap.of((Object)"location", (Object)"file:///tmp/a/path/");
        try {
            glueTrinoCatalog.createNamespace(SESSION, namespace, (Map)properties, new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
            glueTrinoCatalog.createMaterializedView(SESSION, viewName, new ConnectorMaterializedViewDefinition("CREATE * FROM tpch.tiny.nations", Optional.empty(), Optional.of("catalog_name"), Optional.of("schema_name"), (List)ImmutableList.of((Object)new ConnectorMaterializedViewDefinition.Column("col1", IntegerType.INTEGER.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), Optional.of("test_owner"), (List)ImmutableList.of()), (Map)ImmutableMap.of((Object)"format", (Object)IcebergFileFormat.PARQUET, (Object)"format_version", (Object)1), false, false);
            List<SchemaTableName> materializedViews = glueTrinoCatalog.listTables(SESSION, Optional.of(namespace)).stream().filter(info -> info.extendedRelationType() == TableInfo.ExtendedRelationType.TRINO_MATERIALIZED_VIEW).map(TableInfo::tableName).toList();
            Assertions.assertThat(materializedViews).hasSize(1);
            Assertions.assertThat((String)materializedViews.get(0).getTableName()).isEqualTo(table);
            Optional returned = glueTrinoCatalog.getMaterializedView(SESSION, materializedViews.get(0));
            Assertions.assertThat((Optional)returned).isPresent();
            Assertions.assertThat((Optional)((ConnectorMaterializedViewDefinition)returned.get()).getOwner()).isEmpty();
        }
        catch (Throwable throwable) {
            try {
                glueTrinoCatalog.dropMaterializedView(SESSION, viewName);
            }
            catch (MaterializedViewNotFoundException e) {
                LOG.warn("Failed to clean up view: %s", new Object[]{viewName});
            }
            try {
                glueTrinoCatalog.dropNamespace(SESSION, namespace);
            }
            catch (Exception e) {
                LOG.warn("Failed to clean up namespace: %s", new Object[]{namespace});
            }
            throw throwable;
        }
        try {
            glueTrinoCatalog.dropMaterializedView(SESSION, viewName);
        }
        catch (MaterializedViewNotFoundException e) {
            LOG.warn("Failed to clean up view: %s", new Object[]{viewName});
        }
        try {
            glueTrinoCatalog.dropNamespace(SESSION, namespace);
        }
        catch (Exception e) {
            LOG.warn("Failed to clean up namespace: %s", new Object[]{namespace});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultLocation() throws IOException {
        Path tmpDirectory = Files.createTempDirectory("test_glue_catalog_default_location_", new FileAttribute[0]);
        tmpDirectory.toFile().deleteOnExit();
        HdfsFileSystemFactory fileSystemFactory = HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY;
        GlueClient glueClient = GlueClient.create();
        IcebergGlueCatalogConfig catalogConfig = new IcebergGlueCatalogConfig();
        TrinoGlueCatalog catalogWithDefaultLocation = new TrinoGlueCatalog(new CatalogName("catalog_name"), (TrinoFileSystemFactory)fileSystemFactory, (TypeManager)new TestingTypeManager(), catalogConfig.isCacheTableMetadata(), (IcebergTableOperationsProvider)new GlueIcebergTableOperationsProvider(InternalTypeManager.TESTING_TYPE_MANAGER, catalogConfig, (TrinoFileSystemFactory)fileSystemFactory, new GlueMetastoreStats(), glueClient), "test", glueClient, new GlueMetastoreStats(), false, Optional.of(tmpDirectory.toAbsolutePath().toString()), false, new IcebergConfig().isHideMaterializedViewStorageTable(), MoreExecutors.directExecutor());
        String namespace = "test_default_location_" + TestingNames.randomNameSuffix();
        String table = "tableName";
        SchemaTableName schemaTableName = new SchemaTableName(namespace, table);
        catalogWithDefaultLocation.createNamespace(SESSION, namespace, (Map)ImmutableMap.of(), new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
        try {
            File expectedSchemaDirectory = new File(tmpDirectory.toFile(), namespace + ".db");
            File expectedTableDirectory = new File(expectedSchemaDirectory, schemaTableName.getTableName());
            Assertions.assertThat((String)catalogWithDefaultLocation.defaultTableLocation(SESSION, schemaTableName)).isEqualTo(expectedTableDirectory.toPath().toAbsolutePath().toString());
        }
        catch (Throwable throwable) {
            try {
                catalogWithDefaultLocation.dropNamespace(SESSION, namespace);
            }
            catch (Exception e) {
                LOG.warn("Failed to clean up namespace: %s", new Object[]{namespace});
            }
            throw throwable;
        }
        try {
            catalogWithDefaultLocation.dropNamespace(SESSION, namespace);
        }
        catch (Exception e) {
            LOG.warn("Failed to clean up namespace: %s", new Object[]{namespace});
        }
    }

    @Override
    protected void createMaterializedView(ConnectorSession session, TrinoCatalog catalog, SchemaTableName materializedView, ConnectorMaterializedViewDefinition materializedViewDefinition, Map<String, Object> properties, boolean replace, boolean ignoreExisting) {
        catalog.createMaterializedView(session, materializedView, materializedViewDefinition, (Map)ImmutableMap.builder().putAll(properties).put((Object)"location", (Object)("file:///tmp/a/path/" + materializedView.getTableName())).buildOrThrow(), replace, ignoreExisting);
    }
}

