/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.containers.Hive4MinioDataLake;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.sql.TestTable;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
final class TestIcebergHiveCatalogWithoutLock
extends AbstractTestQueryFramework {
    TestIcebergHiveCatalogWithoutLock() {
    }

    protected QueryRunner createQueryRunner() throws Exception {
        String bucketName = "test-bucket" + TestingNames.randomNameSuffix();
        Hive4MinioDataLake hiveMinioDataLake = (Hive4MinioDataLake)this.closeAfterClass((AutoCloseable)new Hive4MinioDataLake(bucketName));
        hiveMinioDataLake.start();
        return IcebergQueryRunner.builder().setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)"HIVE_METASTORE").put((Object)"hive.metastore.uri", (Object)hiveMinioDataLake.getHiveMetastoreEndpoint().toString()).put((Object)"iceberg.hive-catalog.locking-enabled", (Object)"false").put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)hiveMinioDataLake.getMinio().getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").buildOrThrow()).setSchemaInitializer(SchemaInitializer.builder().withSchemaName("tpch").withSchemaProperties(Map.of("location", "'s3://%s/tpch'".formatted(bucketName))).build()).build();
    }

    @Test
    void testCommitWithoutLock() {
        try (TestTable table = this.newTrinoTable("test_lock", "(x int)", List.of("1", "2", "3"));){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE x = 1", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES 2, 3");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE x = 2", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES 3");
        }
    }
}

