/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.hms;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.s3.S3FileSystemConfig;
import io.trino.filesystem.s3.S3FileSystemFactory;
import io.trino.filesystem.s3.S3FileSystemStats;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.Table;
import io.trino.metastore.TableInfo;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.base.util.AutoCloseableCloser;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.TrinoViewHiveMetastore;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.plugin.hive.containers.HiveMinioDataLake;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreFactory;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.catalog.BaseTrinoCatalogTest;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.hms.HiveMetastoreTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.hms.IcebergHiveCatalogConfig;
import io.trino.plugin.iceberg.catalog.hms.TrinoHiveCatalog;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TypeManager;
import io.trino.testing.TestingNames;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestTrinoHiveCatalogWithHiveMetastore
extends BaseTrinoCatalogTest {
    private static final Logger LOG = Logger.get(TestTrinoHiveCatalogWithHiveMetastore.class);
    private final AutoCloseableCloser closer = AutoCloseableCloser.create();
    private HiveMinioDataLake dataLake;
    private TrinoFileSystem fileSystem;
    private CachingHiveMetastore metastore;
    protected String bucketName;

    HiveMinioDataLake hiveMinioDataLake() {
        return new Hive3MinioDataLake(this.bucketName, HiveHadoop.HIVE3_IMAGE);
    }

    @BeforeAll
    public void setUp() {
        this.bucketName = "test-hive-catalog-with-hms-" + TestingNames.randomNameSuffix();
        this.dataLake = (HiveMinioDataLake)this.closer.register((AutoCloseable)this.hiveMinioDataLake());
        this.dataLake.start();
    }

    @AfterAll
    public void tearDown() throws Exception {
        this.dataLake = null;
        this.closer.close();
    }

    @Override
    protected TrinoCatalog createTrinoCatalog(boolean useUniqueTableLocations) {
        S3FileSystemFactory fileSystemFactory = new S3FileSystemFactory(OpenTelemetry.noop(), new S3FileSystemConfig().setEndpoint(this.dataLake.getMinio().getMinioAddress()).setAwsAccessKey("accesskey").setAwsSecretKey("secretkey").setRegion("us-east-1").setPathStyleAccess(true), new S3FileSystemStats());
        final ThriftMetastore thriftMetastore = TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().thriftMetastoreConfig(new ThriftMetastoreConfig().setReadTimeout(new Duration(1.0, TimeUnit.MINUTES))).metastoreClient(this.dataLake.getHiveMetastoreEndpoint()).build(arg_0 -> ((AutoCloseableCloser)this.closer).register(arg_0));
        this.metastore = CachingHiveMetastore.createPerTransactionCache((HiveMetastore)new BridgingHiveMetastore(thriftMetastore), (long)1000L);
        this.fileSystem = fileSystemFactory.create(SESSION);
        return new TrinoHiveCatalog(new CatalogName("catalog"), this.metastore, new TrinoViewHiveMetastore((HiveMetastore)this.metastore, false, "trino-version", "Test"), (TrinoFileSystemFactory)fileSystemFactory, (TypeManager)new TestingTypeManager(), (IcebergTableOperationsProvider)new HiveMetastoreTableOperationsProvider((TrinoFileSystemFactory)fileSystemFactory, new ThriftMetastoreFactory(){

            public boolean isImpersonationEnabled() {
                Verify.verify((boolean)new ThriftMetastoreConfig().isImpersonationEnabled(), (String)"This test wants to test the default behavior and assumes it's off", (Object[])new Object[0]);
                return false;
            }

            public ThriftMetastore createMetastore(Optional<ConnectorIdentity> identity) {
                return thriftMetastore;
            }
        }, new IcebergHiveCatalogConfig()), useUniqueTableLocations, false, false, this.isHideMaterializedViewStorageTable(), MoreExecutors.directExecutor());
    }

    protected boolean isHideMaterializedViewStorageTable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateMaterializedView() throws IOException {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        String namespace = "test_create_mv_" + TestingNames.randomNameSuffix();
        String materializedViewName = "materialized_view_name";
        try {
            String storageTableName;
            catalog.createNamespace(SESSION, namespace, this.defaultNamespaceProperties(namespace), new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
            catalog.createMaterializedView(SESSION, new SchemaTableName(namespace, materializedViewName), new ConnectorMaterializedViewDefinition("SELECT * FROM tpch.tiny.nation", Optional.empty(), Optional.of("catalog_name"), Optional.of("schema_name"), (List)ImmutableList.of((Object)new ConnectorMaterializedViewDefinition.Column("col1", IntegerType.INTEGER.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of()), (Map)ImmutableMap.of((Object)"format", (Object)IcebergFileFormat.PARQUET, (Object)"format_version", (Object)1), false, false);
            List<SchemaTableName> materializedViews = catalog.listTables(SESSION, Optional.of(namespace)).stream().filter(info -> info.extendedRelationType() == TableInfo.ExtendedRelationType.TRINO_MATERIALIZED_VIEW).map(TableInfo::tableName).toList();
            Assertions.assertThat(materializedViews).hasSize(1);
            Assertions.assertThat((String)materializedViews.getFirst().getTableName()).isEqualTo(materializedViewName);
            Optional materializedView = catalog.getMaterializedView(SESSION, materializedViews.getFirst());
            Assertions.assertThat((Optional)materializedView).isPresent();
            if (this.isHideMaterializedViewStorageTable()) {
                storageTableName = materializedViewName;
            } else {
                Optional storageTable = ((ConnectorMaterializedViewDefinition)materializedView.get()).getStorageTable();
                Assertions.assertThat((Optional)storageTable).isPresent();
                storageTableName = ((CatalogSchemaTableName)storageTable.get()).getSchemaTableName().getTableName();
            }
            Location dataLocation = Location.of((String)(this.getNamespaceLocation(namespace) + "/" + storageTableName));
            ((AbstractBooleanAssert)Assertions.assertThat((Boolean)((Boolean)this.fileSystem.directoryExists(dataLocation).orElseThrow())).describedAs("The directory corresponding to the table data for materialized view must exist", new Object[0])).isTrue();
            catalog.dropMaterializedView(SESSION, new SchemaTableName(namespace, materializedViewName));
            ((OptionalAssert)Assertions.assertThat((Optional)this.fileSystem.directoryExists(dataLocation)).describedAs("The materialized view drop should also delete the data files associated with it", new Object[0])).isEmpty();
        }
        catch (Throwable throwable) {
            try {
                catalog.dropNamespace(SESSION, namespace);
            }
            catch (Exception e) {
                LOG.warn("Failed to clean up namespace: %s", new Object[]{namespace});
            }
            throw throwable;
        }
        try {
            catalog.dropNamespace(SESSION, namespace);
        }
        catch (Exception e) {
            LOG.warn("Failed to clean up namespace: %s", new Object[]{namespace});
        }
    }

    @Override
    protected Optional<SchemaTableName> createExternalIcebergTable(TrinoCatalog catalog, String namespace, AutoCloseableCloser closer) throws Exception {
        return this.createTableWithTableType(catalog, namespace, closer, "lowercase_type", Optional.of("iceberg".toLowerCase(Locale.ENGLISH)));
    }

    @Override
    protected Optional<SchemaTableName> createExternalNonIcebergTable(TrinoCatalog catalog, String namespace, AutoCloseableCloser closer) throws Exception {
        return this.createTableWithTableType(catalog, namespace, closer, "non_iceberg_table", Optional.empty());
    }

    private Optional<SchemaTableName> createTableWithTableType(TrinoCatalog catalog, String namespace, AutoCloseableCloser closer, String tableName, Optional<String> tableType) throws Exception {
        SchemaTableName lowerCaseTableTypeTable = new SchemaTableName(namespace, tableName);
        catalog.newCreateTableTransaction(SESSION, lowerCaseTableTypeTable, new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"col1", (Type)Types.LongType.get())}), PartitionSpec.unpartitioned(), SortOrder.unsorted(), Optional.of(this.arbitraryTableLocation(catalog, SESSION, lowerCaseTableTypeTable)), (Map)ImmutableMap.of()).commitTransaction();
        Table metastoreTable = (Table)this.metastore.getTable(namespace, tableName).get();
        this.metastore.replaceTable(namespace, tableName, Table.builder((Table)metastoreTable).setParameter("table_type", tableType).build(), PrincipalPrivileges.NO_PRIVILEGES, (Map)ImmutableMap.of());
        closer.register(() -> this.metastore.dropTable(namespace, tableName, true));
        return Optional.of(lowerCaseTableTypeTable);
    }

    @Override
    protected Map<String, Object> defaultNamespaceProperties(String namespaceName) {
        return Map.of("location", this.getNamespaceLocation(namespaceName));
    }

    private String getNamespaceLocation(String namespaceName) {
        return "s3://%s/%s".formatted(this.bucketName, namespaceName);
    }
}

