/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.jdbc;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.iceberg.catalog.jdbc.IcebergJdbcCatalogConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestIcebergJdbcCatalogConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((IcebergJdbcCatalogConfig)ConfigAssertions.recordDefaults(IcebergJdbcCatalogConfig.class)).setDriverClass(null).setConnectionUrl(null).setConnectionUser(null).setConnectionPassword(null).setCatalogName(null).setDefaultWarehouseDir(null).setRetryableStatusCodes(null).setSchemaVersion(IcebergJdbcCatalogConfig.SchemaVersion.V1));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"iceberg.jdbc-catalog.driver-class", (Object)"org.postgresql.Driver").put((Object)"iceberg.jdbc-catalog.connection-url", (Object)"jdbc:postgresql://localhost:5432/test").put((Object)"iceberg.jdbc-catalog.connection-user", (Object)"foo").put((Object)"iceberg.jdbc-catalog.connection-password", (Object)"bar").put((Object)"iceberg.jdbc-catalog.catalog-name", (Object)"test").put((Object)"iceberg.jdbc-catalog.default-warehouse-dir", (Object)"s3://bucket").put((Object)"iceberg.jdbc-catalog.retryable-status-codes", (Object)"57P01,57P05").put((Object)"iceberg.jdbc-catalog.schema-version", (Object)"V0").buildOrThrow();
        IcebergJdbcCatalogConfig expected = new IcebergJdbcCatalogConfig().setDriverClass("org.postgresql.Driver").setConnectionUrl("jdbc:postgresql://localhost:5432/test").setConnectionUser("foo").setConnectionPassword("bar").setCatalogName("test").setDefaultWarehouseDir("s3://bucket").setRetryableStatusCodes("57P01,57P05").setSchemaVersion(IcebergJdbcCatalogConfig.SchemaVersion.V0);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

