/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.jdbc;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.intellij.lang.annotations.Language;
import org.testcontainers.containers.PostgreSQLContainer;

public class TestingIcebergJdbcServer
implements Closeable {
    public static final String USER = "test";
    public static final String PASSWORD = "test";
    private static final String DATABASE = "tpch";
    private final PostgreSQLContainer<?> dockerContainer = new PostgreSQLContainer("postgres:12.10").withDatabaseName("tpch").withUsername("test").withPassword("test");

    public TestingIcebergJdbcServer() {
        this.dockerContainer.start();
        this.execute("CREATE TABLE iceberg_tables(catalog_name VARCHAR(255) NOT NULL,table_namespace VARCHAR(255) NOT NULL,table_name VARCHAR(255) NOT NULL,metadata_location VARCHAR(1000),previous_metadata_location VARCHAR(1000),PRIMARY KEY (catalog_name, table_namespace, table_name))");
        this.execute("CREATE TABLE iceberg_namespace_properties(catalog_name VARCHAR(255) NOT NULL,namespace VARCHAR(255) NOT NULL,property_key VARCHAR(255),property_value VARCHAR(1000),PRIMARY KEY (catalog_name, namespace, property_key))");
        this.execute("CREATE SCHEMA tpch");
    }

    public void execute(@Language(value="SQL") String sql) {
        try (Connection connection = DriverManager.getConnection(this.getJdbcUrl(), "test", "test");
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getJdbcUrl() {
        return String.format("jdbc:postgresql://%s:%s/%s", this.dockerContainer.getHost(), this.dockerContainer.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue()), DATABASE);
    }

    @Override
    public void close() {
        this.dockerContainer.close();
    }
}

