/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.nessie;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.iceberg.catalog.nessie.IcebergNessieCatalogConfig;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;

public class TestIcebergNessieCatalogConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((IcebergNessieCatalogConfig)ConfigAssertions.recordDefaults(IcebergNessieCatalogConfig.class)).setDefaultWarehouseDir(null).setServerUri(null).setDefaultReferenceName("main").setCompressionEnabled(true).setConnectionTimeout(new Duration(5000.0, TimeUnit.MILLISECONDS)).setReadTimeout(new Duration(25000.0, TimeUnit.MILLISECONDS)).setSecurity(null).setBearerToken(null).setClientAPIVersion(null));
    }

    @Test
    public void testExplicitPropertyMapping() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"iceberg.nessie-catalog.default-warehouse-dir", (Object)"/tmp").put((Object)"iceberg.nessie-catalog.uri", (Object)"http://localhost:xxx/api/custom").put((Object)"iceberg.nessie-catalog.ref", (Object)"someRef").put((Object)"iceberg.nessie-catalog.enable-compression", (Object)"false").put((Object)"iceberg.nessie-catalog.connection-timeout", (Object)"2s").put((Object)"iceberg.nessie-catalog.read-timeout", (Object)"5m").put((Object)"iceberg.nessie-catalog.authentication.type", (Object)"BEARER").put((Object)"iceberg.nessie-catalog.authentication.token", (Object)"bearerToken").put((Object)"iceberg.nessie-catalog.client-api-version", (Object)"V1").buildOrThrow();
        IcebergNessieCatalogConfig expected = new IcebergNessieCatalogConfig().setDefaultWarehouseDir("/tmp").setServerUri(URI.create("http://localhost:xxx/api/custom")).setDefaultReferenceName("someRef").setCompressionEnabled(false).setConnectionTimeout(new Duration(2.0, TimeUnit.SECONDS)).setReadTimeout(new Duration(5.0, TimeUnit.MINUTES)).setSecurity(IcebergNessieCatalogConfig.Security.BEARER).setBearerToken("bearerToken").setClientAPIVersion(IcebergNessieCatalogConfig.ClientApiVersion.V1);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

