/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.nessie;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.plugin.iceberg.BaseIcebergConnectorSmokeTest;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.plugin.iceberg.containers.NessieContainer;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import io.trino.tpch.TpchTable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.NessieCatalog;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestIcebergNessieCatalogConnectorSmokeTest
extends BaseIcebergConnectorSmokeTest {
    private Path tempDir;
    private NessieCatalog catalog;

    public TestIcebergNessieCatalogConnectorSmokeTest() {
        super(new IcebergConfig().getFileFormat().toIceberg());
    }

    @AfterAll
    public void teardown() throws IOException {
        MoreFiles.deleteRecursively((Path)this.tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    protected QueryRunner createQueryRunner() throws Exception {
        NessieContainer nessieContainer = (NessieContainer)((Object)this.closeAfterClass((AutoCloseable)((Object)NessieContainer.builder().build())));
        nessieContainer.start();
        this.tempDir = Files.createTempDirectory("test_trino_nessie_catalog", new FileAttribute[0]);
        this.catalog = (NessieCatalog)CatalogUtil.buildIcebergCatalog((String)"tpch", (Map)ImmutableMap.builder().put((Object)"catalog-impl", (Object)NessieCatalog.class.getName()).put((Object)"uri", (Object)nessieContainer.getRestApiUri()).put((Object)"warehouse", (Object)this.tempDir.toString()).buildOrThrow(), (Object)new Configuration(false));
        return ((IcebergQueryRunner.Builder)IcebergQueryRunner.builder().setBaseDataDir(Optional.of(this.tempDir))).setIcebergProperties((Map<String, String>)ImmutableMap.of((Object)"iceberg.file-format", (Object)this.format.name(), (Object)"iceberg.catalog.type", (Object)"nessie", (Object)"iceberg.nessie-catalog.uri", (Object)nessieContainer.getRestApiUri(), (Object)"iceberg.nessie-catalog.default-warehouse-dir", (Object)this.tempDir.toString(), (Object)"iceberg.writer-sort-buffer-size", (Object)"1MB", (Object)"iceberg.allowed-extra-properties", (Object)"write.metadata.delete-after-commit.enabled,write.metadata.previous-versions-max")).setSchemaInitializer(SchemaInitializer.builder().withClonedTpchTables((Iterable<TpchTable<?>>)ImmutableList.builder().addAll((Iterable)REQUIRED_TPCH_TABLES).build()).build()).build();
    }

    @Override
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_CREATE_VIEW, TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    @Test
    public void testView() {
        Assertions.assertThatThrownBy(() -> super.testView()).hasStackTraceContaining("createView is not supported for Iceberg Nessie catalogs");
    }

    @Test
    public void testMaterializedView() {
        Assertions.assertThatThrownBy(() -> super.testMaterializedView()).hasStackTraceContaining("createMaterializedView is not supported for Iceberg Nessie catalogs");
    }

    @Test
    public void testRenameSchema() {
        Assertions.assertThatThrownBy(() -> super.testRenameSchema()).hasStackTraceContaining("renameNamespace is not supported for Iceberg Nessie catalogs");
    }

    @Override
    protected void dropTableFromMetastore(String tableName) {
    }

    @Override
    protected String getMetadataLocation(String tableName) {
        BaseTable table = (BaseTable)this.catalog.loadTable(TableIdentifier.of((String[])new String[]{"tpch", tableName}));
        return table.operations().current().metadataFileLocation();
    }

    @Override
    @Test
    public void testRegisterTableWithTableLocation() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithTableLocation()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testRegisterTableWithComments() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithComments()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testRegisterTableWithShowCreateTable() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithShowCreateTable()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testRegisterTableWithReInsert() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithReInsert()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testRegisterTableWithDroppedTable() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithDroppedTable()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testRegisterTableWithDifferentTableName() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithDifferentTableName()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testRegisterTableWithMetadataFile() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithMetadataFile()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testRegisterTableWithTrailingSpaceInLocation() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithTrailingSpaceInLocation()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testUnregisterTable() {
        Assertions.assertThatThrownBy(() -> super.testUnregisterTable()).hasStackTraceContaining("unregisterTable is not supported for Iceberg Nessie catalogs");
    }

    @Override
    @Test
    public void testUnregisterBrokenTable() {
        Assertions.assertThatThrownBy(() -> super.testUnregisterBrokenTable()).hasStackTraceContaining("unregisterTable is not supported for Iceberg Nessie catalogs");
    }

    @Override
    @Test
    public void testUnregisterTableNotExistingTable() {
        Assertions.assertThatThrownBy(() -> super.testUnregisterTableNotExistingTable()).hasStackTraceContaining("unregisterTable is not supported for Iceberg Nessie catalogs");
    }

    @Override
    @Test
    public void testRepeatUnregisterTable() {
        Assertions.assertThatThrownBy(() -> super.testRepeatUnregisterTable()).hasStackTraceContaining("unregisterTable is not supported for Iceberg Nessie catalogs");
    }

    @Override
    @Test
    public void testDropTableWithMissingMetadataFile() throws Exception {
        String tableName = "test_drop_table_with_missing_metadata_file_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 x, 'INDIA' y", 1L);
        Location metadataLocation = Location.of((String)this.getMetadataLocation(tableName));
        Location tableLocation = Location.of((String)this.getTableLocation(tableName));
        this.fileSystem.deleteFile(metadataLocation);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(metadataLocation).exists()).describedAs("Current metadata file should not exist", new Object[0])).isFalse();
        this.assertUpdate("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.listFiles(tableLocation).hasNext()).describedAs("Table location should exist", new Object[0])).isTrue();
    }

    @Override
    @Test
    public void testDropTableWithMissingSnapshotFile() throws Exception {
        String tableName = "test_drop_table_with_missing_snapshot_file_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 x, 'INDIA' y", 1L);
        String metadataLocation = this.getMetadataLocation(tableName);
        TableMetadata tableMetadata = TableMetadataParser.read((FileIO)new ForwardingFileIo(this.fileSystem), (String)metadataLocation);
        Location tableLocation = Location.of((String)tableMetadata.location());
        Location currentSnapshotFile = Location.of((String)tableMetadata.currentSnapshot().manifestListLocation());
        this.fileSystem.deleteFile(currentSnapshotFile);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(currentSnapshotFile).exists()).describedAs("Current snapshot file should not exist", new Object[0])).isFalse();
        this.assertUpdate("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.listFiles(tableLocation).hasNext()).describedAs("Table location should exist", new Object[0])).isTrue();
    }

    @Override
    @Test
    public void testDropTableWithMissingManifestListFile() throws Exception {
        String tableName = "test_drop_table_with_missing_manifest_list_file_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 x, 'INDIA' y", 1L);
        String metadataLocation = this.getMetadataLocation(tableName);
        ForwardingFileIo fileIo = new ForwardingFileIo(this.fileSystem);
        TableMetadata tableMetadata = TableMetadataParser.read((FileIO)fileIo, (String)metadataLocation);
        Location tableLocation = Location.of((String)tableMetadata.location());
        Location manifestListFile = Location.of((String)((ManifestFile)tableMetadata.currentSnapshot().allManifests((FileIO)fileIo).get(0)).path());
        this.fileSystem.deleteFile(manifestListFile);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(manifestListFile).exists()).describedAs("Manifest list file should not exist", new Object[0])).isFalse();
        this.assertUpdate("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.listFiles(tableLocation).hasNext()).describedAs("Table location should exist", new Object[0])).isTrue();
    }

    @Override
    @Test
    public void testDropTableWithMissingDataFile() throws Exception {
        String tableName = "test_drop_table_with_missing_data_file_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 x, 'INDIA' y", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, 'POLAND')", 1L);
        Location tableLocation = Location.of((String)this.getTableLocation(tableName));
        Location tableDataPath = tableLocation.appendPath("data");
        FileIterator fileIterator = this.fileSystem.listFiles(tableDataPath);
        Assertions.assertThat((boolean)fileIterator.hasNext()).isTrue();
        Location dataFile = fileIterator.next().location();
        this.fileSystem.deleteFile(dataFile);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.newInputFile(dataFile).exists()).describedAs("Data file should not exist", new Object[0])).isFalse();
        this.assertUpdate("DROP TABLE " + tableName);
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.fileSystem.listFiles(tableLocation).hasNext()).describedAs("Table location should exist", new Object[0])).isTrue();
    }

    @Override
    protected boolean isFileSorted(Location path, String sortColumnName) {
        if (this.format == FileFormat.PARQUET) {
            return IcebergTestUtils.checkParquetFileSorting(this.fileSystem.newInputFile(path), sortColumnName);
        }
        return IcebergTestUtils.checkOrcFileSorting(this.fileSystem, path, sortColumnName);
    }

    @Override
    protected void deleteDirectory(String location) {
    }

    @Override
    protected String schemaPath() {
        return String.format("%s/%s", this.tempDir, this.getSession().getSchema().orElseThrow());
    }

    @Override
    protected boolean locationExists(String location) {
        return Files.exists(Path.of(location, new String[0]), new LinkOption[0]);
    }
}

