/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.nessie;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.containers.KeycloakContainer;
import io.trino.plugin.iceberg.containers.NessieContainer;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.TestTable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;
import org.testcontainers.containers.Network;

public class TestIcebergNessieCatalogWithBearerAuth
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        Network network = (Network)this.closeAfterClass((AutoCloseable)Network.newNetwork());
        KeycloakContainer keycloakContainer = (KeycloakContainer)((Object)this.closeAfterClass((AutoCloseable)((Object)((KeycloakContainer.Builder)KeycloakContainer.builder().withNetwork(network)).build())));
        keycloakContainer.start();
        ImmutableMap envVars = ImmutableMap.builder().putAll(NessieContainer.DEFAULT_ENV_VARS).put((Object)"QUARKUS_OIDC_AUTH_SERVER_URL", (Object)"http://keycloak:8080/realms/master").put((Object)"QUARKUS_OIDC_CLIENT_ID", (Object)"projectnessie").put((Object)"NESSIE_SERVER_AUTHENTICATION_ENABLED", (Object)"true").buildOrThrow();
        NessieContainer nessieContainer = (NessieContainer)((Object)this.closeAfterClass((AutoCloseable)((Object)((NessieContainer.Builder)((NessieContainer.Builder)NessieContainer.builder().withEnvVars((Map)envVars)).withNetwork(network)).build())));
        nessieContainer.start();
        Path tempDir = Files.createTempDirectory("test_trino_nessie_catalog", new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        ImmutableMap properties = ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)"nessie").put((Object)"iceberg.nessie-catalog.uri", (Object)nessieContainer.getRestApiUri()).put((Object)"iceberg.nessie-catalog.default-warehouse-dir", (Object)tempDir.toString()).put((Object)"iceberg.nessie-catalog.authentication.type", (Object)"BEARER").put((Object)"iceberg.nessie-catalog.authentication.token", (Object)keycloakContainer.getAccessToken()).buildOrThrow();
        return ((IcebergQueryRunner.Builder)IcebergQueryRunner.builder().setBaseDataDir(Optional.of(tempDir))).setIcebergProperties((Map<String, String>)properties).build();
    }

    @Test
    public void testWithValidAccessToken() {
        try (TestTable table = this.newTrinoTable("test_valid_access_token", "(a INT, b VARCHAR)", (List)ImmutableList.of((Object)"(1, 'a')"));){
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES(1, 'a')");
        }
    }
}

