/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.nessie;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.json.JsonCodec;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.IcebergMetadata;
import io.trino.plugin.iceberg.TableStatisticsWriter;
import io.trino.plugin.iceberg.catalog.BaseTrinoCatalogTest;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.nessie.IcebergNessieCatalogConfig;
import io.trino.plugin.iceberg.catalog.nessie.IcebergNessieTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.nessie.TrinoNessieCatalog;
import io.trino.plugin.iceberg.containers.NessieContainer;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TypeManager;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingNames;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.nessie.NessieIcebergClient;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.NessieApiV2;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestTrinoNessieCatalog
extends BaseTrinoCatalogTest {
    private NessieContainer nessieContainer;

    @BeforeAll
    public void setupServer() {
        this.nessieContainer = NessieContainer.builder().build();
        this.nessieContainer.start();
    }

    @AfterAll
    public void teardownServer() {
        if (this.nessieContainer != null) {
            this.nessieContainer.close();
        }
    }

    @Override
    protected TrinoCatalog createTrinoCatalog(boolean useUniqueTableLocations) {
        Path tmpDirectory = null;
        try {
            tmpDirectory = Files.createTempDirectory("test_nessie_catalog_warehouse_dir_", new FileAttribute[0]);
        }
        catch (IOException e) {
            Assertions.fail((String)e.getMessage());
        }
        HdfsFileSystemFactory fileSystemFactory = new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS);
        IcebergNessieCatalogConfig icebergNessieCatalogConfig = new IcebergNessieCatalogConfig().setServerUri(URI.create(this.nessieContainer.getRestApiUri()));
        NessieApiV2 nessieApi = (NessieApiV2)NessieClientBuilder.createClientBuilderFromSystemSettings().withUri(this.nessieContainer.getRestApiUri()).build(NessieApiV2.class);
        NessieIcebergClient nessieClient = new NessieIcebergClient((NessieApiV1)nessieApi, icebergNessieCatalogConfig.getDefaultReferenceName(), null, (Map)ImmutableMap.of());
        return new TrinoNessieCatalog(new CatalogName("catalog_name"), (TypeManager)new TestingTypeManager(), (TrinoFileSystemFactory)fileSystemFactory, (IcebergTableOperationsProvider)new IcebergNessieTableOperationsProvider((TrinoFileSystemFactory)fileSystemFactory, nessieClient), nessieClient, tmpDirectory.toAbsolutePath().toString(), useUniqueTableLocations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultLocation() throws IOException {
        Path tmpDirectory = Files.createTempDirectory("test_nessie_catalog_default_location_", new FileAttribute[0]);
        tmpDirectory.toFile().deleteOnExit();
        HdfsFileSystemFactory fileSystemFactory = new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS);
        IcebergNessieCatalogConfig icebergNessieCatalogConfig = new IcebergNessieCatalogConfig().setDefaultWarehouseDir(tmpDirectory.toAbsolutePath().toString()).setServerUri(URI.create(this.nessieContainer.getRestApiUri()));
        NessieApiV2 nessieApi = (NessieApiV2)NessieClientBuilder.createClientBuilderFromSystemSettings().withUri(this.nessieContainer.getRestApiUri()).build(NessieApiV2.class);
        NessieIcebergClient nessieClient = new NessieIcebergClient((NessieApiV1)nessieApi, icebergNessieCatalogConfig.getDefaultReferenceName(), null, (Map)ImmutableMap.of());
        TrinoNessieCatalog catalogWithDefaultLocation = new TrinoNessieCatalog(new CatalogName("catalog_name"), (TypeManager)new TestingTypeManager(), (TrinoFileSystemFactory)fileSystemFactory, (IcebergTableOperationsProvider)new IcebergNessieTableOperationsProvider((TrinoFileSystemFactory)fileSystemFactory, nessieClient), nessieClient, icebergNessieCatalogConfig.getDefaultWarehouseDir(), false);
        String namespace = "test_default_location_" + TestingNames.randomNameSuffix();
        String table = "tableName";
        SchemaTableName schemaTableName = new SchemaTableName(namespace, table);
        catalogWithDefaultLocation.createNamespace(SESSION, namespace, (Map)ImmutableMap.of(), new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
        try {
            File expectedSchemaDirectory = new File(tmpDirectory.toFile(), namespace);
            File expectedTableDirectory = new File(expectedSchemaDirectory, schemaTableName.getTableName());
            Assertions.assertThat((String)catalogWithDefaultLocation.defaultTableLocation(SESSION, schemaTableName)).isEqualTo(expectedTableDirectory.toPath().toAbsolutePath().toString());
        }
        finally {
            catalogWithDefaultLocation.dropNamespace(SESSION, namespace);
        }
    }

    @Override
    @Test
    public void testView() {
        Assertions.assertThatThrownBy(() -> super.testView()).hasMessageContaining("createView is not supported for Iceberg Nessie catalogs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testNonLowercaseNamespace() {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        String namespace = "testNonLowercaseNamespace" + TestingNames.randomNameSuffix();
        String schema = namespace.toLowerCase(Locale.ENGLISH);
        catalog.createNamespace(SESSION, namespace, Map.of(), new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
        try {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.namespaceExists(SESSION, namespace)).as("catalog.namespaceExists(namespace)", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.namespaceExists(SESSION, schema)).as("catalog.namespaceExists(schema)", new Object[0])).isFalse();
            ((ListAssert)((ListAssert)Assertions.assertThat((List)catalog.listNamespaces(SESSION)).as("catalog.listNamespaces", new Object[0])).doesNotContain((Object[])new String[]{schema})).contains((Object[])new String[]{namespace});
            IcebergMetadata icebergMetadata = new IcebergMetadata(TestingPlannerContext.PLANNER_CONTEXT.getTypeManager(), CatalogHandle.fromId((String)"iceberg:NORMAL:v12345"), JsonCodec.jsonCodec(CommitTaskData.class), catalog, (connectorIdentity, fileIoProperties) -> {
                throw new UnsupportedOperationException();
            }, new TableStatisticsWriter(new NodeVersion("test-version")), Optional.empty(), false, string -> false, (ExecutorService)MoreExecutors.newDirectExecutorService(), MoreExecutors.directExecutor(), (ExecutorService)MoreExecutors.newDirectExecutorService());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)icebergMetadata.schemaExists(SESSION, namespace)).as("icebergMetadata.schemaExists(namespace)", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)icebergMetadata.schemaExists(SESSION, schema)).as("icebergMetadata.schemaExists(schema)", new Object[0])).isFalse();
            ((ListAssert)((ListAssert)Assertions.assertThat((List)icebergMetadata.listSchemaNames(SESSION)).as("icebergMetadata.listSchemaNames", new Object[0])).doesNotContain((Object[])new String[]{schema})).contains((Object[])new String[]{namespace});
        }
        finally {
            catalog.dropNamespace(SESSION, namespace);
        }
    }
}

