/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.hdfs.DynamicHdfsConfiguration;
import io.trino.hdfs.HdfsConfig;
import io.trino.hdfs.HdfsConfiguration;
import io.trino.hdfs.HdfsConfigurationInitializer;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.hdfs.authentication.NoHdfsAuthentication;
import io.trino.spi.connector.ConnectorSession;
import io.trino.testing.TestingConnectorSession;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.jdbc.JdbcCatalog;

public final class RestCatalogTestUtils {
    private RestCatalogTestUtils() {
    }

    public static Catalog backendCatalog(java.nio.file.Path warehouseLocation) throws IOException {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"uri", (Object)("jdbc:h2:file:" + String.valueOf(Files.createTempFile(null, null, new FileAttribute[0]).toAbsolutePath())));
        properties.put((Object)"jdbc.username", (Object)"user");
        properties.put((Object)"jdbc.password", (Object)"password");
        properties.put((Object)"jdbc.schema-version", (Object)"V1");
        properties.put((Object)"warehouse", (Object)warehouseLocation.resolve("iceberg_data").toFile().getAbsolutePath());
        TestingConnectorSession connectorSession = TestingConnectorSession.builder().build();
        HdfsConfig hdfsConfig = new HdfsConfig();
        DynamicHdfsConfiguration hdfsConfiguration = new DynamicHdfsConfiguration(new HdfsConfigurationInitializer(hdfsConfig), (Set)ImmutableSet.of());
        HdfsEnvironment hdfsEnvironment = new HdfsEnvironment((HdfsConfiguration)hdfsConfiguration, hdfsConfig, (HdfsAuthentication)new NoHdfsAuthentication());
        HdfsContext context = new HdfsContext((ConnectorSession)connectorSession);
        JdbcCatalog catalog = new JdbcCatalog();
        catalog.setConf((Object)hdfsEnvironment.getConfiguration(context, new Path(warehouseLocation.toAbsolutePath().toString())));
        catalog.initialize("backend_jdbc", (Map)properties.buildOrThrow());
        return catalog;
    }
}

