/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.filesystem.Location;
import io.trino.plugin.iceberg.BaseIcebergConnectorSmokeTest;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergConnector;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.plugin.iceberg.catalog.rest.TestingPolarisCatalog;
import io.trino.spi.connector.SchemaTableName;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Optional;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.FileFormat;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
final class TestIcebergPolarisCatalogConnectorSmokeTest
extends BaseIcebergConnectorSmokeTest {
    private TestingPolarisCatalog polarisCatalog;
    private Path warehouseLocation;

    public TestIcebergPolarisCatalogConnectorSmokeTest() {
        super(new IcebergConfig().getFileFormat().toIceberg());
    }

    @Override
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    protected QueryRunner createQueryRunner() throws Exception {
        this.warehouseLocation = Files.createTempDirectory(null, new FileAttribute[0]);
        this.polarisCatalog = (TestingPolarisCatalog)this.closeAfterClass(new TestingPolarisCatalog(this.warehouseLocation.toString()));
        return ((IcebergQueryRunner.Builder)IcebergQueryRunner.builder().setBaseDataDir(Optional.of(this.warehouseLocation))).addIcebergProperty("iceberg.file-format", this.format.name()).addIcebergProperty("iceberg.register-table-procedure.enabled", "true").addIcebergProperty("iceberg.writer-sort-buffer-size", "1MB").addIcebergProperty("iceberg.allowed-extra-properties", "write.metadata.delete-after-commit.enabled,write.metadata.previous-versions-max").addIcebergProperty("iceberg.catalog.type", "rest").addIcebergProperty("iceberg.rest-catalog.nested-namespace-enabled", "true").addIcebergProperty("iceberg.rest-catalog.uri", this.polarisCatalog.restUri() + "/api/catalog").addIcebergProperty("iceberg.rest-catalog.warehouse", "polaris").addIcebergProperty("iceberg.rest-catalog.security", "OAUTH2").addIcebergProperty("iceberg.rest-catalog.oauth2.credential", "root:s3cr3t").addIcebergProperty("iceberg.rest-catalog.oauth2.scope", "PRINCIPAL_ROLE:ALL").setInitialTables(REQUIRED_TPCH_TABLES).build();
    }

    @Override
    protected void dropTableFromMetastore(String tableName) {
        this.polarisCatalog.dropTable((String)this.getSession().getSchema().orElseThrow(), tableName);
    }

    @Override
    protected String getMetadataLocation(String tableName) {
        TrinoCatalogFactory catalogFactory = (TrinoCatalogFactory)((IcebergConnector)this.getQueryRunner().getCoordinator().getConnector("iceberg")).getInjector().getInstance(TrinoCatalogFactory.class);
        TrinoCatalog trinoCatalog = catalogFactory.create(this.getSession().getIdentity().toConnectorIdentity());
        BaseTable table = trinoCatalog.loadTable(this.getSession().toConnectorSession(), new SchemaTableName((String)this.getSession().getSchema().orElseThrow(), tableName));
        return table.operations().current().metadataFileLocation();
    }

    @Override
    protected String getTableLocation(String tableName) {
        TrinoCatalogFactory catalogFactory = (TrinoCatalogFactory)((IcebergConnector)this.getQueryRunner().getCoordinator().getConnector("iceberg")).getInjector().getInstance(TrinoCatalogFactory.class);
        TrinoCatalog trinoCatalog = catalogFactory.create(this.getSession().getIdentity().toConnectorIdentity());
        BaseTable table = trinoCatalog.loadTable(this.getSession().toConnectorSession(), new SchemaTableName((String)this.getSession().getSchema().orElseThrow(), tableName));
        return table.operations().current().location();
    }

    @Override
    protected String schemaPath() {
        return String.format("file://%s/%s", this.warehouseLocation, this.getSession().getSchema().orElseThrow());
    }

    @Override
    protected boolean locationExists(String location) {
        return Files.exists(Path.of(location, new String[0]), new LinkOption[0]);
    }

    @Override
    protected boolean isFileSorted(Location path, String sortColumnName) {
        if (this.format == FileFormat.PARQUET) {
            return IcebergTestUtils.checkParquetFileSorting(this.fileSystem.newInputFile(path), sortColumnName);
        }
        return IcebergTestUtils.checkOrcFileSorting(this.fileSystem, path, sortColumnName);
    }

    @Override
    protected void deleteDirectory(String location) {
        try {
            MoreFiles.deleteRecursively((Path)Path.of(location.replaceAll("^file://", ""), new String[0]), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Test
    void testNestedNamespace() {
        String parentNamespace = "level1_" + TestingNames.randomNameSuffix();
        String nestedNamespace = parentNamespace + ".level2_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA " + parentNamespace);
        this.assertUpdate("CREATE SCHEMA \"" + nestedNamespace + "\"");
        AssertionsForInterfaceTypes.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).contains(new Object[]{parentNamespace, nestedNamespace});
        this.assertUpdate("DROP SCHEMA \"" + nestedNamespace + "\"");
        this.assertUpdate("DROP SCHEMA " + parentNamespace);
    }

    @Test
    public void testMaterializedView() {
        Assertions.assertThatThrownBy(() -> super.testMaterializedView()).hasMessageContaining("createMaterializedView is not supported for Iceberg REST catalog");
    }

    @Test
    public void testRenameSchema() {
        Assertions.assertThatThrownBy(() -> super.testRenameSchema()).hasMessageContaining("renameNamespace is not supported for Iceberg REST catalog");
    }

    @Override
    @Test
    @Disabled(value="Disable as register table is broken with S3 in Polaris. More info at https://github.com/trinodb/trino/pull/23099")
    public void testRegisterTableWithDroppedTable() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithDroppedTable()).hasStackTraceContaining("Failed to open input stream for file");
    }

    @Override
    @Test
    public void testDropTableWithMissingDataFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingDataFile()).hasMessageContaining("Expecting value to be false but was true");
    }

    @Override
    @Test
    public void testRegisterTableWithTrailingSpaceInLocation() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithTrailingSpaceInLocation()).hasStackTraceContaining("Illegal character in path");
    }

    @Override
    @Test
    public void testCreateTableWithTrailingSpaceInLocation() {
        Assertions.assertThatThrownBy(() -> super.testCreateTableWithTrailingSpaceInLocation()).hasStackTraceContaining("Illegal character in path");
    }

    @Override
    @Test
    public void testDropTableWithMissingMetadataFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingMetadataFile()).hasMessageMatching(".* Table '.*' does not exist");
    }

    @Override
    @Test
    public void testDropTableWithMissingSnapshotFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingSnapshotFile()).hasStackTraceContaining("Expecting value to be false but was true");
    }

    @Override
    @Test
    public void testDropTableWithMissingManifestListFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingManifestListFile()).hasMessageContaining("Table location should not exist");
    }

    @Override
    @Test
    public void testDropTableWithNonExistentTableLocation() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithNonExistentTableLocation()).hasMessageMatching(".* Table '.*' does not exist");
    }

    @Override
    @Test
    public void testDeleteRowsConcurrently() {
        Assumptions.abort((String)"Skipped for now due to #23941");
    }
}

