/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.http.server.testing.TestingHttpServer;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.catalog.rest.RestCatalogTestUtils;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.jdbc.JdbcCatalog;
import org.apache.iceberg.rest.DelegatingRestSessionCatalog;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.view.ViewBuilder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
final class TestIcebergRestCatalogCaseInsensitiveMapping
extends AbstractTestQueryFramework {
    private static final String SCHEMA = "LeVeL1_" + TestingNames.randomNameSuffix();
    private static final String LOWERCASE_SCHEMA = SCHEMA.toLowerCase(Locale.ENGLISH);
    private static final Namespace NAMESPACE = Namespace.of((String[])new String[]{SCHEMA});
    private JdbcCatalog backend;

    TestIcebergRestCatalogCaseInsensitiveMapping() {
    }

    protected QueryRunner createQueryRunner() throws Exception {
        Path warehouseLocation = Files.createTempDirectory(null, new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)warehouseLocation, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        this.backend = (JdbcCatalog)this.closeAfterClass((AutoCloseable)((JdbcCatalog)RestCatalogTestUtils.backendCatalog(warehouseLocation)));
        DelegatingRestSessionCatalog delegatingCatalog = DelegatingRestSessionCatalog.builder().delegate((Catalog)this.backend).build();
        TestingHttpServer testServer = delegatingCatalog.testServer();
        testServer.start();
        this.closeAfterClass(() -> ((TestingHttpServer)testServer).stop());
        return ((IcebergQueryRunner.Builder)IcebergQueryRunner.builder(LOWERCASE_SCHEMA).setBaseDataDir(Optional.of(warehouseLocation))).addIcebergProperty("iceberg.catalog.type", "rest").addIcebergProperty("iceberg.rest-catalog.uri", testServer.getBaseUrl().toString()).addIcebergProperty("iceberg.rest-catalog.case-insensitive-name-matching", "true").addIcebergProperty("iceberg.register-table-procedure.enabled", "true").build();
    }

    @BeforeAll
    void setup() {
        this.backend.createNamespace(NAMESPACE);
        Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{"information_schema", "tpch", LOWERCASE_SCHEMA, "system"});
        Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS LIKE 'level%'").getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{LOWERCASE_SCHEMA});
        this.assertQuery("SELECT * FROM information_schema.schemata", "VALUES\n('iceberg', 'information_schema'),\n('iceberg', 'system'),\n('iceberg', '%s'),\n('iceberg', 'tpch')\n".formatted(LOWERCASE_SCHEMA));
    }

    @Test
    void testCaseInsensitiveMatchingForTable() {
        Map namespaceMetadata = this.backend.loadNamespaceMetadata(NAMESPACE);
        String namespaceLocation = (String)namespaceMetadata.get("location");
        TestIcebergRestCatalogCaseInsensitiveMapping.createDir(namespaceLocation);
        String tableName1 = "MiXed_CaSe_TaBlE1_" + TestingNames.randomNameSuffix();
        String lowercaseTableName1 = tableName1.toLowerCase(Locale.ENGLISH);
        String table1Location = namespaceLocation + "/" + lowercaseTableName1;
        this.assertUpdate("CREATE TABLE " + tableName1 + " WITH (location = '" + table1Location + "') AS SELECT BIGINT '42' a, DOUBLE '-38.5' b", 1L);
        this.assertQuery("SELECT * FROM " + tableName1, "VALUES (42, -38.5)");
        String tableName2 = "mIxEd_cAsE_tAbLe2_" + TestingNames.randomNameSuffix();
        String lowercaseTableName2 = tableName2.toLowerCase(Locale.ENGLISH);
        String table2Location = namespaceLocation + "/" + lowercaseTableName2;
        TestIcebergRestCatalogCaseInsensitiveMapping.createDir(table2Location);
        TestIcebergRestCatalogCaseInsensitiveMapping.createDir(table2Location + "/data");
        TestIcebergRestCatalogCaseInsensitiveMapping.createDir(table2Location + "/metadata");
        this.backend.buildTable(TableIdentifier.of((Namespace)NAMESPACE, (String)tableName2), new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"x", (Type)Types.LongType.get())})).withLocation(table2Location).createTransaction().commitTransaction();
        this.assertUpdate("INSERT INTO " + tableName2 + " VALUES (78)", 1L);
        this.assertQuery("SELECT * FROM " + tableName2, "VALUES (78)");
        Assertions.assertThat((boolean)this.backend.dropTable(TableIdentifier.of((Namespace)NAMESPACE, (String)lowercaseTableName1), false)).isTrue();
        this.assertQueryFails("SELECT * FROM " + tableName1, ".*'iceberg.%s.%s' does not exist".formatted(LOWERCASE_SCHEMA, lowercaseTableName1));
        this.assertUpdate("CALL system.register_table (CURRENT_SCHEMA, '" + tableName1 + "', '" + table1Location + "')");
        this.assertQuery("SELECT * FROM " + tableName1, "VALUES (42, -38.5)");
        this.assertUpdate("CALL system.unregister_table (CURRENT_SCHEMA, '" + tableName1 + "')");
        this.assertQueryFails("SELECT * FROM " + tableName1, ".*'iceberg.%s.%s' does not exist".formatted(LOWERCASE_SCHEMA, lowercaseTableName1));
        this.assertUpdate("CALL system.register_table (CURRENT_SCHEMA, '" + tableName1 + "', '" + table1Location + "')");
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES IN " + SCHEMA).getOnlyColumnAsSet()).contains(new Object[]{lowercaseTableName1, lowercaseTableName2});
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES IN " + SCHEMA + " LIKE 'mixed_case_table%'").getOnlyColumnAsSet()).isEqualTo(Set.of(lowercaseTableName1, lowercaseTableName2));
        this.assertQuery("SELECT * FROM information_schema.tables WHERE table_schema NOT IN ('information_schema', 'system') AND table_type = 'BASE TABLE'", "VALUES\n('iceberg', '%1$s', '%2$s', 'BASE TABLE'),\n('iceberg', '%1$s', '%3$s', 'BASE TABLE')\n".formatted(LOWERCASE_SCHEMA, lowercaseTableName1, lowercaseTableName2));
        this.assertUpdate("COMMENT ON TABLE " + tableName1 + " IS 'test comment' ");
        Assertions.assertThat((String)this.getTableComment(lowercaseTableName1)).isEqualTo("test comment");
        this.assertUpdate("COMMENT ON COLUMN " + tableName1 + ".a IS 'test column comment'");
        Assertions.assertThat((String)this.getColumnComment(lowercaseTableName1, "a")).isEqualTo("test column comment");
        String renamedTableName1 = tableName1 + "_renamed";
        this.assertUpdate("ALTER TABLE " + lowercaseTableName1 + " RENAME TO " + renamedTableName1);
        this.assertQueryFails("SELECT * FROM " + tableName1, ".*'iceberg.%s.%s' does not exist".formatted(LOWERCASE_SCHEMA, lowercaseTableName1));
        this.assertQuery("SELECT * FROM " + renamedTableName1, "VALUES (42, -38.5)");
        this.assertUpdate("DROP TABLE " + renamedTableName1);
        this.assertUpdate("DROP TABLE " + tableName2);
        this.assertQueryFails("SELECT * FROM " + renamedTableName1, ".*'iceberg.%s.%s' does not exist".formatted(LOWERCASE_SCHEMA, renamedTableName1.toLowerCase(Locale.ENGLISH)));
        this.assertQueryFails("SELECT * FROM " + tableName2, ".*'iceberg.%s.%s' does not exist".formatted(LOWERCASE_SCHEMA, lowercaseTableName2));
    }

    @Test
    void testCaseInsensitiveMatchingForView() {
        Map namespaceMetadata = this.backend.loadNamespaceMetadata(NAMESPACE);
        String namespaceLocation = (String)namespaceMetadata.get("location");
        TestIcebergRestCatalogCaseInsensitiveMapping.createDir(namespaceLocation);
        String viewName1 = "MiXed_CaSe_vIeW1_" + TestingNames.randomNameSuffix();
        String lowercaseViewName1 = viewName1.toLowerCase(Locale.ENGLISH);
        this.assertUpdate("CREATE VIEW " + viewName1 + " AS SELECT BIGINT '25' a, DOUBLE '99.4' b");
        this.assertQuery("SELECT * FROM " + viewName1, "VALUES (25, 99.4)");
        String viewName2 = "mIxEd_cAsE_ViEw2_" + TestingNames.randomNameSuffix();
        String lowercaseViewName2 = viewName2.toLowerCase(Locale.ENGLISH);
        String view2Location = namespaceLocation + "/" + lowercaseViewName2;
        TestIcebergRestCatalogCaseInsensitiveMapping.createDir(view2Location);
        TestIcebergRestCatalogCaseInsensitiveMapping.createDir(view2Location + "/data");
        TestIcebergRestCatalogCaseInsensitiveMapping.createDir(view2Location + "/metadata");
        ViewBuilder viewBuilder = this.backend.buildView(TableIdentifier.of((Namespace)NAMESPACE, (String)viewName2));
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)viewBuilder.withQuery("trino", "SELECT BIGINT '34' y")).withSchema(new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"y", (Type)Types.LongType.get())}))).withDefaultNamespace(NAMESPACE)).withLocation(view2Location).createOrReplace();
        this.assertQuery("SELECT * FROM " + viewName2, "VALUES (34)");
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES IN " + SCHEMA).getOnlyColumnAsSet()).contains(new Object[]{lowercaseViewName1, lowercaseViewName2});
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES IN " + SCHEMA + " LIKE 'mixed_case_view%'").getOnlyColumnAsSet()).contains(new Object[]{lowercaseViewName1, lowercaseViewName2});
        this.assertQuery("SELECT * FROM information_schema.tables WHERE table_schema != 'information_schema' AND table_type = 'VIEW'", "VALUES\n('iceberg', '%1$s', '%2$s', 'VIEW'),\n('iceberg', '%1$s', '%3$s', 'VIEW')\n".formatted(LOWERCASE_SCHEMA, lowercaseViewName1, lowercaseViewName2));
        this.assertUpdate("COMMENT ON VIEW " + viewName1 + " IS 'test comment' ");
        Assertions.assertThat((String)this.getTableComment(lowercaseViewName1)).isEqualTo("test comment");
        this.assertUpdate("COMMENT ON COLUMN " + viewName1 + ".a IS 'test column comment'");
        Assertions.assertThat((String)this.getColumnComment(lowercaseViewName1, "a")).isEqualTo("test column comment");
        String renamedViewName1 = viewName1 + "_renamed";
        this.assertUpdate("ALTER VIEW " + lowercaseViewName1 + " RENAME TO " + renamedViewName1);
        this.assertQueryFails("SELECT * FROM " + viewName1, ".*'iceberg.%s.%s' does not exist".formatted(LOWERCASE_SCHEMA, lowercaseViewName1));
        this.assertQuery("SELECT * FROM " + renamedViewName1, "VALUES (25, 99.4)");
        this.assertUpdate("DROP VIEW " + renamedViewName1);
        this.assertUpdate("DROP VIEW " + viewName2);
        this.assertQueryFails("SELECT * FROM " + renamedViewName1, ".*'iceberg.%s.%s' does not exist".formatted(LOWERCASE_SCHEMA, renamedViewName1.toLowerCase(Locale.ENGLISH)));
        this.assertQueryFails("SELECT * FROM " + viewName2, ".*'iceberg.%s.%s' does not exist".formatted(LOWERCASE_SCHEMA, lowercaseViewName2));
    }

    private String getColumnComment(String tableName, String columnName) {
        return (String)this.computeScalar("SELECT comment FROM information_schema.columns WHERE table_schema = '" + LOWERCASE_SCHEMA + "' AND table_name = '" + tableName + "' AND column_name = '" + columnName + "'");
    }

    private static void createDir(String absoluteDirPath) {
        Path path = Paths.get(URI.create(absoluteDirPath).getPath(), new String[0]);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot create %s directory".formatted(absoluteDirPath), e);
        }
    }
}

