/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.iceberg.catalog.rest.IcebergRestCatalogConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.CatalogProperties;
import org.junit.jupiter.api.Test;

public class TestIcebergRestCatalogConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((IcebergRestCatalogConfig)ConfigAssertions.recordDefaults(IcebergRestCatalogConfig.class)).setBaseUri(null).setPrefix(null).setWarehouse(null).setNestedNamespaceEnabled(false).setSessionType(IcebergRestCatalogConfig.SessionType.NONE).setSessionTimeout(new Duration((double)CatalogProperties.AUTH_SESSION_TIMEOUT_MS_DEFAULT, TimeUnit.MILLISECONDS)).setSecurity(IcebergRestCatalogConfig.Security.NONE).setVendedCredentialsEnabled(false).setViewEndpointsEnabled(true).setSigV4Enabled(false).setCaseInsensitiveNameMatching(false).setCaseInsensitiveNameMatchingCacheTtl(new Duration(1.0, TimeUnit.MINUTES)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"iceberg.rest-catalog.uri", (Object)"http://localhost:1234").put((Object)"iceberg.rest-catalog.prefix", (Object)"dev").put((Object)"iceberg.rest-catalog.warehouse", (Object)"test_warehouse_identifier").put((Object)"iceberg.rest-catalog.nested-namespace-enabled", (Object)"true").put((Object)"iceberg.rest-catalog.security", (Object)"OAUTH2").put((Object)"iceberg.rest-catalog.session", (Object)"USER").put((Object)"iceberg.rest-catalog.session-timeout", (Object)"100ms").put((Object)"iceberg.rest-catalog.vended-credentials-enabled", (Object)"true").put((Object)"iceberg.rest-catalog.view-endpoints-enabled", (Object)"false").put((Object)"iceberg.rest-catalog.sigv4-enabled", (Object)"true").put((Object)"iceberg.rest-catalog.case-insensitive-name-matching", (Object)"true").put((Object)"iceberg.rest-catalog.case-insensitive-name-matching.cache-ttl", (Object)"3m").buildOrThrow();
        IcebergRestCatalogConfig expected = new IcebergRestCatalogConfig().setBaseUri("http://localhost:1234").setPrefix("dev").setWarehouse("test_warehouse_identifier").setNestedNamespaceEnabled(true).setSessionType(IcebergRestCatalogConfig.SessionType.USER).setSessionTimeout(new Duration(100.0, TimeUnit.MILLISECONDS)).setSecurity(IcebergRestCatalogConfig.Security.OAUTH2).setVendedCredentialsEnabled(true).setViewEndpointsEnabled(false).setSigV4Enabled(true).setCaseInsensitiveNameMatching(true).setCaseInsensitiveNameMatchingCacheTtl(new Duration(3.0, TimeUnit.MINUTES));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

