/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.filesystem.Location;
import io.trino.plugin.iceberg.BaseIcebergConnectorSmokeTest;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.plugin.iceberg.TestingIcebergPlugin;
import io.trino.plugin.iceberg.catalog.rest.RestCatalogTestUtils;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryFailedException;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.jdbc.JdbcCatalog;
import org.apache.iceberg.rest.DelegatingRestSessionCatalog;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class TestIcebergRestCatalogNestedNamespaceConnectorSmokeTest
extends BaseIcebergConnectorSmokeTest {
    private Path warehouseLocation;
    private JdbcCatalog backend;

    public TestIcebergRestCatalogNestedNamespaceConnectorSmokeTest() {
        super(new IcebergConfig().getFileFormat().toIceberg());
    }

    @Override
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    protected QueryRunner createQueryRunner() throws Exception {
        this.warehouseLocation = Files.createTempDirectory(null, new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)this.warehouseLocation, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        this.backend = (JdbcCatalog)this.closeAfterClass((AutoCloseable)((JdbcCatalog)RestCatalogTestUtils.backendCatalog(this.warehouseLocation)));
        DelegatingRestSessionCatalog delegatingCatalog = DelegatingRestSessionCatalog.builder().delegate((Catalog)this.backend).build();
        TestingHttpServer testServer = delegatingCatalog.testServer();
        testServer.start();
        this.closeAfterClass(() -> ((TestingHttpServer)testServer).stop());
        String nestedSchema = "level_1.level_2";
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().setCatalog("iceberg").setSchema(nestedSchema).build()).setBaseDataDir(Optional.of(this.warehouseLocation)).build();
        ImmutableMap nestedNamespaceDisabled = ImmutableMap.builder().put((Object)"fs.hadoop.enabled", (Object)"true").put((Object)"iceberg.file-format", (Object)this.format.name()).put((Object)"iceberg.catalog.type", (Object)"rest").put((Object)"iceberg.rest-catalog.uri", (Object)testServer.getBaseUrl().toString()).put((Object)"iceberg.register-table-procedure.enabled", (Object)"true").put((Object)"iceberg.writer-sort-buffer-size", (Object)"1MB").put((Object)"iceberg.allowed-extra-properties", (Object)"write.metadata.delete-after-commit.enabled,write.metadata.previous-versions-max").buildOrThrow();
        ImmutableMap nestedNamespaceEnabled = ImmutableMap.builder().putAll((Map)nestedNamespaceDisabled).put((Object)"iceberg.rest-catalog.nested-namespace-enabled", (Object)"true").buildOrThrow();
        try {
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch");
            Path dataDir = queryRunner.getCoordinator().getBaseDataDir().resolve("iceberg_data");
            queryRunner.installPlugin((Plugin)new TestingIcebergPlugin(dataDir));
            queryRunner.createCatalog("iceberg", "iceberg", (Map)nestedNamespaceEnabled);
            queryRunner.createCatalog("nested_namespace_disabled", "iceberg", (Map)nestedNamespaceDisabled);
            SchemaInitializer.builder().withSchemaName(nestedSchema).withClonedTpchTables(REQUIRED_TPCH_TABLES).build().accept((QueryRunner)queryRunner);
            return queryRunner;
        }
        catch (Exception e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
    }

    @Test
    void testNestedNamespaceDisabled() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW SCHEMAS FROM nested_namespace_disabled"))).skippingTypesCheck().containsAll("VALUES 'level_1'");
        this.assertQueryFails("SHOW TABLES IN nested_namespace_disabled.\"level_1.level_2\"", "Nested namespace is not enabled for this catalog");
        this.assertQueryFails("CREATE SCHEMA nested_namespace_disabled.\"level_1.level_2.level_3\"", "Nested namespace is not enabled for this catalog");
        this.assertQueryFails("CREATE TABLE nested_namespace_disabled.\"level_1.level_2\".test_nested(x int)", "Nested namespace is not enabled for this catalog");
        this.assertQueryFails("SELECT * FROM nested_namespace_disabled.\"level_1.level_2\".region", "Nested namespace is not enabled for this catalog");
    }

    @Test
    void testDropNestedSchemaCascade() {
        String rootSchemaName = "test_root" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA " + rootSchemaName);
        this.assertUpdate("CREATE SCHEMA \"" + rootSchemaName + ".test_nested\"");
        this.assertQueryFails("DROP SCHEMA " + rootSchemaName + " CASCADE", "Cannot drop non-empty schema: .*");
        this.assertUpdate("DROP SCHEMA \"" + rootSchemaName + ".test_nested\" CASCADE");
        this.assertUpdate("DROP SCHEMA " + rootSchemaName);
    }

    @Override
    @Test
    public void testShowCreateTable() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE region"))).matches((CharSequence)("CREATE TABLE iceberg.\"" + schemaName + "\".region \\(\n   regionkey bigint,\n   name varchar,\n   comment varchar\n\\)\nWITH \\(\n   format = '" + this.format.name() + "',\n   format_version = 2,\n" + String.format("   location = '.*/" + schemaName + "/region.*',\n   max_commit_retry = 4\n", new Object[0]) + "\\)"));
    }

    @Test
    public void testView() {
        String viewName = "test_view_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + viewName))).skippingTypesCheck().matches("SELECT * FROM nation");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE VIEW " + viewName))).isEqualTo("CREATE VIEW iceberg.\"level_1.level_2\".%s SECURITY DEFINER AS\nSELECT *\nFROM\n  nation".formatted(viewName));
        this.assertUpdate("DROP  VIEW " + viewName);
    }

    @Test
    public void testRenameSchema() {
        Assertions.assertThatThrownBy(() -> super.testRenameSchema()).hasMessageContaining("renameNamespace is not supported for Iceberg REST catalog");
    }

    @Test
    public void testMaterializedView() {
        Assertions.assertThatThrownBy(() -> super.testMaterializedView()).hasMessageContaining("createMaterializedView is not supported for Iceberg REST catalog");
    }

    @Override
    @Test
    public void testDropTableWithMissingMetadataFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingMetadataFile()).hasMessageMatching("Failed to load table: (.*)");
    }

    @Override
    @Test
    public void testDropTableWithMissingSnapshotFile() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingSnapshotFile()).isInstanceOf(QueryFailedException.class)).cause().hasMessageContaining("Failed to drop table").cause().hasMessageMatching("Server error: NotFoundException: Failed to open input stream for file: (.*)");
    }

    @Override
    @Test
    public void testDropTableWithMissingManifestListFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingManifestListFile()).hasMessageContaining("Table location should not exist");
    }

    @Override
    @Test
    public void testDropTableWithNonExistentTableLocation() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithNonExistentTableLocation()).hasMessageMatching("Failed to load table: (.*)");
    }

    @Override
    protected boolean isFileSorted(Location path, String sortColumnName) {
        if (this.format == FileFormat.PARQUET) {
            return IcebergTestUtils.checkParquetFileSorting(this.fileSystem.newInputFile(path), sortColumnName);
        }
        return IcebergTestUtils.checkOrcFileSorting(this.fileSystem, path, sortColumnName);
    }

    @Override
    protected void deleteDirectory(String location) {
        try {
            MoreFiles.deleteRecursively((Path)Path.of(location, new String[0]), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void dropTableFromMetastore(String tableName) {
        this.backend.dropTable(this.toIdentifier(tableName), false);
    }

    @Override
    protected String getMetadataLocation(String tableName) {
        BaseTable table = (BaseTable)this.backend.loadTable(this.toIdentifier(tableName));
        return table.operations().current().metadataFileLocation();
    }

    @Override
    protected String schemaPath() {
        return String.format("%s/%s", this.warehouseLocation, this.getSession().getSchema());
    }

    @Override
    protected boolean locationExists(String location) {
        return Files.exists(Path.of(location, new String[0]), new LinkOption[0]);
    }

    private TableIdentifier toIdentifier(String tableName) {
        return TableIdentifier.of((String[])new String[]{(String)this.getSession().getSchema().orElseThrow(), tableName});
    }
}

