/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import io.trino.filesystem.Location;
import io.trino.plugin.iceberg.BaseIcebergConnectorSmokeTest;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergConnector;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.spi.connector.SchemaTableName;
import io.trino.testing.QueryRunner;
import io.trino.testing.SystemEnvironmentUtils;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import org.apache.iceberg.BaseTable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
final class TestIcebergS3TablesConnectorSmokeTest
extends BaseIcebergConnectorSmokeTest {
    public static final String S3_TABLES_BUCKET = SystemEnvironmentUtils.requireEnv((String)"S3_TABLES_BUCKET");
    public static final String AWS_ACCESS_KEY_ID = SystemEnvironmentUtils.requireEnv((String)"AWS_ACCESS_KEY_ID");
    public static final String AWS_SECRET_ACCESS_KEY = SystemEnvironmentUtils.requireEnv((String)"AWS_SECRET_ACCESS_KEY");
    public static final String AWS_REGION = SystemEnvironmentUtils.requireEnv((String)"AWS_REGION");

    public TestIcebergS3TablesConnectorSmokeTest() {
        super(new IcebergConfig().getFileFormat().toIceberg());
    }

    @Override
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_RENAME_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA, TestingConnectorBehavior.SUPPORTS_RENAME_TABLE -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    protected QueryRunner createQueryRunner() throws Exception {
        return IcebergQueryRunner.builder("tpch").addIcebergProperty("iceberg.file-format", this.format.name()).addIcebergProperty("iceberg.register-table-procedure.enabled", "true").addIcebergProperty("iceberg.catalog.type", "rest").addIcebergProperty("iceberg.rest-catalog.uri", "https://glue.%s.amazonaws.com/iceberg".formatted(AWS_REGION)).addIcebergProperty("iceberg.rest-catalog.warehouse", "s3tablescatalog/" + S3_TABLES_BUCKET).addIcebergProperty("iceberg.rest-catalog.view-endpoints-enabled", "false").addIcebergProperty("iceberg.rest-catalog.sigv4-enabled", "true").addIcebergProperty("iceberg.rest-catalog.signing-name", "glue").addIcebergProperty("iceberg.writer-sort-buffer-size", "1MB").addIcebergProperty("iceberg.allowed-extra-properties", "write.metadata.delete-after-commit.enabled,write.metadata.previous-versions-max").addIcebergProperty("fs.native-s3.enabled", "true").addIcebergProperty("s3.region", AWS_REGION).addIcebergProperty("s3.aws-access-key", AWS_ACCESS_KEY_ID).addIcebergProperty("s3.aws-secret-key", AWS_SECRET_ACCESS_KEY).setInitialTables(REQUIRED_TPCH_TABLES).build();
    }

    @Override
    protected String getMetadataLocation(String tableName) {
        TrinoCatalogFactory catalogFactory = (TrinoCatalogFactory)((IcebergConnector)this.getQueryRunner().getCoordinator().getConnector("iceberg")).getInjector().getInstance(TrinoCatalogFactory.class);
        TrinoCatalog trinoCatalog = catalogFactory.create(this.getSession().getIdentity().toConnectorIdentity());
        BaseTable table = trinoCatalog.loadTable(this.getSession().toConnectorSession(), new SchemaTableName((String)this.getSession().getSchema().orElseThrow(), tableName));
        return table.operations().current().metadataFileLocation();
    }

    @Override
    protected String schemaPath() {
        return "dummy";
    }

    @Override
    protected boolean locationExists(String location) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isFileSorted(Location path, String sortColumnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void deleteDirectory(String location) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dropTableFromMetastore(String tableName) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE region"))).matches((CharSequence)"CREATE TABLE iceberg.tpch.region \\(\n   regionkey bigint,\n   name varchar,\n   comment varchar\n\\)\nWITH \\(\n   format = 'PARQUET',\n   format_version = 2,\n   location = 's3://.*--table-s3',\n   max_commit_retry = 4\n\\)");
    }

    @Test
    public void testRenameSchema() {
        Assertions.assertThatThrownBy(() -> super.testRenameSchema()).hasMessageContaining("renameNamespace is not supported for Iceberg REST catalog");
    }

    @Test
    public void testMaterializedView() {
        Assertions.assertThatThrownBy(() -> super.testMaterializedView()).hasMessageContaining("createMaterializedView is not supported for Iceberg REST catalog");
    }

    @Override
    @Test
    public void testCreateTableWithTrailingSpaceInLocation() {
        String tableName = "test_create_table_with_trailing_space_" + TestingNames.randomNameSuffix();
        String tableLocationWithTrailingSpace = this.schemaPath() + tableName + " ";
        this.assertQueryFails(String.format("CREATE TABLE %s WITH (location = '%s') AS SELECT 1 AS a, 'INDIA' AS b, true AS c", tableName, tableLocationWithTrailingSpace), "Failed to create transaction");
    }

    @Test
    public void testRenameTable() {
        Assertions.assertThatThrownBy(() -> super.testRenameTable()).hasStackTraceContaining("Unable to process: RenameTable endpoint is not supported for Glue Catalog");
    }

    @Test
    public void testView() {
        Assertions.assertThatThrownBy(() -> super.testView()).hasMessageContaining("Server does not support endpoint: POST /v1/{prefix}/namespaces/{namespace}/views");
    }

    @Test
    public void testCommentViewColumn() {
        Assertions.assertThatThrownBy(() -> super.testCommentViewColumn()).hasMessageContaining("Server does not support endpoint: POST /v1/{prefix}/namespaces/{namespace}/views");
    }

    @Test
    public void testCommentView() {
        Assertions.assertThatThrownBy(() -> super.testCommentView()).hasMessageContaining("Server does not support endpoint: POST /v1/{prefix}/namespaces/{namespace}/views");
    }

    @Override
    @Test
    public void testCreateTableWithNonExistingSchemaVerifyLocation() {
    }

    @Override
    @Test
    public void testDropTableWithMissingMetadataFile() {
    }

    @Override
    @Test
    public void testDropTableWithMissingManifestListFile() {
    }

    @Override
    @Test
    public void testMetadataDeleteAfterCommitEnabled() {
    }

    @Override
    @Test
    public void testDropTableWithMissingSnapshotFile() {
    }

    @Override
    @Test
    public void testDropTableWithMissingDataFile() {
    }

    @Override
    @Test
    public void testDropTableWithNonExistentTableLocation() {
    }

    @Override
    @Test
    public void testSortedNationTable() {
    }

    @Override
    @Test
    public void testFileSortingWithLargerTable() {
    }

    @Override
    @Test
    public void testRegisterTableWithTableLocation() {
    }

    @Override
    @Test
    public void testRegisterTableWithComments() {
    }

    @Override
    @Test
    public void testRegisterTableWithShowCreateTable() {
    }

    @Override
    @Test
    public void testRegisterTableWithReInsert() {
    }

    @Override
    @Test
    public void testRegisterTableWithDroppedTable() {
    }

    @Override
    @Test
    public void testRegisterTableWithDifferentTableName() {
    }

    @Override
    @Test
    public void testRegisterTableWithMetadataFile() {
    }

    @Override
    @Test
    public void testRegisterTableWithTrailingSpaceInLocation() {
    }

    @Override
    @Test
    public void testUnregisterTable() {
    }

    @Override
    @Test
    public void testUnregisterBrokenTable() {
    }

    @Override
    @Test
    public void testUnregisterTableNotExistingSchema() {
    }

    @Override
    @Test
    public void testUnregisterTableNotExistingTable() {
    }

    @Override
    @Test
    public void testRepeatUnregisterTable() {
    }

    @Override
    @Test
    public void testUnregisterTableAccessControl() {
    }
}

