/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.http.server.testing.TestingHttpServer;
import io.trino.filesystem.Location;
import io.trino.plugin.iceberg.BaseIcebergConnectorSmokeTest;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.catalog.rest.RestCatalogTestUtils;
import io.trino.testing.QueryFailedException;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.jdbc.JdbcCatalog;
import org.apache.iceberg.rest.DelegatingRestSessionCatalog;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.view.ViewBuilder;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIcebergTrinoRestCatalogConnectorSmokeTest
extends BaseIcebergConnectorSmokeTest {
    private Path warehouseLocation;
    private JdbcCatalog backend;

    public TestIcebergTrinoRestCatalogConnectorSmokeTest() {
        super(new IcebergConfig().getFileFormat().toIceberg());
    }

    @Override
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_RENAME_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    protected QueryRunner createQueryRunner() throws Exception {
        this.warehouseLocation = Files.createTempDirectory(null, new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)this.warehouseLocation, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        this.backend = (JdbcCatalog)this.closeAfterClass((AutoCloseable)((JdbcCatalog)RestCatalogTestUtils.backendCatalog(this.warehouseLocation)));
        DelegatingRestSessionCatalog delegatingCatalog = DelegatingRestSessionCatalog.builder().delegate((Catalog)this.backend).build();
        TestingHttpServer testServer = delegatingCatalog.testServer();
        testServer.start();
        this.closeAfterClass(() -> ((TestingHttpServer)testServer).stop());
        return ((IcebergQueryRunner.Builder)IcebergQueryRunner.builder().setBaseDataDir(Optional.of(this.warehouseLocation))).setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"iceberg.file-format", (Object)this.format.name()).put((Object)"iceberg.catalog.type", (Object)"rest").put((Object)"iceberg.rest-catalog.uri", (Object)testServer.getBaseUrl().toString()).put((Object)"iceberg.register-table-procedure.enabled", (Object)"true").put((Object)"iceberg.writer-sort-buffer-size", (Object)"1MB").put((Object)"iceberg.allowed-extra-properties", (Object)"write.metadata.delete-after-commit.enabled,write.metadata.previous-versions-max").buildOrThrow()).setInitialTables(REQUIRED_TPCH_TABLES).build();
    }

    @AfterAll
    public void teardown() {
        this.backend = null;
    }

    @Test
    void testDropSchemaCascadeWithViews() {
        String schemaName = "test_drop_schema_cascade" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        TableIdentifier sparkViewIdentifier = TableIdentifier.of((String[])new String[]{schemaName, "test_spark_views" + TestingNames.randomNameSuffix()});
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)this.backend.buildView(sparkViewIdentifier).withDefaultNamespace(Namespace.of((String[])new String[]{schemaName}))).withDefaultCatalog("iceberg")).withQuery("spark", "SELECT 1 x")).withSchema(new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"x", (Type)Types.LongType.get())}))).create();
        TableIdentifier trinoViewIdentifier = TableIdentifier.of((String[])new String[]{schemaName, "test_trino_views" + TestingNames.randomNameSuffix()});
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)this.backend.buildView(trinoViewIdentifier).withDefaultNamespace(Namespace.of((String[])new String[]{schemaName}))).withDefaultCatalog("iceberg")).withQuery("trino", "SELECT 1 x")).withSchema(new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"x", (Type)Types.LongType.get())}))).create();
        Assertions.assertThat((boolean)this.backend.viewExists(sparkViewIdentifier)).isTrue();
        Assertions.assertThat((boolean)this.backend.viewExists(trinoViewIdentifier)).isTrue();
        this.assertUpdate("DROP SCHEMA " + schemaName + " CASCADE");
        Assertions.assertThat((boolean)this.backend.viewExists(sparkViewIdentifier)).isFalse();
        Assertions.assertThat((boolean)this.backend.viewExists(trinoViewIdentifier)).isFalse();
    }

    @Test
    void testUnsupportedViewDialect() {
        String viewName = "test_unsupported_dialect" + TestingNames.randomNameSuffix();
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"tpch", viewName});
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)((ViewBuilder)this.backend.buildView(identifier).withDefaultNamespace(Namespace.of((String[])new String[]{"tpch"}))).withDefaultCatalog("iceberg")).withQuery("spark", "SELECT 1 x")).withSchema(new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"x", (Type)Types.LongType.get())}))).create();
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES FROM iceberg.tpch").getOnlyColumnAsSet()).contains(new Object[]{viewName});
        Assertions.assertThat((Collection)this.computeActual("SELECT table_name FROM information_schema.views WHERE table_schema = 'tpch'").getOnlyColumnAsSet()).doesNotContain(new Object[]{viewName});
        Assertions.assertThat((Collection)this.computeActual("SELECT table_name FROM information_schema.columns WHERE table_schema = 'tpch'").getOnlyColumnAsSet()).doesNotContain(new Object[]{viewName});
        this.assertQueryReturnsEmptyResult("SELECT * FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '" + viewName + "'");
        this.assertQueryFails("SELECT * FROM " + viewName, "Cannot read unsupported dialect 'spark' for view '.*'");
        this.backend.dropView(identifier);
    }

    @Test
    public void testMaterializedView() {
        Assertions.assertThatThrownBy(() -> super.testMaterializedView()).hasMessageContaining("createMaterializedView is not supported for Iceberg REST catalog");
    }

    @Test
    public void testRenameSchema() {
        Assertions.assertThatThrownBy(() -> super.testRenameSchema()).hasMessageContaining("renameNamespace is not supported for Iceberg REST catalog");
    }

    @Override
    protected void dropTableFromMetastore(String tableName) {
        this.backend.dropTable(this.toIdentifier(tableName), false);
    }

    @Override
    protected String getMetadataLocation(String tableName) {
        BaseTable table = (BaseTable)this.backend.loadTable(this.toIdentifier(tableName));
        return table.operations().current().metadataFileLocation();
    }

    @Override
    protected String schemaPath() {
        return String.format("%s/%s", this.warehouseLocation, this.getSession().getSchema());
    }

    @Override
    protected boolean locationExists(String location) {
        return Files.exists(Path.of(location, new String[0]), new LinkOption[0]);
    }

    @Override
    @Test
    public void testDropTableWithMissingMetadataFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingMetadataFile()).hasMessageMatching("Failed to load table: (.*)");
    }

    @Override
    @Test
    public void testDropTableWithMissingSnapshotFile() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingSnapshotFile()).isInstanceOf(QueryFailedException.class)).cause().hasMessageContaining("Failed to drop table").cause().hasMessageMatching("Server error: NotFoundException: Failed to open input stream for file: (.*)");
    }

    @Override
    @Test
    public void testDropTableWithMissingManifestListFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingManifestListFile()).hasMessageContaining("Table location should not exist");
    }

    @Override
    @Test
    public void testDropTableWithNonExistentTableLocation() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithNonExistentTableLocation()).hasMessageMatching("Failed to load table: (.*)");
    }

    @Override
    protected boolean isFileSorted(Location path, String sortColumnName) {
        if (this.format == FileFormat.PARQUET) {
            return IcebergTestUtils.checkParquetFileSorting(this.fileSystem.newInputFile(path), sortColumnName);
        }
        return IcebergTestUtils.checkOrcFileSorting(this.fileSystem, path, sortColumnName);
    }

    @Override
    protected void deleteDirectory(String location) {
        try {
            MoreFiles.deleteRecursively((Path)Path.of(location, new String[0]), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private TableIdentifier toIdentifier(String tableName) {
        return TableIdentifier.of((String[])new String[]{(String)this.getSession().getSchema().orElseThrow(), tableName});
    }
}

