/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.filesystem.Location;
import io.trino.plugin.iceberg.BaseIcebergConnectorSmokeTest;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.containers.UnityCatalogContainer;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class TestIcebergUnityRestCatalogConnectorSmokeTest
extends BaseIcebergConnectorSmokeTest {
    private final Path warehouseLocation = Files.createTempDirectory(null, new FileAttribute[0]);
    private UnityCatalogContainer unityCatalog;

    public TestIcebergUnityRestCatalogConnectorSmokeTest() throws IOException {
        super(new IcebergConfig().getFileFormat().toIceberg());
    }

    @Override
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_RENAME_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    protected QueryRunner createQueryRunner() throws Exception {
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)this.warehouseLocation, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        this.unityCatalog = (UnityCatalogContainer)this.closeAfterClass(new UnityCatalogContainer("unity", "tpch"));
        DistributedQueryRunner queryRunner = ((IcebergQueryRunner.Builder)IcebergQueryRunner.builder().setBaseDataDir(Optional.of(this.warehouseLocation))).addIcebergProperty("iceberg.file-format", this.format.name()).addIcebergProperty("iceberg.security", "read_only").addIcebergProperty("iceberg.catalog.type", "rest").addIcebergProperty("iceberg.rest-catalog.uri", this.unityCatalog.uri() + "/iceberg").addIcebergProperty("iceberg.rest-catalog.warehouse", "unity").addIcebergProperty("iceberg.register-table-procedure.enabled", "true").disableSchemaInitializer().build();
        this.unityCatalog.copyTpchTables(REQUIRED_TPCH_TABLES);
        return queryRunner;
    }

    @Override
    protected void createSchema(String schemaName) {
        this.unityCatalog.createSchema(schemaName);
    }

    @Override
    protected void dropSchema(String schema) {
        this.unityCatalog.dropSchema(schema);
    }

    @Override
    protected AutoCloseable createTable(String schema, String tableName, String tableDefinition) {
        this.unityCatalog.createTable(schema, tableName, tableDefinition);
        return () -> this.unityCatalog.dropTable(schema, tableName);
    }

    @Override
    protected void dropTableFromMetastore(String tableName) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getMetadataLocation(String tableName) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String schemaPath() {
        return String.format("%s/%s", this.warehouseLocation, this.getSession().getSchema().orElseThrow());
    }

    @Override
    protected boolean locationExists(String location) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isFileSorted(Location path, String sortColumnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void deleteDirectory(String location) {
        try {
            MoreFiles.deleteRecursively((Path)Path.of(location, new String[0]), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Test
    public void testView() {
        Assertions.assertThatThrownBy(() -> super.testView()).hasStackTraceContaining("Access Denied");
    }

    @Test
    public void testCommentView() {
        Assertions.assertThatThrownBy(() -> super.testCommentView()).hasStackTraceContaining("Access Denied");
    }

    @Test
    public void testCommentViewColumn() {
        Assertions.assertThatThrownBy(() -> super.testCommentViewColumn()).hasStackTraceContaining("Access Denied");
    }

    @Test
    public void testMaterializedView() {
        Assertions.assertThatThrownBy(() -> super.testMaterializedView()).hasStackTraceContaining("Access Denied");
    }

    @Test
    public void testRenameSchema() {
        Assertions.assertThatThrownBy(() -> super.testRenameSchema()).hasStackTraceContaining("Access Denied");
    }

    @Test
    public void testRenameTable() {
        Assertions.assertThatThrownBy(() -> super.testRenameTable()).hasStackTraceContaining("Access Denied");
    }

    @Test
    public void testRenameTableAcrossSchemas() {
        Assertions.assertThatThrownBy(() -> super.testRenameTableAcrossSchemas()).hasStackTraceContaining("Access Denied");
    }

    @Test
    public void testCreateTable() {
        Assertions.assertThatThrownBy(() -> super.testCreateTable()).hasMessageContaining("Access Denied");
    }

    @Test
    public void testCreateTableAsSelect() {
        Assertions.assertThatThrownBy(() -> super.testCreateTableAsSelect()).hasMessageContaining("Access Denied");
    }

    @Test
    public void testUpdate() {
        Assertions.assertThatThrownBy(() -> super.testUpdate()).hasMessageContaining("Access Denied");
    }

    @Test
    public void testInsert() {
        Assertions.assertThatThrownBy(() -> super.testInsert()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testHiddenPathColumn() {
        Assertions.assertThatThrownBy(() -> super.testHiddenPathColumn()).hasMessageContaining("Access Denied");
    }

    @Test
    public void testRowLevelDelete() {
        Assertions.assertThatThrownBy(() -> super.testRowLevelDelete()).hasMessageContaining("Access Denied");
    }

    @Test
    public void testDeleteAllDataFromTable() {
        Assertions.assertThatThrownBy(() -> super.testDeleteAllDataFromTable()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testDeleteRowsConcurrently() {
        Assertions.assertThatThrownBy(() -> super.testDeleteRowsConcurrently()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testCreateOrReplaceTable() {
        Assertions.assertThatThrownBy(() -> super.testCreateOrReplaceTable()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testCreateOrReplaceTableChangeColumnNamesAndTypes() {
        Assertions.assertThatThrownBy(() -> super.testCreateOrReplaceTableChangeColumnNamesAndTypes()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testRegisterTableWithTableLocation() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithTableLocation()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testRegisterTableWithComments() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithComments()).hasMessageContaining("Access Denied");
    }

    @Test
    public void testRowLevelUpdate() {
        Assertions.assertThatThrownBy(() -> super.testRowLevelUpdate()).hasMessageContaining("Access Denied");
    }

    @Test
    public void testMerge() {
        Assertions.assertThatThrownBy(() -> super.testMerge()).hasMessageContaining("Access Denied");
    }

    @Test
    public void testCreateSchema() {
        Assertions.assertThatThrownBy(() -> super.testCreateSchema()).hasMessageContaining("Access Denied");
    }

    @Test
    public void testCreateSchemaWithNonLowercaseOwnerName() {
        Assertions.assertThatThrownBy(() -> super.testCreateSchemaWithNonLowercaseOwnerName()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testRegisterTableWithShowCreateTable() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithShowCreateTable()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testRegisterTableWithReInsert() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithReInsert()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testRegisterTableWithDroppedTable() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithDroppedTable()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testRegisterTableWithDifferentTableName() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithDifferentTableName()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testRegisterTableWithMetadataFile() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithMetadataFile()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testCreateTableWithTrailingSpaceInLocation() {
        Assertions.assertThatThrownBy(() -> super.testCreateTableWithTrailingSpaceInLocation()).hasStackTraceContaining("Access Denied");
    }

    @Override
    @Test
    public void testRegisterTableWithTrailingSpaceInLocation() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithTrailingSpaceInLocation()).hasStackTraceContaining("Access Denied");
    }

    @Override
    @Test
    public void testUnregisterTable() {
        Assertions.assertThatThrownBy(() -> super.testUnregisterTable()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testUnregisterBrokenTable() {
        Assertions.assertThatThrownBy(() -> super.testUnregisterBrokenTable()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testUnregisterTableNotExistingTable() {
        Assertions.assertThatThrownBy(() -> super.testUnregisterTableNotExistingTable()).hasStackTraceContaining("Table .* not found");
    }

    @Override
    @Test
    public void testUnregisterTableNotExistingSchema() {
        Assertions.assertThatThrownBy(() -> super.testUnregisterTableNotExistingSchema()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testRepeatUnregisterTable() {
        Assertions.assertThatThrownBy(() -> super.testRepeatUnregisterTable()).hasStackTraceContaining("Table .* not found");
    }

    @Override
    @Test
    public void testUnregisterTableAccessControl() {
        Assertions.assertThatThrownBy(() -> super.testUnregisterTableAccessControl()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testCreateTableWithNonExistingSchemaVerifyLocation() {
        Assertions.assertThatThrownBy(() -> super.testCreateTableWithNonExistingSchemaVerifyLocation()).hasStackTraceContaining("Access Denied");
    }

    @Override
    @Test
    public void testSortedNationTable() {
        Assertions.assertThatThrownBy(() -> super.testSortedNationTable()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testFileSortingWithLargerTable() {
        Assertions.assertThatThrownBy(() -> super.testFileSortingWithLargerTable()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testDropTableWithMissingMetadataFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingMetadataFile()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testDropTableWithMissingSnapshotFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingSnapshotFile()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testDropTableWithMissingManifestListFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingManifestListFile()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testDropTableWithMissingDataFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingDataFile()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testDropTableWithNonExistentTableLocation() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithNonExistentTableLocation()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testMetadataTables() {
        Assertions.assertThatThrownBy(() -> super.testMetadataTables()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testPartitionFilterRequired() {
        Assertions.assertThatThrownBy(() -> super.testPartitionFilterRequired()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testTableChangesFunction() {
        Assertions.assertThatThrownBy(() -> super.testTableChangesFunction()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testRowLevelDeletesWithTableChangesFunction() {
        Assertions.assertThatThrownBy(() -> super.testRowLevelDeletesWithTableChangesFunction()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testCreateOrReplaceWithTableChangesFunction() {
        Assertions.assertThatThrownBy(() -> super.testCreateOrReplaceWithTableChangesFunction()).hasMessageContaining("Access Denied");
    }

    @Test
    public void testTruncateTable() {
        Assertions.assertThatThrownBy(() -> super.testTruncateTable()).hasMessageContaining("Access Denied");
    }

    @Override
    @Test
    public void testMetadataDeleteAfterCommitEnabled() {
        Assertions.assertThatThrownBy(() -> super.testMetadataDeleteAfterCommitEnabled()).hasStackTraceContaining("Access Denied");
    }
}

