/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.collect.ImmutableMap;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.filesystem.Location;
import io.trino.filesystem.s3.S3FileSystemConfig;
import io.trino.filesystem.s3.S3FileSystemFactory;
import io.trino.filesystem.s3.S3FileSystemStats;
import io.trino.plugin.iceberg.BaseIcebergConnectorSmokeTest;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.testing.QueryFailedException;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingNames;
import io.trino.testing.containers.IcebergRestCatalogBackendContainer;
import io.trino.testing.containers.Minio;
import io.trino.testing.minio.MinioClient;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.RESTSessionCatalog;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.testcontainers.containers.Network;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;

public class TestIcebergVendingRestCatalogConnectorSmokeTest
extends BaseIcebergConnectorSmokeTest {
    private final String bucketName = "test-iceberg-vending-rest-connector-smoke-test-" + TestingNames.randomNameSuffix();
    private String warehouseLocation;
    private IcebergRestCatalogBackendContainer restCatalogBackendContainer;
    private Minio minio;

    public TestIcebergVendingRestCatalogConnectorSmokeTest() {
        super(new IcebergConfig().getFileFormat().toIceberg());
    }

    @Override
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_RENAME_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    protected QueryRunner createQueryRunner() throws Exception {
        Network network = Network.newNetwork();
        this.minio = (Minio)this.closeAfterClass((AutoCloseable)((Minio.Builder)Minio.builder().withNetwork(network)).build());
        this.minio.start();
        this.minio.createBucket(this.bucketName);
        this.warehouseLocation = "s3://%s/default/".formatted(this.bucketName);
        AwsBasicCredentials credentials = AwsBasicCredentials.create((String)"accesskey", (String)"secretkey");
        StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)((StsClientBuilder)StsClient.builder().endpointOverride(URI.create(this.minio.getMinioAddress()))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials))).region(Region.US_EAST_1)).build();
        AssumeRoleResponse assumeRoleResponse = stsClient.assumeRole((AssumeRoleRequest)AssumeRoleRequest.builder().build());
        this.restCatalogBackendContainer = (IcebergRestCatalogBackendContainer)this.closeAfterClass((AutoCloseable)new IcebergRestCatalogBackendContainer(Optional.of(network), this.warehouseLocation, assumeRoleResponse.credentials().accessKeyId(), assumeRoleResponse.credentials().secretAccessKey(), assumeRoleResponse.credentials().sessionToken()));
        this.restCatalogBackendContainer.start();
        return IcebergQueryRunner.builder().setIcebergProperties((Map<String, String>)ImmutableMap.builder().put((Object)"iceberg.file-format", (Object)this.format.name()).put((Object)"iceberg.catalog.type", (Object)"rest").put((Object)"iceberg.rest-catalog.uri", (Object)("http://" + this.restCatalogBackendContainer.getRestCatalogEndpoint())).put((Object)"iceberg.rest-catalog.vended-credentials-enabled", (Object)"true").put((Object)"iceberg.writer-sort-buffer-size", (Object)"1MB").put((Object)"iceberg.allowed-extra-properties", (Object)"write.metadata.delete-after-commit.enabled,write.metadata.previous-versions-max").put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)this.minio.getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").buildOrThrow()).setInitialTables(REQUIRED_TPCH_TABLES).build();
    }

    @Override
    @BeforeAll
    public void initFileSystem() {
        this.fileSystem = new S3FileSystemFactory(OpenTelemetry.noop(), new S3FileSystemConfig().setRegion("us-east-1").setEndpoint(this.minio.getMinioAddress()).setPathStyleAccess(true).setAwsAccessKey("accesskey").setAwsSecretKey("secretkey"), new S3FileSystemStats()).create(TestingConnectorSession.SESSION);
    }

    @Test
    public void testMaterializedView() {
        Assertions.assertThatThrownBy(() -> super.testMaterializedView()).hasMessageContaining("createMaterializedView is not supported for Iceberg REST catalog");
    }

    @Test
    public void testRenameSchema() {
        Assertions.assertThatThrownBy(() -> super.testRenameSchema()).hasMessageContaining("renameNamespace is not supported for Iceberg REST catalog");
    }

    @Override
    protected void dropTableFromMetastore(String tableName) {
    }

    @Override
    protected String getMetadataLocation(String tableName) {
        String string;
        RESTSessionCatalog catalog = new RESTSessionCatalog();
        try {
            catalog.initialize("rest-catalog", (Map)ImmutableMap.of((Object)"uri", (Object)("http://" + this.restCatalogBackendContainer.getRestCatalogEndpoint())));
            SessionCatalog.SessionContext context = new SessionCatalog.SessionContext("user-default", "user", (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Object)TestingConnectorSession.SESSION.getIdentity());
            string = ((BaseTable)catalog.loadTable(context, this.toIdentifier(tableName))).operations().current().metadataFileLocation();
        }
        catch (Throwable throwable) {
            try {
                try {
                    catalog.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catalog.close();
        return string;
    }

    @Override
    protected String schemaPath() {
        return String.format("%s%s", this.warehouseLocation, this.getSession().getSchema().orElseThrow());
    }

    @Override
    protected boolean locationExists(String location) {
        return Files.exists(Path.of(location, new String[0]), new LinkOption[0]);
    }

    @Override
    @Test
    public void testRegisterTableWithTableLocation() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithTableLocation()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testRegisterTableWithComments() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithComments()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testRegisterTableWithShowCreateTable() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithShowCreateTable()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testRegisterTableWithReInsert() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithReInsert()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testRegisterTableWithDroppedTable() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithDroppedTable()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testRegisterTableWithDifferentTableName() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithDifferentTableName()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testRegisterTableWithMetadataFile() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithMetadataFile()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testRegisterTableWithTrailingSpaceInLocation() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithTrailingSpaceInLocation()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testUnregisterTable() {
        Assertions.assertThatThrownBy(() -> super.testUnregisterTable()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testRepeatUnregisterTable() {
        Assertions.assertThatThrownBy(() -> super.testRepeatUnregisterTable()).hasMessageContaining("register_table procedure is disabled");
    }

    @Override
    @Test
    public void testDropTableWithMissingMetadataFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingMetadataFile()).hasMessageMatching("Failed to load table: (.*)");
    }

    @Override
    @Test
    public void testDropTableWithMissingSnapshotFile() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingSnapshotFile()).isInstanceOf(QueryFailedException.class)).cause().hasMessageContaining("Failed to drop table").cause().hasMessageMatching("Server error: NoSuchKeyException:.*");
    }

    @Override
    @Test
    public void testDropTableWithMissingManifestListFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingManifestListFile()).hasMessageContaining("Table location should not exist");
    }

    @Override
    @Test
    public void testDropTableWithNonExistentTableLocation() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithNonExistentTableLocation()).hasMessageMatching("Failed to load table: (.*)");
    }

    @Override
    protected boolean isFileSorted(Location path, String sortColumnName) {
        if (this.format == FileFormat.PARQUET) {
            return IcebergTestUtils.checkParquetFileSorting(this.fileSystem.newInputFile(path), sortColumnName);
        }
        return IcebergTestUtils.checkOrcFileSorting(this.fileSystem, path, sortColumnName);
    }

    @Override
    protected void deleteDirectory(String location) {
        try (MinioClient minioClient = this.minio.createMinioClient();){
            String prefix = "s3://" + this.bucketName + "/";
            String key = location.substring(prefix.length());
            for (String file : minioClient.listObjects(this.bucketName, key)) {
                minioClient.removeObject(this.bucketName, file);
            }
            Assertions.assertThat((List)minioClient.listObjects(this.bucketName, key)).isEmpty();
        }
    }

    private TableIdentifier toIdentifier(String tableName) {
        return TableIdentifier.of((String[])new String[]{(String)this.getSession().getSchema().orElseThrow(), tableName});
    }
}

