/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.iceberg.catalog.rest.OAuth2SecurityConfig;
import java.net.URI;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOAuth2SecurityConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((OAuth2SecurityConfig)ConfigAssertions.recordDefaults(OAuth2SecurityConfig.class)).setCredential(null).setToken(null).setScope(null).setServerUri(null).setTokenRefreshEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"iceberg.rest-catalog.oauth2.token", (Object)"token").put((Object)"iceberg.rest-catalog.oauth2.credential", (Object)"credential").put((Object)"iceberg.rest-catalog.oauth2.scope", (Object)"scope").put((Object)"iceberg.rest-catalog.oauth2.server-uri", (Object)"http://localhost:8080/realms/iceberg/protocol/openid-connect/token").put((Object)"iceberg.rest-catalog.oauth2.token-refresh-enabled", (Object)"false").buildOrThrow();
        OAuth2SecurityConfig expected = new OAuth2SecurityConfig().setCredential("credential").setToken("token").setScope("scope").setServerUri(URI.create("http://localhost:8080/realms/iceberg/protocol/openid-connect/token")).setTokenRefreshEnabled(false);
        Assertions.assertThat((boolean)expected.credentialOrTokenPresent()).isTrue();
        Assertions.assertThat((boolean)expected.scopePresentOnlyWithCredential()).isFalse();
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

