/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.json.JsonCodec;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.metastore.TableInfo;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.IcebergMetadata;
import io.trino.plugin.iceberg.TableStatisticsWriter;
import io.trino.plugin.iceberg.catalog.BaseTrinoCatalogTest;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.rest.IcebergRestCatalogConfig;
import io.trino.plugin.iceberg.catalog.rest.RestCatalogTestUtils;
import io.trino.plugin.iceberg.catalog.rest.TrinoRestCatalog;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TypeManager;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingNames;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.rest.DelegatingRestSessionCatalog;
import org.apache.iceberg.rest.RESTSessionCatalog;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class TestTrinoRestCatalog
extends BaseTrinoCatalogTest {
    @Override
    protected TrinoCatalog createTrinoCatalog(boolean useUniqueTableLocations) throws IOException {
        return TestTrinoRestCatalog.createTrinoRestCatalog(useUniqueTableLocations, (Map<String, String>)ImmutableMap.of());
    }

    private static TrinoRestCatalog createTrinoRestCatalog(boolean useUniqueTableLocations, Map<String, String> properties) throws IOException {
        Path warehouseLocation = Files.createTempDirectory(null, new FileAttribute[0]);
        warehouseLocation.toFile().deleteOnExit();
        String catalogName = "iceberg_rest";
        DelegatingRestSessionCatalog restSessionCatalog = DelegatingRestSessionCatalog.builder().delegate(RestCatalogTestUtils.backendCatalog(warehouseLocation)).build();
        restSessionCatalog.initialize(catalogName, properties);
        return new TrinoRestCatalog((RESTSessionCatalog)restSessionCatalog, new CatalogName(catalogName), IcebergRestCatalogConfig.SessionType.NONE, (Map)ImmutableMap.of(), false, "test", (TypeManager)new TestingTypeManager(), useUniqueTableLocations, false, EvictableCacheBuilder.newBuilder().expireAfterWrite(1000L, TimeUnit.MILLISECONDS).shareNothingWhenDisabled().build(), EvictableCacheBuilder.newBuilder().expireAfterWrite(1000L, TimeUnit.MILLISECONDS).shareNothingWhenDisabled().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testNonLowercaseNamespace() throws Exception {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        String namespace = "testNonLowercaseNamespace" + TestingNames.randomNameSuffix();
        String schema = namespace.toLowerCase(Locale.ENGLISH);
        catalog.createNamespace(SESSION, namespace, this.defaultNamespaceProperties(namespace), new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
        try {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.namespaceExists(SESSION, namespace)).as("catalog.namespaceExists(namespace)", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.namespaceExists(SESSION, schema)).as("catalog.namespaceExists(schema)", new Object[0])).isFalse();
            ((ListAssert)((ListAssert)Assertions.assertThat((List)catalog.listNamespaces(SESSION)).as("catalog.listNamespaces", new Object[0])).doesNotContain((Object[])new String[]{schema})).contains((Object[])new String[]{namespace});
            IcebergMetadata icebergMetadata = new IcebergMetadata(TestingPlannerContext.PLANNER_CONTEXT.getTypeManager(), CatalogHandle.fromId((String)"iceberg:NORMAL:v12345"), JsonCodec.jsonCodec(CommitTaskData.class), catalog, (connectorIdentity, fileIoProperties) -> {
                throw new UnsupportedOperationException();
            }, new TableStatisticsWriter(new NodeVersion("test-version")), Optional.empty(), false, string -> false, (ExecutorService)MoreExecutors.newDirectExecutorService(), MoreExecutors.directExecutor(), (ExecutorService)MoreExecutors.newDirectExecutorService());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)icebergMetadata.schemaExists(SESSION, namespace)).as("icebergMetadata.schemaExists(namespace)", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)icebergMetadata.schemaExists(SESSION, schema)).as("icebergMetadata.schemaExists(schema)", new Object[0])).isFalse();
            ((ListAssert)((ListAssert)Assertions.assertThat((List)icebergMetadata.listSchemaNames(SESSION)).as("icebergMetadata.listSchemaNames", new Object[0])).doesNotContain((Object[])new String[]{schema})).contains((Object[])new String[]{namespace});
        }
        finally {
            catalog.dropNamespace(SESSION, namespace);
        }
    }

    @Test
    public void testPrefix() throws Exception {
        TrinoRestCatalog catalog = TestTrinoRestCatalog.createTrinoRestCatalog(false, (Map<String, String>)ImmutableMap.of((Object)"prefix", (Object)"dev"));
        String namespace = "testPrefixNamespace" + TestingNames.randomNameSuffix();
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testPrefix$0((TrinoCatalog)catalog, namespace)).isInstanceOf(TrinoException.class)).hasMessageContaining("Failed to create namespace").cause().as("should fail as the prefix dev is not implemented for the current endpoint", new Object[0])).hasMessageContaining("Malformed request: No route for request: POST v1/dev/namespaces");
    }

    @Override
    protected TableInfo.ExtendedRelationType getViewType() {
        return TableInfo.ExtendedRelationType.OTHER_VIEW;
    }

    private /* synthetic */ void lambda$testPrefix$0(TrinoCatalog catalog, String namespace) throws Throwable {
        catalog.createNamespace(SESSION, namespace, this.defaultNamespaceProperties(namespace), new TrinoPrincipal(PrincipalType.USER, SESSION.getUser()));
    }
}

