/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.http.client.StringResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.ObjectMapperProvider;
import io.trino.testing.TestingProperties;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public final class TestingPolarisCatalog
implements Closeable {
    public static final String WAREHOUSE = "polaris";
    private static final int POLARIS_PORT = 8181;
    public static final String CREDENTIAL = "root:s3cr3t";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    private static final HttpClient HTTP_CLIENT = new JettyHttpClient();
    private final GenericContainer<?> polarisCatalog;
    private final String token;
    private final String warehouseLocation;

    public TestingPolarisCatalog(String warehouseLocation) {
        this.warehouseLocation = Objects.requireNonNull(warehouseLocation, "warehouseLocation is null");
        this.polarisCatalog = new GenericContainer("ghcr.io/trinodb/testing/polaris-catalog:" + TestingProperties.getDockerImagesVersion());
        this.polarisCatalog.addExposedPort(Integer.valueOf(8181));
        this.polarisCatalog.withFileSystemBind(warehouseLocation, warehouseLocation, BindMode.READ_WRITE);
        this.polarisCatalog.waitingFor((WaitStrategy)new LogMessageWaitStrategy().withRegEx(".*Apache Polaris Server.* started.*"));
        this.polarisCatalog.withEnv("POLARIS_BOOTSTRAP_CREDENTIALS", "default-realm,root,s3cr3t");
        this.polarisCatalog.withEnv("polaris.realm-context.realms", "default-realm");
        this.polarisCatalog.start();
        this.token = this.getToken();
        this.createCatalog();
        this.grantPrivilege();
    }

    private String getToken() {
        String body = "grant_type=client_credentials&client_id=root&client_secret=s3cr3t&scope=PRINCIPAL_ROLE:ALL";
        Request request = Request.Builder.preparePost().setUri(URI.create(this.restUri() + "/api/catalog/v1/oauth/tokens")).setHeader("Polaris-Realm", "default-realm").setHeader("Content-Type", "application/x-www-form-urlencoded").setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)body, (Charset)StandardCharsets.UTF_8)).build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)HTTP_CLIENT.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        try {
            return OBJECT_MAPPER.readTree(response.getBody()).get("access_token").asText();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void createCatalog() {
        String body = "{\"name\": \"polaris\",\"id\": 1,\"type\": \"INTERNAL\",\"readOnly\": false, \"storageConfigInfo\": {\"storageType\": \"FILE\"}, \"properties\": {\"default-base-location\": \"file://" + this.warehouseLocation + "\"}}";
        Request request = Request.Builder.preparePost().setUri(URI.create(this.restUri() + "/api/management/v1/catalogs")).setHeader("Authorization", "Bearer " + this.token).setHeader("Content-Type", "application/json").setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)body, (Charset)StandardCharsets.UTF_8)).build();
        HTTP_CLIENT.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
    }

    private void grantPrivilege() {
        String body = "{\"grant\": {\"type\": \"catalog\", \"privilege\": \"TABLE_WRITE_DATA\"}}";
        Request request = Request.Builder.preparePut().setUri(URI.create(this.restUri() + "/api/management/v1/catalogs/polaris/catalog-roles/catalog_admin/grants")).setHeader("Authorization", "Bearer " + this.token).setHeader("Content-Type", "application/json").setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)body, (Charset)StandardCharsets.UTF_8)).build();
        HTTP_CLIENT.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
    }

    public void dropTable(String schema, String table) {
        Request request = Request.Builder.prepareDelete().setUri(URI.create(this.restUri() + "/api/catalog/v1/polaris/namespaces/" + schema + "/tables/" + table)).setHeader("Authorization", "Bearer " + this.token).setHeader("Content-Type", "application/json").build();
        HTTP_CLIENT.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
    }

    public String restUri() {
        return "http://%s:%s".formatted(this.polarisCatalog.getHost(), this.polarisCatalog.getMappedPort(8181));
    }

    @Override
    public void close() {
        this.polarisCatalog.close();
    }
}

