/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.snowflake;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.iceberg.catalog.snowflake.IcebergSnowflakeCatalogConfig;
import java.net.URI;
import java.sql.SQLException;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIcebergSnowflakeCatalogConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((IcebergSnowflakeCatalogConfig)ConfigAssertions.recordDefaults(IcebergSnowflakeCatalogConfig.class)).setUser(null).setPassword(null).setDatabase(null).setUri(null).setRole(null));
    }

    @Test
    public void testExplicitPropertyMapping() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"iceberg.snowflake-catalog.password", (Object)"password").put((Object)"iceberg.snowflake-catalog.user", (Object)"user").put((Object)"iceberg.snowflake-catalog.role", (Object)"role").put((Object)"iceberg.snowflake-catalog.account-uri", (Object)"jdbc:snowflake://sample.url").put((Object)"iceberg.snowflake-catalog.database", (Object)"database").buildOrThrow();
        IcebergSnowflakeCatalogConfig expected = new IcebergSnowflakeCatalogConfig().setPassword("password").setUser("user").setRole("role").setUri(URI.create("jdbc:snowflake://sample.url")).setDatabase("database");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testInvalidSnowflakeUrl() throws SQLException {
        IcebergSnowflakeCatalogConfig config = new IcebergSnowflakeCatalogConfig().setPassword("password").setUser("user").setRole("role").setUri(URI.create("foobar")).setDatabase("database");
        Assertions.assertThat((boolean)config.isUrlValid()).isFalse();
    }
}

