/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.snowflake;

import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.Location;
import io.trino.plugin.iceberg.BaseIcebergConnectorSmokeTest;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.plugin.iceberg.SchemaInitializer;
import io.trino.plugin.iceberg.catalog.snowflake.TestingSnowflakeServer;
import io.trino.testing.QueryFailedException;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingProperties;
import io.trino.tpch.TpchTable;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import org.apache.iceberg.FileFormat;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIcebergSnowflakeCatalogConnectorSmokeTest
extends BaseIcebergConnectorSmokeTest {
    public static final String S3_ACCESS_KEY = TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.s3.access-key");
    public static final String S3_SECRET_KEY = TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.s3.secret-key");
    public static final String S3_REGION = TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.s3.region");
    public static final String SNOWFLAKE_S3_EXTERNAL_VOLUME = TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.s3.external.volume");
    public static final String SNOWFLAKE_TEST_SCHEMA = TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.schema");
    private TestingSnowflakeServer server;

    public TestIcebergSnowflakeCatalogConnectorSmokeTest() {
        super(FileFormat.PARQUET);
    }

    protected QueryRunner createQueryRunner() throws Exception {
        this.server = new TestingSnowflakeServer();
        this.server.execute(SNOWFLAKE_TEST_SCHEMA, "CREATE SCHEMA IF NOT EXISTS %s".formatted(SNOWFLAKE_TEST_SCHEMA));
        if (!this.server.checkIfTableExists(TestingSnowflakeServer.TableType.ICEBERG, SNOWFLAKE_TEST_SCHEMA, TpchTable.NATION.getTableName())) {
            this.executeOnSnowflake("CREATE OR REPLACE ICEBERG TABLE %s (\n\tNATIONKEY NUMBER(38,0),\n\tNAME STRING,\n\tREGIONKEY NUMBER(38,0),\n\tCOMMENT STRING\n)\n EXTERNAL_VOLUME = '%s'\n CATALOG = 'SNOWFLAKE'\n BASE_LOCATION = '%s/'".formatted(TpchTable.NATION.getTableName(), SNOWFLAKE_S3_EXTERNAL_VOLUME, TpchTable.NATION.getTableName()));
            this.executeOnSnowflake("INSERT INTO %s(NATIONKEY, NAME, REGIONKEY, COMMENT) SELECT N_NATIONKEY, N_NAME, N_REGIONKEY, N_COMMENT FROM SNOWFLAKE_SAMPLE_DATA.TPCH_SF1.%s".formatted(TpchTable.NATION.getTableName(), TpchTable.NATION.getTableName()));
        }
        if (!this.server.checkIfTableExists(TestingSnowflakeServer.TableType.ICEBERG, SNOWFLAKE_TEST_SCHEMA, TpchTable.REGION.getTableName())) {
            this.executeOnSnowflake("CREATE OR REPLACE ICEBERG TABLE %s (\n\tREGIONKEY NUMBER(38,0),\n\tNAME STRING,\n\tCOMMENT STRING\n)\n EXTERNAL_VOLUME = '%s'\n CATALOG = 'SNOWFLAKE'\n BASE_LOCATION = '%s/'".formatted(TpchTable.REGION.getTableName(), SNOWFLAKE_S3_EXTERNAL_VOLUME, TpchTable.REGION.getTableName()));
            this.executeOnSnowflake("INSERT INTO %s(REGIONKEY, NAME, COMMENT) SELECT R_REGIONKEY, R_NAME, R_COMMENT FROM SNOWFLAKE_SAMPLE_DATA.TPCH_SF1.%s".formatted(TpchTable.REGION.getTableName(), TpchTable.REGION.getTableName()));
        }
        ImmutableMap properties = ImmutableMap.builder().put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)S3_ACCESS_KEY).put((Object)"s3.aws-secret-key", (Object)S3_SECRET_KEY).put((Object)"s3.region", (Object)S3_REGION).put((Object)"iceberg.file-format", (Object)"parquet").put((Object)"iceberg.catalog.type", (Object)"snowflake").put((Object)"iceberg.snowflake-catalog.role", (Object)TestingSnowflakeServer.SNOWFLAKE_ROLE).put((Object)"iceberg.snowflake-catalog.database", (Object)TestingSnowflakeServer.SNOWFLAKE_TEST_DATABASE).put((Object)"iceberg.snowflake-catalog.account-uri", (Object)TestingSnowflakeServer.SNOWFLAKE_JDBC_URI).put((Object)"iceberg.snowflake-catalog.user", (Object)TestingSnowflakeServer.SNOWFLAKE_USER).put((Object)"iceberg.snowflake-catalog.password", (Object)TestingSnowflakeServer.SNOWFLAKE_PASSWORD).buildOrThrow();
        return IcebergQueryRunner.builder(SNOWFLAKE_TEST_SCHEMA.toLowerCase(Locale.ENGLISH)).setIcebergProperties((Map<String, String>)properties).setSchemaInitializer(SchemaInitializer.builder().withSchemaName(SNOWFLAKE_TEST_SCHEMA.toLowerCase(Locale.ENGLISH)).build()).build();
    }

    @Override
    protected void createSchema(String schemaName) throws SQLException {
        this.server.execute(schemaName, "CREATE SCHEMA " + schemaName);
    }

    @Override
    protected void dropSchema(String schema) throws SQLException {
        this.server.execute(schema, "DROP SCHEMA " + schema);
    }

    @Override
    protected AutoCloseable createTable(String schema, String tableName, String tableDefinition) throws SQLException {
        this.server.execute(schema, "CREATE OR REPLACE ICEBERG TABLE %s %s\n EXTERNAL_VOLUME = '%s'\n CATALOG = 'SNOWFLAKE'\n BASE_LOCATION = '%s/'\n".formatted(tableName, tableDefinition, SNOWFLAKE_S3_EXTERNAL_VOLUME, tableName));
        return () -> this.server.execute(schema, "DROP TABLE %s".formatted(tableName));
    }

    @Override
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_CREATE_TABLE, TestingConnectorBehavior.SUPPORTS_DELETE, TestingConnectorBehavior.SUPPORTS_INSERT, TestingConnectorBehavior.SUPPORTS_CREATE_VIEW, TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA, TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA, TestingConnectorBehavior.SUPPORTS_MERGE, TestingConnectorBehavior.SUPPORTS_UPDATE, TestingConnectorBehavior.SUPPORTS_RENAME_TABLE, TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_UPDATE, TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE, TestingConnectorBehavior.SUPPORTS_CREATE_OR_REPLACE_TABLE, TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA, TestingConnectorBehavior.SUPPORTS_COMMENT_ON_TABLE, TestingConnectorBehavior.SUPPORTS_COMMENT_ON_COLUMN, TestingConnectorBehavior.SUPPORTS_COMMENT_ON_VIEW -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    @Test
    public void testView() {
        Assertions.assertThatThrownBy(() -> super.testView()).hasStackTraceContaining("This connector does not support creating views");
    }

    @Test
    public void testMaterializedView() {
        Assertions.assertThatThrownBy(() -> super.testMaterializedView()).hasStackTraceContaining("This connector does not support creating materialized views");
    }

    @Test
    public void testRenameSchema() {
        Assertions.assertThatThrownBy(() -> super.testRenameSchema()).hasStackTraceContaining("This connector does not support renaming schemas");
    }

    @Test
    public void testRenameTable() {
        Assertions.assertThatThrownBy(() -> super.testRenameTable()).hasStackTraceContaining("This connector does not support renaming tables");
    }

    @Override
    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + TpchTable.REGION.getTableName()))).matches((CharSequence)("CREATE TABLE iceberg." + SNOWFLAKE_TEST_SCHEMA.toLowerCase(Locale.ENGLISH) + ".%s \\(\n".formatted(TpchTable.REGION.getTableName()) + "   regionkey decimal\\(38, 0\\),\n   name varchar,\n   comment varchar\n\\)\nWITH \\(\n   format = 'PARQUET',\n   format_version = 2,\n" + "   location = 's3://.*/%s'\n".formatted(TpchTable.REGION.getTableName()) + "\\)"));
    }

    @Test
    public void testCreateTable() {
        Assertions.assertThatThrownBy(() -> super.testCreateTable()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void testCreateTableAsSelect() {
        Assertions.assertThatThrownBy(() -> super.testCreateTableAsSelect()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void testInsert() {
        Assertions.assertThatThrownBy(() -> super.testInsert()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testHiddenPathColumn() {
        Assertions.assertThatThrownBy(() -> super.testHiddenPathColumn()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testDeleteRowsConcurrently() {
        Assertions.assertThatThrownBy(() -> super.testDeleteRowsConcurrently()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testCreateOrReplaceTable() {
        Assertions.assertThatThrownBy(() -> super.testCreateOrReplaceTable()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testCreateOrReplaceTableChangeColumnNamesAndTypes() {
        Assertions.assertThatThrownBy(() -> super.testCreateOrReplaceTableChangeColumnNamesAndTypes()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testRegisterTableWithTableLocation() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithTableLocation()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testRegisterTableWithComments() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithComments()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void testRowLevelUpdate() {
        Assertions.assertThatThrownBy(() -> super.testRowLevelUpdate()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void testMerge() {
        Assertions.assertThatThrownBy(() -> super.testMerge()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void testCreateSchema() {
        Assertions.assertThatThrownBy(() -> super.testCreateSchema()).hasMessageContaining("This connector does not support creating schemas");
    }

    @Override
    @Test
    public void testRegisterTableWithShowCreateTable() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithShowCreateTable()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testRegisterTableWithReInsert() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithReInsert()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testRegisterTableWithDroppedTable() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithDroppedTable()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testRegisterTableWithDifferentTableName() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithDifferentTableName()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testRegisterTableWithMetadataFile() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithMetadataFile()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testCreateTableWithTrailingSpaceInLocation() {
        Assertions.assertThatThrownBy(() -> super.testCreateTableWithTrailingSpaceInLocation()).isInstanceOf(UnsupportedOperationException.class);
    }

    @Override
    @Test
    public void testRegisterTableWithTrailingSpaceInLocation() {
        Assertions.assertThatThrownBy(() -> super.testRegisterTableWithTrailingSpaceInLocation()).isInstanceOf(UnsupportedOperationException.class);
    }

    @Override
    @Test
    public void testUnregisterTable() {
        Assertions.assertThatThrownBy(() -> super.testUnregisterTable()).hasStackTraceContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testUnregisterBrokenTable() {
        Assertions.assertThatThrownBy(() -> super.testUnregisterBrokenTable()).hasStackTraceContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testUnregisterTableNotExistingTable() {
        Assertions.assertThatThrownBy(() -> super.testUnregisterTableNotExistingTable()).hasStackTraceContaining("Table .* not found");
    }

    @Override
    @Test
    public void testRepeatUnregisterTable() {
        Assertions.assertThatThrownBy(() -> super.testRepeatUnregisterTable()).hasStackTraceContaining("Table .* not found");
    }

    @Override
    @Test
    public void testUnregisterTableAccessControl() {
        Assertions.assertThatThrownBy(() -> super.testUnregisterTableAccessControl()).hasMessageMatching("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testCreateTableWithNonExistingSchemaVerifyLocation() {
        Assertions.assertThatThrownBy(() -> super.testCreateTableWithNonExistingSchemaVerifyLocation()).isInstanceOf(UnsupportedOperationException.class);
    }

    @Override
    @Test
    public void testSortedNationTable() {
        Assertions.assertThatThrownBy(() -> super.testSortedNationTable()).hasMessageMatching("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testFileSortingWithLargerTable() {
        Assertions.assertThatThrownBy(() -> super.testFileSortingWithLargerTable()).hasMessageMatching("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testDropTableWithMissingMetadataFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingMetadataFile()).hasMessageMatching("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testDropTableWithMissingSnapshotFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingSnapshotFile()).hasMessageMatching("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testDropTableWithMissingManifestListFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingManifestListFile()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testDropTableWithMissingDataFile() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithMissingDataFile()).hasMessageMatching("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testDropTableWithNonExistentTableLocation() {
        Assertions.assertThatThrownBy(() -> super.testDropTableWithNonExistentTableLocation()).hasMessageMatching("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testMetadataTables() {
        Assertions.assertThatThrownBy(() -> super.testMetadataTables()).hasMessageMatching("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testPartitionFilterRequired() {
        Assertions.assertThatThrownBy(() -> super.testPartitionFilterRequired()).hasMessageMatching("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testTableChangesFunction() {
        Assertions.assertThatThrownBy(() -> super.testTableChangesFunction()).hasMessageMatching("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testRowLevelDeletesWithTableChangesFunction() {
        Assertions.assertThatThrownBy(() -> super.testRowLevelDeletesWithTableChangesFunction()).hasMessageMatching("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testCreateOrReplaceWithTableChangesFunction() {
        Assertions.assertThatThrownBy(() -> super.testCreateOrReplaceWithTableChangesFunction()).hasMessageMatching("Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void testNation() {
        this.assertQuery("SELECT count(*) FROM " + TpchTable.NATION.getTableName(), "VALUES 25");
        this.assertTableColumnNames(TpchTable.NATION.getTableName(), new String[]{"nationkey", "name", "regionkey", "comment"});
    }

    @Test
    public void testListTables() {
        Assertions.assertThat(this.computeActual("SHOW TABLES").getMaterializedRows().stream().map(row -> row.getField(0)).toList()).contains(new Object[]{TpchTable.REGION.getTableName(), TpchTable.NATION.getTableName()});
    }

    @Test
    public void testRegion() {
        this.assertQuery("SELECT count(*) FROM " + TpchTable.REGION.getTableName(), "VALUES 5");
        this.assertTableColumnNames(TpchTable.REGION.getTableName(), new String[]{"regionkey", "name", "comment"});
        this.assertQuery("SELECT name FROM " + TpchTable.REGION.getTableName(), "VALUES ('AFRICA'), ('AMERICA'), ('ASIA'), ('EUROPE'), ('MIDDLE EAST')");
    }

    @Test
    public void testSetTableComment() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("COMMENT ON TABLE " + TpchTable.REGION.getTableName() + " is 'my-table-comment'")).hasMessage("Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void testSetViewComment() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("COMMENT ON VIEW temp_view is 'my-table-comment'")).hasMessageMatching("line 1:1: View '.*' does not exist");
    }

    @Test
    public void testSetViewColumnComment() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("COMMENT ON COLUMN temp_view.col1 is 'my-column-comment'")).hasMessageMatching(".*Table does not exist: .*temp_view");
    }

    @Test
    public void testSetMaterializedViewColumnComment() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("COMMENT ON COLUMN temp_view.col1 is 'my-column-comment'")).hasMessageMatching(".*Table does not exist: .*temp_view");
    }

    @Test
    public void testSetTableProperties() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + TpchTable.REGION.getTableName() + " SET PROPERTIES format_version = 2")).hasMessageMatching("Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void testAddColumn() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + TpchTable.REGION.getTableName() + " ADD COLUMN zip varchar")).hasMessageMatching("Failed to add column: Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void testDropColumn() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + TpchTable.REGION.getTableName() + " DROP COLUMN name")).hasMessageMatching("Failed to drop column: Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void testRenameColumn() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + TpchTable.REGION.getTableName() + " RENAME COLUMN name TO new_name")).hasMessageMatching("Failed to rename column: Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void testBeginStatisticsCollection() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ANALYZE " + TpchTable.REGION.getTableName())).hasMessageMatching("Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void testCreateView() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE VIEW temp_view AS SELECT * FROM " + TpchTable.REGION.getTableName())).hasMessage("Views are not supported for the Snowflake Iceberg catalog");
    }

    @Test
    public void testRenameView() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER VIEW non_existing_view RENAME TO existing_view")).hasMessageMatching("line 1:1: View '.*' does not exist");
    }

    @Test
    public void testDropView() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("DROP VIEW non_existing_view")).hasMessageMatching("line 1:1: View '.*' does not exist");
    }

    @Test
    public void testListViews() {
        this.assertQuery("SELECT count(*) FROM information_schema.views", "VALUES 0");
    }

    @Test
    public void testExecuteDelete() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("DELETE FROM " + TpchTable.REGION.getTableName())).hasMessageContaining("Failed to close manifest writer");
    }

    @Test
    public void testTruncateTable() {
        Assertions.assertThatThrownBy(() -> super.testTruncateTable()).hasMessageContaining("Failed to close manifest writer");
    }

    @Test
    public void testGetTableStatistics() {
        this.assertQuery("SHOW STATS FOR " + TpchTable.NATION.getTableName(), "VALUES\n('nationkey', null, null, 0, null, 0.0, '24.0'),\n('name', null, null, 0, null, null, null),\n('regionkey', null, null, 0, null, 0.0, '4.0'),\n('comment', null, null, 0, null, null, null),\n(null, null, null, null, 25, null, null)\n");
    }

    @Test
    public void testCreateMaterializedView() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE MATERIALIZED VIEW mv_orders AS SELECT * FROM orders")).hasMessageMatching(".* Table '.*orders' does not exist");
    }

    @Test
    public void testDropMaterializedView() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("DROP MATERIALIZED VIEW mv_orders")).hasMessageMatching(".*Materialized view '.*mv_orders' does not exist");
    }

    @Test
    public void testListMaterializedViews() {
        this.assertQuery("SELECT count(*) FROM information_schema.views", "VALUES 0");
    }

    @Test
    public void testRenameMaterializedView() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER MATERIALIZED VIEW mv_orders RENAME TO mv_new_orders")).hasMessageMatching(".*Materialized View '.*mv_orders' does not exist");
    }

    @Test
    public void testSetColumnComment() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("COMMENT ON COLUMN " + TpchTable.REGION.getTableName() + ".name IS 'region name_col_comment'")).hasMessageMatching("Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void testSnowflakeNativeTable() throws SQLException {
        String snowflakeNativeTableName = "snowflake_native_nation";
        if (!this.server.checkIfTableExists(TestingSnowflakeServer.TableType.NATIVE, SNOWFLAKE_TEST_SCHEMA, snowflakeNativeTableName)) {
            this.executeOnSnowflake("CREATE TABLE %s IF NOT EXISTS AS SELECT * FROM SNOWFLAKE_SAMPLE_DATA.TPCH_SF1.%s".formatted(snowflakeNativeTableName, TpchTable.NATION.getTableName()));
        }
        Assertions.assertThatThrownBy(() -> this.assertQuery("SELECT count(*) FROM " + snowflakeNativeTableName)).hasCauseInstanceOf(QueryFailedException.class).hasRootCauseMessage("SQL compilation error:\ninvalid parameter 'table ? is not a Snowflake iceberg table'");
    }

    @Override
    protected boolean isFileSorted(Location path, String sortColumnName) {
        if (this.format == FileFormat.PARQUET) {
            return IcebergTestUtils.checkParquetFileSorting(this.fileSystem.newInputFile(path), sortColumnName);
        }
        throw new UnsupportedOperationException("Only PARQUET file format is supported for Iceberg Snowflake catalogs");
    }

    @Override
    protected void deleteDirectory(String location) {
        throw new UnsupportedOperationException("deleteDirectory is not supported for Iceberg snowflake catalog");
    }

    @Override
    protected void dropTableFromMetastore(String tableName) {
        throw new UnsupportedOperationException("dropTableFromMetastore is not supported for Iceberg snowflake catalog");
    }

    @Override
    protected String getMetadataLocation(String tableName) {
        throw new UnsupportedOperationException("getMetadataLocation is not supported for Iceberg snowflake catalog");
    }

    @Override
    protected String schemaPath() {
        throw new UnsupportedOperationException("schemaPath is not supported for Iceberg snowflake catalog");
    }

    @Override
    protected boolean locationExists(String location) {
        throw new UnsupportedOperationException("locationExists is not supported for Iceberg snowflake catalog");
    }

    private void executeOnSnowflake(String sql) throws SQLException {
        this.server.execute(SNOWFLAKE_TEST_SCHEMA, sql);
    }
}

