/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.catalog.snowflake;

import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import io.trino.testing.TestingProperties;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;

public class TestingSnowflakeServer {
    private static final Logger LOG = Logger.get(TestingSnowflakeServer.class);
    public static final String SNOWFLAKE_JDBC_URI = TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.account-url");
    public static final String SNOWFLAKE_USER = TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.user");
    public static final String SNOWFLAKE_PASSWORD = TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.password");
    public static final String SNOWFLAKE_ROLE = TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.role");
    public static final String SNOWFLAKE_WAREHOUSE = TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.warehouse");
    public static final String SNOWFLAKE_TEST_DATABASE = TestingProperties.requiredNonEmptySystemProperty((String)"testing.snowflake.catalog.database");

    public void execute(String schema, String sql) throws SQLException {
        Preconditions.checkArgument((sql != null && !sql.isEmpty() ? 1 : 0) != 0, (Object)"sql can not be null or empty");
        this.executeOnDatabaseWithResultSetOperator(schema, Optional.empty(), sql);
    }

    public boolean checkIfTableExists(TableType tableType, String schema, String tableName) throws SQLException {
        Function<ResultSet, Boolean> tableExistsOperator = resultSet -> {
            try {
                return resultSet.next();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        };
        String sql = "SHOW %sTABLES LIKE '%s'".formatted(tableType == TableType.ICEBERG ? "ICEBERG " : "", tableName);
        return (Boolean)this.executeOnDatabaseWithResultSetOperator(schema, Optional.of(tableExistsOperator), sql).orElseThrow();
    }

    private <T> Optional<T> executeOnDatabaseWithResultSetOperator(String schema, Optional<Function<ResultSet, T>> function, String sql) throws SQLException {
        Properties properties = new Properties();
        properties.put("user", SNOWFLAKE_USER);
        properties.put("password", SNOWFLAKE_PASSWORD);
        properties.put("role", SNOWFLAKE_ROLE);
        properties.put("warehouse", SNOWFLAKE_WAREHOUSE);
        properties.put("db", SNOWFLAKE_TEST_DATABASE);
        properties.put("schema", schema);
        try (Connection connection = DriverManager.getConnection(SNOWFLAKE_JDBC_URI, properties);){
            Optional<Object> optional;
            block12: {
                Statement statement = connection.createStatement();
                try {
                    LOG.info("Using user: %s, role: %s, warehouse: %s, database: %s, schema: %s to execute: [%s]", new Object[]{SNOWFLAKE_USER, SNOWFLAKE_ROLE, SNOWFLAKE_WAREHOUSE, SNOWFLAKE_TEST_DATABASE, schema, sql});
                    statement.execute(sql);
                    optional = function.map(func -> {
                        try {
                            return func.apply(statement.getResultSet());
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    if (statement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return optional;
        }
    }

    public static enum TableType {
        NATIVE,
        ICEBERG;

    }
}

