/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.containers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.testing.containers.BaseTestContainer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.testcontainers.containers.Network;

public class KeycloakContainer
extends BaseTestContainer {
    public static final String DEFAULT_IMAGE = "quay.io/keycloak/keycloak:24.0.1";
    public static final String DEFAULT_HOST_NAME = "keycloak";
    public static final String DEFAULT_USER_NAME = "admin";
    public static final String DEFAULT_PASSWORD = "admin";
    public static final int PORT = 8080;
    public static final String SERVER_URL = "http://keycloak:8080";

    public static Builder builder() {
        return new Builder();
    }

    private KeycloakContainer(String image, String hostName, Set<Integer> exposePorts, Map<String, String> filesToMount, Map<String, String> envVars, Optional<Network> network, int retryLimit) {
        super(image, hostName, exposePorts, filesToMount, envVars, network, retryLimit);
    }

    protected void setupContainer() {
        super.setupContainer();
        this.withRunCommand((List)ImmutableList.of((Object)"start-dev"));
    }

    public void start() {
        super.start();
    }

    public String getUrl() {
        return "http://" + String.valueOf(this.getMappedHostAndPortForExposedPort(8080));
    }

    public String getAccessToken() {
        String realm = "master";
        String clientId = "admin-cli";
        try (Keycloak keycloak = KeycloakBuilder.builder().serverUrl(this.getUrl()).realm(realm).clientId(clientId).username("admin").password("admin").build();){
            RealmResource master = keycloak.realms().realm(realm);
            RealmRepresentation masterRep = master.toRepresentation();
            masterRep.setAccessTokenLifespan(Integer.valueOf(3600));
            master.update(masterRep);
            String string = keycloak.tokenManager().grantToken().getToken();
            return string;
        }
    }

    public static class Builder
    extends BaseTestContainer.Builder<Builder, KeycloakContainer> {
        private Builder() {
            this.image = KeycloakContainer.DEFAULT_IMAGE;
            this.hostName = KeycloakContainer.DEFAULT_HOST_NAME;
            this.exposePorts = ImmutableSet.of((Object)8080);
            this.envVars = ImmutableMap.of((Object)"KEYCLOAK_ADMIN", (Object)"admin", (Object)"KEYCLOAK_ADMIN_PASSWORD", (Object)"admin", (Object)"KC_HOSTNAME_URL", (Object)KeycloakContainer.SERVER_URL);
        }

        public KeycloakContainer build() {
            return new KeycloakContainer(this.image, this.hostName, this.exposePorts, this.filesToMount, this.envVars, this.network, this.startupRetryLimit);
        }
    }
}

