/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.containers;

import com.google.common.base.Verify;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StringResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.trino.plugin.base.util.AutoCloseableCloser;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingProperties;
import io.trino.tpch.TpchTable;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import org.intellij.lang.annotations.Language;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class UnityCatalogContainer
implements AutoCloseable {
    private static final HttpClient HTTP_CLIENT = new JettyHttpClient();
    private final String catalogName;
    private final String schemaName;
    private final PostgreSQLContainer<?> postgreSql;
    private final GenericContainer<?> unityCatalog;
    private final QueryRunner queryRunner;
    private final AutoCloseableCloser closer = AutoCloseableCloser.create();

    public UnityCatalogContainer(String catalogName, String schemaName) throws Exception {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schema is null");
        Network network = Network.newNetwork();
        this.closer.register((AutoCloseable)network);
        this.postgreSql = (PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(DockerImageName.parse((String)"postgres")).withNetwork(network)).withNetworkAliases(new String[]{"postgres"});
        this.postgreSql.start();
        this.closer.register(this.postgreSql);
        String hibernate = "hibernate.connection.driver_class=org.postgresql.Driver\nhibernate.connection.url=jdbc:postgresql://postgres:5432/test\nhibernate.connection.username=test\nhibernate.connection.password=test\nhibernate.hbm2ddl.auto=update\n";
        File hibernateProperties = Files.createTempFile("hibernate", ".properties", new FileAttribute[0]).toFile();
        Files.writeString(hibernateProperties.toPath(), (CharSequence)hibernate, new OpenOption[0]);
        this.unityCatalog = new GenericContainer(DockerImageName.parse((String)("ghcr.io/trinodb/testing/unity-catalog:" + TestingProperties.getDockerImagesVersion()))).withExposedPorts(new Integer[]{8080}).withNetwork(network).withCopyFileToContainer(MountableFile.forHostPath((Path)hibernateProperties.toPath()), "/unity/etc/conf/hibernate.properties");
        this.unityCatalog.start();
        this.closer.register(this.unityCatalog);
        this.createCatalog();
        this.createSchema(schemaName);
        File metastoreDir = Files.createTempDirectory("iceberg_query_runner", new FileAttribute[0]).toFile();
        metastoreDir.deleteOnExit();
        this.queryRunner = IcebergQueryRunner.builder().addIcebergProperty("hive.metastore.catalog.dir", metastoreDir.toURI().toString()).build();
    }

    public String uri() {
        return "http://%s:%s/api/2.1/unity-catalog".formatted(this.unityCatalog.getHost(), this.unityCatalog.getMappedPort(8080));
    }

    private void createCatalog() {
        String body = "{\"name\": \"" + this.catalogName + "\"}";
        Request request = Request.Builder.preparePost().setUri(URI.create(this.uri() + "/catalogs")).setHeader("Content-Type", "application/json").setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)body, (Charset)StandardCharsets.UTF_8)).build();
        UnityCatalogContainer.execute(request);
    }

    public void createSchema(String schemaName) {
        String body = "{\"name\": \"" + schemaName + "\", \"catalog_name\": \"" + this.catalogName + "\"}";
        Request request = Request.Builder.preparePost().setUri(URI.create(this.uri() + "/schemas")).setHeader("Content-Type", "application/json").setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)body, (Charset)StandardCharsets.UTF_8)).build();
        UnityCatalogContainer.execute(request);
    }

    public void dropSchema(String schema) {
        Request request = Request.Builder.prepareDelete().setUri(URI.create(this.uri() + "/schemas/%s.%s?catalog_name=%s".formatted(this.catalogName, schema, schema))).build();
        UnityCatalogContainer.execute(request);
    }

    public void copyTpchTables(Iterable<TpchTable<?>> tpchTables) {
        for (TpchTable<?> table : tpchTables) {
            String tableName = table.getTableName();
            this.createTable(this.schemaName, tableName, "AS SELECT * FROM tpch.tiny." + tableName);
        }
    }

    public void createTable(String schemaName, String tableName, String tableDefinition) {
        this.queryRunner.execute("CREATE TABLE iceberg.tpch." + tableName + " " + tableDefinition);
        String metadataFilePath = (String)this.queryRunner.execute("SELECT file FROM \"" + tableName + "$metadata_log_entries\" ORDER BY file LIMIT 1").getOnlyValue();
        String body = "{\"catalog_name\": \"" + this.catalogName + "\",\"schema_name\": \"" + schemaName + "\",\"name\": \"" + tableName + "\",\"table_type\": \"EXTERNAL\",\"data_source_format\": \"DELTA\",\"storage_location\": \"" + metadataFilePath + "\"}";
        Request request = Request.Builder.preparePost().setUri(URI.create(this.uri() + "/tables")).setHeader("Content-Type", "application/json").setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)body, (Charset)StandardCharsets.UTF_8)).build();
        UnityCatalogContainer.execute(request);
        this.execute("UPDATE uc_tables SET uniform_iceberg_metadata_location = '" + metadataFilePath + "'WHERE name = '" + tableName + "'");
        Path absoluteMetadataFilePath = Paths.get(URI.create(metadataFilePath));
        Path metadataDirectory = absoluteMetadataFilePath.getParent();
        Verify.verify((boolean)metadataDirectory.endsWith("metadata"));
        File tableDirectory = metadataDirectory.getParent().toFile();
        this.unityCatalog.copyFileToContainer(MountableFile.forHostPath((String)tableDirectory.getAbsolutePath()), tableDirectory.getPath());
    }

    public void dropTable(String schema, String tableName) {
        Request request = Request.Builder.prepareDelete().setUri(URI.create(this.uri() + "/tables/%s.%s.%s?catalog_name=%s&schema_name=%s".formatted(this.catalogName, schema, tableName, this.catalogName, schema))).build();
        UnityCatalogContainer.execute(request);
        this.queryRunner.execute("DROP TABLE iceberg.tpch.%s".formatted(tableName));
    }

    public void execute(@Language(value="SQL") String sql) {
        try (Connection connection = DriverManager.getConnection(this.postgreSql.getJdbcUrl(), this.postgreSql.getUsername(), this.postgreSql.getPassword());
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.queryRunner.close();
        this.closer.close();
    }

    private static void execute(Request request) {
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)HTTP_CLIENT.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        int status = response.getStatusCode();
        if (status != HttpStatus.OK.code()) {
            throw new IllegalStateException(String.format("Request '%s' returned unexpected status code: '%d'", request, status));
        }
    }
}

