/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.fileio;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.local.LocalFileSystemFactory;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.spi.testing.InterfaceTestUtils;
import io.trino.testing.TestingConnectorSession;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.SupportsBulkOperations;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestForwardingFileIo {
    @Test
    public void testEverythingImplemented() {
        InterfaceTestUtils.assertAllMethodsOverridden(FileIO.class, ForwardingFileIo.class);
        InterfaceTestUtils.assertAllMethodsOverridden(SupportsBulkOperations.class, ForwardingFileIo.class);
    }

    @Test
    public void testUseFileSizeFromMetadata() throws Exception {
        Path tempDir = Files.createTempDirectory("test_forwarding_fileio", new FileAttribute[0]);
        Path filePath = tempDir.resolve("data.txt");
        Files.writeString(filePath, (CharSequence)"test-data", new OpenOption[0]);
        LocalFileSystemFactory factory = new LocalFileSystemFactory(tempDir);
        TrinoFileSystem fileSystem = factory.create(TestingConnectorSession.SESSION);
        long actualLength = Files.size(filePath);
        try (ForwardingFileIo ignoringFileIo = new ForwardingFileIo(fileSystem, false);){
            Assertions.assertThat((long)ignoringFileIo.newInputFile("file:///data.txt", 1L).getLength()).isEqualTo(actualLength);
        }
        try (ForwardingFileIo usingFileIo = new ForwardingFileIo(fileSystem, true);){
            Assertions.assertThat((long)usingFileIo.newInputFile("file:///data.txt", 1L).getLength()).isEqualTo(1L);
        }
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }
}

