/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.functions;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.iceberg.IcebergPlugin;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.SqlPath;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
final class TestBucketFunctions {
    private QueryAssertions assertions;

    TestBucketFunctions() {
    }

    @BeforeAll
    void init() {
        this.assertions = new QueryAssertions(TestingSession.testSessionBuilder().setPath(SqlPath.buildPath((String)"iceberg.system", Optional.empty())).build());
        this.assertions.addPlugin((Plugin)new IcebergPlugin());
        this.assertions.getQueryRunner().createCatalog("iceberg", "iceberg", (Map)ImmutableMap.of((Object)"hive.metastore.uri", (Object)"thrift://example.net:9083"));
    }

    @AfterAll
    void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    void testTinyint() {
        this.assertBucket("TINYINT '-128'", 16, 2);
        this.assertBucket("TINYINT '127'", 16, 5);
        this.assertBucket("CAST(NULL AS TINYINT)", 16, null);
    }

    @Test
    void testSmallint() {
        this.assertBucket("SMALLINT '-32768'", 16, 1);
        this.assertBucket("SMALLINT '32767'", 16, 5);
        this.assertBucket("CAST(NULL AS SMALLINT)", 16, null);
    }

    @Test
    void testInteger() {
        this.assertBucket("1", 1, 0);
        this.assertBucket("198765432", 16, 15);
        this.assertBucket("1987654329876", 16, 15);
        this.assertBucket("CAST(NULL AS INTEGER)", 16, null);
    }

    @Test
    void testBigint() {
        this.assertBucket("-9223372036854775808", 16, 5);
        this.assertBucket("9223372036854775807", 16, 15);
        this.assertBucket("CAST(NULL AS BIGINT)", 16, null);
    }

    @Test
    void testDecimal() {
        this.assertBucket("DECIMAL '36.654'", 16, 1);
        this.assertBucket("36.654", 16, 1);
        this.assertBucket("99099.9876", 16, 15);
        this.assertBucket("1110000000000000000000000.0", 16, 10);
        this.assertBucket("CAST(NULL AS DECIMAL(5, 2))", 16, null);
        this.assertBucket("CAST(NULL AS DECIMAL(24, 2))", 16, null);
    }

    @Test
    void testVarchar() {
        this.assertBucket("'trino'", 16, 10);
        this.assertBucket("'iceberg'", 16, 9);
        this.assertBucket("CAST(NULL AS VARCHAR)", 16, null);
    }

    @Test
    void testVarbinary() {
        this.assertBucket("x'65683F'", 16, 11);
        this.assertBucket("CAST(NULL AS VARBINARY)", 16, null);
    }

    @Test
    void testDate() {
        this.assertBucket("DATE '0001-01-01'", 16, 9);
        this.assertBucket("DATE '2024-11-19'", 16, 11);
        this.assertBucket("DATE '9999-12-31'", 16, 9);
        this.assertBucket("CAST(NULL AS DATE)", 16, null);
    }

    @Test
    void testTimestamp() {
        this.assertBucket("TIMESTAMP '0001-01-01 00:00:00'", 1, 0);
        this.assertBucket("TIMESTAMP '1970-01-30 16:00:00'", 1, 0);
        this.assertBucket("TIMESTAMP '1970-01-30 16:00:00'", 16, 13);
        this.assertBucket("TIMESTAMP '1970-01-30 16:00:00.123456789012'", 16, 7);
        this.assertBucket("TIMESTAMP '1970-01-30 16:00:00.123456999999'", 16, 7);
        this.assertBucket("TIMESTAMP '9999-12-31 23:59:59.123456'", 16, 14);
        this.assertBucket("CAST(NULL AS TIMESTAMP)", 16, null);
        this.assertBucket("CAST(NULL AS TIMESTAMP(0))", 16, null);
        this.assertBucket("CAST(NULL AS TIMESTAMP(12))", 16, null);
    }

    @Test
    void testTimestampWithTimeZone() {
        this.assertBucket("TIMESTAMP '0001-01-01 00:00:00 +02:09'", 1, 0);
        this.assertBucket("TIMESTAMP '1988-04-08 14:15:16 +02:09'", 1, 0);
        this.assertBucket("TIMESTAMP '1988-04-08 14:15:16 +02:09'", 16, 0);
        this.assertBucket("TIMESTAMP '2025-01-01 00:00:00.123 +01:00'", 16, 10);
        this.assertBucket("TIMESTAMP '9999-12-31 23:59:59.123456 +00:00'", 16, 14);
        this.assertBucket("CAST(NULL AS TIMESTAMP WITH TIME ZONE)", 16, null);
        this.assertBucket("CAST(NULL AS TIMESTAMP(0) WITH TIME ZONE)", 16, null);
        this.assertBucket("CAST(NULL AS TIMESTAMP(12) WITH TIME ZONE)", 16, null);
    }

    @Test
    void testInvalidArguments() {
        this.assertInvalidType("true", "boolean");
        this.assertInvalidType("REAL '1.23'", "real");
        this.assertInvalidType("DOUBLE '1.23'", "double");
        this.assertInvalidType("CHAR 'abc'", "char(3)");
        this.assertInvalidType("uuid()", "uuid");
        this.assertInvalidType("ROW(1)", "row(integer)");
        this.assertInvalidType("ARRAY[1]", "array(integer)");
        this.assertInvalidType("MAP(ARRAY[1], ARRAY[2])", "map(integer, integer)");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("bucket", new String[]{"'abc'"}).evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("bucket", new String[]{"'abc'", "'abc'", "'abc'"}).evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND});
    }

    private void assertBucket(@Language(value="SQL") String input, int bucketCount, Integer expectedBucket) {
        ((QueryAssertions.ExpressionAssert)Assertions.assertThat((AssertProvider)this.assertions.function("bucket", new String[]{input, Integer.toString(bucketCount)}))).hasType((Type)IntegerType.INTEGER).isEqualTo((Object)expectedBucket);
    }

    private void assertInvalidType(@Language(value="SQL") String input, String type) {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("bucket", new String[]{input, "1"}).evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("Unsupported type: " + type);
    }
}

