/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.Session;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergConnector;
import io.trino.plugin.iceberg.IcebergPlugin;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.TableType;
import io.trino.plugin.iceberg.TestingIcebergConnectorFactory;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneTableScanColumns;
import io.trino.sql.planner.iterative.rule.PushPredicateIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushProjectionIntoTableScan;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;

public class TestConnectorPushdownRulesWithIceberg
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction NEGATION_BIGINT = FUNCTIONS.resolveOperator(OperatorType.NEGATION, (List)ImmutableList.of((Object)BigintType.BIGINT));
    private static final String SCHEMA_NAME = "test_schema";
    private static final Type ROW_TYPE = RowType.from(Arrays.asList(RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)BigintType.BIGINT)));
    private File baseDir;
    private HiveMetastore metastore;
    private CatalogHandle catalogHandle;
    private static final Session ICEBERG_SESSION = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("test_schema").build();

    public TestConnectorPushdownRulesWithIceberg() {
        super(new Plugin[0]);
    }

    protected Optional<PlanTester> createPlanTester() {
        try {
            this.baseDir = Files.createTempDirectory("metastore", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        PlanTester planTester = PlanTester.create((Session)ICEBERG_SESSION);
        InternalFunctionBundle.InternalFunctionBundleBuilder functions = InternalFunctionBundle.builder();
        new IcebergPlugin().getFunctions().forEach(arg_0 -> ((InternalFunctionBundle.InternalFunctionBundleBuilder)functions).functions(arg_0));
        planTester.addFunctions((FunctionBundle)functions.build());
        planTester.createCatalog("test_catalog", (ConnectorFactory)new TestingIcebergConnectorFactory(this.baseDir.toPath()), (Map)ImmutableMap.of());
        this.catalogHandle = planTester.getCatalogHandle("test_catalog");
        this.metastore = ((HiveMetastoreFactory)((IcebergConnector)planTester.getConnector("test_catalog")).getInjector().getInstance(HiveMetastoreFactory.class)).createMetastore(Optional.empty());
        Database database = Database.builder().setDatabaseName(SCHEMA_NAME).setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build();
        this.metastore.createDatabase(database);
        return Optional.of(planTester);
    }

    @Test
    public void testProjectionPushdown() {
        String tableName = "projection_test";
        PushProjectionIntoTableScan pushProjectionIntoTableScan = new PushProjectionIntoTableScan(this.tester().getPlannerContext(), new ScalarStatsCalculator(this.tester().getPlannerContext()));
        this.tester().getPlanTester().executeStatement(String.format("CREATE TABLE  %s (struct_of_int) AS SELECT cast(row(5, 6) as row(a bigint, b bigint)) as struct_of_int where false", tableName));
        Type baseType = ROW_TYPE;
        IcebergColumnHandle partialColumn = new IcebergColumnHandle(new ColumnIdentity(3, "struct_of_int", ColumnIdentity.TypeCategory.STRUCT, (List)ImmutableList.of((Object)ColumnIdentity.primitiveColumnIdentity((int)1, (String)"a"), (Object)ColumnIdentity.primitiveColumnIdentity((int)2, (String)"b"))), baseType, (List)ImmutableList.of((Object)1), (Type)BigintType.BIGINT, true, Optional.empty());
        IcebergTableHandle icebergTable = new IcebergTableHandle(CatalogHandle.fromId((String)"iceberg:NORMAL:v12345"), SCHEMA_NAME, tableName, TableType.DATA, Optional.of(1L), "", Optional.of(""), 1, TupleDomain.all(), TupleDomain.all(), OptionalLong.empty(), (Set)ImmutableSet.of(), Optional.empty(), "", (Map)ImmutableMap.of(), Optional.empty(), false, Optional.empty(), (Set)ImmutableSet.of(), Optional.of(false));
        TableHandle table = new TableHandle(this.catalogHandle, (ConnectorTableHandle)icebergTable, (ConnectorTransactionHandle)new HiveTransactionHandle(false));
        IcebergColumnHandle fullColumn = partialColumn.getBaseColumn();
        this.tester().assertThat((Rule)pushProjectionIntoTableScan).on(p -> p.project(Assignments.of((Symbol)p.symbol("struct_of_int", baseType), (Expression)p.symbol("struct_of_int", baseType).toSymbolReference()), (PlanNode)p.tableScan(table, (List)ImmutableList.of((Object)p.symbol("struct_of_int", baseType)), (Map)ImmutableMap.of((Object)p.symbol("struct_of_int", baseType), (Object)fullColumn)))).matches(PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)IntegerType.INTEGER, "col"))), (PlanMatchPattern)PlanMatchPattern.tableScan(arg_0 -> ((IcebergTableHandle)icebergTable.withProjectedColumns((Set)ImmutableSet.of((Object)fullColumn))).equals(arg_0), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col", arg_0 -> ((IcebergColumnHandle)fullColumn).equals(arg_0)))));
        this.tester().assertThat((Rule)pushProjectionIntoTableScan).on(p -> p.project(Assignments.of((Symbol)p.symbol("struct_of_int", baseType), (Expression)p.symbol("struct_of_int", baseType).toSymbolReference()), (PlanNode)p.tableScan(new TableHandle(this.catalogHandle, (ConnectorTableHandle)icebergTable.withProjectedColumns((Set)ImmutableSet.of((Object)fullColumn)), (ConnectorTransactionHandle)new HiveTransactionHandle(false)), (List)ImmutableList.of((Object)p.symbol("struct_of_int", baseType)), (Map)ImmutableMap.of((Object)p.symbol("struct_of_int", baseType), (Object)fullColumn)))).doesNotFire();
        this.tester().assertThat((Rule)pushProjectionIntoTableScan).on(p -> p.project(Assignments.of((Symbol)p.symbol("expr_deref", (Type)BigintType.BIGINT), (Expression)new FieldReference((Expression)p.symbol("struct_of_int", baseType).toSymbolReference(), 0)), (PlanNode)p.tableScan(table, (List)ImmutableList.of((Object)p.symbol("struct_of_int", baseType)), (Map)ImmutableMap.of((Object)p.symbol("struct_of_int", baseType), (Object)fullColumn)))).matches(PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr_deref", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "struct_of_int#a"))), (PlanMatchPattern)PlanMatchPattern.tableScan(arg_0 -> ((IcebergTableHandle)icebergTable.withProjectedColumns((Set)ImmutableSet.of((Object)partialColumn))).equals(arg_0), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"struct_of_int#a", arg_0 -> ((IcebergColumnHandle)partialColumn).equals(arg_0)))));
        this.metastore.dropTable(SCHEMA_NAME, tableName, true);
    }

    @Test
    public void testPredicatePushdown() {
        String tableName = "predicate_test";
        this.tester().getPlanTester().executeStatement(String.format("CREATE TABLE %s (a, b) AS SELECT 5, 6", tableName));
        long snapshotId = (Long)((IcebergTableHandle)this.tester().getPlanTester().getTableHandle("test_catalog", SCHEMA_NAME, tableName).connectorHandle()).getSnapshotId().orElseThrow();
        PushPredicateIntoTableScan pushPredicateIntoTableScan = new PushPredicateIntoTableScan(this.tester().getPlannerContext(), false);
        IcebergTableHandle icebergTable = new IcebergTableHandle(CatalogHandle.fromId((String)"iceberg:NORMAL:v12345"), SCHEMA_NAME, tableName, TableType.DATA, Optional.of(snapshotId), "", Optional.of(""), 1, TupleDomain.all(), TupleDomain.all(), OptionalLong.empty(), (Set)ImmutableSet.of(), Optional.empty(), "", (Map)ImmutableMap.of(), Optional.empty(), false, Optional.empty(), (Set)ImmutableSet.of(), Optional.of(false));
        TableHandle table = new TableHandle(this.catalogHandle, (ConnectorTableHandle)icebergTable, (ConnectorTransactionHandle)new HiveTransactionHandle(false));
        IcebergColumnHandle column = new IcebergColumnHandle(ColumnIdentity.primitiveColumnIdentity((int)1, (String)"a"), (Type)IntegerType.INTEGER, (List)ImmutableList.of(), (Type)IntegerType.INTEGER, true, Optional.empty());
        this.tester().assertThat((Rule)pushPredicateIntoTableScan).on(p -> p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (PlanNode)p.tableScan(table, (List)ImmutableList.of((Object)p.symbol("a", (Type)IntegerType.INTEGER)), (Map)ImmutableMap.of((Object)p.symbol("a", (Type)IntegerType.INTEGER), (Object)column)))).matches(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)5L)), (PlanMatchPattern)PlanMatchPattern.tableScan(tableHandle -> ((Map)((IcebergTableHandle)tableHandle).getUnenforcedPredicate().getDomains().get()).equals(ImmutableMap.of((Object)column, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)5L))), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"a", arg_0 -> ((IcebergColumnHandle)column).equals(arg_0)))));
        this.metastore.dropTable(SCHEMA_NAME, tableName, true);
    }

    @Test
    public void testColumnPruningProjectionPushdown() {
        String tableName = "column_pruning_projection_test";
        this.tester().getPlanTester().executeStatement(String.format("CREATE TABLE %s (a, b) AS SELECT 5, 6", tableName));
        PruneTableScanColumns pruneTableScanColumns = new PruneTableScanColumns(this.tester().getMetadata());
        IcebergTableHandle icebergTable = new IcebergTableHandle(CatalogHandle.fromId((String)"iceberg:NORMAL:v12345"), SCHEMA_NAME, tableName, TableType.DATA, Optional.empty(), "", Optional.of(""), 1, TupleDomain.all(), TupleDomain.all(), OptionalLong.empty(), (Set)ImmutableSet.of(), Optional.empty(), "", (Map)ImmutableMap.of(), Optional.empty(), false, Optional.empty(), (Set)ImmutableSet.of(), Optional.of(false));
        TableHandle table = new TableHandle(this.catalogHandle, (ConnectorTableHandle)icebergTable, (ConnectorTransactionHandle)new HiveTransactionHandle(false));
        IcebergColumnHandle columnA = new IcebergColumnHandle(ColumnIdentity.primitiveColumnIdentity((int)0, (String)"a"), (Type)IntegerType.INTEGER, (List)ImmutableList.of(), (Type)IntegerType.INTEGER, true, Optional.empty());
        IcebergColumnHandle columnB = new IcebergColumnHandle(ColumnIdentity.primitiveColumnIdentity((int)1, (String)"b"), (Type)IntegerType.INTEGER, (List)ImmutableList.of(), (Type)IntegerType.INTEGER, true, Optional.empty());
        this.tester().assertThat((Rule)pruneTableScanColumns).on(p -> {
            Symbol symbolA = p.symbol("a", (Type)IntegerType.INTEGER);
            Symbol symbolB = p.symbol("b", (Type)IntegerType.INTEGER);
            return p.project(Assignments.of((Symbol)p.symbol("x", (Type)IntegerType.INTEGER), (Expression)symbolA.toSymbolReference()), (PlanNode)p.tableScan(table, (List)ImmutableList.of((Object)symbolA, (Object)symbolB), (Map)ImmutableMap.of((Object)symbolA, (Object)columnA, (Object)symbolB, (Object)columnB)));
        }).matches(PlanMatchPattern.strictProject((Map)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)IntegerType.INTEGER, "COLA"))), (PlanMatchPattern)PlanMatchPattern.tableScan(arg_0 -> ((IcebergTableHandle)icebergTable.withProjectedColumns((Set)ImmutableSet.of((Object)columnA))).equals(arg_0), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"COLA", arg_0 -> ((IcebergColumnHandle)columnA).equals(arg_0)))));
        this.metastore.dropTable(SCHEMA_NAME, tableName, true);
    }

    @Test
    public void testPushdownWithDuplicateExpressions() {
        String tableName = "duplicate_expressions";
        this.tester().getPlanTester().executeStatement(String.format("CREATE TABLE  %s (struct_of_bigint, just_bigint) AS SELECT cast(row(5, 6) AS row(a bigint, b bigint)) AS struct_of_int, 5 AS just_bigint WHERE false", tableName));
        PushProjectionIntoTableScan pushProjectionIntoTableScan = new PushProjectionIntoTableScan(this.tester().getPlannerContext(), new ScalarStatsCalculator(this.tester().getPlannerContext()));
        IcebergTableHandle icebergTable = new IcebergTableHandle(CatalogHandle.fromId((String)"iceberg:NORMAL:v12345"), SCHEMA_NAME, tableName, TableType.DATA, Optional.of(1L), "", Optional.of(""), 1, TupleDomain.all(), TupleDomain.all(), OptionalLong.empty(), (Set)ImmutableSet.of(), Optional.empty(), "", (Map)ImmutableMap.of(), Optional.empty(), false, Optional.empty(), (Set)ImmutableSet.of(), Optional.of(false));
        TableHandle table = new TableHandle(this.catalogHandle, (ConnectorTableHandle)icebergTable, (ConnectorTransactionHandle)new HiveTransactionHandle(false));
        IcebergColumnHandle bigintColumn = new IcebergColumnHandle(ColumnIdentity.primitiveColumnIdentity((int)1, (String)"just_bigint"), (Type)BigintType.BIGINT, (List)ImmutableList.of(), (Type)BigintType.BIGINT, true, Optional.empty());
        IcebergColumnHandle partialColumn = new IcebergColumnHandle(new ColumnIdentity(3, "struct_of_bigint", ColumnIdentity.TypeCategory.STRUCT, (List)ImmutableList.of((Object)ColumnIdentity.primitiveColumnIdentity((int)1, (String)"a"), (Object)ColumnIdentity.primitiveColumnIdentity((int)2, (String)"b"))), ROW_TYPE, (List)ImmutableList.of((Object)1), (Type)BigintType.BIGINT, true, Optional.empty());
        this.tester().assertThat((Rule)pushProjectionIntoTableScan).on(p -> {
            Reference column = p.symbol("just_bigint", (Type)BigintType.BIGINT).toSymbolReference();
            Call negation = new Call(NEGATION_BIGINT, (List)ImmutableList.of((Object)column));
            return p.project(Assignments.of((Symbol)p.symbol("column_ref", (Type)BigintType.BIGINT), (Expression)column, (Symbol)p.symbol("negated_column_ref", (Type)BigintType.BIGINT), (Expression)negation), (PlanNode)p.tableScan(table, (List)ImmutableList.of((Object)p.symbol("just_bigint", (Type)BigintType.BIGINT)), (Map)ImmutableMap.of((Object)p.symbol("just_bigint", (Type)BigintType.BIGINT), (Object)bigintColumn)));
        }).matches(PlanMatchPattern.project((Map)ImmutableMap.of((Object)"column_ref", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "just_bigint_0")), (Object)"negated_column_ref", (Object)PlanMatchPattern.expression((Expression)new Call(NEGATION_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "just_bigint_0"))))), (PlanMatchPattern)PlanMatchPattern.tableScan(arg_0 -> ((IcebergTableHandle)icebergTable.withProjectedColumns((Set)ImmutableSet.of((Object)bigintColumn))).equals(arg_0), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"just_bigint_0", arg_0 -> ((IcebergColumnHandle)bigintColumn).equals(arg_0)))));
        this.tester().assertThat((Rule)pushProjectionIntoTableScan).on(p -> {
            FieldReference fieldReference = new FieldReference((Expression)p.symbol("struct_of_bigint", ROW_TYPE).toSymbolReference(), 0);
            Call sum = new Call(ADD_BIGINT, (List)ImmutableList.of((Object)fieldReference, (Object)new Constant((Type)BigintType.BIGINT, (Object)2L)));
            return p.project(Assignments.of((Symbol)p.symbol("expr_deref", (Type)BigintType.BIGINT), (Expression)fieldReference, (Symbol)p.symbol("expr_deref_2", (Type)BigintType.BIGINT), (Expression)sum), (PlanNode)p.tableScan(table, (List)ImmutableList.of((Object)p.symbol("struct_of_bigint", ROW_TYPE)), (Map)ImmutableMap.of((Object)p.symbol("struct_of_bigint", ROW_TYPE), (Object)partialColumn.getBaseColumn())));
        }).matches(PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr_deref", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "struct_of_bigint#a")), (Object)"expr_deref_2", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "struct_of_bigint#a"), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L))))), (PlanMatchPattern)PlanMatchPattern.tableScan(arg_0 -> ((IcebergTableHandle)icebergTable.withProjectedColumns((Set)ImmutableSet.of((Object)partialColumn))).equals(arg_0), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"struct_of_bigint#a", arg_0 -> ((IcebergColumnHandle)partialColumn).equals(arg_0)))));
        this.metastore.dropTable(SCHEMA_NAME, tableName, true);
    }

    @AfterAll
    public void cleanup() throws IOException {
        if (this.baseDir != null) {
            MoreFiles.deleteRecursively((Path)this.baseDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }
}

