/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.procedure;

import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.Location;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.spi.Plugin;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

final class TestIcebergAddFilesProcedure
extends AbstractTestQueryFramework {
    private Path dataDirectory;

    TestIcebergAddFilesProcedure() {
    }

    protected QueryRunner createQueryRunner() throws Exception {
        this.dataDirectory = Files.createTempDirectory("_test_hidden", new FileAttribute[0]);
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().setMetastoreDirectory(this.dataDirectory.toFile()).addIcebergProperty("iceberg.add-files-procedure.enabled", "true").build();
        queryRunner.installPlugin((Plugin)new TestingHivePlugin(this.dataDirectory));
        queryRunner.createCatalog("hive", "hive", (Map)ImmutableMap.builder().put((Object)"hive.security", (Object)"allow-all").buildOrThrow());
        return queryRunner;
    }

    @Test
    void testAddFilesFomTable() {
        String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " AS SELECT 1 x", 1L);
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " AS SELECT 2 x", 1L);
        this.assertUpdate("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "')");
        this.assertQuery("SELECT * FROM hive.tpch." + hiveTableName, "VALUES 1");
        this.assertQuery("SELECT * FROM iceberg.tpch." + icebergTableName, "VALUES 1, 2");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesNotNull() {
        String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " AS SELECT 1 x", 1L);
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + "(x int NOT NULL)");
        this.assertUpdate("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "')");
        this.assertQuery("SELECT * FROM hive.tpch." + hiveTableName, "VALUES 1");
        this.assertQuery("SELECT * FROM iceberg.tpch." + icebergTableName, "VALUES 1");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesNotNullViolation() {
        String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " AS SELECT CAST(NULL AS int) x", 1L);
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + "(x int NOT NULL)");
        String path = (String)this.computeScalar("SELECT \"$path\" FROM hive.tpch." + hiveTableName);
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files('" + path + "', 'ORC')", ".*NULL value not allowed for NOT NULL column: x");
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "')", ".*NULL value not allowed for NOT NULL column: x");
        this.assertQueryReturnsEmptyResult("SELECT * FROM iceberg.tpch." + icebergTableName);
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesDifferentFileFormat() {
        this.testAddFilesDifferentFileFormat("PARQUET", "ORC");
        this.testAddFilesDifferentFileFormat("PARQUET", "AVRO");
        this.testAddFilesDifferentFileFormat("ORC", "PARQUET");
        this.testAddFilesDifferentFileFormat("ORC", "AVRO");
        this.testAddFilesDifferentFileFormat("AVRO", "PARQUET");
        this.testAddFilesDifferentFileFormat("AVRO", "ORC");
    }

    private void testAddFilesDifferentFileFormat(String hiveFormat, String icebergFormat) {
        String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " WITH (format = '" + icebergFormat + "') AS SELECT 1 x", 1L);
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " WITH (format = '" + hiveFormat + "') AS SELECT 2 x", 1L);
        this.assertUpdate("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "')");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES 1, 2");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesAcrossSchema() {
        String hiveSchemaName = "test_schema" + TestingNames.randomNameSuffix();
        String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE SCHEMA hive." + hiveSchemaName);
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " WITH (format = 'PARQUET') AS SELECT 1 x", 1L);
        this.assertUpdate("CREATE TABLE hive." + hiveSchemaName + "." + hiveTableName + " WITH (format = 'ORC') AS SELECT 2 x", 1L);
        this.assertUpdate("ALTER TABLE tpch." + icebergTableName + " EXECUTE add_files_from_table('" + hiveSchemaName + "', '" + hiveTableName + "')");
        this.assertQuery("SELECT * FROM iceberg.tpch." + icebergTableName, "VALUES 1, 2");
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
        this.assertUpdate("DROP SCHEMA hive." + hiveSchemaName + " CASCADE ");
    }

    @Test
    void testAddFilesTypeMismatch() {
        String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " WITH (format = 'ORC') AS SELECT '1' x", 1L);
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " WITH (format = 'ORC') AS SELECT 2 x", 1L);
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "')", "Target 'x' column is 'string' type, but got source 'int' type");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesFromLessColumnTable() {
        for (String format : List.of("ORC", "PARQUET", "AVRO")) {
            String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
            String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
            this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " WITH (format = '" + format + "') AS SELECT 1 x", 1L);
            this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " WITH (format = '" + format + "') AS SELECT 2 x, 20 y", 1L);
            this.assertUpdate("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "')");
            this.assertQuery("SELECT * FROM iceberg.tpch." + icebergTableName, "VALUES (1, NULL), (2, 20)");
            this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
            this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
        }
    }

    @Test
    void testAddFilesFromLessColumnTableNotNull() {
        for (String format : List.of("ORC", "PARQUET", "AVRO")) {
            String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
            String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
            this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " WITH (format = '" + format + "') AS SELECT 1 x", 1L);
            this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + "(x int, y int NOT NULL) WITH (format = '" + format + "')");
            this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "')", ".*NULL value not allowed for NOT NULL column: y");
            this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
            this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
        }
    }

    @Test
    void testAddFilesFromMoreColumnTable() {
        for (String format : List.of("ORC", "PARQUET", "AVRO")) {
            String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
            String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
            this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " WITH (format = '" + format + "') AS SELECT 1 x, 'extra' y", 1L);
            this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " WITH (format = '" + format + "') AS SELECT 2 x", 1L);
            this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "')", "Target table should have at least 2 columns but got 1");
            this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
            this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
        }
    }

    @Test
    void testAddFilesDifferentAllDataColumnDefinitions() {
        for (String format : List.of("ORC", "PARQUET", "AVRO")) {
            String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
            String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
            this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " WITH (format = '" + format + "') AS SELECT 1 x", 1L);
            this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " WITH (format = '" + format + "') AS SELECT 2 y", 1L);
            this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "')", "All columns in the source table do not exist in the target table");
            this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
            this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
        }
    }

    @Test
    void testAddFilesDifferentPartitionColumnDefinitions() {
        String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " WITH (partitioned_by = ARRAY['hive_part']) AS SELECT 1 x, 10 hive_part", 1L);
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " WITH (partitioning = ARRAY['iceberg_part']) AS SELECT 2 x, 20 iceberg_part", 1L);
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "', map(ARRAY['hive_part'], ARRAY['10']))", "Partition column 'hive_part' does not exist");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesSpecialCharPartitionColumnDefinitions() {
        String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " WITH (partitioned_by = ARRAY['special@col']) AS SELECT 1 x, 10 \"special@col\"", 1L);
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " WITH (partitioning = ARRAY['\"special@col\"']) AS SELECT 2 x, 20 \"special@col\"", 1L);
        this.assertUpdate("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "', map(ARRAY['special@col'], ARRAY['10']))");
        this.assertQuery("SELECT * FROM iceberg.tpch." + icebergTableName, "VALUES (1, 10), (2, 20)");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesFromNonPartitionTable() {
        String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " AS SELECT 1 x", 1L);
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " WITH (partitioning = ARRAY['iceberg_part']) AS SELECT 2 x, 20 iceberg_part", 1L);
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "')", "Numbers of partition columns should be equivalent. target: 1, source: 0");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesPartitionFilter() {
        String hiveTableName = "test_add_files_partition_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_partition_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + "(id int, part varchar) WITH (partitioning = ARRAY['part'])");
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + "(id int, part varchar) WITH (partitioned_by = ARRAY['part'])");
        this.assertUpdate("INSERT INTO hive.tpch." + hiveTableName + " VALUES (1, 'test1'), (2, 'test2'), (3, 'test3'), (4, 'test4')", 4L);
        this.assertUpdate("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "', map(ARRAY['part'], ARRAY['test1']))");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1, 'test1')");
        this.assertUpdate("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "', map(ARRAY['part'], ARRAY['test2']))");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1, 'test1'), (2, 'test2')");
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "')", "partition_filter argument must be provided for partitioned tables");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1, 'test1'), (2, 'test2')");
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "', map())", ".* partition value count must match partition column count");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1, 'test1'), (2, 'test2')");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void tetAddFilesNonPartitionTableWithPartitionFilter() {
        String hiveTableName = "test_add_files_non_partition_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_partition_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + "(id int, part varchar) WITH (partitioning = ARRAY['part'])");
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + "(id int)");
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "', map(ARRAY['part'], ARRAY['test1']))", "Numbers of partition columns should be equivalent. target: 1, source: 0");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void tetAddFilesInvalidPartitionFilter() {
        String hiveTableName = "test_add_files_partition_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_partition_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + "(id int, part varchar) WITH (partitioning = ARRAY['part'])");
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + "(id int, part varchar) WITH (partitioned_by = ARRAY['part'])");
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "', map(ARRAY['invalid_part'], ARRAY['test1']))", ".*Invalid partition: invalid_part=test1");
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "', map(ARRAY['part'], ARRAY['invalid_value']))", ".*Invalid partition: part=invalid_value");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesNestedPartitionFilter() {
        String hiveTableName = "test_add_files_nested_partition_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_nested_partition_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + "(id int, parent varchar, child varchar) WITH (partitioning = ARRAY['parent', 'child'])");
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + "(id int, parent varchar, child varchar) WITH (partitioned_by = ARRAY['parent', 'child'])");
        this.assertUpdate("INSERT INTO hive.tpch." + hiveTableName + " VALUES (1, 'parent1', 'child1'), (2, 'parent1', 'child2'), (3, 'parent2', 'child3'), (4, 'parent2', 'child4')", 4L);
        this.assertUpdate("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "', map(ARRAY['parent', 'child'], ARRAY['parent1', 'child1']))");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1, 'parent1', 'child1')");
        this.assertUpdate("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "', map(ARRAY['parent', 'child'], ARRAY['parent1', 'child2']))");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1, 'parent1', 'child1'), (2, 'parent1', 'child2')");
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "', map(ARRAY['parent'], ARRAY['parent2']))", ".*partition value count must match partition column count.*");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesWithRecursiveDirectory() throws Exception {
        String hiveTableName = "test_migrate_recursive_directory_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_migrate_recursive_directory_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " WITH (format = 'ORC') AS SELECT 1 x", 1L);
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + "(x int)");
        String path = (String)this.computeScalar("SELECT \"$path\" FROM hive.tpch." + hiveTableName);
        String fileName = Location.of((String)path).fileName();
        Path tableLocation = this.dataDirectory.resolve("tpch").resolve(hiveTableName);
        Files.createDirectory(tableLocation.resolve("nested"), new FileAttribute[0]);
        Files.move(tableLocation.resolve(fileName), tableLocation.resolve("nested").resolve(fileName), new CopyOption[0]);
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files('" + String.valueOf(tableLocation) + "', 'ORC')", ".*Recursive directory must not exist when recursive_directory argument is 'fail'.*");
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files('" + String.valueOf(tableLocation) + "', 'ORC', 'fail')", ".*Recursive directory must not exist when recursive_directory argument is 'fail'.*");
        this.assertUpdate("ALTER TABLE " + icebergTableName + " EXECUTE add_files('" + String.valueOf(tableLocation) + "', 'ORC', 'false')");
        this.assertQueryReturnsEmptyResult("SELECT * FROM " + icebergTableName);
        this.assertUpdate("ALTER TABLE " + icebergTableName + " EXECUTE add_files('" + String.valueOf(tableLocation) + "', 'ORC', 'true')");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES 1");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesDirectoryLocation() {
        String hiveTableName = "test_add_files_location_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_location_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " AS SELECT 1 x", 1L);
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " AS SELECT 2 x", 1L);
        String path = (String)this.computeScalar("SELECT \"$path\" FROM hive.tpch." + hiveTableName);
        String directory = Location.of((String)path).parentDirectory().toString();
        this.assertUpdate("ALTER TABLE " + icebergTableName + " EXECUTE add_files('" + directory + "', 'ORC')");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES 1, 2");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesFileLocation() {
        String hiveTableName = "test_add_files_location_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_location_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " AS SELECT 1 x", 1L);
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " AS SELECT 2 x", 1L);
        String path = (String)this.computeScalar("SELECT \"$path\" FROM hive.tpch." + hiveTableName);
        this.assertUpdate("ALTER TABLE " + icebergTableName + " EXECUTE add_files('" + path + "', 'ORC')");
        this.assertQuery("SELECT * FROM iceberg.tpch." + icebergTableName, "VALUES 1, 2");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesToPartitionTableWithLocation() {
        String hiveTableName = "test_add_files_location_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_location_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " WITH (partitioning = ARRAY['part']) AS SELECT 1 x, 'test' part", 1L);
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " AS SELECT 2 x", 1L);
        String path = (String)this.computeScalar("SELECT \"$path\" FROM hive.tpch." + hiveTableName);
        String directory = Location.of((String)path).parentDirectory().toString();
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files('" + directory + "', 'ORC')", ".*The procedure does not support partitioned tables");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesLocationWithWrongFormat() {
        String hiveTableName = "test_add_files_location_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_location_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " AS SELECT 1 x", 1L);
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " WITH (format = 'ORC') AS SELECT 2 x", 1L);
        String path = (String)this.computeScalar("SELECT \"$path\" FROM hive.tpch." + hiveTableName);
        String location = Location.of((String)path).parentDirectory().toString();
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files('" + location + "', 'TEXTFILE')", ".* The procedure does not support storage format: TEXTFILE");
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files(location=>'" + location + "', format=>'PARQUET')", ".*Failed to read file footer.*");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesUnsupportedFileFormat() {
        String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " AS SELECT '1' x", 1L);
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " WITH (format = 'TEXTFILE') AS SELECT '2' x", 1L);
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "')", ".*Unsupported storage format: TEXTFILE.*");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES '1'");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesToNonIcebergTable() {
        String sourceHiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        String targetHiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE hive.tpch." + sourceHiveTableName + " AS SELECT 1 x", 1L);
        this.assertUpdate("CREATE TABLE hive.tpch." + targetHiveTableName + " AS SELECT 2 x", 1L);
        this.assertQueryFails("ALTER TABLE " + targetHiveTableName + " EXECUTE add_files_from_table('tpch', '" + sourceHiveTableName + "')", "Not an Iceberg table: .*");
        this.assertQuery("SELECT * FROM hive.tpch." + sourceHiveTableName, "VALUES 1");
        this.assertQuery("SELECT * FROM hive.tpch." + targetHiveTableName, "VALUES 2");
        this.assertUpdate("DROP TABLE hive.tpch." + sourceHiveTableName);
        this.assertUpdate("DROP TABLE hive.tpch." + targetHiveTableName);
    }

    @Test
    void testAddFilesToView() {
        String sourceViewName = "test_add_files_" + TestingNames.randomNameSuffix();
        String targetIcebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE VIEW iceberg.tpch." + sourceViewName + " AS SELECT 1 x");
        this.assertUpdate("CREATE TABLE iceberg.tpch." + targetIcebergTableName + " AS SELECT 2 x", 1L);
        this.assertQueryFails("ALTER TABLE " + targetIcebergTableName + " EXECUTE add_files_from_table('tpch', '" + sourceViewName + "')", "The procedure doesn't support adding files from VIRTUAL_VIEW table type");
        this.assertQuery("SELECT * FROM iceberg.tpch." + sourceViewName, "VALUES 1");
        this.assertQuery("SELECT * FROM iceberg.tpch." + targetIcebergTableName, "VALUES 2");
        this.assertUpdate("DROP VIEW iceberg.tpch." + sourceViewName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + targetIcebergTableName);
    }

    @Test
    void testAddFilesFromIcebergTable() {
        String sourceIcebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        String targetIcebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE iceberg.tpch." + sourceIcebergTableName + " AS SELECT 1 x", 1L);
        this.assertUpdate("CREATE TABLE iceberg.tpch." + targetIcebergTableName + " AS SELECT 2 x", 1L);
        this.assertQueryFails("ALTER TABLE " + targetIcebergTableName + " EXECUTE add_files_from_table('tpch', '" + sourceIcebergTableName + "')", "Adding files from non-Hive tables is unsupported");
        this.assertQuery("SELECT * FROM iceberg.tpch." + sourceIcebergTableName, "VALUES 1");
        this.assertQuery("SELECT * FROM iceberg.tpch." + targetIcebergTableName, "VALUES 2");
        this.assertUpdate("DROP TABLE iceberg.tpch." + sourceIcebergTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + targetIcebergTableName);
    }

    @Test
    void testAddDuplicatedFiles() {
        String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " AS SELECT 1 x", 1L);
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " AS SELECT 2 x", 1L);
        String path = (String)this.computeScalar("SELECT \"$path\" FROM hive.tpch." + hiveTableName);
        this.assertUpdate("ALTER TABLE " + icebergTableName + " EXECUTE add_files('" + path + "', 'ORC')");
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files('" + path + "', 'ORC')", ".*File already exists.*");
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files(location=>'" + path + "', format=>'ORC')", ".*File already exists.*");
        this.assertQuery("SELECT * FROM iceberg.tpch." + icebergTableName, "VALUES 1, 2");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddDuplicatedFilesFromTable() {
        String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " AS SELECT 1 x", 1L);
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + " AS SELECT 2 x", 1L);
        this.assertUpdate("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "')");
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', '" + hiveTableName + "')", ".*File already exists.*");
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table(schema_name=>'tpch', table_name=>'" + hiveTableName + "')", ".*File already exists.*");
        this.assertQuery("SELECT * FROM iceberg.tpch." + icebergTableName, "VALUES 1, 2");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesTargetTableNotFound() {
        String hiveTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE hive.tpch." + hiveTableName + " AS SELECT 1 x", 1L);
        this.assertQueryFails("ALTER TABLE table_not_found EXECUTE add_files_from_table('tpch', '" + hiveTableName + "')", ".* Table 'iceberg.tpch.table_not_found' does not exist");
        this.assertUpdate("DROP TABLE hive.tpch." + hiveTableName);
    }

    @Test
    void testAddFilesSourceTableNotFound() {
        String icebergTableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE iceberg.tpch." + icebergTableName + "(x int)");
        this.assertQueryFails("ALTER TABLE " + icebergTableName + " EXECUTE add_files_from_table('tpch', 'table_not_found')", "Table 'tpch.table_not_found' not found");
        this.assertUpdate("DROP TABLE iceberg.tpch." + icebergTableName);
    }

    @Test
    void testAddFilesLocationNotFound() {
        String tableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE iceberg.tpch." + tableName + "(x int)");
        this.assertQueryFails("ALTER TABLE " + tableName + " EXECUTE add_files('file:///location-not-found', 'ORC')", ".*Location not found.*");
        this.assertUpdate("DROP TABLE iceberg.tpch." + tableName);
    }

    @Test
    void testAddFilesInvalidArguments() {
        String tableName = "test_add_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE iceberg.tpch." + tableName + "(x int)");
        this.assertQueryFails("ALTER TABLE " + tableName + " EXECUTE add_files_from_table(schema_name=>'tpch')", "Required procedure argument 'table_name' is missing");
        this.assertQueryFails("ALTER TABLE " + tableName + " EXECUTE add_files_from_table(table_name=>'test')", "Required procedure argument 'schema_name' is missing");
        this.assertQueryFails("ALTER TABLE " + tableName + " EXECUTE add_files(location=>'file:///tmp')", "Required procedure argument 'format' is missing");
        this.assertQueryFails("ALTER TABLE " + tableName + " EXECUTE add_files(format=>'ORC')", "Required procedure argument 'location' is missing");
        this.assertUpdate("DROP TABLE iceberg.tpch." + tableName);
    }
}

