/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.procedure;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.spi.Plugin;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestIcebergMigrateProcedure
extends AbstractTestQueryFramework {
    private Path dataDirectory;

    protected QueryRunner createQueryRunner() throws Exception {
        this.dataDirectory = Files.createTempDirectory("_test_hidden", new FileAttribute[0]);
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().setMetastoreDirectory(this.dataDirectory.toFile()).build();
        queryRunner.installPlugin((Plugin)new TestingHivePlugin(this.dataDirectory));
        queryRunner.createCatalog("hive", "hive", (Map)ImmutableMap.builder().put((Object)"hive.security", (Object)"allow-all").buildOrThrow());
        return queryRunner;
    }

    @ParameterizedTest
    @MethodSource(value={"fileFormats"})
    public void testMigrateTable(IcebergFileFormat fileFormat) {
        String tableName = "test_migrate_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.tpch." + tableName;
        String icebergTableName = "iceberg.tpch." + tableName;
        this.assertUpdate("CREATE TABLE " + hiveTableName + " WITH (format='" + String.valueOf(fileFormat) + "') AS SELECT 1 x", 1L);
        this.assertUpdate("INSERT INTO " + hiveTableName + " VALUES NULL", 1L);
        this.assertQueryFails("SELECT * FROM " + icebergTableName, "Not an Iceberg table: .*");
        this.assertUpdate("CALL iceberg.system.migrate('tpch', '" + tableName + "')");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + icebergTableName))).contains(new CharSequence[]{"format = '%s'".formatted(fileFormat)});
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES 1, NULL");
        this.assertQuery("SELECT count(*) FROM " + icebergTableName, "VALUES 2");
        this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES 1, NULL");
        this.assertQuery("SELECT count(*) FROM " + icebergTableName, "VALUES 2");
        this.assertUpdate("INSERT INTO " + icebergTableName + " VALUES 2, NULL", 2L);
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES 1, NULL, 2, NULL");
        this.assertQuery("SELECT count(*) FROM " + icebergTableName, "VALUES 4");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @ParameterizedTest
    @MethodSource(value={"fileFormats"})
    public void testMigrateTableWithTinyintType(IcebergFileFormat fileFormat) {
        String tableName = "test_migrate_tinyint" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.tpch." + tableName;
        String icebergTableName = "iceberg.tpch." + tableName;
        String createTable = "CREATE TABLE " + hiveTableName + "(col TINYINT) WITH (format = '" + String.valueOf(fileFormat) + "')";
        if (fileFormat == IcebergFileFormat.AVRO) {
            this.assertQueryFails(createTable, "Column 'col' is tinyint, which is not supported by Avro. Use integer instead.");
            return;
        }
        this.assertUpdate(createTable);
        this.assertUpdate("INSERT INTO " + hiveTableName + " VALUES NULL, -128, 127", 3L);
        this.assertUpdate("CALL iceberg.system.migrate('tpch', '" + tableName + "')");
        Assertions.assertThat((String)this.getColumnType(tableName, "col")).isEqualTo("integer");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (NULL), (-128), (127)");
        this.assertUpdate("INSERT INTO " + icebergTableName + " VALUES -2147483648, 2147483647", 2L);
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (NULL), (-2147483648), (-128), (127), (2147483647)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @ParameterizedTest
    @MethodSource(value={"fileFormats"})
    public void testMigrateTableWithSmallintType(IcebergFileFormat fileFormat) {
        String tableName = "test_migrate_smallint" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.tpch." + tableName;
        String icebergTableName = "iceberg.tpch." + tableName;
        String createTable = "CREATE TABLE " + hiveTableName + "(col SMALLINT) WITH (format = '" + String.valueOf(fileFormat) + "')";
        if (fileFormat == IcebergFileFormat.AVRO) {
            this.assertQueryFails(createTable, "Column 'col' is smallint, which is not supported by Avro. Use integer instead.");
            return;
        }
        this.assertUpdate(createTable);
        this.assertUpdate("INSERT INTO " + hiveTableName + " VALUES NULL, -32768, 32767", 3L);
        this.assertUpdate("CALL iceberg.system.migrate('tpch', '" + tableName + "')");
        Assertions.assertThat((String)this.getColumnType(tableName, "col")).isEqualTo("integer");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (NULL), (-32768), (32767)");
        this.assertUpdate("INSERT INTO " + icebergTableName + " VALUES -2147483648, 2147483647", 2L);
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (NULL), (-2147483648), (-32768), (32767), (2147483647)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @ParameterizedTest
    @MethodSource(value={"fileFormats"})
    public void testMigrateTableWithComplexType(IcebergFileFormat fileFormat) {
        String tableName = "test_migrate_complex_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.tpch." + tableName;
        String icebergTableName = "iceberg.tpch." + tableName;
        this.assertUpdate("CREATE TABLE " + hiveTableName + " WITH (format='" + String.valueOf(fileFormat) + "') AS SELECT 1 x, array[2, 3] a, CAST(map(array['key1'], array['value1']) AS map(varchar, varchar)) b, CAST(row(1) AS row(d integer)) c", 1L);
        this.assertUpdate("CALL iceberg.system.migrate('tpch', '" + tableName + "')");
        String firstRow = "VALUES (1, ARRAY[2, 3], CAST(map(ARRAY['key1'], ARRAY['value1']) AS map(varchar, varchar)), CAST(row(1) AS row(d integer)))";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + icebergTableName))).matches(firstRow);
        String secondRow = " VALUES (2, ARRAY[4, 5], CAST(map(ARRAY['key2'], ARRAY['value2']) AS map(varchar, varchar)), CAST(row(2) AS row(d integer)))";
        this.assertUpdate("INSERT INTO " + icebergTableName + secondRow, 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + icebergTableName))).matches(firstRow + " UNION ALL " + secondRow);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testMigrateTimestampHiveTableInComplexType() {
        String inputValue = "2021-01-01 10:11:12.123";
        String expectedValue = "2021-01-01 16:11:12.123000 UTC";
        String tableName = "test_migrate_timestamp_complex_type_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.tpch." + tableName;
        String icebergTableName = "iceberg.tpch." + tableName;
        this.assertUpdate("CREATE TABLE " + hiveTableName + " WITH (format='PARQUET') AS SELECT CAST(row(timestamp '" + inputValue + "') AS row(t timestamp(3))) r,array[timestamp '" + inputValue + "'] a, CAST(map(array[1], array[timestamp '" + inputValue + "']) AS map(int, timestamp(3))) m", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a, m, r.t FROM " + hiveTableName))).matches("VALUES ( ARRAY[timestamp '" + inputValue + "'],  CAST(map(ARRAY[1], ARRAY[timestamp '" + inputValue + "']) AS map(int, timestamp(3))), timestamp '" + inputValue + "')");
        this.assertUpdate("CALL iceberg.system.migrate('tpch', '" + tableName + "')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a, m, r.t FROM " + icebergTableName))).matches("VALUES ( ARRAY[timestamp '" + expectedValue + "'],  CAST(map(ARRAY[1], ARRAY[timestamp '" + expectedValue + "']) AS map(int, timestamp(6) with time zone)), timestamp '" + expectedValue + "')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @ParameterizedTest
    @MethodSource(value={"fileFormats"})
    public void testMigrateTableSchemaEvolution(IcebergFileFormat fileFormat) throws Exception {
        String randomNameSuffix = TestingNames.randomNameSuffix();
        String tableNameOneColumn = "test_migrate_one_column_" + randomNameSuffix;
        String tableNameTwoColumns = "test_migrate_two_columns_" + randomNameSuffix;
        String hiveTableNameOneColumn = "hive.tpch." + tableNameOneColumn;
        String hiveTableNameTwoColumns = "hive.tpch." + tableNameTwoColumns;
        String icebergTableNameTwoColumns = "iceberg.tpch." + tableNameTwoColumns;
        this.assertUpdate("CREATE TABLE " + hiveTableNameOneColumn + " WITH (format='" + String.valueOf(fileFormat) + "') AS SELECT 1 col1", 1L);
        this.assertUpdate("CREATE TABLE " + hiveTableNameTwoColumns + " WITH (format='" + String.valueOf(fileFormat) + "') AS SELECT 2 col1, CAST(row(10, 20) AS row(x integer, y integer)) AS nested", 1L);
        Path tableNameOneColumnLocation = Path.of("%s/tpch/%s".formatted(this.dataDirectory, tableNameOneColumn), new String[0]);
        Path tableNameTwoColumnsLocation = Path.of("%s/tpch/%s".formatted(this.dataDirectory, tableNameTwoColumns), new String[0]);
        try (Stream<Path> files = Files.list(tableNameOneColumnLocation);){
            Path file = (Path)files.filter(path -> !path.getFileName().toString().startsWith(".")).collect(MoreCollectors.onlyElement());
            Files.copy(file, tableNameTwoColumnsLocation.resolve(file.getFileName()), new CopyOption[0]);
        }
        this.assertUpdate("CALL iceberg.system.migrate('tpch', '" + tableNameTwoColumns + "')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + icebergTableNameTwoColumns))).skippingTypesCheck().matches("VALUES (1, CAST(null AS row(x integer, y integer))), (2, row(10, 20))");
        this.assertUpdate("INSERT INTO " + icebergTableNameTwoColumns + " VALUES (3, row(100, 200))", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + icebergTableNameTwoColumns))).skippingTypesCheck().matches("VALUES (1, CAST(null AS row(x integer, y integer))), (2, row(10, 20)), (3, row(100, 200))");
        this.assertUpdate("DROP TABLE " + icebergTableNameTwoColumns);
        this.assertUpdate("DROP TABLE " + hiveTableNameOneColumn);
    }

    @ParameterizedTest
    @MethodSource(value={"fileFormats"})
    public void testMigrateTableRowColumnSchemaEvolution(IcebergFileFormat fileFormat) throws Exception {
        String randomNameSuffix = TestingNames.randomNameSuffix();
        String tableNameRowOneField = "test_migrate_row_one_field_" + randomNameSuffix;
        String tableNameRowTwoFields = "test_migrate_row_two_fields_" + randomNameSuffix;
        String hiveTableNameRowOneField = "hive.tpch." + tableNameRowOneField;
        String hiveTableNameRowTwoFields = "hive.tpch." + tableNameRowTwoFields;
        String icebergTableNameRowTwoFields = "iceberg.tpch." + tableNameRowTwoFields;
        this.assertUpdate("CREATE TABLE " + hiveTableNameRowOneField + " WITH (format='" + String.valueOf(fileFormat) + "') AS SELECT CAST(row(1) AS row(x integer)) as nested", 1L);
        this.assertUpdate("CREATE TABLE " + hiveTableNameRowTwoFields + " WITH (format='" + String.valueOf(fileFormat) + "') AS SELECT CAST(row(10, 20) AS row(x integer, y integer)) AS nested", 1L);
        Path tableNameRowOneFieldLocation = Path.of("%s/tpch/%s".formatted(this.dataDirectory, tableNameRowOneField), new String[0]);
        Path tableNameRowTwoFieldsLocation = Path.of("%s/tpch/%s".formatted(this.dataDirectory, tableNameRowTwoFields), new String[0]);
        try (Stream<Path> files = Files.list(tableNameRowOneFieldLocation);){
            Path file = (Path)files.filter(path -> !path.getFileName().toString().startsWith(".")).collect(MoreCollectors.onlyElement());
            Files.copy(file, tableNameRowTwoFieldsLocation.resolve(file.getFileName()), new CopyOption[0]);
        }
        this.assertUpdate("CALL iceberg.system.migrate('tpch', '" + tableNameRowTwoFields + "')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + icebergTableNameRowTwoFields))).skippingTypesCheck().matches("VALUES row(CAST((1,null) AS row(x integer, y integer))), row(row(10, 20))");
        this.assertUpdate("INSERT INTO " + icebergTableNameRowTwoFields + " VALUES (row(row(100, 200)))", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + icebergTableNameRowTwoFields))).skippingTypesCheck().matches("VALUES row(CAST((1, null) AS row(x integer, y integer))), row(row(10, 20)), row(row(100, 200))");
        this.assertUpdate("DROP TABLE " + icebergTableNameRowTwoFields);
        this.assertUpdate("DROP TABLE " + hiveTableNameRowOneField);
    }

    /*
     * Exception decompiling
     */
    public static Object[][] fileFormats() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testMigratePartitionedTable() {
        String tableName = "test_migrate_partitioned_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.tpch." + tableName;
        String icebergTableName = "iceberg.tpch." + tableName;
        this.assertUpdate("CREATE TABLE " + hiveTableName + " WITH (partitioned_by = ARRAY['part_col']) AS SELECT 1 id, 'part1' part_col", 1L);
        this.assertQueryFails("SELECT * FROM " + icebergTableName, "Not an Iceberg table: .*");
        this.assertUpdate("CALL iceberg.system.migrate('tpch', '" + tableName + "')");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1, 'part1')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition FROM iceberg.tpch.\"" + tableName + "$partitions\""))).skippingTypesCheck().matches("SELECT CAST(row('part1') AS row(part_col varchar))");
        this.assertUpdate("INSERT INTO " + icebergTableName + " VALUES (2, 'part2')", 1L);
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1, 'part1'), (2, 'part2')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testMigratePartitionedTableWithSpecialChar() {
        String tableName = "test_migrate_partitioned_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.tpch." + tableName;
        String icebergTableName = "iceberg.tpch." + tableName;
        this.assertUpdate("CREATE TABLE " + hiveTableName + " WITH (partitioned_by = ARRAY['special@col']) AS SELECT 1 id, 'special1' \"special@col\"", 1L);
        this.assertQueryFails("SELECT * FROM " + icebergTableName, "Not an Iceberg table: .*");
        this.assertUpdate("CALL iceberg.system.migrate('tpch', '" + tableName + "')");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1, 'special1')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition FROM iceberg.tpch.\"" + tableName + "$partitions\""))).skippingTypesCheck().matches("SELECT CAST(row('special1') AS row(\"special@col\" varchar))");
        this.assertUpdate("INSERT INTO " + icebergTableName + " VALUES (2, 'special2')", 1L);
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1, 'special1'), (2, 'special2')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testMigrateBucketedTable() {
        String tableName = "test_migrate_bucketed_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.tpch." + tableName;
        String icebergTableName = "iceberg.tpch." + tableName;
        this.assertUpdate("CREATE TABLE " + hiveTableName + " WITH (partitioned_by = ARRAY['part'], bucketed_by = ARRAY['bucket'], bucket_count = 10) AS SELECT 1 bucket, 'part1' part", 1L);
        this.assertUpdate("CALL iceberg.system.migrate('tpch', '" + tableName + "')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition FROM iceberg.tpch.\"" + tableName + "$partitions\""))).skippingTypesCheck().matches("SELECT CAST(row('part1') AS row(part_col varchar))");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + icebergTableName))).contains(new CharSequence[]{"partitioning = ARRAY['part']"});
        this.assertUpdate("INSERT INTO " + icebergTableName + " VALUES (2, 'part2')", 1L);
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1, 'part1'), (2, 'part2')");
        this.assertUpdate("DROP TABLE " + icebergTableName);
    }

    @Test
    public void testMigrateTableWithRecursiveDirectory() throws Exception {
        String tableName = "test_migrate_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.tpch." + tableName;
        String icebergTableName = "iceberg.tpch." + tableName;
        this.assertUpdate("CREATE TABLE " + hiveTableName + " AS SELECT 1 x", 1L);
        Path tableLocation = Path.of("%s/tpch/%s".formatted(this.dataDirectory, tableName), new String[0]);
        Path nestedDirectory = tableLocation.resolve("nested");
        try (Stream<Path> files = Files.list(tableLocation);){
            Path file = (Path)files.filter(path -> !path.getFileName().toString().startsWith(".")).collect(MoreCollectors.onlyElement());
            Files.createDirectory(nestedDirectory, new FileAttribute[0]);
            Files.copy(file, nestedDirectory.resolve(file.getFileName()), new CopyOption[0]);
        }
        this.assertUpdate("CALL iceberg.system.migrate('tpch', '" + tableName + "', 'true')");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1), (1)");
        this.assertUpdate("INSERT INTO " + icebergTableName + " VALUES (2)", 1L);
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1), (1), (2)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testMigrateTableWithoutRecursiveDirectory() throws Exception {
        String tableName = "test_migrate_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.tpch." + tableName;
        String icebergTableName = "iceberg.tpch." + tableName;
        this.assertUpdate("CREATE TABLE " + hiveTableName + " AS SELECT 1 x", 1L);
        Path tableLocation = Path.of("%s/tpch/%s".formatted(this.dataDirectory, tableName), new String[0]);
        Path nestedDirectory = tableLocation.resolve("nested");
        try (Stream<Path> files = Files.list(tableLocation);){
            Path file = (Path)files.filter(path -> !path.getFileName().toString().startsWith(".")).collect(MoreCollectors.onlyElement());
            Files.createDirectory(nestedDirectory, new FileAttribute[0]);
            Files.copy(file, nestedDirectory.resolve(file.getFileName()), new CopyOption[0]);
        }
        this.assertUpdate("CALL iceberg.system.migrate('tpch', '" + tableName + "', 'false')");
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1)");
        this.assertUpdate("INSERT INTO " + icebergTableName + " VALUES (2)", 1L);
        this.assertQuery("SELECT * FROM " + icebergTableName, "VALUES (1), (2)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testMigrateTableFailRecursiveDirectory() throws Exception {
        String tableName = "test_migrate_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.tpch." + tableName;
        this.assertUpdate("CREATE TABLE " + hiveTableName + " AS SELECT 1 x", 1L);
        Path tableLocation = Path.of("%s/tpch/%s".formatted(this.dataDirectory, tableName), new String[0]);
        Path nestedDirectory = tableLocation.resolve("nested");
        try (Stream<Path> files = Files.list(tableLocation);){
            Path file = (Path)files.filter(path -> !path.getFileName().toString().startsWith(".")).collect(MoreCollectors.onlyElement());
            Files.createDirectory(nestedDirectory, new FileAttribute[0]);
            Files.copy(file, nestedDirectory.resolve(file.getFileName()), new CopyOption[0]);
        }
        this.assertQueryFails("CALL iceberg.system.migrate('tpch', '" + tableName + "')", "Failed to migrate table");
        this.assertQueryFails("CALL iceberg.system.migrate('tpch', '" + tableName + "', 'fail')", "Failed to migrate table");
        this.assertQuery("SELECT * FROM " + hiveTableName, "VALUES (1)");
        this.assertUpdate("DROP TABLE " + hiveTableName);
    }

    @Test
    public void testMigrateTablePreserveComments() {
        String tableName = "test_migrate_comments_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.tpch." + tableName;
        this.assertUpdate("CREATE TABLE " + hiveTableName + "(col int COMMENT 'column comment') COMMENT 'table comment'");
        this.assertUpdate("CALL iceberg.system.migrate('tpch', '" + tableName + "')");
        Assertions.assertThat((String)this.getTableComment(tableName)).isEqualTo("table comment");
        Assertions.assertThat((String)this.getColumnComment(tableName, "col")).isEqualTo("column comment");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private String getColumnComment(String tableName, String columnName) {
        return (String)this.computeScalar("SELECT comment FROM information_schema.columns WHERE table_catalog = 'iceberg' AND table_schema = 'tpch' AND table_name = '" + tableName + "' AND column_name = '" + columnName + "'");
    }

    @Test
    public void testMigrateTimestampMillisTypeWithAvro() {
        String tableName = "test_migrate_timestamp_millis_avro" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.tpch." + tableName;
        this.assertUpdate("CREATE TABLE " + hiveTableName + " WITH (format='AVRO') AS SELECT timestamp '2021-01-01 00:00:00.000' x", 1L);
        this.assertQuery("SELECT * FROM " + hiveTableName, "VALUES timestamp '2021-01-01 00:00:00.000'");
        this.assertQueryFails("CALL iceberg.system.migrate('tpch', '" + tableName + "')", "Migrating timestamp type with Avro format is not supported.");
        this.assertUpdate("DROP TABLE " + hiveTableName);
    }

    @Test
    public void testMigrateUnsupportedTableFormat() {
        String tableName = "test_migrate_unsupported_table_format_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.tpch." + tableName;
        String icebergTableName = "iceberg.tpch." + tableName;
        this.assertUpdate("CREATE TABLE " + hiveTableName + " WITH (format = 'RCBINARY') AS SELECT 1 x", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("CALL iceberg.system.migrate('tpch', '" + tableName + "')"))).failure().hasStackTraceContaining("Unsupported storage format: RCBINARY");
        this.assertQuery("SELECT * FROM " + hiveTableName, "VALUES 1");
        this.assertQueryFails("SELECT * FROM " + icebergTableName, "Not an Iceberg table: .*");
        this.assertUpdate("DROP TABLE " + hiveTableName);
    }

    @Test
    public void testMigrateUnsupportedTableType() {
        String viewName = "test_migrate_unsupported_table_type_" + TestingNames.randomNameSuffix();
        String trinoViewInHive = "hive.tpch." + viewName;
        String trinoViewInIceberg = "iceberg.tpch." + viewName;
        this.assertUpdate("CREATE VIEW " + trinoViewInHive + " AS SELECT 1 x");
        this.assertQueryFails("CALL iceberg.system.migrate('tpch', '" + viewName + "')", "The procedure doesn't support migrating VIRTUAL_VIEW table type");
        this.assertQuery("SELECT * FROM " + trinoViewInHive, "VALUES 1");
        this.assertQuery("SELECT * FROM " + trinoViewInIceberg, "VALUES 1");
        this.assertUpdate("DROP VIEW " + trinoViewInHive);
    }

    @Test
    public void testMigrateEmptyTable() {
        String tableName = "test_migrate_empty_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.tpch." + tableName;
        String icebergTableName = "iceberg.tpch." + tableName;
        this.assertUpdate("CREATE TABLE " + hiveTableName + " (col int)");
        this.assertUpdate("CALL iceberg.system.migrate('tpch', '" + tableName + "')");
        this.assertQuery("DESCRIBE " + icebergTableName, "VALUES ('col', 'integer', '', '')");
        this.assertQueryReturnsEmptyResult("SELECT * FROM " + icebergTableName);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private String getColumnType(String tableName, String columnName) {
        return (String)this.computeScalar(String.format("SELECT data_type FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name = '%s' AND column_name = '%s'", tableName, columnName));
    }

    private static /* synthetic */ Object[][] lambda$fileFormats$1(int x$0) {
        return new Object[x$0][];
    }
}

