/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.procedure;

import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.iceberg.IcebergQueryRunner;
import io.trino.plugin.iceberg.IcebergTestUtils;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.TestTable;
import java.util.Set;
import org.apache.iceberg.BaseTable;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class TestIcebergOptimizeManifestsProcedure
extends AbstractTestQueryFramework {
    private HiveMetastore metastore;
    private TrinoFileSystemFactory fileSystemFactory;

    TestIcebergOptimizeManifestsProcedure() {
    }

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = IcebergQueryRunner.builder().build();
        this.metastore = IcebergTestUtils.getHiveMetastore((QueryRunner)queryRunner);
        this.fileSystemFactory = IcebergTestUtils.getFileSystemFactory((QueryRunner)queryRunner);
        return queryRunner;
    }

    @Test
    void testOptimizeManifests() {
        try (TestTable table = this.newTrinoTable("test_optimize_manifests", "(x int)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 1", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            Set<String> manifestFiles = this.manifestFiles(table.getName());
            Assertions.assertThat(manifestFiles).hasSize(2);
            this.assertUpdate("ALTER TABLE " + table.getName() + " EXECUTE optimize_manifests");
            ((AbstractCollectionAssert)Assertions.assertThat(this.manifestFiles(table.getName())).hasSize(1)).doesNotContainAnyElementsOf(manifestFiles);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES 1, 2");
        }
    }

    @Test
    void testSplitManifests() {
        try (TestTable table = this.newTrinoTable("test_optimize_manifests", "(x int)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 1", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 3", 1L);
            this.assertUpdate("ALTER TABLE " + table.getName() + " EXECUTE optimize_manifests");
            Assertions.assertThat(this.manifestFiles(table.getName())).hasSize(1);
            BaseTable icebergTable = this.loadTable(table.getName());
            icebergTable.updateProperties().set("commit.manifest.target-size-bytes", "1").commit();
            this.assertUpdate("ALTER TABLE " + table.getName() + " EXECUTE optimize_manifests");
            Assertions.assertThat(this.manifestFiles(table.getName())).hasSize(3);
        }
    }

    @Test
    void testPartitionTable() {
        try (TestTable table = this.newTrinoTable("test_partition", "(id int, part int) WITH (partitioning = ARRAY['part'])");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (1, 10)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2, 10)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (3, 20)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (4, 20)", 1L);
            Set<String> manifestFiles = this.manifestFiles(table.getName());
            Assertions.assertThat(manifestFiles).hasSize(4);
            this.assertUpdate("ALTER TABLE " + table.getName() + " EXECUTE optimize_manifests");
            ((AbstractCollectionAssert)Assertions.assertThat(this.manifestFiles(table.getName())).hasSize(2)).doesNotContainAnyElementsOf(manifestFiles);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES (1, 10), (2, 10), (3, 20), (4, 20)");
        }
    }

    @Test
    void testFirstPartitionField() {
        try (TestTable table = this.newTrinoTable("test_partition", "(id int, part int, nested int) WITH (partitioning = ARRAY['part', 'nested'])");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (1, 10, 100)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2, 10, 200)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (3, 20, 300)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (4, 20, 400)", 1L);
            Set<String> manifestFiles = this.manifestFiles(table.getName());
            Assertions.assertThat(manifestFiles).hasSize(4);
            this.assertUpdate("ALTER TABLE " + table.getName() + " EXECUTE optimize_manifests");
            ((AbstractCollectionAssert)Assertions.assertThat(this.manifestFiles(table.getName())).hasSize(2)).doesNotContainAnyElementsOf(manifestFiles);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES (1, 10, 100), (2, 10, 200), (3, 20, 300), (4, 20, 400)");
        }
    }

    @Test
    void testEmptyManifest() {
        try (TestTable table = this.newTrinoTable("test_no_rewrite", "(x int)");){
            Set<String> manifestFiles = this.manifestFiles(table.getName());
            Assertions.assertThat(manifestFiles).isEmpty();
            this.assertUpdate("ALTER TABLE " + table.getName() + " EXECUTE optimize_manifests");
            Assertions.assertThat(this.manifestFiles(table.getName())).isEmpty();
            this.assertQueryReturnsEmptyResult("SELECT * FROM " + table.getName());
        }
    }

    @Test
    void testNotRewriteSingleManifest() {
        try (TestTable table = this.newTrinoTable("test_no_rewrite", "(x int)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 1", 1L);
            Set<String> manifestFiles = this.manifestFiles(table.getName());
            Assertions.assertThat(manifestFiles).hasSize(1);
            this.assertUpdate("ALTER TABLE " + table.getName() + " EXECUTE optimize_manifests");
            ((AbstractCollectionAssert)Assertions.assertThat(this.manifestFiles(table.getName())).hasSize(1)).isEqualTo(manifestFiles);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES 1");
        }
    }

    @Test
    void testUnsupportedWhere() {
        try (TestTable table = this.newTrinoTable("test_unsupported_where", "WITH (partitioning = ARRAY['part']) AS SELECT 1 id, 1 part");){
            this.assertQueryFails("ALTER TABLE " + table.getName() + " EXECUTE optimize_manifests WHERE id = 1", ".* WHERE not supported for procedure OPTIMIZE_MANIFESTS");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " EXECUTE optimize_manifests WHERE part = 10", ".* WHERE not supported for procedure OPTIMIZE_MANIFESTS");
        }
    }

    private Set<String> manifestFiles(String tableName) {
        return (Set)this.computeActual("SELECT path FROM \"" + tableName + "$manifests\"").getOnlyColumnAsSet().stream().map(path -> (String)path).collect(ImmutableSet.toImmutableSet());
    }

    private BaseTable loadTable(String tableName) {
        return IcebergTestUtils.loadTable(tableName, this.metastore, this.fileSystemFactory, "hive", "tpch");
    }
}

