/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.util;

import com.google.common.collect.ImmutableList;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.fileio.ForwardingFileIo;
import io.trino.testing.TestingConnectorSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;

public final class EqualityDeleteUtils {
    private EqualityDeleteUtils() {
    }

    public static void writeEqualityDeleteForTable(Table icebergTable, TrinoFileSystemFactory fileSystemFactory, Optional<PartitionSpec> partitionSpec, Optional<PartitionData> partitionData, Map<String, Object> overwriteValues, Optional<List<String>> deleteFileColumns) throws IOException {
        List deleteColumns = deleteFileColumns.orElse(new ArrayList<String>(overwriteValues.keySet()));
        Schema deleteRowSchema = icebergTable.schema().select((Collection)deleteColumns);
        List equalityDeleteFieldIds = (List)deleteColumns.stream().map(name -> deleteRowSchema.findField(name).fieldId()).collect(ImmutableList.toImmutableList());
        EqualityDeleteUtils.writeEqualityDeleteForTableWithSchema(icebergTable, fileSystemFactory, partitionSpec, partitionData, deleteRowSchema, equalityDeleteFieldIds, overwriteValues);
    }

    public static void writeEqualityDeleteForTableWithSchema(Table icebergTable, TrinoFileSystemFactory fileSystemFactory, Optional<PartitionSpec> partitionSpec, Optional<PartitionData> partitionData, Schema deleteRowSchema, List<Integer> equalityDeleteFieldIds, Map<String, Object> overwriteValues) throws IOException {
        String deleteFileName = "local:///delete_file_" + String.valueOf(UUID.randomUUID()) + ".parquet";
        ForwardingFileIo fileIo = new ForwardingFileIo(fileSystemFactory.create(TestingConnectorSession.SESSION));
        Parquet.DeleteWriteBuilder writerBuilder = Parquet.writeDeletes((OutputFile)fileIo.newOutputFile(deleteFileName)).forTable(icebergTable).rowSchema(deleteRowSchema).createWriterFunc(GenericParquetWriter::create).equalityFieldIds(equalityDeleteFieldIds).overwrite();
        if (partitionSpec.isPresent() && partitionData.isPresent()) {
            writerBuilder = writerBuilder.withSpec(partitionSpec.get()).withPartition((StructLike)partitionData.get());
        }
        EqualityDeleteWriter writer = writerBuilder.buildEqualityWriter();
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        try (EqualityDeleteWriter ignored = writer;){
            writer.write((Object)dataDelete.copy(overwriteValues));
        }
        icebergTable.newRowDelta().addDeletes(writer.toDeleteFile()).commit();
    }
}

