/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.util;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.trino.filesystem.tracing.FileSystemAttributes;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class FileOperationUtils {
    private FileOperationUtils() {
    }

    public static Multiset<FileOperation> getOperations(List<SpanData> spans) {
        return (Multiset)spans.stream().filter(span -> span.getName().startsWith("InputFile.") || span.getName().startsWith("OutputFile.")).map(span -> new FileOperation(FileType.fromFilePath(Objects.requireNonNull((String)span.getAttributes().get(FileSystemAttributes.FILE_LOCATION))), span.getName())).collect(Collectors.toCollection(HashMultiset::create));
    }

    public record FileOperation(FileType fileType, String operationType) {
        public FileOperation {
            Objects.requireNonNull(fileType, "fileType is null");
            Objects.requireNonNull(operationType, "operationType is null");
        }
    }

    public static enum FileType {
        METADATA_JSON,
        SNAPSHOT,
        MANIFEST,
        STATS,
        DATA,
        DELETE,
        METASTORE;


        public static FileType fromFilePath(String path) {
            if (path.endsWith("metadata.json")) {
                return METADATA_JSON;
            }
            if (path.contains("/snap-")) {
                return SNAPSHOT;
            }
            if (path.endsWith("-m0.avro")) {
                return MANIFEST;
            }
            if (path.endsWith(".stats")) {
                return STATS;
            }
            if (path.contains("/data/") && (path.endsWith(".orc") || path.endsWith(".parquet"))) {
                return DATA;
            }
            if (path.contains("delete_file") && (path.endsWith(".orc") || path.endsWith(".parquet"))) {
                return DELETE;
            }
            if (path.endsWith(".trinoSchema") || path.contains("/.trinoPermissions/")) {
                return METASTORE;
            }
            throw new IllegalArgumentException("File not recognized: " + path);
        }
    }

    public static enum Scope implements Predicate<FileOperation>
    {
        METADATA_FILES{

            @Override
            public boolean test(FileOperation fileOperation) {
                return fileOperation.fileType() != FileType.DATA && fileOperation.fileType() != FileType.METASTORE;
            }
        }
        ,
        ALL_FILES{

            @Override
            public boolean test(FileOperation fileOperation) {
                return fileOperation.fileType() != FileType.METASTORE;
            }
        };

    }
}

