/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.util;

import io.trino.plugin.iceberg.util.DefaultLocationProvider;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestDefaultLocationProvider {
    TestDefaultLocationProvider() {
    }

    @Test
    void testDefault() {
        DefaultLocationProvider provider = new DefaultLocationProvider("s3://table-location/", Map.of());
        Assertions.assertThat((String)provider.newDataLocation("test")).isEqualTo("s3://table-location/data/test");
    }

    @Test
    void testDefaultWithCustomDataLocation() {
        DefaultLocationProvider provider = new DefaultLocationProvider("s3://table-location/", Map.of("write.data.path", "s3://write-location/"));
        Assertions.assertThat((String)provider.newDataLocation("test")).isEqualTo("s3://write-location/test");
    }

    @Test
    void testDefaultPropertyResolution() {
        DefaultLocationProvider provider = new DefaultLocationProvider("s3://table-location/", Map.of("write.folder-storage.path", "s3://folder-location/"));
        Assertions.assertThat((String)provider.newDataLocation("test")).isEqualTo("s3://folder-location/test");
        provider = new DefaultLocationProvider("s3://table-location/", Map.of("write.folder-storage.path", "s3://folder-location/", "write.data.path", "s3://data-location/"));
        Assertions.assertThat((String)provider.newDataLocation("test")).isEqualTo("s3://data-location/test");
    }
}

