/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.util;

import io.trino.plugin.iceberg.util.ObjectStoreLocationProvider;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestObjectStoreLocationProvider {
    TestObjectStoreLocationProvider() {
    }

    @Test
    void testObjectStorageWithinTableLocation() {
        ObjectStoreLocationProvider provider = new ObjectStoreLocationProvider("s3://table-location/xyz", Map.of());
        Assertions.assertThat((String)provider.newDataLocation("test")).isEqualTo("s3://table-location/xyz/data/E9Jrug/test");
    }

    @Test
    void testObjectStorageWithContextEmpty() {
        ObjectStoreLocationProvider provider = new ObjectStoreLocationProvider("s3://table-location/", Map.of("write.data.path", "s3://data-location/write/"));
        Assertions.assertThat((String)provider.newDataLocation("test")).isEqualTo("s3://data-location/write/E9Jrug/test");
    }

    @Test
    void testObjectStorageWithContextTable() {
        ObjectStoreLocationProvider provider = new ObjectStoreLocationProvider("s3://table-location/xyz", Map.of("write.data.path", "s3://data-location/write/"));
        Assertions.assertThat((String)provider.newDataLocation("test")).isEqualTo("s3://data-location/write/E9Jrug/xyz/test");
    }

    @Test
    void testObjectStorageWithContextDatabaseTable() {
        ObjectStoreLocationProvider provider = new ObjectStoreLocationProvider("s3://table-location/abc/xyz", Map.of("write.data.path", "s3://data-location/write/"));
        Assertions.assertThat((String)provider.newDataLocation("test")).isEqualTo("s3://data-location/write/E9Jrug/abc/xyz/test");
    }

    @Test
    void testObjectStorageWithContextPrefixDatabaseTable() {
        ObjectStoreLocationProvider provider = new ObjectStoreLocationProvider("s3://table-location/hello/world/abc/xyz", Map.of("write.data.path", "s3://data-location/write/"));
        Assertions.assertThat((String)provider.newDataLocation("test")).isEqualTo("s3://data-location/write/E9Jrug/abc/xyz/test");
    }

    @Test
    void testObjectStoragePropertyResolution() {
        ObjectStoreLocationProvider provider = new ObjectStoreLocationProvider("s3://table-location/", Map.of("write.folder-storage.path", "s3://folder-location/xyz"));
        Assertions.assertThat((String)provider.newDataLocation("test")).isEqualTo("s3://folder-location/xyz/E9Jrug/test");
        provider = new ObjectStoreLocationProvider("s3://table-location/", Map.of("write.folder-storage.path", "s3://folder-location/abc", "write.object-storage.path", "s3://object-location/xyz"));
        Assertions.assertThat((String)provider.newDataLocation("test")).isEqualTo("s3://object-location/xyz/E9Jrug/test");
        provider = new ObjectStoreLocationProvider("s3://table-location/", Map.of("write.folder-storage.path", "s3://folder-location/abc", "write.object-storage.path", "s3://object-location/abc", "write.data.path", "s3://data-location/xyz"));
        Assertions.assertThat((String)provider.newDataLocation("test")).isEqualTo("s3://data-location/xyz/E9Jrug/test");
    }
}

