/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg.util;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.iceberg.util.PrimitiveTypeMapBuilder;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPrimitiveTypeMapBuilder {
    @Test
    public void testMakeTypeMapProducesCorrectMapForTypesWithQuotes() {
        ImmutableList inputTypes = ImmutableList.of((Object)IntegerType.INTEGER, (Object)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("another identifier"), (Type)IntegerType.INTEGER))));
        ImmutableList inputColumnNames = ImmutableList.of((Object)"an identifier with \"quotes\" ", (Object)"a");
        Assertions.assertThat((Map)PrimitiveTypeMapBuilder.makeTypeMap((List)inputTypes, (List)inputColumnNames)).containsExactly(new Map.Entry[]{Map.entry(ImmutableList.of((Object)"an_x20identifier_x20with_x20_x22quotes_x22_x20"), IntegerType.INTEGER), Map.entry(ImmutableList.of((Object)"a", (Object)"another_x20identifier"), IntegerType.INTEGER)});
    }
}

