/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.node.NodeInfo;
import jakarta.servlet.Servlet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.rest.RESTCatalogAdapter;
import org.apache.iceberg.rest.RESTSessionCatalog;
import org.apache.iceberg.rest.RestCatalogServlet;

public class DelegatingRestSessionCatalog
extends RESTSessionCatalog {
    private RESTCatalogAdapter adapter;
    private Catalog delegate;

    private DelegatingRestSessionCatalog() {
    }

    DelegatingRestSessionCatalog(RESTCatalogAdapter adapter, Catalog delegate) {
        super(properties -> adapter, null);
        this.adapter = Objects.requireNonNull(adapter, "adapter is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate catalog is null");
    }

    public void close() throws IOException {
        super.close();
        this.adapter.close();
        Catalog catalog = this.delegate;
        if (catalog instanceof Closeable) {
            Closeable closeable = (Closeable)catalog;
            closeable.close();
        }
    }

    public TestingHttpServer testServer() throws IOException {
        NodeInfo nodeInfo = new NodeInfo("test");
        HttpServerConfig config = new HttpServerConfig().setHttpPort(0).setMinThreads(4).setMaxThreads(8).setHttpAcceptorThreads(Integer.valueOf(4)).setHttpAcceptQueueSize(10).setHttpEnabled(true);
        HttpServerInfo httpServerInfo = new HttpServerInfo(config, nodeInfo);
        RestCatalogServlet servlet = new RestCatalogServlet(this.adapter);
        return new TestingHttpServer(httpServerInfo, nodeInfo, config, (Servlet)servlet, false, true, false);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Catalog delegate;

        public Builder delegate(Catalog delegate) {
            this.delegate = delegate;
            return this;
        }

        public DelegatingRestSessionCatalog build() {
            Objects.requireNonNull(this.delegate, "Delegate must be set");
            return new DelegatingRestSessionCatalog(new RESTCatalogAdapter(this.delegate), this.delegate);
        }
    }
}

