/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.snowflake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.s3.S3FileSystemConfig;
import io.trino.filesystem.s3.S3FileSystemFactory;
import io.trino.filesystem.s3.S3FileSystemStats;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.IcebergMetadata;
import io.trino.plugin.iceberg.TableStatisticsWriter;
import io.trino.plugin.iceberg.catalog.BaseTrinoCatalogTest;
import io.trino.plugin.iceberg.catalog.IcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.catalog.snowflake.IcebergSnowflakeCatalogConfig;
import io.trino.plugin.iceberg.catalog.snowflake.SnowflakeIcebergTableOperationsProvider;
import io.trino.plugin.iceberg.catalog.snowflake.TestIcebergSnowflakeCatalogConnectorSmokeTest;
import io.trino.plugin.iceberg.catalog.snowflake.TestingSnowflakeServer;
import io.trino.plugin.iceberg.catalog.snowflake.TrinoSnowflakeCatalog;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingNames;
import io.trino.tpch.TpchTable;
import io.trino.type.InternalTypeManager;
import java.net.URI;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.jdbc.JdbcClientPool;
import org.apache.iceberg.snowflake.JdbcSnowflakeClient;
import org.apache.iceberg.snowflake.SnowflakeCatalog;
import org.apache.iceberg.snowflake.SnowflakeClient;
import org.apache.iceberg.snowflake.TrinoIcebergSnowflakeCatalogFactory;
import org.apache.iceberg.snowflake.TrinoIcebergSnowflakeCatalogFileIOFactory;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestTrinoSnowflakeCatalog
extends BaseTrinoCatalogTest {
    public static final IcebergSnowflakeCatalogConfig CATALOG_CONFIG = new IcebergSnowflakeCatalogConfig().setDatabase(TestingSnowflakeServer.SNOWFLAKE_TEST_DATABASE).setUri(URI.create(TestingSnowflakeServer.SNOWFLAKE_JDBC_URI)).setRole(TestingSnowflakeServer.SNOWFLAKE_ROLE).setUser(TestingSnowflakeServer.SNOWFLAKE_USER).setPassword(TestingSnowflakeServer.SNOWFLAKE_PASSWORD);

    @BeforeAll
    public static void setupServer() {
        TestTrinoSnowflakeCatalog.testTableSetup();
    }

    private static void testTableSetup() {
        TestingSnowflakeServer server = new TestingSnowflakeServer();
        try {
            server.execute(TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA, "CREATE SCHEMA IF NOT EXISTS %s".formatted(TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA));
            if (!server.checkIfTableExists(TestingSnowflakeServer.TableType.ICEBERG, TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA, TpchTable.NATION.getTableName())) {
                TestTrinoSnowflakeCatalog.executeOnSnowflake(server, "CREATE OR REPLACE ICEBERG TABLE %s (\n\tNATIONKEY NUMBER(38,0),\n\tNAME STRING,\n\tREGIONKEY NUMBER(38,0),\n\tCOMMENT STRING\n)\n EXTERNAL_VOLUME = '%s'\n CATALOG = 'SNOWFLAKE'\n BASE_LOCATION = '%s/'".formatted(TpchTable.NATION.getTableName(), TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_S3_EXTERNAL_VOLUME, TpchTable.NATION.getTableName()));
                TestTrinoSnowflakeCatalog.executeOnSnowflake(server, "INSERT INTO %s(NATIONKEY, NAME, REGIONKEY, COMMENT) SELECT N_NATIONKEY, N_NAME, N_REGIONKEY, N_COMMENT FROM SNOWFLAKE_SAMPLE_DATA.TPCH_SF1.%s".formatted(TpchTable.NATION.getTableName(), TpchTable.NATION.getTableName()));
            }
            if (!server.checkIfTableExists(TestingSnowflakeServer.TableType.ICEBERG, TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA, TpchTable.REGION.getTableName())) {
                TestTrinoSnowflakeCatalog.executeOnSnowflake(server, "CREATE OR REPLACE ICEBERG TABLE %s (\n\tREGIONKEY NUMBER(38,0),\n\tNAME STRING,\n\tCOMMENT STRING\n)\n EXTERNAL_VOLUME = '%s'\n CATALOG = 'SNOWFLAKE'\n BASE_LOCATION = '%s/'".formatted(TpchTable.REGION.getTableName(), TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_S3_EXTERNAL_VOLUME, TpchTable.REGION.getTableName()));
                TestTrinoSnowflakeCatalog.executeOnSnowflake(server, "INSERT INTO %s(REGIONKEY, NAME, COMMENT) SELECT R_REGIONKEY, R_NAME, R_COMMENT FROM SNOWFLAKE_SAMPLE_DATA.TPCH_SF1.%s".formatted(TpchTable.REGION.getTableName(), TpchTable.REGION.getTableName()));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void executeOnSnowflake(TestingSnowflakeServer server, String sql) throws SQLException {
        server.execute(TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA, sql);
    }

    @Override
    protected TrinoCatalog createTrinoCatalog(boolean useUniqueTableLocations) {
        Map properties = TrinoIcebergSnowflakeCatalogFactory.getSnowflakeDriverProperties((URI)CATALOG_CONFIG.getUri(), (String)CATALOG_CONFIG.getUser(), (String)CATALOG_CONFIG.getPassword(), (Optional)CATALOG_CONFIG.getRole());
        JdbcClientPool connectionPool = new JdbcClientPool(TestingSnowflakeServer.SNOWFLAKE_JDBC_URI, properties);
        JdbcSnowflakeClient snowflakeClient = new JdbcSnowflakeClient(connectionPool);
        S3FileSystemFactory s3FileSystemFactory = new S3FileSystemFactory(OpenTelemetry.noop(), new S3FileSystemConfig().setAwsAccessKey(TestIcebergSnowflakeCatalogConnectorSmokeTest.S3_ACCESS_KEY).setAwsSecretKey(TestIcebergSnowflakeCatalogConnectorSmokeTest.S3_SECRET_KEY).setRegion(TestIcebergSnowflakeCatalogConnectorSmokeTest.S3_REGION).setStreamingPartSize(DataSize.valueOf((String)"5.5MB")), new S3FileSystemStats());
        CatalogName catalogName = new CatalogName("snowflake_test_catalog");
        TrinoIcebergSnowflakeCatalogFileIOFactory catalogFileIOFactory = new TrinoIcebergSnowflakeCatalogFileIOFactory((TrinoFileSystemFactory)s3FileSystemFactory, ConnectorIdentity.ofUser((String)"trino"));
        SnowflakeCatalog snowflakeCatalog = new SnowflakeCatalog();
        snowflakeCatalog.initialize(catalogName.toString(), (SnowflakeClient)snowflakeClient, (SnowflakeCatalog.FileIOFactory)catalogFileIOFactory, properties);
        SnowflakeIcebergTableOperationsProvider tableOperationsProvider = new SnowflakeIcebergTableOperationsProvider(CATALOG_CONFIG, (TrinoFileSystemFactory)s3FileSystemFactory);
        return new TrinoSnowflakeCatalog(snowflakeCatalog, catalogName, InternalTypeManager.TESTING_TYPE_MANAGER, (TrinoFileSystemFactory)s3FileSystemFactory, (IcebergTableOperationsProvider)tableOperationsProvider, TestingSnowflakeServer.SNOWFLAKE_TEST_DATABASE);
    }

    @Override
    @Test
    public void testCreateNamespaceWithLocation() {
        Assertions.assertThatThrownBy(() -> super.testCreateNamespaceWithLocation()).hasMessageContaining("Iceberg Snowflake catalog schemas do not support modifications");
    }

    @Override
    @Test
    public void testNonLowercaseNamespace() {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        String namespace = TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA.toUpperCase(Locale.ENGLISH);
        String schema = namespace.toLowerCase(Locale.ENGLISH);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.namespaceExists(SESSION, namespace)).as("catalog.namespaceExists(namespace)", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.namespaceExists(SESSION, schema)).as("catalog.namespaceExists(schema)", new Object[0])).isTrue();
        ((ListAssert)((ListAssert)Assertions.assertThat((List)catalog.listNamespaces(SESSION)).as("catalog.listNamespaces", new Object[0])).doesNotContain((Object[])new String[]{schema})).contains((Object[])new String[]{namespace});
        IcebergMetadata icebergMetadata = new IcebergMetadata(TestingPlannerContext.PLANNER_CONTEXT.getTypeManager(), CatalogHandle.fromId((String)"iceberg:NORMAL:v12345"), JsonCodec.jsonCodec(CommitTaskData.class), catalog, (connectorIdentity, fileIOProperties) -> {
            throw new UnsupportedOperationException();
        }, new TableStatisticsWriter(new NodeVersion("test-version")), Optional.empty(), false, string -> false, (ExecutorService)MoreExecutors.newDirectExecutorService(), MoreExecutors.directExecutor(), (ExecutorService)MoreExecutors.newDirectExecutorService());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)icebergMetadata.schemaExists(SESSION, namespace)).as("icebergMetadata.schemaExists(namespace)", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)icebergMetadata.schemaExists(SESSION, schema)).as("icebergMetadata.schemaExists(schema)", new Object[0])).isTrue();
        ((ListAssert)((ListAssert)Assertions.assertThat((List)icebergMetadata.listSchemaNames(SESSION)).as("icebergMetadata.listSchemaNames", new Object[0])).doesNotContain((Object[])new String[]{schema})).contains((Object[])new String[]{namespace});
    }

    @Override
    @Test
    public void testCreateTable() {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        String table = "tableName";
        SchemaTableName schemaTableName = new SchemaTableName(TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA, table);
        Map<String, String> tableProperties = Map.of("test_key", "test_value");
        String tableLocation = "some/location";
        Assertions.assertThatThrownBy(() -> catalog.newCreateTableTransaction(SESSION, schemaTableName, new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"col1", (Type)Types.LongType.get())}), PartitionSpec.unpartitioned(), SortOrder.unsorted(), Optional.of(tableLocation), tableProperties).commitTransaction()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testCreateWithSortTable() {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        String namespace = "test_create_sort_table_" + TestingNames.randomNameSuffix();
        String table = "tableName";
        SchemaTableName schemaTableName = new SchemaTableName(namespace, table);
        Schema tableSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"col1", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"col2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"col3", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)4, (String)"col4", (Type)Types.StringType.get())});
        SortOrder sortOrder = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)tableSchema).asc("col1")).desc("col2", NullOrder.NULLS_FIRST)).desc("col3")).desc((Term)Expressions.year((String)"col3"), NullOrder.NULLS_LAST).desc((Term)Expressions.month((String)"col3"), NullOrder.NULLS_FIRST).asc((Term)Expressions.day((String)"col3"), NullOrder.NULLS_FIRST).asc((Term)Expressions.hour((String)"col3"), NullOrder.NULLS_FIRST).desc((Term)Expressions.bucket((String)"col2", (int)10), NullOrder.NULLS_FIRST).desc((Term)Expressions.truncate((String)"col4", (int)5), NullOrder.NULLS_FIRST).build();
        String tableLocation = "some/location";
        Assertions.assertThatThrownBy(() -> catalog.newCreateTableTransaction(SESSION, schemaTableName, tableSchema, PartitionSpec.unpartitioned(), sortOrder, Optional.of(tableLocation), (Map)ImmutableMap.of()).commitTransaction()).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testRenameTable() {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        Assertions.assertThatThrownBy(() -> {
            SchemaTableName sourceSchemaTableName = new SchemaTableName(TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA, TpchTable.REGION.getTableName());
            SchemaTableName targetSchemaTableName = new SchemaTableName(sourceSchemaTableName.getSchemaName(), "newTableName");
            catalog.renameTable(SESSION, sourceSchemaTableName, targetSchemaTableName);
        }).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testUseUniqueTableLocations() {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        String table = "non_existing_table";
        Assertions.assertThatThrownBy(() -> catalog.defaultTableLocation(SESSION, SchemaTableName.schemaTableName((String)TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA, (String)table))).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Override
    @Test
    public void testView() {
        ConnectorViewDefinition viewDefinition = new ConnectorViewDefinition("SELECT name FROM local.tiny.%s".formatted(TpchTable.NATION.getTableName()), Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("name", VarcharType.createVarcharType((int)25).getTypeId(), Optional.empty())), Optional.empty(), Optional.of(SESSION.getUser()), false, (List)ImmutableList.of());
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        Assertions.assertThatThrownBy(() -> catalog.createView(SESSION, SchemaTableName.schemaTableName((String)TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA, (String)TpchTable.NATION.getTableName()), viewDefinition, true)).hasMessageContaining("Views are not supported for the Snowflake Iceberg catalog");
    }

    @Override
    @Test
    public void testListTables() {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        List tables = catalog.listTables(SESSION, Optional.of(TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA));
        Assertions.assertThat(tables.stream().map(table -> table.tableName().getTableName()).toList()).contains((Object[])new String[]{TpchTable.NATION.getTableName(), TpchTable.REGION.getTableName()});
        tables = catalog.listTables(SESSION, Optional.of(TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA));
        Assertions.assertThat(tables.stream().map(table -> table.tableName().getTableName()).toList()).contains((Object[])new String[]{TpchTable.NATION.getTableName(), TpchTable.REGION.getTableName()});
    }

    @Test
    public void testLoadTable() {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        BaseTable table = catalog.loadTable(SESSION, SchemaTableName.schemaTableName((String)TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA, (String)TpchTable.REGION.getTableName()));
        Assertions.assertThat(table.schema().columns().stream().map(Types.NestedField::name).toList()).containsExactlyInAnyOrder((Object[])new String[]{"REGIONKEY", "NAME", "COMMENT"});
    }

    @Test
    public void testLoadNamespaceMetadata() {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        Map metadata = catalog.loadNamespaceMetadata(SESSION, TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA);
        Assertions.assertThat((Map)metadata).isEmpty();
    }

    @Test
    public void updateTableComment() {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        Assertions.assertThatThrownBy(() -> catalog.updateTableComment(SESSION, SchemaTableName.schemaTableName((String)TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA, (String)TpchTable.REGION.getTableName()), Optional.empty())).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void defaultTableLocation() {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        Assertions.assertThatThrownBy(() -> catalog.defaultTableLocation(SESSION, SchemaTableName.schemaTableName((String)TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA, (String)TpchTable.REGION.getTableName()))).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void updateColumnComment() {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        Assertions.assertThatThrownBy(() -> catalog.updateColumnComment(SESSION, SchemaTableName.schemaTableName((String)TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA, (String)TpchTable.NATION.getTableName()), ColumnIdentity.primitiveColumnIdentity((int)2, (String)"REGIONKEY"), Optional.of("Column comment created from test code"))).hasMessageContaining("Snowflake managed Iceberg tables do not support modifications");
    }

    @Test
    public void listNamespaces() {
        TrinoCatalog catalog = this.createTrinoCatalog(false);
        Assertions.assertThat(catalog.listNamespaces(SESSION).stream().map(String::toLowerCase).toList()).contains((Object[])new String[]{TestIcebergSnowflakeCatalogConnectorSmokeTest.SNOWFLAKE_TEST_SCHEMA.toLowerCase(Locale.ENGLISH)});
    }
}

