/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.slice.SizeOf;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class ColumnIdentity {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ColumnIdentity.class);
    private final int id;
    private final String name;
    private final TypeCategory typeCategory;
    private final Map<Integer, ColumnIdentity> children;
    private final Map<Integer, Integer> childFieldIdToIndex;

    @JsonCreator
    public ColumnIdentity(@JsonProperty(value="id") int id, @JsonProperty(value="name") String name, @JsonProperty(value="typeCategory") TypeCategory typeCategory, @JsonProperty(value="children") List<ColumnIdentity> children) {
        this.id = id;
        this.name = Objects.requireNonNull(name, "name is null");
        this.typeCategory = Objects.requireNonNull(typeCategory, "typeCategory is null");
        Objects.requireNonNull(children, "children is null");
        Preconditions.checkArgument((children.isEmpty() == (typeCategory == TypeCategory.PRIMITIVE) ? 1 : 0) != 0, (Object)"Children should be empty if and only if column type is primitive");
        ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
        ImmutableMap.Builder childFieldIdToIndex = ImmutableMap.builder();
        for (int i = 0; i < children.size(); ++i) {
            ColumnIdentity child = children.get(i);
            childrenBuilder.put((Object)child.getId(), (Object)child);
            childFieldIdToIndex.put((Object)child.getId(), (Object)i);
        }
        this.children = childrenBuilder.buildOrThrow();
        this.childFieldIdToIndex = childFieldIdToIndex.buildOrThrow();
    }

    @JsonProperty
    public int getId() {
        return this.id;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public TypeCategory getTypeCategory() {
        return this.typeCategory;
    }

    @JsonProperty
    public List<ColumnIdentity> getChildren() {
        return ImmutableList.copyOf(this.children.values());
    }

    @JsonIgnore
    public ColumnIdentity getChildByFieldId(int fieldId) {
        Preconditions.checkArgument((boolean)this.children.containsKey(fieldId), (String)"ColumnIdentity %s does not contain child with field id %s", (Object)this, (int)fieldId);
        return this.children.get(fieldId);
    }

    @JsonIgnore
    public int getChildIndexByFieldId(int fieldId) {
        Preconditions.checkArgument((boolean)this.childFieldIdToIndex.containsKey(fieldId), (String)"ColumnIdentity %s does not contain child with field id %s", (Object)this, (int)fieldId);
        return this.childFieldIdToIndex.get(fieldId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnIdentity that = (ColumnIdentity)o;
        return this.id == that.id && this.name.equals(that.name) && this.typeCategory == that.typeCategory && this.children.equals(that.children);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.typeCategory, this.children});
    }

    public String toString() {
        return this.id + ":" + this.name;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Integer)this.id) + SizeOf.estimatedSizeOf((String)this.name) + SizeOf.estimatedSizeOf(this.children, SizeOf::sizeOf, ColumnIdentity::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf(this.childFieldIdToIndex, SizeOf::sizeOf, SizeOf::sizeOf);
    }

    public static ColumnIdentity primitiveColumnIdentity(int id, String name) {
        return new ColumnIdentity(id, name, TypeCategory.PRIMITIVE, (List<ColumnIdentity>)ImmutableList.of());
    }

    public static ColumnIdentity createColumnIdentity(Types.NestedField column) {
        int id = column.fieldId();
        String name = column.name();
        Type fieldType = column.type();
        if (!fieldType.isNestedType()) {
            return new ColumnIdentity(id, name, TypeCategory.PRIMITIVE, (List<ColumnIdentity>)ImmutableList.of());
        }
        if (fieldType.isListType()) {
            ColumnIdentity elementColumn = ColumnIdentity.createColumnIdentity((Types.NestedField)Iterables.getOnlyElement((Iterable)fieldType.asListType().fields()));
            return new ColumnIdentity(id, name, TypeCategory.ARRAY, (List<ColumnIdentity>)ImmutableList.of((Object)elementColumn));
        }
        if (fieldType.isStructType()) {
            List fieldColumns = (List)fieldType.asStructType().fields().stream().map(ColumnIdentity::createColumnIdentity).collect(ImmutableList.toImmutableList());
            return new ColumnIdentity(id, name, TypeCategory.STRUCT, fieldColumns);
        }
        if (fieldType.isMapType()) {
            List keyValueColumns = (List)fieldType.asMapType().fields().stream().map(ColumnIdentity::createColumnIdentity).collect(ImmutableList.toImmutableList());
            Preconditions.checkArgument((keyValueColumns.size() == 2 ? 1 : 0) != 0, (Object)"Expected map type to have two fields");
            return new ColumnIdentity(id, name, TypeCategory.MAP, keyValueColumns);
        }
        throw new UnsupportedOperationException(String.format("Iceberg column type %s is not supported", fieldType.typeId()));
    }

    public static enum TypeCategory {
        PRIMITIVE,
        STRUCT,
        ARRAY,
        MAP;

    }
}

