/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.iceberg.IcebergAvroDataConversion;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergFileWriter;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataWriter;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;

public final class IcebergAvroFileWriter
implements IcebergFileWriter {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(IcebergAvroFileWriter.class);
    public static final String AVRO_TABLE_NAME = "table";
    private final Schema icebergSchema;
    private final List<Type> types;
    private final FileAppender<Record> avroWriter;
    private final Closeable rollbackAction;

    public IcebergAvroFileWriter(OutputFile file, Closeable rollbackAction, Schema icebergSchema, List<Type> types, HiveCompressionCodec hiveCompressionCodec) {
        this.rollbackAction = Objects.requireNonNull(rollbackAction, "rollbackAction null");
        this.icebergSchema = Objects.requireNonNull(icebergSchema, "icebergSchema is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        try {
            this.avroWriter = Avro.write((OutputFile)file).schema(icebergSchema).createWriterFunc(DataWriter::create).named(AVRO_TABLE_NAME).set("write.avro.compression-codec", IcebergAvroFileWriter.toIcebergAvroCompressionName(hiveCompressionCodec)).build();
        }
        catch (IOException | UncheckedIOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_WRITER_OPEN_ERROR, "Error creating Avro file: " + file.location(), (Throwable)e);
        }
    }

    public long getWrittenBytes() {
        return this.avroWriter.length();
    }

    public long getMemoryUsage() {
        return INSTANCE_SIZE;
    }

    public void appendRows(Page dataPage) {
        for (Record record : IcebergAvroDataConversion.toIcebergRecords(dataPage, this.types, this.icebergSchema)) {
            this.avroWriter.add((Object)record);
        }
    }

    public Closeable commit() {
        try {
            this.avroWriter.close();
        }
        catch (IOException e) {
            block4: {
                try {
                    this.rollbackAction.close();
                }
                catch (Exception ex) {
                    if (e.equals(ex)) break block4;
                    e.addSuppressed(ex);
                }
            }
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_WRITER_CLOSE_ERROR, "Error closing Avro file", (Throwable)e);
        }
        return this.rollbackAction;
    }

    public void rollback() {
        try (Closeable closeable = this.rollbackAction;){
            this.avroWriter.close();
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_WRITER_CLOSE_ERROR, "Error rolling back write to Avro file", (Throwable)e);
        }
    }

    public long getValidationCpuNanos() {
        return 0L;
    }

    private static String toIcebergAvroCompressionName(HiveCompressionCodec hiveCompressionCodec) {
        return switch (hiveCompressionCodec) {
            default -> throw new MatchException(null, null);
            case HiveCompressionCodec.NONE -> "UNCOMPRESSED";
            case HiveCompressionCodec.SNAPPY -> "SNAPPY";
            case HiveCompressionCodec.LZ4 -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Compression codec LZ4 not supported for Avro");
            case HiveCompressionCodec.ZSTD -> "ZSTD";
            case HiveCompressionCodec.GZIP -> "GZIP";
        };
    }

    @Override
    public IcebergFileWriter.FileMetrics getFileMetrics() {
        return new IcebergFileWriter.FileMetrics(this.avroWriter.metrics(), Optional.empty());
    }
}

