/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.plugin.iceberg.IcebergAvroDataConversion;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.BigintType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.PlannedDataReader;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class IcebergAvroPageSource
implements ConnectorPageSource {
    private final CloseableIterator<Record> recordIterator;
    private final List<String> columnNames;
    private final List<io.trino.spi.type.Type> columnTypes;
    private final Map<String, Type> icebergTypes;
    private final boolean appendRowNumberColumn;
    private final PageBuilder pageBuilder;
    private final AggregatedMemoryContext memoryUsage;
    private int rowId;
    private long readBytes;
    private long readTimeNanos;

    public IcebergAvroPageSource(InputFile file, long start, long length, Schema fileSchema, Optional<NameMapping> nameMapping, List<String> columnNames, List<io.trino.spi.type.Type> columnTypes, boolean appendRowNumberColumn, AggregatedMemoryContext memoryUsage) {
        this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        this.appendRowNumberColumn = appendRowNumberColumn;
        this.memoryUsage = Objects.requireNonNull(memoryUsage, "memoryUsage is null");
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"names and types must correspond one-to-one-to-one");
        Schema readSchema = fileSchema.select(columnNames);
        Avro.ReadBuilder builder = Avro.read((InputFile)file).project(readSchema).createReaderFunc(schema -> PlannedDataReader.create((Schema)readSchema)).split(start, length);
        nameMapping.ifPresent(arg_0 -> ((Avro.ReadBuilder)builder).withNameMapping(arg_0));
        AvroIterable avroReader = builder.build();
        this.icebergTypes = (Map)readSchema.columns().stream().collect(ImmutableMap.toImmutableMap(Types.NestedField::name, Types.NestedField::type));
        this.pageBuilder = new PageBuilder(appendRowNumberColumn ? ImmutableList.builder().addAll(columnTypes).add((Object)BigintType.BIGINT).build() : columnTypes);
        this.recordIterator = avroReader.iterator();
    }

    public long getCompletedBytes() {
        return this.readBytes;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return !this.recordIterator.hasNext();
    }

    public SourcePage getNextSourcePage() {
        if (!this.recordIterator.hasNext()) {
            return null;
        }
        long start = System.nanoTime();
        this.pageBuilder.reset();
        while (!this.pageBuilder.isFull() && this.recordIterator.hasNext()) {
            this.pageBuilder.declarePosition();
            Record record = (Record)this.recordIterator.next();
            for (int channel = 0; channel < this.columnTypes.size(); ++channel) {
                String name = this.columnNames.get(channel);
                IcebergAvroDataConversion.serializeToTrinoBlock(this.columnTypes.get(channel), this.icebergTypes.get(name), this.pageBuilder.getBlockBuilder(channel), record.getField(name));
            }
            if (this.appendRowNumberColumn) {
                BigintType.BIGINT.writeLong(this.pageBuilder.getBlockBuilder(this.columnTypes.size()), (long)this.rowId);
            }
            ++this.rowId;
        }
        Page page = this.pageBuilder.build();
        this.readBytes += page.getSizeInBytes();
        this.readTimeNanos += System.nanoTime() - start;
        return SourcePage.create((Page)page);
    }

    public long getMemoryUsage() {
        return this.memoryUsage.getBytes();
    }

    public void close() {
        try {
            this.recordIterator.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

