/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Verify;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.json.JsonModule;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.manager.FileSystemModule;
import io.trino.plugin.base.Versions;
import io.trino.plugin.base.jmx.ConnectorObjectNameGeneratorModule;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergConnector;
import io.trino.plugin.iceberg.IcebergModule;
import io.trino.plugin.iceberg.IcebergSecurityModule;
import io.trino.plugin.iceberg.catalog.IcebergCatalogModule;
import io.trino.spi.NodeManager;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.PageSorter;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.weakref.jmx.guice.MBeanModule;

public class IcebergConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "iceberg";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        return IcebergConnectorFactory.createConnector(catalogName, config, context, Modules.EMPTY_MODULE, Optional.empty());
    }

    public static Connector createConnector(String catalogName, Map<String, String> config, ConnectorContext context, Module module, Optional<Module> icebergCatalogModule) {
        ClassLoader classLoader = IcebergConnectorFactory.class.getClassLoader();
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new ConnectorObjectNameGeneratorModule("io.trino.plugin.iceberg", "trino.plugin.iceberg"), new JsonModule(), new IcebergModule(), new IcebergSecurityModule(), icebergCatalogModule.orElse((Module)new IcebergCatalogModule()), new MBeanServerModule(), new IcebergFileSystemModule(catalogName, context), binder -> {
                binder.bind(ClassLoader.class).toInstance((Object)IcebergConnectorFactory.class.getClassLoader());
                binder.bind(OpenTelemetry.class).toInstance((Object)context.getOpenTelemetry());
                binder.bind(Tracer.class).toInstance((Object)context.getTracer());
                binder.bind(NodeVersion.class).toInstance((Object)new NodeVersion(context.getNodeManager().getCurrentNode().getVersion()));
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
                binder.bind(PageIndexerFactory.class).toInstance((Object)context.getPageIndexerFactory());
                binder.bind(CatalogHandle.class).toInstance((Object)context.getCatalogHandle());
                binder.bind(CatalogName.class).toInstance((Object)new CatalogName(catalogName));
                binder.bind(PageSorter.class).toInstance((Object)context.getPageSorter());
            }, module});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            Verify.verify((!injector.getBindings().containsKey(Key.get(HiveConfig.class)) ? 1 : 0) != 0, (String)"HiveConfig should not be bound", (Object[])new Object[0]);
            Connector connector = (Connector)injector.getInstance(IcebergConnector.class);
            return connector;
        }
    }

    private static class IcebergFileSystemModule
    extends AbstractConfigurationAwareModule {
        private final String catalogName;
        private final NodeManager nodeManager;
        private final OpenTelemetry openTelemetry;

        public IcebergFileSystemModule(String catalogName, ConnectorContext context) {
            this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
            this.nodeManager = context.getNodeManager();
            this.openTelemetry = context.getOpenTelemetry();
        }

        protected void setup(Binder binder) {
            boolean metadataCacheEnabled = ((IcebergConfig)this.buildConfigObject(IcebergConfig.class)).isMetadataCacheEnabled();
            this.install((Module)new FileSystemModule(this.catalogName, this.nodeManager, this.openTelemetry, metadataCacheEnabled));
        }
    }
}

