/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.airlift.concurrent.Threads;
import io.trino.plugin.base.ClosingBinder;
import io.trino.plugin.iceberg.ForIcebergMetadata;
import io.trino.plugin.iceberg.ForIcebergPlanning;
import io.trino.plugin.iceberg.ForIcebergSplitManager;
import io.trino.plugin.iceberg.ForIcebergSplitSource;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.spi.catalog.CatalogName;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class IcebergExecutorModule
implements Module {
    public void configure(Binder binder) {
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ExecutorService.class, ForIcebergMetadata.class));
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ListeningExecutorService.class, ForIcebergSplitSource.class));
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ExecutorService.class, ForIcebergSplitManager.class));
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ExecutorService.class, ForIcebergPlanning.class));
    }

    @Singleton
    @Provides
    @ForIcebergMetadata
    public ExecutorService createIcebergMetadataExecutor(CatalogName catalogName) {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("iceberg-metadata-" + String.valueOf(catalogName) + "-%s")));
    }

    @Provides
    @Singleton
    @ForIcebergSplitSource
    public ListeningExecutorService createSplitSourceExecutor(CatalogName catalogName) {
        return MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("iceberg-split-source-" + String.valueOf(catalogName) + "-%s"))));
    }

    @Provides
    @Singleton
    @ForIcebergSplitManager
    public ExecutorService createSplitManagerExecutor(CatalogName catalogName, IcebergConfig config) {
        if (config.getSplitManagerThreads() == 0) {
            return MoreExecutors.newDirectExecutorService();
        }
        return Executors.newFixedThreadPool(config.getSplitManagerThreads(), Threads.daemonThreadsNamed((String)("iceberg-split-manager-" + String.valueOf(catalogName) + "-%s")));
    }

    @Provides
    @Singleton
    @ForIcebergPlanning
    public ExecutorService createPlanningExecutor(CatalogName catalogName, IcebergConfig config) {
        if (config.getPlanningThreads() == 0) {
            return MoreExecutors.newDirectExecutorService();
        }
        return Executors.newFixedThreadPool(config.getPlanningThreads(), Threads.daemonThreadsNamed((String)("iceberg-planning-" + String.valueOf(catalogName) + "-%s")));
    }
}

