/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.orc.OrcDataSink;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcWriterOptions;
import io.trino.orc.OrcWriterStats;
import io.trino.orc.OutputStreamOrcDataSink;
import io.trino.parquet.writer.ParquetWriterOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveCompressionCodecs;
import io.trino.plugin.hive.HiveCompressionOption;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.iceberg.IcebergAvroFileWriter;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergFileWriter;
import io.trino.plugin.iceberg.IcebergOrcFileWriter;
import io.trino.plugin.iceberg.IcebergParquetFileWriter;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.TrinoOrcDataSource;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.plugin.iceberg.fileio.ForwardingOutputFile;
import io.trino.plugin.iceberg.util.OrcTypeConverter;
import io.trino.plugin.iceberg.util.PrimitiveTypeMapBuilder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.TypeManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.Schema;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.types.Types;
import org.apache.parquet.format.CompressionCodec;
import org.weakref.jmx.Managed;

public class IcebergFileWriterFactory {
    private static final Schema POSITION_DELETE_SCHEMA = DeleteSchemaUtil.pathPosSchema();
    private static final MetricsConfig FULL_METRICS_CONFIG = MetricsConfig.fromProperties((Map)ImmutableMap.of((Object)"write.metadata.metrics.default", (Object)"full"));
    private static final Splitter COLUMN_NAMES_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final TypeManager typeManager;
    private final NodeVersion nodeVersion;
    private final FileFormatDataSourceStats readStats;
    private final OrcWriterStats orcWriterStats = new OrcWriterStats();
    private final OrcWriterOptions orcWriterOptions;

    @Inject
    public IcebergFileWriterFactory(TypeManager typeManager, NodeVersion nodeVersion, FileFormatDataSourceStats readStats, OrcWriterConfig orcWriterConfig) {
        Preconditions.checkArgument((!orcWriterConfig.isUseLegacyVersion() ? 1 : 0) != 0, (Object)"the ORC writer shouldn't be configured to use a legacy version");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.readStats = Objects.requireNonNull(readStats, "readStats is null");
        this.orcWriterOptions = orcWriterConfig.toOrcWriterOptions();
    }

    @Managed
    public OrcWriterStats getOrcWriterStats() {
        return this.orcWriterStats;
    }

    public IcebergFileWriter createDataFileWriter(TrinoFileSystem fileSystem, Location outputPath, Schema icebergSchema, ConnectorSession session, IcebergFileFormat fileFormat, MetricsConfig metricsConfig, Map<String, String> storageProperties) {
        return switch (fileFormat) {
            default -> throw new MatchException(null, null);
            case IcebergFileFormat.PARQUET -> this.createParquetWriter(MetricsConfig.getDefault(), fileSystem, outputPath, icebergSchema, session, storageProperties);
            case IcebergFileFormat.ORC -> this.createOrcWriter(metricsConfig, fileSystem, outputPath, icebergSchema, session, storageProperties, IcebergSessionProperties.getOrcStringStatisticsLimit(session));
            case IcebergFileFormat.AVRO -> this.createAvroWriter(fileSystem, outputPath, icebergSchema, session);
        };
    }

    public IcebergFileWriter createPositionDeleteWriter(TrinoFileSystem fileSystem, Location outputPath, ConnectorSession session, IcebergFileFormat fileFormat, Map<String, String> storageProperties) {
        return switch (fileFormat) {
            default -> throw new MatchException(null, null);
            case IcebergFileFormat.PARQUET -> this.createParquetWriter(FULL_METRICS_CONFIG, fileSystem, outputPath, POSITION_DELETE_SCHEMA, session, storageProperties);
            case IcebergFileFormat.ORC -> this.createOrcWriter(FULL_METRICS_CONFIG, fileSystem, outputPath, POSITION_DELETE_SCHEMA, session, storageProperties, DataSize.ofBytes((long)Integer.MAX_VALUE));
            case IcebergFileFormat.AVRO -> this.createAvroWriter(fileSystem, outputPath, POSITION_DELETE_SCHEMA, session);
        };
    }

    private IcebergFileWriter createParquetWriter(MetricsConfig metricsConfig, TrinoFileSystem fileSystem, Location outputPath, Schema icebergSchema, ConnectorSession session, Map<String, String> storageProperties) {
        List fileColumnNames = (List)icebergSchema.columns().stream().map(Types.NestedField::name).collect(ImmutableList.toImmutableList());
        List fileColumnTypes = (List)icebergSchema.columns().stream().map(column -> TypeConverter.toTrinoType(column.type(), this.typeManager)).collect(ImmutableList.toImmutableList());
        try {
            TrinoOutputFile outputFile = fileSystem.newOutputFile(outputPath);
            Closeable rollbackAction = () -> fileSystem.deleteFile(outputPath);
            ParquetWriterOptions parquetWriterOptions = ParquetWriterOptions.builder().setMaxPageSize(IcebergSessionProperties.getParquetWriterPageSize(session)).setMaxPageValueCount(IcebergSessionProperties.getParquetWriterPageValueCount(session)).setMaxBlockSize(IcebergSessionProperties.getParquetWriterBlockSize(session)).setBatchSize(IcebergSessionProperties.getParquetWriterBatchSize(session)).setBloomFilterColumns(IcebergUtil.getParquetBloomFilterColumns(storageProperties)).build();
            HiveCompressionCodec hiveCompressionCodec = HiveCompressionCodecs.toCompressionCodec((HiveCompressionOption)IcebergSessionProperties.getCompressionCodec(session));
            return new IcebergParquetFileWriter(metricsConfig, outputFile, rollbackAction, fileColumnTypes, fileColumnNames, ParquetSchemaUtil.convert((Schema)icebergSchema, (String)"table"), PrimitiveTypeMapBuilder.makeTypeMap(fileColumnTypes, fileColumnNames), parquetWriterOptions, IntStream.range(0, fileColumnNames.size()).toArray(), (CompressionCodec)hiveCompressionCodec.getParquetCompressionCodec().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Compression codec %s not supported for Parquet".formatted(hiveCompressionCodec))), this.nodeVersion.toString());
        }
        catch (IOException | UncheckedIOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_WRITER_OPEN_ERROR, "Error creating Parquet file", (Throwable)e);
        }
    }

    private IcebergFileWriter createOrcWriter(MetricsConfig metricsConfig, TrinoFileSystem fileSystem, Location outputPath, Schema icebergSchema, ConnectorSession session, Map<String, String> storageProperties, DataSize stringStatisticsLimit) {
        try {
            OutputStreamOrcDataSink orcDataSink = OutputStreamOrcDataSink.create((TrinoOutputFile)fileSystem.newOutputFile(outputPath));
            Closeable rollbackAction = () -> fileSystem.deleteFile(outputPath);
            List columnFields = icebergSchema.columns();
            List fileColumnNames = (List)columnFields.stream().map(Types.NestedField::name).collect(ImmutableList.toImmutableList());
            List fileColumnTypes = (List)columnFields.stream().map(Types.NestedField::type).map(type -> TypeConverter.toTrinoType(type, this.typeManager)).collect(ImmutableList.toImmutableList());
            Optional<Supplier<OrcDataSource>> validationInputFactory = Optional.empty();
            if (IcebergSessionProperties.isOrcWriterValidate(session)) {
                validationInputFactory = Optional.of(() -> {
                    try {
                        TrinoInputFile inputFile = fileSystem.newInputFile(outputPath);
                        return new TrinoOrcDataSource(inputFile, new OrcReaderOptions(), this.readStats);
                    }
                    catch (IOException | UncheckedIOException e) {
                        throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_WRITE_VALIDATION_FAILED, (Throwable)e);
                    }
                });
            }
            return new IcebergOrcFileWriter(metricsConfig, icebergSchema, (OrcDataSink)orcDataSink, rollbackAction, fileColumnNames, fileColumnTypes, OrcTypeConverter.toOrcType(icebergSchema), HiveCompressionCodecs.toCompressionCodec((HiveCompressionOption)IcebergSessionProperties.getCompressionCodec(session)).getOrcCompressionKind(), IcebergFileWriterFactory.withBloomFilterOptions(this.orcWriterOptions, storageProperties).withStripeMinSize(IcebergSessionProperties.getOrcWriterMinStripeSize(session)).withStripeMaxSize(IcebergSessionProperties.getOrcWriterMaxStripeSize(session)).withStripeMaxRowCount(IcebergSessionProperties.getOrcWriterMaxStripeRows(session)).withRowGroupMaxRowCount(IcebergSessionProperties.getOrcWriterMaxRowGroupRows(session)).withDictionaryMaxMemory(IcebergSessionProperties.getOrcWriterMaxDictionaryMemory(session)).withMaxStringStatisticsLimit(stringStatisticsLimit), IntStream.range(0, fileColumnNames.size()).toArray(), (Map<String, String>)ImmutableMap.builder().put((Object)"trino_version", (Object)this.nodeVersion.toString()).put((Object)"trino_query_id", (Object)session.getQueryId()).buildOrThrow(), validationInputFactory, IcebergSessionProperties.getOrcWriterValidateMode(session), this.orcWriterStats);
        }
        catch (IOException | UncheckedIOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_WRITER_OPEN_ERROR, "Error creating ORC file", (Throwable)e);
        }
    }

    public static OrcWriterOptions withBloomFilterOptions(OrcWriterOptions orcWriterOptions, Map<String, String> storageProperties) {
        Optional<String> orcBloomFilterColumns = IcebergUtil.getOrcBloomFilterColumns(storageProperties);
        Optional<String> orcBloomFilterFpp = IcebergUtil.getOrcBloomFilterFpp(storageProperties);
        if (orcBloomFilterColumns.isPresent()) {
            try {
                double fpp = orcBloomFilterFpp.map(Double::parseDouble).orElseGet(() -> ((OrcWriterOptions)orcWriterOptions).getBloomFilterFpp());
                return OrcWriterOptions.builderFrom((OrcWriterOptions)orcWriterOptions).setBloomFilterColumns((Set)ImmutableSet.copyOf((Collection)COLUMN_NAMES_SPLITTER.splitToList((CharSequence)orcBloomFilterColumns.get()))).setBloomFilterFpp(fpp).build();
            }
            catch (NumberFormatException e) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Invalid value for %s property: %s", "orc_bloom_filter_fpp", orcBloomFilterFpp.get()));
            }
        }
        return orcWriterOptions;
    }

    private IcebergFileWriter createAvroWriter(TrinoFileSystem fileSystem, Location outputPath, Schema icebergSchema, ConnectorSession session) {
        Closeable rollbackAction = () -> fileSystem.deleteFile(outputPath);
        List columnTypes = (List)icebergSchema.columns().stream().map(column -> TypeConverter.toTrinoType(column.type(), this.typeManager)).collect(ImmutableList.toImmutableList());
        return new IcebergAvroFileWriter(new ForwardingOutputFile(fileSystem, outputPath), rollbackAction, icebergSchema, columnTypes, HiveCompressionCodecs.toCompressionCodec((HiveCompressionOption)IcebergSessionProperties.getCompressionCodec(session)));
    }
}

