/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.Locations;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.metastore.Column;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.HiveType;
import io.trino.metastore.TableInfo;
import io.trino.plugin.base.classloader.ClassLoaderSafeSystemTable;
import io.trino.plugin.base.filter.UtcConstraintExtractor;
import io.trino.plugin.base.projection.ApplyProjectionUtil;
import io.trino.plugin.base.util.ExecutorUtil;
import io.trino.plugin.base.util.Procedures;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.HiveWrittenPartitions;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.util.HiveTypeUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.iceberg.AllManifestsTable;
import io.trino.plugin.iceberg.CollectedStatistics;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.CorruptedIcebergTableHandle;
import io.trino.plugin.iceberg.EntriesTable;
import io.trino.plugin.iceberg.ExpressionConverter;
import io.trino.plugin.iceberg.FilesTable;
import io.trino.plugin.iceberg.HistoryTable;
import io.trino.plugin.iceberg.IcebergAnalyzeProperties;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergFileSystemFactory;
import io.trino.plugin.iceberg.IcebergInputInfo;
import io.trino.plugin.iceberg.IcebergMergeTableHandle;
import io.trino.plugin.iceberg.IcebergMetadataColumn;
import io.trino.plugin.iceberg.IcebergPartitionFunction;
import io.trino.plugin.iceberg.IcebergPartitioningHandle;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergTableName;
import io.trino.plugin.iceberg.IcebergTablePartitioning;
import io.trino.plugin.iceberg.IcebergTableProperties;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.IcebergWritableTableHandle;
import io.trino.plugin.iceberg.ManifestsTable;
import io.trino.plugin.iceberg.MetadataLogEntriesTable;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.PartitionFields;
import io.trino.plugin.iceberg.PartitionsTable;
import io.trino.plugin.iceberg.PropertiesTable;
import io.trino.plugin.iceberg.RefsTable;
import io.trino.plugin.iceberg.SnapshotsTable;
import io.trino.plugin.iceberg.SortFieldUtils;
import io.trino.plugin.iceberg.StructLikeWrapperWithFieldIdToIndex;
import io.trino.plugin.iceberg.TableStatisticsReader;
import io.trino.plugin.iceberg.TableStatisticsWriter;
import io.trino.plugin.iceberg.TableType;
import io.trino.plugin.iceberg.TrinoSortField;
import io.trino.plugin.iceberg.TypeConverter;
import io.trino.plugin.iceberg.UnknownTableTypeException;
import io.trino.plugin.iceberg.aggregation.DataSketchStateSerializer;
import io.trino.plugin.iceberg.catalog.TrinoCatalog;
import io.trino.plugin.iceberg.functions.IcebergFunctionProvider;
import io.trino.plugin.iceberg.procedure.IcebergAddFilesFromTableHandle;
import io.trino.plugin.iceberg.procedure.IcebergAddFilesHandle;
import io.trino.plugin.iceberg.procedure.IcebergDropExtendedStatsHandle;
import io.trino.plugin.iceberg.procedure.IcebergExpireSnapshotsHandle;
import io.trino.plugin.iceberg.procedure.IcebergOptimizeHandle;
import io.trino.plugin.iceberg.procedure.IcebergOptimizeManifestsHandle;
import io.trino.plugin.iceberg.procedure.IcebergRemoveOrphanFilesHandle;
import io.trino.plugin.iceberg.procedure.IcebergRollbackToSnapshotHandle;
import io.trino.plugin.iceberg.procedure.IcebergTableExecuteHandle;
import io.trino.plugin.iceberg.procedure.IcebergTableProcedureId;
import io.trino.plugin.iceberg.procedure.MigrationUtils;
import io.trino.plugin.iceberg.util.DataFileWithDeleteFiles;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.RefreshType;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnPosition;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorAnalyzeMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.DiscretePredicates;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.PointerType;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.RelationType;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.WriterScalingOptions;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.Variable;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.ReachableFileUtil;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.UpdateStatistics;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.LocationUtil;
import org.apache.iceberg.util.SnapshotUtil;

public class IcebergMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(IcebergMetadata.class);
    private static final Pattern PATH_PATTERN = Pattern.compile("(.*)/[^/]+");
    private static final int OPTIMIZE_MAX_SUPPORTED_TABLE_VERSION = 2;
    private static final int CLEANING_UP_PROCEDURES_MAX_SUPPORTED_TABLE_VERSION = 2;
    private static final String RETENTION_THRESHOLD = "retention_threshold";
    private static final String UNKNOWN_SNAPSHOT_TOKEN = "UNKNOWN";
    public static final Set<String> UPDATABLE_TABLE_PROPERTIES = ImmutableSet.builder().add((Object)"extra_properties").add((Object)"format").add((Object)"format_version").add((Object)"max_commit_retry").add((Object)"object_store_layout_enabled").add((Object)"data_location").add((Object)"orc_bloom_filter_columns").add((Object)"parquet_bloom_filter_columns").add((Object)"partitioning").add((Object)"sorted_by").build();
    private static final String SYSTEM_SCHEMA = "system";
    public static final String NUMBER_OF_DISTINCT_VALUES_NAME = "NUMBER_OF_DISTINCT_VALUES";
    private static final FunctionName NUMBER_OF_DISTINCT_VALUES_FUNCTION = new FunctionName("$iceberg_theta_stat");
    private static final Integer DELETE_BATCH_SIZE = 1000;
    public static final int GET_METADATA_BATCH_SIZE = 1000;
    private static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings().withKeyValueSeparator("=");
    private static final String DEPENDS_ON_TABLES = "dependsOnTables";
    private static final String DEPENDS_ON_TABLE_FUNCTIONS = "dependsOnTableFunctions";
    private static final String TRINO_QUERY_START_TIME = "trino-query-start-time";
    private final TypeManager typeManager;
    private final CatalogHandle trinoCatalogHandle;
    private final JsonCodec<CommitTaskData> commitTaskCodec;
    private final TrinoCatalog catalog;
    private final IcebergFileSystemFactory fileSystemFactory;
    private final TableStatisticsWriter tableStatisticsWriter;
    private final Optional<HiveMetastoreFactory> metastoreFactory;
    private final boolean addFilesProcedureEnabled;
    private final Predicate<String> allowedExtraProperties;
    private final ExecutorService icebergScanExecutor;
    private final Executor metadataFetchingExecutor;
    private final ExecutorService icebergPlanningExecutor;
    private final Map<IcebergTableHandle, AtomicReference<TableStatistics>> tableStatisticsCache = new ConcurrentHashMap<IcebergTableHandle, AtomicReference<TableStatistics>>();
    private Transaction transaction;
    private Optional<Long> fromSnapshotForRefresh = Optional.empty();

    public IcebergMetadata(TypeManager typeManager, CatalogHandle trinoCatalogHandle, JsonCodec<CommitTaskData> commitTaskCodec, TrinoCatalog catalog, IcebergFileSystemFactory fileSystemFactory, TableStatisticsWriter tableStatisticsWriter, Optional<HiveMetastoreFactory> metastoreFactory, boolean addFilesProcedureEnabled, Predicate<String> allowedExtraProperties, ExecutorService icebergScanExecutor, Executor metadataFetchingExecutor, ExecutorService icebergPlanningExecutor) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.trinoCatalogHandle = Objects.requireNonNull(trinoCatalogHandle, "trinoCatalogHandle is null");
        this.commitTaskCodec = Objects.requireNonNull(commitTaskCodec, "commitTaskCodec is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.tableStatisticsWriter = Objects.requireNonNull(tableStatisticsWriter, "tableStatisticsWriter is null");
        this.metastoreFactory = Objects.requireNonNull(metastoreFactory, "metastoreFactory is null");
        this.addFilesProcedureEnabled = addFilesProcedureEnabled;
        this.allowedExtraProperties = Objects.requireNonNull(allowedExtraProperties, "allowedExtraProperties is null");
        this.icebergScanExecutor = Objects.requireNonNull(icebergScanExecutor, "icebergScanExecutor is null");
        this.metadataFetchingExecutor = Objects.requireNonNull(metadataFetchingExecutor, "metadataFetchingExecutor is null");
        this.icebergPlanningExecutor = Objects.requireNonNull(icebergPlanningExecutor, "icebergPlanningExecutor is null");
    }

    public Collection<FunctionMetadata> listFunctions(ConnectorSession session, String schemaName) {
        return schemaName.equals(SYSTEM_SCHEMA) ? IcebergFunctionProvider.FUNCTIONS : List.of();
    }

    public Collection<FunctionMetadata> getFunctions(ConnectorSession session, SchemaFunctionName name) {
        if (!name.getSchemaName().equals(SYSTEM_SCHEMA)) {
            return List.of();
        }
        return IcebergFunctionProvider.FUNCTIONS.stream().filter(function -> function.getCanonicalName().equals(name.getFunctionName())).toList();
    }

    public FunctionMetadata getFunctionMetadata(ConnectorSession session, FunctionId functionId) {
        return IcebergFunctionProvider.FUNCTIONS.stream().filter(function -> function.getFunctionId().equals((Object)functionId)).findFirst().orElseThrow();
    }

    public boolean schemaExists(ConnectorSession session, String schemaName) {
        return this.catalog.namespaceExists(session, schemaName);
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.catalog.listNamespaces(session);
    }

    public Map<String, Object> getSchemaProperties(ConnectorSession session, String schemaName) {
        return this.catalog.loadNamespaceMetadata(session, schemaName);
    }

    public Optional<TrinoPrincipal> getSchemaOwner(ConnectorSession session, String schemaName) {
        return this.catalog.getNamespacePrincipal(session, schemaName);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        BaseTable table;
        if (startVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Read table with start version is not supported");
        }
        if (!IcebergTableName.isIcebergTableName(tableName.getTableName())) {
            return null;
        }
        if (IcebergTableName.isMaterializedViewStorage(tableName.getTableName())) {
            Verify.verify((boolean)endVersion.isEmpty(), (String)"Materialized views do not support versioned queries", (Object[])new Object[0]);
            SchemaTableName materializedViewName = new SchemaTableName(tableName.getSchemaName(), IcebergTableName.tableNameFrom(tableName.getTableName()));
            if (this.getMaterializedView(session, materializedViewName).isEmpty()) {
                throw new TableNotFoundException(tableName);
            }
            BaseTable storageTable = this.catalog.getMaterializedViewStorageTable(session, materializedViewName).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, "Storage table metadata not found for materialized view " + String.valueOf(tableName)));
            return this.tableHandleForCurrentSnapshot(session, tableName, storageTable);
        }
        if (!IcebergTableName.isDataTable(tableName.getTableName())) {
            return null;
        }
        try {
            table = this.catalog.loadTable(session, new SchemaTableName(tableName.getSchemaName(), tableName.getTableName()));
        }
        catch (TableNotFoundException e) {
            return null;
        }
        catch (TrinoException e) {
            ErrorCode errorCode = e.getErrorCode();
            if (errorCode.equals((Object)IcebergErrorCode.ICEBERG_MISSING_METADATA.toErrorCode()) || errorCode.equals((Object)IcebergErrorCode.ICEBERG_INVALID_METADATA.toErrorCode())) {
                return new CorruptedIcebergTableHandle(tableName, e);
            }
            throw e;
        }
        if (endVersion.isPresent()) {
            long snapshotId = IcebergMetadata.getSnapshotIdFromVersion(session, (Table)table, endVersion.get());
            return this.tableHandleForSnapshot(session, tableName, table, Optional.of(snapshotId), SnapshotUtil.schemaFor((Table)table, (long)snapshotId), Optional.empty());
        }
        return this.tableHandleForCurrentSnapshot(session, tableName, table);
    }

    private IcebergTableHandle tableHandleForCurrentSnapshot(ConnectorSession session, SchemaTableName tableName, BaseTable table) {
        return this.tableHandleForSnapshot(session, tableName, table, Optional.ofNullable(table.currentSnapshot()).map(Snapshot::snapshotId), table.schema(), Optional.of(table.spec()));
    }

    private IcebergTableHandle tableHandleForSnapshot(ConnectorSession session, SchemaTableName tableName, BaseTable table, Optional<Long> tableSnapshotId, Schema tableSchema, Optional<PartitionSpec> partitionSpec) {
        Map tableProperties = table.properties();
        return new IcebergTableHandle(this.trinoCatalogHandle, tableName.getSchemaName(), tableName.getTableName(), TableType.DATA, tableSnapshotId, SchemaParser.toJson((Schema)tableSchema), partitionSpec.map(PartitionSpecParser::toJson), table.operations().current().formatVersion(), (TupleDomain<IcebergColumnHandle>)TupleDomain.all(), (TupleDomain<IcebergColumnHandle>)TupleDomain.all(), OptionalLong.empty(), (Set<IcebergColumnHandle>)ImmutableSet.of(), Optional.ofNullable((String)tableProperties.get("schema.name-mapping.default")), table.location(), table.properties(), this.getTablePartitioning(session, (Table)table), false, Optional.empty(), (Set<IcebergColumnHandle>)ImmutableSet.of(), Optional.of(false));
    }

    private Optional<IcebergTablePartitioning> getTablePartitioning(ConnectorSession session, Table icebergTable) {
        if (!IcebergSessionProperties.isBucketExecutionEnabled(session) || icebergTable.specs().size() != 1) {
            return Optional.empty();
        }
        PartitionSpec partitionSpec = icebergTable.spec();
        if (partitionSpec.fields().isEmpty()) {
            return Optional.empty();
        }
        Schema schema = icebergTable.schema();
        IcebergPartitioningHandle partitioningHandle = IcebergPartitioningHandle.create(partitionSpec, this.typeManager, List.of());
        Map columnById = (Map)IcebergUtil.getProjectedColumns(schema, this.typeManager).stream().collect(ImmutableMap.toImmutableMap(IcebergColumnHandle::getId, Function.identity()));
        List partitionColumns = (List)partitionSpec.fields().stream().map(PartitionField::sourceId).distinct().sorted().map(columnById::get).collect(ImmutableList.toImmutableList());
        return Optional.of(new IcebergTablePartitioning(false, partitioningHandle, partitionColumns, (List)IntStream.range(0, partitioningHandle.partitionFunctions().size()).boxed().collect(ImmutableList.toImmutableList())));
    }

    private static long getSnapshotIdFromVersion(ConnectorSession session, Table table, ConnectorTableVersion version) {
        io.trino.spi.type.Type versionType = version.getVersionType();
        return switch (version.getPointerType()) {
            default -> throw new MatchException(null, null);
            case PointerType.TEMPORAL -> IcebergMetadata.getTemporalSnapshotIdFromVersion(session, table, version, versionType);
            case PointerType.TARGET_ID -> IcebergMetadata.getTargetSnapshotIdFromVersion(table, version, versionType);
        };
    }

    private static long getTargetSnapshotIdFromVersion(Table table, ConnectorTableVersion version, io.trino.spi.type.Type versionType) {
        long snapshotId;
        if (versionType == BigintType.BIGINT) {
            snapshotId = (Long)version.getVersion();
        } else if (versionType instanceof VarcharType) {
            String refName = ((Slice)version.getVersion()).toStringUtf8();
            SnapshotRef ref = (SnapshotRef)table.refs().get(refName);
            if (ref == null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Cannot find snapshot with reference name: " + refName);
            }
            snapshotId = ref.snapshotId();
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type for table version: " + versionType.getDisplayName());
        }
        if (table.snapshot(snapshotId) == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Iceberg snapshot ID does not exists: " + snapshotId);
        }
        return snapshotId;
    }

    private static long getTemporalSnapshotIdFromVersion(ConnectorSession session, Table table, ConnectorTableVersion version, io.trino.spi.type.Type versionType) {
        if (versionType.equals((Object)DateType.DATE)) {
            long epochMillis = LocalDate.ofEpochDay((Long)version.getVersion()).atStartOfDay().atZone(session.getTimeZoneKey().getZoneId()).toInstant().toEpochMilli();
            return IcebergUtil.getSnapshotIdAsOfTime(table, epochMillis);
        }
        if (versionType instanceof TimestampType) {
            TimestampType timestampVersionType = (TimestampType)versionType;
            long epochMicrosUtc = timestampVersionType.isShort() ? ((Long)version.getVersion()).longValue() : ((LongTimestamp)version.getVersion()).getEpochMicros();
            long epochMillisUtc = Math.floorDiv(epochMicrosUtc, 1000);
            long epochMillis = LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMillisUtc), ZoneOffset.UTC).atZone(session.getTimeZoneKey().getZoneId()).toInstant().toEpochMilli();
            return IcebergUtil.getSnapshotIdAsOfTime(table, epochMillis);
        }
        if (versionType instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timeZonedVersionType = (TimestampWithTimeZoneType)versionType;
            long epochMillis = timeZonedVersionType.isShort() ? DateTimeEncoding.unpackMillisUtc((long)((Long)version.getVersion())) : ((LongTimestampWithTimeZone)version.getVersion()).getEpochMillis();
            return IcebergUtil.getSnapshotIdAsOfTime(table, epochMillis);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type for temporal table version: " + versionType.getDisplayName());
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return this.getRawSystemTable(session, tableName).map(systemTable -> new ClassLoaderSafeSystemTable(systemTable, this.getClass().getClassLoader()));
    }

    private Optional<SystemTable> getRawSystemTable(ConnectorSession session, SchemaTableName tableName) {
        BaseTable table;
        if (!IcebergTableName.isIcebergTableName(tableName.getTableName()) || IcebergTableName.isDataTable(tableName.getTableName()) || IcebergTableName.isMaterializedViewStorage(tableName.getTableName())) {
            return Optional.empty();
        }
        String name = IcebergTableName.tableNameFrom(tableName.getTableName());
        try {
            table = this.catalog.loadTable(session, new SchemaTableName(tableName.getSchemaName(), name));
        }
        catch (TableNotFoundException e) {
            return Optional.empty();
        }
        catch (UnknownTableTypeException e) {
            return Optional.empty();
        }
        TableType tableType = IcebergTableName.tableTypeFrom(tableName.getTableName());
        return switch (tableType) {
            default -> throw new MatchException(null, null);
            case TableType.DATA, TableType.MATERIALIZED_VIEW_STORAGE -> throw new VerifyException("Unexpected table type: " + String.valueOf((Object)tableType));
            case TableType.HISTORY -> Optional.of(new HistoryTable(tableName, (Table)table));
            case TableType.METADATA_LOG_ENTRIES -> Optional.of(new MetadataLogEntriesTable(tableName, (Table)table, this.icebergScanExecutor));
            case TableType.SNAPSHOTS -> Optional.of(new SnapshotsTable(tableName, this.typeManager, (Table)table, this.icebergScanExecutor));
            case TableType.PARTITIONS -> Optional.of(new PartitionsTable(tableName, this.typeManager, (Table)table, this.getCurrentSnapshotId((Table)table), this.icebergScanExecutor));
            case TableType.ALL_MANIFESTS -> Optional.of(new AllManifestsTable(tableName, (Table)table, this.icebergScanExecutor));
            case TableType.MANIFESTS -> Optional.of(new ManifestsTable(tableName, (Table)table, this.getCurrentSnapshotId((Table)table)));
            case TableType.FILES -> Optional.of(new FilesTable(tableName, this.typeManager, (Table)table, this.getCurrentSnapshotId((Table)table), this.icebergScanExecutor));
            case TableType.ALL_ENTRIES -> Optional.of(new EntriesTable(this.typeManager, tableName, (Table)table, MetadataTableType.ALL_ENTRIES, this.icebergScanExecutor));
            case TableType.ENTRIES -> Optional.of(new EntriesTable(this.typeManager, tableName, (Table)table, MetadataTableType.ENTRIES, this.icebergScanExecutor));
            case TableType.PROPERTIES -> Optional.of(new PropertiesTable(tableName, table));
            case TableType.REFS -> Optional.of(new RefsTable(tableName, (Table)table, this.icebergScanExecutor));
        };
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        if (table.getSnapshotId().isEmpty()) {
            return new ConnectorTableProperties(TupleDomain.none(), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
        }
        BaseTable icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Set<Integer> partitionSourceIds = IcebergMetadata.identityPartitionColumnsInAllSpecs((Table)icebergTable);
        TupleDomain<IcebergColumnHandle> enforcedPredicate = table.getEnforcedPredicate();
        DiscretePredicates discretePredicates = null;
        if (!partitionSourceIds.isEmpty()) {
            Map columns = (Map)IcebergUtil.getProjectedColumns(icebergTable.schema(), this.typeManager, partitionSourceIds).stream().collect(ImmutableMap.toImmutableMap(IcebergColumnHandle::getId, Function.identity()));
            com.google.common.base.Supplier lazyUniquePartitions = Suppliers.memoize(() -> this.lambda$getTableProperties$0((Table)icebergTable, table, enforcedPredicate));
            Iterable discreteTupleDomain = Iterables.transform(() -> IcebergMetadata.lambda$getTableProperties$1((Supplier)lazyUniquePartitions), entry -> {
                Map<Integer, Optional<String>> partitionColumnValueStrings = IcebergUtil.getPartitionKeys(((StructLikeWrapperWithFieldIdToIndex)entry.getKey()).getStructLikeWrapper().get(), (PartitionSpec)entry.getValue());
                Map partitionValues = (Map)partitionSourceIds.stream().filter(partitionColumnValueStrings::containsKey).collect(ImmutableMap.toImmutableMap(columns::get, columnId -> {
                    IcebergColumnHandle column = (IcebergColumnHandle)columns.get(columnId);
                    Object prestoValue = IcebergUtil.deserializePartitionValue(column.getType(), ((Optional)partitionColumnValueStrings.get(columnId)).orElse(null), column.getName());
                    return new NullableValue(column.getType(), prestoValue);
                }));
                return TupleDomain.fromFixedValues((Map)partitionValues);
            });
            discretePredicates = new DiscretePredicates((List)columns.values().stream().map(ColumnHandle.class::cast).collect(ImmutableList.toImmutableList()), discreteTupleDomain);
        }
        return new ConnectorTableProperties(enforcedPredicate.transformKeys(ColumnHandle.class::cast), table.getTablePartitioning().flatMap(IcebergTablePartitioning::toConnectorTablePartitioning), Optional.ofNullable(discretePredicates), (List)ImmutableList.of());
    }

    public Optional<ConnectorTableHandle> applyPartitioning(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<ConnectorPartitioningHandle> partitioningHandle, List<ColumnHandle> partitioningColumns) {
        IcebergTableHandle icebergTableHandle = IcebergMetadata.checkValidTableHandle(tableHandle);
        if (icebergTableHandle.getPartitionSpecJson().isEmpty()) {
            return Optional.empty();
        }
        Optional<IcebergTablePartitioning> connectorTablePartitioning = icebergTableHandle.getTablePartitioning();
        if (connectorTablePartitioning.isEmpty()) {
            return Optional.empty();
        }
        IcebergTablePartitioning tablePartitioning = connectorTablePartitioning.get();
        if (!new HashSet<IcebergColumnHandle>(tablePartitioning.partitioningColumns()).containsAll(partitioningColumns)) {
            return Optional.empty();
        }
        Map newPartitioningColumnIndex = (Map)IntStream.range(0, partitioningColumns.size()).boxed().collect(ImmutableMap.toImmutableMap(partitioningColumns::get, Function.identity()));
        ImmutableList.Builder newPartitionFunctions = ImmutableList.builder();
        ImmutableList.Builder newPartitionStructFields = ImmutableList.builder();
        for (int functionIndex = 0; functionIndex < tablePartitioning.partitioningHandle().partitionFunctions().size(); ++functionIndex) {
            IcebergPartitionFunction function = tablePartitioning.partitioningHandle().partitionFunctions().get(functionIndex);
            int oldColumnIndex = function.dataPath().getFirst();
            Integer newColumnIndex = (Integer)newPartitioningColumnIndex.get(tablePartitioning.partitioningColumns().get(oldColumnIndex));
            if (newColumnIndex == null) continue;
            newPartitionFunctions.add((Object)function.withTopLevelColumnIndex(newColumnIndex));
            newPartitionStructFields.add((Object)tablePartitioning.partitionStructFields().get(functionIndex));
        }
        IcebergPartitioningHandle newPartitioningHandle = new IcebergPartitioningHandle(false, (List<IcebergPartitionFunction>)newPartitionFunctions.build());
        if (partitioningHandle.isPresent() && !partitioningHandle.get().equals((Object)newPartitioningHandle)) {
            return Optional.empty();
        }
        if (newPartitioningHandle.partitionFunctions().stream().map(IcebergPartitionFunction::transform).noneMatch(IcebergPartitionFunction.Transform.BUCKET::equals)) {
            return Optional.empty();
        }
        return Optional.of(icebergTableHandle.withTablePartitioning(Optional.of(new IcebergTablePartitioning(true, newPartitioningHandle, (List)partitioningColumns.stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList()), (List<Integer>)newPartitionStructFields.build()))));
    }

    public SchemaTableName getTableName(ConnectorSession session, ConnectorTableHandle table) {
        if (table instanceof CorruptedIcebergTableHandle) {
            CorruptedIcebergTableHandle corruptedTableHandle = (CorruptedIcebergTableHandle)table;
            return corruptedTableHandle.schemaTableName();
        }
        return ((IcebergTableHandle)table).getSchemaTableName();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        IcebergTableHandle tableHandle = IcebergMetadata.checkValidTableHandle(table);
        Preconditions.checkArgument((boolean)tableHandle.getProjectedColumns().isEmpty(), (Object)"Unexpected projected columns");
        BaseTable icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        List<ColumnMetadata> columns = IcebergUtil.getColumnMetadatas(SchemaParser.fromJson((String)tableHandle.getTableSchemaJson()), this.typeManager);
        return new ConnectorTableMetadata(tableHandle.getSchemaTableName(), columns, IcebergUtil.getIcebergTableProperties(icebergTable), IcebergUtil.getTableComment((Table)icebergTable));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.listTables(session, schemaName).stream().map(TableInfo::tableName).toList();
    }

    public Map<SchemaTableName, RelationType> getRelationTypes(ConnectorSession session, Optional<String> schemaName) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (TableInfo info : this.catalog.listTables(session, schemaName)) {
            result.put((Object)info.tableName(), (Object)info.extendedRelationType().toRelationType());
        }
        return result.buildKeepingLast();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = IcebergMetadata.checkValidTableHandle(tableHandle);
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (IcebergColumnHandle columnHandle : IcebergUtil.getTopLevelColumns(SchemaParser.fromJson((String)table.getTableSchemaJson()), this.typeManager)) {
            columnHandles.put((Object)columnHandle.getName(), (Object)columnHandle);
        }
        columnHandles.put((Object)IcebergMetadataColumn.PARTITION.getColumnName(), (Object)IcebergColumnHandle.partitionColumnHandle());
        columnHandles.put((Object)IcebergMetadataColumn.FILE_PATH.getColumnName(), (Object)IcebergColumnHandle.pathColumnHandle());
        columnHandles.put((Object)IcebergMetadataColumn.FILE_MODIFIED_TIME.getColumnName(), (Object)IcebergColumnHandle.fileModifiedTimeColumnHandle());
        return columnHandles.buildOrThrow();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        IcebergColumnHandle column = (IcebergColumnHandle)columnHandle;
        return ColumnMetadata.builder().setName(column.getName()).setType(column.getType()).setNullable(column.isNullable()).setComment(column.getComment()).build();
    }

    public void validateScan(ConnectorSession session, ConnectorTableHandle handle) {
        IcebergTableHandle table = (IcebergTableHandle)handle;
        if (IcebergMetadata.isQueryPartitionFilterRequiredForTable(session, table) && table.getEnforcedPredicate().isAll() && !table.getForAnalyze().orElseThrow().booleanValue()) {
            Schema schema = SchemaParser.fromJson((String)table.getTableSchemaJson());
            Optional<PartitionSpec> partitionSpec = table.getPartitionSpecJson().map(partitionSpecJson -> PartitionSpecParser.fromJson((Schema)schema, (String)partitionSpecJson));
            if (partitionSpec.isEmpty() || partitionSpec.get().isUnpartitioned()) {
                return;
            }
            HashSet columnsWithPredicates = new HashSet();
            table.getConstraintColumns().stream().map(IcebergColumnHandle::getId).forEach(columnsWithPredicates::add);
            table.getUnenforcedPredicate().getDomains().ifPresent(domain -> domain.keySet().stream().map(IcebergColumnHandle::getId).forEach(columnsWithPredicates::add));
            Set partitionColumns = (Set)partitionSpec.get().fields().stream().filter(field -> !field.transform().isVoid()).map(PartitionField::sourceId).collect(ImmutableSet.toImmutableSet());
            if (Collections.disjoint(columnsWithPredicates, partitionColumns)) {
                String partitionColumnNames = partitionSpec.get().fields().stream().filter(field -> !field.transform().isVoid()).map(PartitionField::sourceId).map(id -> (String)schema.idToName().get(id)).collect(Collectors.joining(", "));
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Filter required for %s on at least one of the partition columns: %s", table.getSchemaTableName(), partitionColumnNames));
            }
        }
    }

    private static boolean isQueryPartitionFilterRequiredForTable(ConnectorSession session, IcebergTableHandle table) {
        Set<String> requiredSchemas = IcebergSessionProperties.getQueryPartitionFilterRequiredSchemas(session);
        return IcebergSessionProperties.isQueryPartitionFilterRequired(session) && (requiredSchemas.isEmpty() || requiredSchemas.contains(table.getSchemaName()));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        throw new UnsupportedOperationException("The deprecated listTableColumns is not supported because streamTableColumns is implemented instead");
    }

    public Iterator<TableColumnsMetadata> streamTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Object schemaTableNames = prefix.getTable().isEmpty() ? (List)this.catalog.listTables(session, prefix.getSchema()).stream().map(TableInfo::tableName).collect(ImmutableList.toImmutableList()) : ImmutableList.of((Object)prefix.toSchemaTableName());
        return Lists.partition((List)schemaTableNames, (int)1000).stream().map(tableBatch -> {
            ImmutableList.Builder tableMetadatas = ImmutableList.builderWithExpectedSize((int)tableBatch.size());
            HashSet<SchemaTableName> remainingTables = new HashSet<SchemaTableName>(tableBatch.size());
            for (SchemaTableName tableName2 : tableBatch) {
                if (this.redirectTable(session, tableName2).isPresent()) {
                    tableMetadatas.add((Object)TableColumnsMetadata.forRedirectedTable((SchemaTableName)tableName2));
                    continue;
                }
                remainingTables.add(tableName2);
            }
            Map<SchemaTableName, List<ColumnMetadata>> loaded = this.catalog.tryGetColumnMetadata(session, (List<SchemaTableName>)ImmutableList.copyOf(remainingTables));
            loaded.forEach((tableName, columns) -> {
                remainingTables.remove(tableName);
                tableMetadatas.add((Object)TableColumnsMetadata.forTable((SchemaTableName)tableName, (List)columns));
            });
            List tasks = (List)remainingTables.stream().map(tableName -> () -> {
                try {
                    BaseTable icebergTable = this.catalog.loadTable(session, (SchemaTableName)tableName);
                    List<ColumnMetadata> columns = IcebergUtil.getColumnMetadatas(icebergTable.schema(), this.typeManager);
                    return Optional.of(TableColumnsMetadata.forTable((SchemaTableName)tableName, columns));
                }
                catch (TableNotFoundException e) {
                    return Optional.empty();
                }
                catch (UnknownTableTypeException e) {
                    return Optional.empty();
                }
                catch (RuntimeException e) {
                    log.warn((Throwable)e, "Failed to access metadata of table %s during streaming table columns for %s", new Object[]{tableName, prefix});
                    return Optional.empty();
                }
            }).collect(ImmutableList.toImmutableList());
            try {
                List taskResults = (List)ExecutorUtil.processWithAdditionalThreads((Collection)tasks, (Executor)this.metadataFetchingExecutor).stream().flatMap(Optional::stream).collect(ImmutableList.toImmutableList());
                tableMetadatas.addAll((Iterable)taskResults);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
            return tableMetadatas.build();
        }).flatMap(Collection::stream).iterator();
    }

    public Iterator<RelationColumnsMetadata> streamRelationColumns(ConnectorSession session, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        return this.catalog.streamRelationColumns(session, schemaName, relationFilter, tableName -> this.redirectTable(session, (SchemaTableName)tableName).isPresent()).orElseGet(() -> super.streamRelationColumns(session, schemaName, relationFilter));
    }

    public Iterator<RelationCommentMetadata> streamRelationComments(ConnectorSession session, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        return this.catalog.streamRelationComments(session, schemaName, relationFilter, tableName -> this.redirectTable(session, (SchemaTableName)tableName).isPresent()).orElseGet(() -> super.streamRelationComments(session, schemaName, relationFilter));
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        this.catalog.createNamespace(session, schemaName, properties, owner);
    }

    public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        if (cascade) {
            List<String> nestedNamespaces = this.getChildNamespaces(session, schemaName);
            if (!nestedNamespaces.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CATALOG_ERROR, String.format("Cannot drop non-empty schema: %s, contains %s nested schema(s)", schemaName, Joiner.on((String)", ").join(nestedNamespaces)));
            }
            for (SchemaTableName materializedView : this.listMaterializedViews(session, Optional.of(schemaName))) {
                this.dropMaterializedView(session, materializedView);
            }
            for (SchemaTableName viewName : this.listViews(session, Optional.of(schemaName))) {
                this.dropView(session, viewName);
            }
            for (SchemaTableName tableName : this.listTables(session, Optional.of(schemaName))) {
                this.dropTable(session, this.getTableHandle(session, tableName, Optional.empty(), Optional.empty()));
            }
        }
        this.catalog.dropNamespace(session, schemaName);
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        this.catalog.renameNamespace(session, source, target);
    }

    public void setSchemaAuthorization(ConnectorSession session, String schemaName, TrinoPrincipal principal) {
        this.catalog.setNamespacePrincipal(session, schemaName, principal);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, SaveMode saveMode) {
        Optional<ConnectorTableLayout> layout = this.getNewTableLayout(session, tableMetadata);
        this.finishCreateTable(session, this.beginCreateTable(session, tableMetadata, layout, RetryMode.NO_RETRIES, saveMode == SaveMode.REPLACE), (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        IcebergTableHandle handle = IcebergMetadata.checkValidTableHandle(tableHandle);
        this.catalog.updateTableComment(session, handle.getSchemaTableName(), comment);
    }

    public void setViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        this.catalog.updateViewComment(session, viewName, comment);
    }

    public void setViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        this.catalog.updateViewColumnComment(session, viewName, columnName, comment);
    }

    public void setMaterializedViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        this.catalog.updateMaterializedViewColumnComment(session, viewName, columnName, comment);
    }

    public Optional<ConnectorTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        Schema schema = IcebergUtil.schemaFromMetadata(tableMetadata.getColumns());
        PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, IcebergTableProperties.getPartitioning(tableMetadata.getProperties()));
        return this.getWriteLayout(schema, partitionSpec, false);
    }

    public Optional<io.trino.spi.type.Type> getSupportedType(ConnectorSession session, Map<String, Object> tableProperties, io.trino.spi.type.Type type) {
        io.trino.spi.type.Type newType = this.coerceType(type);
        if (type.getTypeSignature().equals((Object)newType.getTypeSignature())) {
            return Optional.empty();
        }
        return Optional.of(newType);
    }

    private io.trino.spi.type.Type coerceType(io.trino.spi.type.Type type) {
        if (type == TinyintType.TINYINT || type == SmallintType.SMALLINT) {
            return IntegerType.INTEGER;
        }
        if (type instanceof TimestampWithTimeZoneType) {
            return TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS;
        }
        if (type instanceof TimestampType) {
            return TimestampType.TIMESTAMP_MICROS;
        }
        if (type instanceof TimeType) {
            return TimeType.TIME_MICROS;
        }
        if (type instanceof CharType) {
            return VarcharType.VARCHAR;
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return new ArrayType(this.coerceType(arrayType.getElementType()));
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return new MapType(this.coerceType(mapType.getKeyType()), this.coerceType(mapType.getValueType()), this.typeManager.getTypeOperators());
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return RowType.from((List)((List)rowType.getFields().stream().map(field -> new RowType.Field(field.getName(), this.coerceType(field.getType()))).collect(ImmutableList.toImmutableList())));
        }
        return type;
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode, boolean replace) {
        ConnectorTableHandle tableHandle;
        Verify.verify((this.transaction == null ? 1 : 0) != 0, (String)"transaction already set", (Object[])new Object[0]);
        String schemaName = tableMetadata.getTable().getSchemaName();
        if (!this.schemaExists(session, schemaName)) {
            throw new SchemaNotFoundException(schemaName);
        }
        String tableLocation = null;
        if (replace && (tableHandle = this.getTableHandle(session, tableMetadata.getTableSchema().getTable(), Optional.empty(), Optional.empty())) != null) {
            IcebergMetadata.checkValidTableHandle(tableHandle);
            IcebergTableHandle table = (IcebergTableHandle)tableHandle;
            IcebergMetadata.verifyTableVersionForUpdate(table);
            BaseTable icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
            Optional<String> providedTableLocation = IcebergTableProperties.getTableLocation(tableMetadata.getProperties());
            if (providedTableLocation.isPresent() && !LocationUtil.stripTrailingSlash((String)providedTableLocation.get()).equals(icebergTable.location())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("The provided location '%s' does not match the existing table location '%s'", providedTableLocation.get(), icebergTable.location()));
            }
            IcebergMetadata.validateNotModifyingOldSnapshot(table, (Table)icebergTable);
            tableLocation = icebergTable.location();
        }
        if (tableLocation == null) {
            tableLocation = IcebergTableProperties.getTableLocation(tableMetadata.getProperties()).orElseGet(() -> this.catalog.defaultTableLocation(session, tableMetadata.getTable()));
        }
        this.transaction = IcebergUtil.newCreateTableTransaction(this.catalog, tableMetadata, session, replace, tableLocation, this.allowedExtraProperties);
        Location location = Location.of((String)this.transaction.table().location());
        try {
            if (!Locations.isS3Tables((String)location.toString())) {
                TrinoFileSystem fileSystem = this.fileSystemFactory.create(session.getIdentity(), this.transaction.table().io().properties());
                if (!replace && fileSystem.listFiles(location).hasNext()) {
                    throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, String.format("Cannot create a table on a non-empty location: %s, set 'iceberg.unique-table-location=true' in your Iceberg catalog properties to use unique table locations for every table.", location));
                }
            }
            return this.newWritableTableHandle(tableMetadata.getTable(), this.transaction.table(), retryMode);
        }
        catch (IOException | UncheckedIOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed checking new table's location: " + String.valueOf(location), (Throwable)e);
        }
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        IcebergWritableTableHandle icebergTableHandle = (IcebergWritableTableHandle)tableHandle;
        try {
            if (fragments.isEmpty()) {
                AppendFiles appendFiles = this.transaction.newFastAppend();
                IcebergMetadata.commitUpdateAndTransaction(appendFiles, session, this.transaction, "create table");
                this.transaction = null;
                return Optional.empty();
            }
            return this.finishInsert(session, icebergTableHandle, (List<ConnectorTableHandle>)ImmutableList.of(), fragments, computedStatistics);
        }
        catch (AlreadyExistsException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, String.format("Table %s already exists", icebergTableHandle.name()), (Throwable)e);
        }
    }

    public Optional<ConnectorTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Schema schema = SchemaParser.fromJson((String)table.getTableSchemaJson());
        PartitionSpec partitionSpec = PartitionSpecParser.fromJson((Schema)schema, (String)table.getPartitionSpecJson().orElseThrow(() -> new VerifyException("Partition spec missing in the table handle")));
        return this.getWriteLayout(schema, partitionSpec, false);
    }

    private Optional<ConnectorTableLayout> getWriteLayout(Schema tableSchema, PartitionSpec partitionSpec, boolean forceRepartitioning) {
        if (partitionSpec.isUnpartitioned()) {
            return Optional.empty();
        }
        Types.StructType schemaAsStruct = tableSchema.asStruct();
        Map indexById = TypeUtil.indexById((Types.StructType)schemaAsStruct);
        Map indexParents = TypeUtil.indexParents((Types.StructType)schemaAsStruct);
        Map indexPaths = (Map)indexById.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableList.copyOf(IcebergUtil.buildPath(indexParents, (Integer)entry.getKey()))));
        List partitioningColumns = (List)partitionSpec.fields().stream().sorted(Comparator.comparing(PartitionField::sourceId)).map(field -> {
            boolean isBaseColumn = !indexParents.containsKey(field.sourceId());
            int sourceId = isBaseColumn ? field.sourceId() : IcebergMetadata.getRootFieldId(indexParents, field.sourceId());
            Type sourceType = tableSchema.findType(sourceId);
            if (sourceType.isMapType()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Partitioning field [" + field.name() + "] cannot be contained in a map");
            }
            if (sourceType.isListType()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Partitioning field [" + field.name() + "] cannot be contained in a array");
            }
            Verify.verify((boolean)indexById.containsKey(sourceId), (String)("Cannot find source column for partition field " + String.valueOf(field)), (Object[])new Object[0]);
            return IcebergUtil.createColumnHandle(this.typeManager, sourceId, indexById, indexPaths);
        }).distinct().collect(ImmutableList.toImmutableList());
        List partitioningColumnNames = (List)partitioningColumns.stream().map(column -> column.getName().toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
        if (!forceRepartitioning && partitionSpec.fields().stream().allMatch(field -> field.transform().isIdentity())) {
            return Optional.of(new ConnectorTableLayout(partitioningColumnNames));
        }
        IcebergPartitioningHandle partitioningHandle = IcebergPartitioningHandle.create(partitionSpec, this.typeManager, List.of());
        return Optional.of(new ConnectorTableLayout((ConnectorPartitioningHandle)partitioningHandle, partitioningColumnNames, true));
    }

    private static int getRootFieldId(Map<Integer, Integer> indexParents, int fieldId) {
        int rootFieldId = fieldId;
        while (indexParents.containsKey(rootFieldId)) {
            rootFieldId = indexParents.get(rootFieldId);
        }
        return rootFieldId;
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        BaseTable icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        IcebergMetadata.validateNotModifyingOldSnapshot(table, (Table)icebergTable);
        this.beginTransaction((Table)icebergTable);
        return this.newWritableTableHandle(table.getSchemaTableName(), (Table)icebergTable, retryMode);
    }

    private List<String> getChildNamespaces(ConnectorSession session, String parentNamespace) {
        Optional<String> namespaceSeparator = this.catalog.getNamespaceSeparator();
        if (namespaceSeparator.isEmpty()) {
            return ImmutableList.of();
        }
        return (List)this.catalog.listNamespaces(session).stream().filter(namespace -> namespace.startsWith(parentNamespace + (String)namespaceSeparator.get())).collect(ImmutableList.toImmutableList());
    }

    private IcebergWritableTableHandle newWritableTableHandle(SchemaTableName name, Table table, RetryMode retryMode) {
        return new IcebergWritableTableHandle(name, SchemaParser.toJson((Schema)table.schema()), Maps.transformValues((Map)table.specs(), PartitionSpecParser::toJson), table.spec().specId(), IcebergMetadata.getSupportedSortFields(table.schema(), table.sortOrder()), IcebergUtil.getProjectedColumns(table.schema(), this.typeManager), table.location(), IcebergUtil.getFileFormat(table), table.properties(), retryMode, table.io().properties());
    }

    private static List<TrinoSortField> getSupportedSortFields(Schema schema, SortOrder sortOrder) {
        if (!sortOrder.isSorted()) {
            return ImmutableList.of();
        }
        Set baseColumnFieldIds = (Set)schema.columns().stream().map(Types.NestedField::fieldId).collect(ImmutableSet.toImmutableSet());
        ImmutableList.Builder sortFields = ImmutableList.builder();
        for (SortField sortField : sortOrder.fields()) {
            if (!sortField.transform().isIdentity() || !baseColumnFieldIds.contains(sortField.sourceId())) continue;
            sortFields.add((Object)TrinoSortField.fromIceberg(sortField));
        }
        return sortFields.build();
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        List commitTasks = (List)fragments.stream().map(Slice::getInput).map(arg_0 -> this.commitTaskCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        if (commitTasks.isEmpty()) {
            this.transaction = null;
            return Optional.empty();
        }
        IcebergWritableTableHandle table = (IcebergWritableTableHandle)insertHandle;
        Table icebergTable = this.transaction.table();
        Optional<Long> beforeWriteSnapshotId = Optional.ofNullable(icebergTable.currentSnapshot()).map(Snapshot::snapshotId);
        Schema schema = icebergTable.schema();
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(schema.findType(field.sourceId()))).toArray(Type[]::new);
        AppendFiles appendFiles = IcebergSessionProperties.isMergeManifestsOnWrite(session) ? this.transaction.newAppend() : this.transaction.newFastAppend();
        ImmutableSet.Builder writtenFiles = ImmutableSet.builder();
        for (CommitTaskData task : commitTasks) {
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(task.path()).withFileSizeInBytes(task.fileSizeInBytes()).withFormat(table.fileFormat().toIceberg()).withMetrics(task.metrics().metrics());
            task.fileSplitOffsets().ifPresent(arg_0 -> ((DataFiles.Builder)builder).withSplitOffsets(arg_0));
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.partitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            appendFiles.appendFile(builder.build());
            writtenFiles.add((Object)task.path());
        }
        if (table.retryMode() != RetryMode.NO_RETRIES) {
            this.cleanExtraOutputFiles(session, (Set<String>)writtenFiles.build());
        }
        IcebergMetadata.commitUpdateAndTransaction(appendFiles, session, this.transaction, "insert");
        long newSnapshotId = this.transaction.table().currentSnapshot().snapshotId();
        this.transaction = null;
        beforeWriteSnapshotId.ifPresent(previous -> Verify.verify((previous != newSnapshotId ? 1 : 0) != 0, (String)"Failed to get new snapshot ID", (Object[])new Object[0]));
        if (Locations.isS3Tables((String)icebergTable.location())) {
            log.debug("S3 Tables does not support statistics: %s", new Object[]{table.name()});
        } else if (!computedStatistics.isEmpty()) {
            try {
                this.beginTransaction((Table)this.catalog.loadTable(session, table.name()));
                Table reloadedTable = this.transaction.table();
                CollectedStatistics collectedStatistics = IcebergMetadata.processComputedTableStatistics(reloadedTable, computedStatistics);
                StatisticsFile statisticsFile = this.tableStatisticsWriter.writeStatisticsFile(session, reloadedTable, newSnapshotId, TableStatisticsWriter.StatsUpdateMode.INCREMENTAL_UPDATE, collectedStatistics);
                this.transaction.updateStatistics().setStatistics(statisticsFile).commit();
                IcebergMetadata.commitTransaction(this.transaction, "update statistics on insert");
            }
            catch (Exception e) {
                log.error((Throwable)e, "Failed to save table statistics");
            }
            this.transaction = null;
        }
        return Optional.of(new HiveWrittenPartitions((List)commitTasks.stream().map(CommitTaskData::path).collect(ImmutableList.toImmutableList())));
    }

    private void cleanExtraOutputFiles(ConnectorSession session, Set<String> writtenFiles) {
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session.getIdentity(), this.transaction.table().io().properties());
        Set<String> locations = IcebergMetadata.getOutputFilesLocations(writtenFiles);
        Set<String> fileNames = IcebergMetadata.getOutputFilesFileNames(writtenFiles);
        for (String location : locations) {
            IcebergMetadata.cleanExtraOutputFiles(fileSystem, session.getQueryId(), Location.of((String)location), fileNames);
        }
    }

    private static void cleanExtraOutputFiles(TrinoFileSystem fileSystem, String queryId, Location location, Set<String> fileNamesToKeep) {
        Preconditions.checkArgument((!queryId.contains("-") ? 1 : 0) != 0, (String)"query ID should not contain hyphens: %s", (Object)queryId);
        ArrayDeque<String> filesToDelete = new ArrayDeque<String>();
        try {
            ImmutableList deletedFiles;
            log.debug("Deleting failed attempt files from %s for query %s", new Object[]{location, queryId});
            FileIterator iterator = fileSystem.listFiles(location);
            while (iterator.hasNext()) {
                FileEntry entry = iterator.next();
                String name = entry.location().fileName();
                if (!name.startsWith(queryId + "-") || fileNamesToKeep.contains(name)) continue;
                filesToDelete.add(name);
            }
            if (filesToDelete.isEmpty()) {
                return;
            }
            log.info("Found %s files to delete and %s to retain in location %s for query %s", new Object[]{filesToDelete.size(), fileNamesToKeep.size(), location, queryId});
            ImmutableList.Builder deletedFilesBuilder = ImmutableList.builder();
            ArrayList<Location> deleteBatch = new ArrayList<Location>();
            for (String fileName : filesToDelete) {
                deletedFilesBuilder.add((Object)fileName);
                deleteBatch.add(location.appendPath(fileName));
                if (deleteBatch.size() < DELETE_BATCH_SIZE) continue;
                log.debug("Deleting failed attempt files %s for query %s", new Object[]{deleteBatch, queryId});
                fileSystem.deleteFiles(deleteBatch);
                deleteBatch.clear();
            }
            if (!deleteBatch.isEmpty()) {
                log.debug("Deleting failed attempt files %s for query %s", new Object[]{deleteBatch, queryId});
                fileSystem.deleteFiles(deleteBatch);
            }
            if (!(deletedFiles = deletedFilesBuilder.build()).isEmpty()) {
                log.info("Deleted failed attempt files %s from %s for query %s", new Object[]{deletedFiles, location, queryId});
            }
        }
        catch (IOException | UncheckedIOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, String.format("Could not clean up extraneous output files; remaining files: %s", filesToDelete), (Throwable)e);
        }
    }

    private static Set<String> getOutputFilesLocations(Set<String> writtenFiles) {
        return (Set)writtenFiles.stream().map(IcebergMetadata::getLocation).collect(ImmutableSet.toImmutableSet());
    }

    private static Set<String> getOutputFilesFileNames(Set<String> writtenFiles) {
        return (Set)writtenFiles.stream().map(IcebergUtil::fileName).collect(ImmutableSet.toImmutableSet());
    }

    private static String getLocation(String path) {
        Matcher matcher = PATH_PATTERN.matcher(path);
        Verify.verify((boolean)matcher.matches(), (String)"path %s does not match pattern", (Object)path);
        return matcher.group(1);
    }

    public Optional<ConnectorTableExecuteHandle> getTableHandleForExecute(ConnectorSession session, ConnectorAccessControl accessControl, ConnectorTableHandle connectorTableHandle, String procedureName, Map<String, Object> executeProperties, RetryMode retryMode) {
        IcebergTableProcedureId procedureId;
        IcebergTableHandle tableHandle = (IcebergTableHandle)connectorTableHandle;
        Preconditions.checkArgument((tableHandle.getTableType() == TableType.DATA ? 1 : 0) != 0, (String)"Cannot execute table procedure %s on non-DATA table: %s", (Object)procedureName, (Object)((Object)tableHandle.getTableType()));
        BaseTable icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        if (tableHandle.getSnapshotId().isPresent() && tableHandle.getSnapshotId().get().longValue() != icebergTable.currentSnapshot().snapshotId()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot execute table procedure %s on old snapshot %s".formatted(procedureName, tableHandle.getSnapshotId().get()));
        }
        try {
            procedureId = IcebergTableProcedureId.valueOf(procedureName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown procedure '" + procedureName + "'");
        }
        return switch (procedureId) {
            default -> throw new MatchException(null, null);
            case IcebergTableProcedureId.OPTIMIZE -> this.getTableHandleForOptimize(tableHandle, (Table)icebergTable, executeProperties, retryMode);
            case IcebergTableProcedureId.OPTIMIZE_MANIFESTS -> this.getTableHandleForOptimizeManifests(session, tableHandle);
            case IcebergTableProcedureId.DROP_EXTENDED_STATS -> this.getTableHandleForDropExtendedStats(session, tableHandle);
            case IcebergTableProcedureId.ROLLBACK_TO_SNAPSHOT -> this.getTableHandleForRollbackToSnapshot(session, tableHandle, executeProperties);
            case IcebergTableProcedureId.EXPIRE_SNAPSHOTS -> this.getTableHandleForExpireSnapshots(session, tableHandle, executeProperties);
            case IcebergTableProcedureId.REMOVE_ORPHAN_FILES -> this.getTableHandleForRemoveOrphanFiles(session, tableHandle, executeProperties);
            case IcebergTableProcedureId.ADD_FILES -> this.getTableHandleForAddFiles(session, accessControl, tableHandle, executeProperties);
            case IcebergTableProcedureId.ADD_FILES_FROM_TABLE -> this.getTableHandleForAddFilesFromTable(session, accessControl, tableHandle, executeProperties);
        };
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForOptimize(IcebergTableHandle tableHandle, Table icebergTable, Map<String, Object> executeProperties, RetryMode retryMode) {
        DataSize maxScannedFileSize = (DataSize)executeProperties.get("file_size_threshold");
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.OPTIMIZE, new IcebergOptimizeHandle(tableHandle.getSnapshotId(), tableHandle.getTableSchemaJson(), tableHandle.getPartitionSpecJson().orElseThrow(() -> new VerifyException("Partition spec missing in the table handle")), IcebergUtil.getProjectedColumns(SchemaParser.fromJson((String)tableHandle.getTableSchemaJson()), this.typeManager), (List)icebergTable.sortOrder().fields().stream().map(TrinoSortField::fromIceberg).collect(ImmutableList.toImmutableList()), IcebergUtil.getFileFormat(tableHandle.getStorageProperties()), tableHandle.getStorageProperties(), maxScannedFileSize, retryMode != RetryMode.NO_RETRIES), tableHandle.getTableLocation(), icebergTable.io().properties()));
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForOptimizeManifests(ConnectorSession session, IcebergTableHandle tableHandle) {
        BaseTable icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.OPTIMIZE_MANIFESTS, new IcebergOptimizeManifestsHandle(), icebergTable.location(), icebergTable.io().properties()));
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForDropExtendedStats(ConnectorSession session, IcebergTableHandle tableHandle) {
        BaseTable icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.DROP_EXTENDED_STATS, new IcebergDropExtendedStatsHandle(), icebergTable.location(), icebergTable.io().properties()));
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForExpireSnapshots(ConnectorSession session, IcebergTableHandle tableHandle, Map<String, Object> executeProperties) {
        Duration retentionThreshold = (Duration)executeProperties.get(RETENTION_THRESHOLD);
        BaseTable icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.EXPIRE_SNAPSHOTS, new IcebergExpireSnapshotsHandle(retentionThreshold), icebergTable.location(), icebergTable.io().properties()));
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForRemoveOrphanFiles(ConnectorSession session, IcebergTableHandle tableHandle, Map<String, Object> executeProperties) {
        Duration retentionThreshold = (Duration)executeProperties.get(RETENTION_THRESHOLD);
        BaseTable icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.REMOVE_ORPHAN_FILES, new IcebergRemoveOrphanFilesHandle(retentionThreshold), icebergTable.location(), icebergTable.io().properties()));
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForAddFiles(ConnectorSession session, ConnectorAccessControl accessControl, IcebergTableHandle tableHandle, Map<String, Object> executeProperties) {
        if (!this.addFilesProcedureEnabled) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "add_files procedure is disabled");
        }
        accessControl.checkCanInsertIntoTable(null, tableHandle.getSchemaTableName());
        String location = (String)IcebergMetadata.requireProcedureArgument(executeProperties, "location");
        HiveStorageFormat format = (HiveStorageFormat)IcebergMetadata.requireProcedureArgument(executeProperties, "format");
        MigrationUtils.RecursiveDirectory recursiveDirectory = (MigrationUtils.RecursiveDirectory)((Object)executeProperties.getOrDefault("recursive_directory", "fail"));
        BaseTable icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.ADD_FILES, new IcebergAddFilesHandle(location, format, recursiveDirectory), icebergTable.location(), icebergTable.io().properties()));
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForAddFilesFromTable(ConnectorSession session, ConnectorAccessControl accessControl, IcebergTableHandle tableHandle, Map<String, Object> executeProperties) {
        accessControl.checkCanInsertIntoTable(null, tableHandle.getSchemaTableName());
        String schemaName = (String)IcebergMetadata.requireProcedureArgument(executeProperties, "schema_name");
        String tableName = (String)IcebergMetadata.requireProcedureArgument(executeProperties, "table_name");
        Map partitionFilter = (Map)executeProperties.get("partition_filter");
        MigrationUtils.RecursiveDirectory recursiveDirectory = (MigrationUtils.RecursiveDirectory)((Object)executeProperties.getOrDefault("recursive_directory", "fail"));
        HiveMetastore metastore = this.metastoreFactory.orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This catalog does not support add_files_from_table procedure")).createMetastore(Optional.of(session.getIdentity()));
        SchemaTableName sourceName = new SchemaTableName(schemaName, tableName);
        io.trino.metastore.Table sourceTable = (io.trino.metastore.Table)metastore.getTable(schemaName, tableName).orElseThrow(() -> new TableNotFoundException(sourceName));
        accessControl.checkCanSelectFromColumns(null, sourceName, (Set)Stream.concat(sourceTable.getDataColumns().stream(), sourceTable.getPartitionColumns().stream()).map(Column::getName).collect(ImmutableSet.toImmutableSet()));
        BaseTable icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        Procedures.checkProcedureArgument((icebergTable.schemas().size() >= sourceTable.getDataColumns().size() ? 1 : 0) != 0, (String)"Target table should have at least %d columns but got %d", (Object[])new Object[]{sourceTable.getDataColumns().size(), icebergTable.schemas().size()});
        Procedures.checkProcedureArgument((icebergTable.spec().fields().size() == sourceTable.getPartitionColumns().size() ? 1 : 0) != 0, (String)"Numbers of partition columns should be equivalent. target: %d, source: %d", (Object[])new Object[]{icebergTable.spec().fields().size(), sourceTable.getPartitionColumns().size()});
        Procedures.checkProcedureArgument((sourceTable.getPartitionColumns().isEmpty() || partitionFilter != null ? 1 : 0) != 0, (String)"partition_filter argument must be provided for partitioned tables", (Object[])new Object[0]);
        String transactionalProperty = (String)sourceTable.getParameters().get("transactional");
        if (Boolean.parseBoolean(transactionalProperty)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Adding files from transactional tables is unsupported");
        }
        if (!"MANAGED_TABLE".equalsIgnoreCase(sourceTable.getTableType()) && !"EXTERNAL_TABLE".equalsIgnoreCase(sourceTable.getTableType())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The procedure doesn't support adding files from %s table type".formatted(sourceTable.getTableType()));
        }
        if (ViewReaderUtil.isSomeKindOfAView((io.trino.metastore.Table)sourceTable) || HiveUtil.isIcebergTable((io.trino.metastore.Table)sourceTable) || HiveUtil.isDeltaLakeTable((io.trino.metastore.Table)sourceTable) || HiveUtil.isHudiTable((io.trino.metastore.Table)sourceTable)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Adding files from non-Hive tables is unsupported");
        }
        if (sourceTable.getPartitionColumns().isEmpty() && partitionFilter != null && !partitionFilter.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Partition filter is not supported for non-partitioned tables");
        }
        HashSet missingDataColumns = new HashSet();
        Stream.of(sourceTable.getDataColumns(), sourceTable.getPartitionColumns()).flatMap(Collection::stream).forEach(arg_0 -> this.lambda$getTableHandleForAddFilesFromTable$2((Table)icebergTable, sourceTable, missingDataColumns, arg_0));
        if (missingDataColumns.size() == sourceTable.getDataColumns().size()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, "All columns in the source table do not exist in the target table");
        }
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.ADD_FILES_FROM_TABLE, new IcebergAddFilesFromTableHandle(sourceTable, partitionFilter, recursiveDirectory), icebergTable.location(), icebergTable.io().properties()));
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForRollbackToSnapshot(ConnectorSession session, IcebergTableHandle tableHandle, Map<String, Object> executeProperties) {
        long snapshotId = (Long)executeProperties.get("snapshot_id");
        BaseTable icebergTable = this.catalog.loadTable(session, tableHandle.getSchemaTableName());
        return Optional.of(new IcebergTableExecuteHandle(tableHandle.getSchemaTableName(), IcebergTableProcedureId.ROLLBACK_TO_SNAPSHOT, new IcebergRollbackToSnapshotHandle(snapshotId), icebergTable.location(), icebergTable.io().properties()));
    }

    private static Object requireProcedureArgument(Map<String, Object> properties, String name) {
        Object value = properties.get(name);
        Procedures.checkProcedureArgument((value != null ? 1 : 0) != 0, (String)"Required procedure argument '%s' is missing", (Object[])new Object[]{name});
        return value;
    }

    public Optional<ConnectorTableLayout> getLayoutForTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.procedureId()) {
            case OPTIMIZE: {
                return this.getLayoutForOptimize(session, executeHandle);
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + String.valueOf((Object)executeHandle.procedureId()) + "'");
    }

    private Optional<ConnectorTableLayout> getLayoutForOptimize(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        BaseTable icebergTable = this.catalog.loadTable(session, executeHandle.schemaTableName());
        return this.getWriteLayout(icebergTable.schema(), icebergTable.spec(), true);
    }

    public BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorTableHandle updatedSourceTableHandle) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        IcebergTableHandle table = (IcebergTableHandle)updatedSourceTableHandle;
        switch (executeHandle.procedureId()) {
            case OPTIMIZE: {
                return this.beginOptimize(session, executeHandle, table);
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + String.valueOf((Object)executeHandle.procedureId()) + "'");
    }

    private BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginOptimize(ConnectorSession session, IcebergTableExecuteHandle executeHandle, IcebergTableHandle table) {
        IcebergOptimizeHandle optimizeHandle = (IcebergOptimizeHandle)executeHandle.procedureHandle();
        BaseTable icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        IcebergMetadata.validateNotModifyingOldSnapshot(table, (Table)icebergTable);
        int tableFormatVersion = icebergTable.operations().current().formatVersion();
        if (tableFormatVersion > 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("%s is not supported for Iceberg table format version > %d. Table %s format version is %s.", IcebergTableProcedureId.OPTIMIZE.name(), 2, table.getSchemaTableName(), tableFormatVersion));
        }
        this.beginTransaction((Table)icebergTable);
        return new BeginTableExecuteResult((Object)executeHandle, (Object)table.forOptimize(true, optimizeHandle.maxScannedFileSize()));
    }

    public void finishTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.procedureId()) {
            case OPTIMIZE: {
                this.finishOptimize(session, executeHandle, fragments, splitSourceInfo);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + String.valueOf((Object)executeHandle.procedureId()) + "'");
    }

    private void finishOptimize(ConnectorSession session, IcebergTableExecuteHandle executeHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        IcebergOptimizeHandle optimizeHandle = (IcebergOptimizeHandle)executeHandle.procedureHandle();
        Table icebergTable = this.transaction.table();
        Optional<Long> beforeWriteSnapshotId = this.getCurrentSnapshotId(icebergTable);
        ImmutableSet.Builder scannedDataFilesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder scannedDeleteFilesBuilder = ImmutableSet.builder();
        splitSourceInfo.stream().map(DataFileWithDeleteFiles.class::cast).forEach(dataFileWithDeleteFiles -> {
            scannedDataFilesBuilder.add((Object)dataFileWithDeleteFiles.dataFile());
            scannedDeleteFilesBuilder.addAll(dataFileWithDeleteFiles.deleteFiles());
        });
        ImmutableSet scannedDataFiles = scannedDataFilesBuilder.build();
        ImmutableSet fullyAppliedDeleteFiles = scannedDeleteFilesBuilder.build();
        List commitTasks = (List)fragments.stream().map(Slice::getInput).map(arg_0 -> this.commitTaskCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        HashSet<DataFile> newFiles = new HashSet<DataFile>();
        for (CommitTaskData task : commitTasks) {
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(task.path()).withFileSizeInBytes(task.fileSizeInBytes()).withFormat(optimizeHandle.fileFormat().toIceberg()).withMetrics(task.metrics().metrics());
            task.fileSplitOffsets().ifPresent(arg_0 -> ((DataFiles.Builder)builder).withSplitOffsets(arg_0));
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.partitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            newFiles.add(builder.build());
        }
        if (optimizeHandle.snapshotId().isEmpty() || scannedDataFiles.isEmpty() && fullyAppliedDeleteFiles.isEmpty() && newFiles.isEmpty()) {
            this.transaction = null;
            return;
        }
        if (optimizeHandle.retriesEnabled()) {
            this.cleanExtraOutputFiles(session, (Set)newFiles.stream().map(ContentFile::location).collect(ImmutableSet.toImmutableSet()));
        }
        RewriteFiles rewriteFiles = this.transaction.newRewrite();
        scannedDataFiles.forEach(arg_0 -> ((RewriteFiles)rewriteFiles).deleteFile(arg_0));
        fullyAppliedDeleteFiles.forEach(arg_0 -> ((RewriteFiles)rewriteFiles).deleteFile(arg_0));
        newFiles.forEach(arg_0 -> ((RewriteFiles)rewriteFiles).addFile(arg_0));
        Snapshot snapshot = Objects.requireNonNull(icebergTable.snapshot(optimizeHandle.snapshotId().get().longValue()), "snapshot is null");
        rewriteFiles.dataSequenceNumber(snapshot.sequenceNumber());
        rewriteFiles.validateFromSnapshot(snapshot.snapshotId());
        IcebergMetadata.commitUpdateAndTransaction(rewriteFiles, session, this.transaction, "optimize");
        long newSnapshotId = this.transaction.table().currentSnapshot().snapshotId();
        this.transaction = null;
        beforeWriteSnapshotId.ifPresent(previous -> Verify.verify((previous != newSnapshotId ? 1 : 0) != 0, (String)"Failed to get new snapshot ID", (Object[])new Object[0]));
        try {
            this.beginTransaction((Table)this.catalog.loadTable(session, executeHandle.schemaTableName()));
            Table reloadedTable = this.transaction.table();
            StatisticsFile newStatsFile = this.tableStatisticsWriter.rewriteStatisticsFile(session, reloadedTable, newSnapshotId);
            this.transaction.updateStatistics().setStatistics(newStatsFile).commit();
            IcebergMetadata.commitTransaction(this.transaction, "update statistics after optimize");
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to save table statistics");
        }
        this.transaction = null;
    }

    private static void commitUpdateAndTransaction(SnapshotUpdate<?> update, ConnectorSession session, Transaction transaction, String operation) {
        IcebergMetadata.commitUpdate(update, session, operation);
        IcebergMetadata.commitTransaction(transaction, operation);
    }

    private static void commitUpdate(SnapshotUpdate<?> update, ConnectorSession session, String operation) {
        try {
            IcebergUtil.commit(update, session);
        }
        catch (UncheckedIOException | CommitFailedException | CommitStateUnknownException | ValidationException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, String.format("Failed to commit during %s: %s", operation, MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), e);
        }
    }

    private static void commitTransaction(Transaction transaction, String operation) {
        try {
            transaction.commitTransaction();
        }
        catch (UncheckedIOException | CommitFailedException | CommitStateUnknownException | ValidationException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, String.format("Failed to commit the transaction during %s: %s", operation, MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), e);
        }
    }

    public void executeTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle) {
        IcebergTableExecuteHandle executeHandle = (IcebergTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.procedureId()) {
            case OPTIMIZE_MANIFESTS: {
                this.executeOptimizeManifests(session, executeHandle);
                return;
            }
            case DROP_EXTENDED_STATS: {
                this.executeDropExtendedStats(session, executeHandle);
                return;
            }
            case ROLLBACK_TO_SNAPSHOT: {
                this.executeRollbackToSnapshot(session, executeHandle);
                return;
            }
            case EXPIRE_SNAPSHOTS: {
                this.executeExpireSnapshots(session, executeHandle);
                return;
            }
            case REMOVE_ORPHAN_FILES: {
                this.executeRemoveOrphanFiles(session, executeHandle);
                return;
            }
            case ADD_FILES: {
                this.executeAddFiles(session, executeHandle);
                return;
            }
            case ADD_FILES_FROM_TABLE: {
                this.executeAddFilesFromTable(session, executeHandle);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + String.valueOf((Object)executeHandle.procedureId()) + "'");
    }

    private void executeOptimizeManifests(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        Preconditions.checkArgument((boolean)(executeHandle.procedureHandle() instanceof IcebergOptimizeManifestsHandle), (String)"Unexpected procedure handle %s", (Object)executeHandle.procedureHandle());
        BaseTable icebergTable = this.catalog.loadTable(session, executeHandle.schemaTableName());
        List<ManifestFile> manifests = IcebergMetadata.loadAllManifestsFromSnapshot((Table)icebergTable, icebergTable.currentSnapshot());
        if (manifests.isEmpty()) {
            return;
        }
        if (manifests.size() == 1 && manifests.getFirst().length() < icebergTable.operations().current().propertyAsLong("commit.manifest.target-size-bytes", 0x800000L)) {
            return;
        }
        this.beginTransaction((Table)icebergTable);
        RewriteManifests rewriteManifests = this.transaction.rewriteManifests();
        rewriteManifests.clusterBy(file -> {
            StructLike partition = file.partition();
            return partition.size() > 1 ? partition.get(0, Object.class) : partition;
        }).commit();
        IcebergMetadata.commitTransaction(this.transaction, "optimize manifests");
        this.transaction = null;
    }

    private void executeDropExtendedStats(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        Preconditions.checkArgument((boolean)(executeHandle.procedureHandle() instanceof IcebergDropExtendedStatsHandle), (String)"Unexpected procedure handle %s", (Object)executeHandle.procedureHandle());
        BaseTable icebergTable = this.catalog.loadTable(session, executeHandle.schemaTableName());
        this.beginTransaction((Table)icebergTable);
        UpdateStatistics updateStatistics = this.transaction.updateStatistics();
        for (StatisticsFile statisticsFile : icebergTable.statisticsFiles()) {
            updateStatistics.removeStatistics(statisticsFile.snapshotId());
        }
        updateStatistics.commit();
        IcebergMetadata.commitTransaction(this.transaction, "drop extended stats");
        this.transaction = null;
    }

    private void executeRollbackToSnapshot(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        Preconditions.checkArgument((boolean)(executeHandle.procedureHandle() instanceof IcebergRollbackToSnapshotHandle), (String)"Unexpected procedure handle %s", (Object)executeHandle.procedureHandle());
        long snapshotId = ((IcebergRollbackToSnapshotHandle)executeHandle.procedureHandle()).snapshotId();
        BaseTable icebergTable = this.catalog.loadTable(session, executeHandle.schemaTableName());
        icebergTable.manageSnapshots().setCurrentSnapshot(snapshotId).commit();
    }

    private void executeExpireSnapshots(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        IcebergExpireSnapshotsHandle expireSnapshotsHandle = (IcebergExpireSnapshotsHandle)executeHandle.procedureHandle();
        BaseTable table = this.catalog.loadTable(session, executeHandle.schemaTableName());
        Duration retention = Objects.requireNonNull(expireSnapshotsHandle.retentionThreshold(), "retention is null");
        IcebergMetadata.validateTableExecuteParameters(table, executeHandle.schemaTableName(), IcebergTableProcedureId.EXPIRE_SNAPSHOTS.name(), retention, IcebergSessionProperties.getExpireSnapshotMinRetention(session), "iceberg.expire-snapshots.min-retention", "expire_snapshots_min_retention");
        long expireTimestampMillis = session.getStart().toEpochMilli() - retention.toMillis();
        this.executeExpireSnapshots((Table)table, session, expireTimestampMillis);
    }

    private static void validateTableExecuteParameters(BaseTable table, SchemaTableName schemaTableName, String procedureName, Duration retentionThreshold, Duration minRetention, String minRetentionParameterName, String sessionMinRetentionParameterName) {
        int tableFormatVersion = table.operations().current().formatVersion();
        if (tableFormatVersion > 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("%s is not supported for Iceberg table format version > %d. Table %s format version is %s.", procedureName, 2, schemaTableName, tableFormatVersion));
        }
        Map properties = table.properties();
        if (properties.containsKey("write.location-provider.impl")) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table " + String.valueOf(schemaTableName) + " specifies " + (String)properties.get("write.location-provider.impl") + " as a location provider. Writing to Iceberg tables with custom location provider is not supported.");
        }
        Duration retention = Objects.requireNonNull(retentionThreshold, "retention is null");
        Procedures.checkProcedureArgument((retention.compareTo(minRetention) >= 0 ? 1 : 0) != 0, (String)"Retention specified (%s) is shorter than the minimum retention configured in the system (%s). Minimum retention can be changed with %s configuration property or iceberg.%s session property", (Object[])new Object[]{retention, minRetention, minRetentionParameterName, sessionMinRetentionParameterName});
    }

    public void executeRemoveOrphanFiles(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        IcebergRemoveOrphanFilesHandle removeOrphanFilesHandle = (IcebergRemoveOrphanFilesHandle)executeHandle.procedureHandle();
        BaseTable table = this.catalog.loadTable(session, executeHandle.schemaTableName());
        Duration retention = Objects.requireNonNull(removeOrphanFilesHandle.retentionThreshold(), "retention is null");
        IcebergMetadata.validateTableExecuteParameters(table, executeHandle.schemaTableName(), IcebergTableProcedureId.REMOVE_ORPHAN_FILES.name(), retention, IcebergSessionProperties.getRemoveOrphanFilesMinRetention(session), "iceberg.remove-orphan-files.min-retention", "remove_orphan_files_min_retention");
        if (table.currentSnapshot() == null) {
            log.debug("Skipping remove_orphan_files procedure for empty table %s", new Object[]{table});
            return;
        }
        Instant expiration = session.getStart().minusMillis(retention.toMillis());
        this.removeOrphanFiles((Table)table, session, executeHandle.schemaTableName(), expiration, executeHandle.fileIoProperties());
    }

    private void removeOrphanFiles(Table table, ConnectorSession session, SchemaTableName schemaTableName, Instant expiration, Map<String, String> fileIoProperties) {
        HashSet<String> processedManifestFilePaths = new HashSet<String>();
        ImmutableSet.Builder validMetadataFileNames = ImmutableSet.builder();
        ImmutableSet.Builder validDataFileNames = ImmutableSet.builder();
        for (Snapshot snapshot : table.snapshots()) {
            if (snapshot.manifestListLocation() != null) {
                validMetadataFileNames.add((Object)IcebergUtil.fileName(snapshot.manifestListLocation()));
            }
            for (ManifestFile manifest : IcebergMetadata.loadAllManifestsFromSnapshot(table, snapshot)) {
                if (!processedManifestFilePaths.add(manifest.path())) continue;
                validMetadataFileNames.add((Object)IcebergUtil.fileName(manifest.path()));
                try {
                    ManifestReader<? extends ContentFile<?>> manifestReader = IcebergMetadata.readerForManifest(table, manifest);
                    try {
                        for (ContentFile contentFile : manifestReader) {
                            validDataFileNames.add((Object)IcebergUtil.fileName(contentFile.location()));
                        }
                    }
                    finally {
                        if (manifestReader == null) continue;
                        manifestReader.close();
                    }
                }
                catch (IOException | UncheckedIOException e) {
                    throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Unable to list manifest file content from " + manifest.path(), (Throwable)e);
                }
                catch (NotFoundException e) {
                    throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, "Manifest file does not exist: " + manifest.path());
                }
            }
        }
        ReachableFileUtil.metadataFileLocations((Table)table, (boolean)false).stream().map(IcebergUtil::fileName).forEach(arg_0 -> ((ImmutableSet.Builder)validMetadataFileNames).add(arg_0));
        ReachableFileUtil.statisticsFilesLocations((Table)table).stream().map(IcebergUtil::fileName).forEach(arg_0 -> ((ImmutableSet.Builder)validMetadataFileNames).add(arg_0));
        validMetadataFileNames.add((Object)"version-hint.text");
        this.scanAndDeleteInvalidFiles(table, session, schemaTableName, expiration, (Set<String>)validDataFileNames.build(), "data", fileIoProperties);
        this.scanAndDeleteInvalidFiles(table, session, schemaTableName, expiration, (Set<String>)validMetadataFileNames.build(), "metadata", fileIoProperties);
    }

    public void executeAddFiles(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        IcebergAddFilesHandle addFilesHandle = (IcebergAddFilesHandle)executeHandle.procedureHandle();
        BaseTable table = this.catalog.loadTable(session, executeHandle.schemaTableName());
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session.getIdentity(), table.io().properties());
        MigrationUtils.addFiles(session, fileSystem, this.catalog, executeHandle.schemaTableName(), addFilesHandle.location(), addFilesHandle.format(), addFilesHandle.recursiveDirectory());
    }

    public void executeAddFilesFromTable(ConnectorSession session, IcebergTableExecuteHandle executeHandle) {
        IcebergAddFilesFromTableHandle addFilesHandle = (IcebergAddFilesFromTableHandle)executeHandle.procedureHandle();
        BaseTable table = this.catalog.loadTable(session, executeHandle.schemaTableName());
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session.getIdentity(), table.io().properties());
        MigrationUtils.addFilesFromTable(session, fileSystem, this.metastoreFactory.orElseThrow(), (Table)table, addFilesHandle.table(), addFilesHandle.partitionFilter(), addFilesHandle.recursiveDirectory());
    }

    private static ManifestReader<? extends ContentFile<?>> readerForManifest(Table table, ManifestFile manifest) {
        return switch (manifest.content()) {
            default -> throw new MatchException(null, null);
            case ManifestContent.DATA -> ManifestFiles.read((ManifestFile)manifest, (FileIO)table.io());
            case ManifestContent.DELETES -> ManifestFiles.readDeleteManifest((ManifestFile)manifest, (FileIO)table.io(), (Map)table.specs());
        };
    }

    private void scanAndDeleteInvalidFiles(Table table, ConnectorSession session, SchemaTableName schemaTableName, Instant expiration, Set<String> validFiles, String subfolder, Map<String, String> fileIoProperties) {
        try {
            ArrayList<Location> filesToDelete = new ArrayList<Location>();
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session.getIdentity(), fileIoProperties);
            FileIterator allFiles = fileSystem.listFiles(Location.of((String)table.location()).appendPath(subfolder));
            while (allFiles.hasNext()) {
                FileEntry entry = allFiles.next();
                if (entry.lastModified().isBefore(expiration) && !validFiles.contains(entry.location().fileName())) {
                    filesToDelete.add(entry.location());
                    if (filesToDelete.size() < DELETE_BATCH_SIZE) continue;
                    log.debug("Deleting files while removing orphan files for table %s [%s]", new Object[]{schemaTableName, filesToDelete});
                    fileSystem.deleteFiles(filesToDelete);
                    filesToDelete.clear();
                    continue;
                }
                log.debug("%s file retained while removing orphan files %s", new Object[]{entry.location(), schemaTableName.getTableName()});
            }
            if (!filesToDelete.isEmpty()) {
                log.debug("Deleting files while removing orphan files for table %s %s", new Object[]{schemaTableName, filesToDelete});
                fileSystem.deleteFiles(filesToDelete);
            }
        }
        catch (IOException | UncheckedIOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed accessing data for table: " + String.valueOf(schemaTableName), (Throwable)e);
        }
    }

    public FunctionDependencyDeclaration getFunctionDependencies(ConnectorSession session, FunctionId functionId, BoundSignature boundSignature) {
        return FunctionDependencyDeclaration.NO_DEPENDENCIES;
    }

    public Optional<Object> getInfo(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)tableHandle;
        List partitionFields = (List)icebergTableHandle.getPartitionSpecJson().map(partitionSpecJson -> (ImmutableList)PartitionSpecParser.fromJson((Schema)SchemaParser.fromJson((String)icebergTableHandle.getTableSchemaJson()), (String)partitionSpecJson).fields().stream().map(field -> field.name() + ": " + String.valueOf(field.transform())).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
        Object summary = ImmutableMap.of();
        if (icebergTableHandle.getSnapshotId().isPresent()) {
            BaseTable table = this.catalog.loadTable(session, icebergTableHandle.getSchemaTableName());
            summary = table.snapshot(icebergTableHandle.getSnapshotId().get().longValue()).summary();
        }
        Optional<String> totalRecords = Optional.ofNullable((String)summary.get("total-records"));
        Optional<String> deletedRecords = Optional.ofNullable((String)summary.get("deleted-records"));
        Optional<String> totalDataFiles = Optional.ofNullable((String)summary.get("total-data-files"));
        Optional<String> totalDeleteFiles = Optional.ofNullable((String)summary.get("total-delete-files"));
        return Optional.of(new IcebergInputInfo(icebergTableHandle.getSnapshotId(), partitionFields, IcebergUtil.getFileFormat(icebergTableHandle.getStorageProperties()).name(), totalRecords, deletedRecords, totalDataFiles, totalDeleteFiles));
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        if (tableHandle instanceof CorruptedIcebergTableHandle) {
            CorruptedIcebergTableHandle corruptedTableHandle = (CorruptedIcebergTableHandle)tableHandle;
            this.catalog.dropCorruptedTable(session, corruptedTableHandle.schemaTableName());
        } else {
            this.catalog.dropTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        }
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTable) {
        IcebergTableHandle handle = IcebergMetadata.checkValidTableHandle(tableHandle);
        this.catalog.renameTable(session, handle.getSchemaTableName(), newTable);
    }

    public void setTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Optional<Object>> properties) {
        IcebergTableHandle table = IcebergMetadata.checkValidTableHandle(tableHandle);
        BaseTable icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Sets.SetView unsupportedProperties = Sets.difference(properties.keySet(), UPDATABLE_TABLE_PROPERTIES);
        if (!unsupportedProperties.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The following properties cannot be updated: " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)unsupportedProperties));
        }
        this.beginTransaction((Table)icebergTable);
        UpdateProperties updateProperties = this.transaction.updateProperties();
        if (properties.containsKey("extra_properties")) {
            Map extraProperties = (Map)properties.get("extra_properties").orElseThrow(() -> new IllegalArgumentException("The extra_properties property cannot be empty"));
            IcebergUtil.verifyExtraProperties(properties.keySet(), extraProperties, this.allowedExtraProperties);
            extraProperties.forEach((arg_0, arg_1) -> ((UpdateProperties)updateProperties).set(arg_0, arg_1));
        }
        if (properties.containsKey("parquet_bloom_filter_columns")) {
            IcebergUtil.checkFormatForProperty(IcebergUtil.getFileFormat((Table)icebergTable).toIceberg(), FileFormat.PARQUET, "parquet_bloom_filter_columns");
            List parquetBloomFilterColumns = (List)properties.get("parquet_bloom_filter_columns").orElseThrow(() -> new IllegalArgumentException("The parquet_bloom_filter_columns property cannot be empty"));
            IcebergUtil.validateParquetBloomFilterColumns(IcebergUtil.getColumnMetadatas(SchemaParser.fromJson((String)table.getTableSchemaJson()), this.typeManager), parquetBloomFilterColumns);
            Set existingParquetBloomFilterColumns = (Set)icebergTable.properties().keySet().stream().filter(key -> key.startsWith("write.parquet.bloom-filter-enabled.column.")).map(key -> key.substring("write.parquet.bloom-filter-enabled.column.".length())).collect(ImmutableSet.toImmutableSet());
            Sets.SetView removeParquetBloomFilterColumns = Sets.difference((Set)existingParquetBloomFilterColumns, Set.copyOf(parquetBloomFilterColumns));
            removeParquetBloomFilterColumns.forEach(column -> updateProperties.remove("write.parquet.bloom-filter-enabled.column." + column));
            parquetBloomFilterColumns.forEach(column -> updateProperties.set("write.parquet.bloom-filter-enabled.column." + column, "true"));
        }
        if (properties.containsKey("orc_bloom_filter_columns")) {
            IcebergUtil.checkFormatForProperty(IcebergUtil.getFileFormat((Table)icebergTable).toIceberg(), FileFormat.ORC, "orc_bloom_filter_columns");
            List orcBloomFilterColumns = (List)properties.get("orc_bloom_filter_columns").orElseThrow(() -> new IllegalArgumentException("The orc_bloom_filter_columns property cannot be empty"));
            if (orcBloomFilterColumns.isEmpty()) {
                updateProperties.remove("write.orc.bloom.filter.columns");
            } else {
                IcebergUtil.validateOrcBloomFilterColumns(IcebergUtil.getColumnMetadatas(SchemaParser.fromJson((String)table.getTableSchemaJson()), this.typeManager), orcBloomFilterColumns);
                updateProperties.set("write.orc.bloom.filter.columns", Joiner.on((String)",").join((Iterable)orcBloomFilterColumns));
            }
        }
        if (properties.containsKey("format")) {
            IcebergFileFormat fileFormat = (IcebergFileFormat)((Object)properties.get("format").orElseThrow(() -> new IllegalArgumentException("The format property cannot be empty")));
            updateProperties.defaultFormat(fileFormat.toIceberg());
        }
        if (properties.containsKey("format_version")) {
            int formatVersion = (Integer)properties.get("format_version").orElseThrow(() -> new IllegalArgumentException("The format_version property cannot be empty"));
            updateProperties.set("format-version", Integer.toString(formatVersion));
        }
        if (properties.containsKey("max_commit_retry")) {
            int formatVersion = (Integer)properties.get("max_commit_retry").orElseThrow(() -> new IllegalArgumentException("The max_commit_retry property cannot be empty"));
            updateProperties.set("commit.retry.num-retries", Integer.toString(formatVersion));
        }
        if (properties.containsKey("object_store_layout_enabled")) {
            boolean objectStoreEnabled = (Boolean)properties.get("object_store_layout_enabled").orElseThrow(() -> new IllegalArgumentException("The object_store_enabled property cannot be empty"));
            updateProperties.set("write.object-storage.enabled", Boolean.toString(objectStoreEnabled));
        }
        if (properties.containsKey("data_location")) {
            String dataLocation = (String)properties.get("data_location").orElseThrow(() -> new IllegalArgumentException("The data_location property cannot be empty"));
            boolean objectStoreEnabled = properties.getOrDefault("object_store_layout_enabled", Optional.of(Boolean.parseBoolean((String)icebergTable.properties().get("write.object-storage.enabled")))).orElseThrow();
            if (!objectStoreEnabled) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Data location can only be set when object store layout is enabled");
            }
            updateProperties.set("write.data.path", dataLocation);
        }
        try {
            updateProperties.commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to set new property values", (Throwable)e);
        }
        if (properties.containsKey("partitioning")) {
            List partitionColumns = (List)properties.get("partitioning").orElseThrow(() -> new IllegalArgumentException("The partitioning property cannot be empty"));
            IcebergMetadata.updatePartitioning((Table)icebergTable, this.transaction, partitionColumns);
        }
        if (properties.containsKey("sorted_by")) {
            List sortColumns = (List)properties.get("sorted_by").orElseThrow(() -> new IllegalArgumentException("The sorted_by property cannot be empty"));
            ReplaceSortOrder replaceSortOrder = this.transaction.replaceSortOrder();
            SortFieldUtils.parseSortFields(replaceSortOrder, (List<String>)sortColumns);
            try {
                replaceSortOrder.commit();
            }
            catch (RuntimeException e) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to set the sorted_by property", (Throwable)e);
            }
        }
        IcebergMetadata.commitTransaction(this.transaction, "set table properties");
    }

    private static void updatePartitioning(Table icebergTable, Transaction transaction, List<String> partitionColumns) {
        UpdatePartitionSpec updatePartitionSpec = transaction.updateSpec();
        ImmutableSet existingPartitionFields = ImmutableSet.copyOf((Collection)icebergTable.spec().fields());
        Schema schema = icebergTable.schema();
        if (partitionColumns.isEmpty()) {
            existingPartitionFields.stream().map(partitionField -> IcebergMetadata.toIcebergTerm(schema, partitionField)).forEach(arg_0 -> ((UpdatePartitionSpec)updatePartitionSpec).removeField(arg_0));
        } else {
            PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, partitionColumns);
            ImmutableSet partitionFields = ImmutableSet.copyOf((Collection)partitionSpec.fields());
            Sets.difference((Set)existingPartitionFields, (Set)partitionFields).stream().map(PartitionField::name).forEach(arg_0 -> ((UpdatePartitionSpec)updatePartitionSpec).removeField(arg_0));
            Sets.difference((Set)partitionFields, (Set)existingPartitionFields).forEach(partitionField -> updatePartitionSpec.addField(partitionField.name(), IcebergMetadata.toIcebergTerm(schema, partitionField)));
        }
        try {
            updatePartitionSpec.commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to set new partitioning value", (Throwable)e);
        }
    }

    private static Term toIcebergTerm(Schema schema, PartitionField partitionField) {
        return Expressions.transform((String)schema.findColumnName(partitionField.sourceId()), (Transform)partitionField.transform());
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column, ColumnPosition position) {
        if (!column.isNullable()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding not null columns");
        }
        BaseTable icebergTable = this.catalog.loadTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        AtomicInteger nextFieldId = new AtomicInteger(icebergTable.schema().highestFieldId() + 2);
        try {
            UpdateSchema updateSchema = icebergTable.updateSchema();
            updateSchema.addColumn(null, column.getName(), TypeConverter.toIcebergTypeForNewColumn(column.getType(), nextFieldId), column.getComment());
            ColumnPosition columnPosition = position;
            Objects.requireNonNull(columnPosition);
            ColumnPosition columnPosition2 = columnPosition;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ColumnPosition.First.class, ColumnPosition.After.class, ColumnPosition.Last.class}, (ColumnPosition)columnPosition2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    updateSchema.moveFirst(column.getName());
                    break;
                }
                case 1: {
                    ColumnPosition.After after = (ColumnPosition.After)columnPosition2;
                    updateSchema.moveAfter(column.getName(), after.columnName());
                }
                case 2: 
            }
            updateSchema.commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to add column: " + String.valueOf(MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), (Throwable)e);
        }
    }

    public void addField(ConnectorSession session, ConnectorTableHandle tableHandle, List<String> parentPath, String fieldName, io.trino.spi.type.Type type, boolean ignoreExisting) {
        String parentName = String.join((CharSequence)".", parentPath);
        BaseTable icebergTable = this.catalog.loadTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        Types.NestedField parent = icebergTable.schema().caseInsensitiveFindField(parentName);
        String caseSensitiveParentName = icebergTable.schema().findColumnName(parent.fieldId());
        Types.StructType structType = parent.type().isListType() ? parent.type().asListType().elementType().asStructType() : parent.type().asStructType();
        Types.NestedField field = structType.caseInsensitiveField(fieldName);
        if (field != null) {
            if (ignoreExisting) {
                return;
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_ALREADY_EXISTS, "Field '%s' already exists".formatted(fieldName));
        }
        try {
            icebergTable.updateSchema().addColumn(caseSensitiveParentName, fieldName, TypeConverter.toIcebergTypeForNewColumn(type, new AtomicInteger())).commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to add field: " + String.valueOf(MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), (Throwable)e);
        }
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        IcebergColumnHandle handle = (IcebergColumnHandle)column;
        this.dropField(session, tableHandle, handle.getName());
    }

    public void dropField(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, List<String> fieldPath) {
        IcebergColumnHandle handle = (IcebergColumnHandle)column;
        String name = String.join((CharSequence)".", (Iterable<? extends CharSequence>)ImmutableList.builder().add((Object)handle.getName()).addAll(fieldPath).build());
        this.dropField(session, tableHandle, name);
    }

    private void dropField(ConnectorSession session, ConnectorTableHandle tableHandle, String name) {
        BaseTable icebergTable = this.catalog.loadTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        long fieldId = icebergTable.schema().findField(name).fieldId();
        boolean isPartitionColumn = icebergTable.spec().fields().stream().anyMatch(field -> (long)field.sourceId() == fieldId);
        if (isPartitionColumn) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop partition field: " + name);
        }
        int currentSpecId = icebergTable.spec().specId();
        boolean columnUsedInOlderPartitionSpecs = icebergTable.specs().entrySet().stream().filter(spec -> ((PartitionSpec)spec.getValue()).specId() != currentSpecId).flatMap(spec -> ((PartitionSpec)spec.getValue()).fields().stream()).anyMatch(field -> (long)field.sourceId() == fieldId);
        if (columnUsedInOlderPartitionSpecs) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop column which is used by an old partition spec: " + name);
        }
        try {
            icebergTable.updateSchema().deleteColumn(name).commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to drop column: " + String.valueOf(MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), (Throwable)e);
        }
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        IcebergColumnHandle columnHandle = (IcebergColumnHandle)source;
        BaseTable icebergTable = this.catalog.loadTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        try {
            icebergTable.updateSchema().renameColumn(columnHandle.getName(), target).commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to rename column: " + String.valueOf(MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), (Throwable)e);
        }
    }

    public void renameField(ConnectorSession session, ConnectorTableHandle tableHandle, List<String> fieldPath, String target) {
        BaseTable icebergTable = this.catalog.loadTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        String parentPath = String.join((CharSequence)".", fieldPath.subList(0, fieldPath.size() - 1));
        Types.NestedField parent = icebergTable.schema().caseInsensitiveFindField(parentPath);
        String caseSensitiveParentName = icebergTable.schema().findColumnName(parent.fieldId());
        Types.NestedField source = parent.type().asStructType().caseInsensitiveField((String)Iterables.getLast(fieldPath));
        String sourcePath = caseSensitiveParentName + "." + source.name();
        try {
            icebergTable.updateSchema().renameColumn(sourcePath, target).commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to rename field: " + String.valueOf(MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), (Throwable)e);
        }
    }

    public void setColumnType(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle, io.trino.spi.type.Type type) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        IcebergColumnHandle column = (IcebergColumnHandle)columnHandle;
        Verify.verify((boolean)column.isBaseColumn(), (String)"Cannot change nested field types", (Object[])new Object[0]);
        BaseTable icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Type sourceType = icebergTable.schema().findType(column.getName());
        AtomicInteger nextFieldId = new AtomicInteger(1);
        Type newType = TypeConverter.toIcebergTypeForNewColumn(type, nextFieldId);
        try {
            UpdateSchema schemaUpdate = icebergTable.updateSchema();
            IcebergMetadata.buildUpdateSchema(column.getName(), sourceType, newType, schemaUpdate);
            schemaUpdate.commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to set column type: " + String.valueOf(MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), (Throwable)e);
        }
    }

    private static void buildUpdateSchema(String name, Type sourceType, Type newType, UpdateSchema schemaUpdate) {
        if (sourceType.equals((Object)newType)) {
            return;
        }
        if (sourceType.isPrimitiveType() && newType.isPrimitiveType()) {
            schemaUpdate.updateColumn(name, newType.asPrimitiveType());
            return;
        }
        if (sourceType instanceof Types.StructType) {
            Types.StructType sourceRowType = (Types.StructType)sourceType;
            if (newType instanceof Types.StructType) {
                Types.StructType newRowType = (Types.StructType)newType;
                List fields = (List)Streams.concat((Stream[])new Stream[]{sourceRowType.fields().stream(), newRowType.fields().stream()}).distinct().collect(ImmutableList.toImmutableList());
                for (Types.NestedField field : fields) {
                    if (IcebergMetadata.fieldExists(sourceRowType, field.name()) && IcebergMetadata.fieldExists(newRowType, field.name())) {
                        IcebergMetadata.buildUpdateSchema(name + "." + field.name(), sourceRowType.fieldType(field.name()), newRowType.fieldType(field.name()), schemaUpdate);
                        continue;
                    }
                    if (IcebergMetadata.fieldExists(newRowType, field.name())) {
                        schemaUpdate.addColumn(name, field.name(), field.type());
                        continue;
                    }
                    schemaUpdate.deleteColumn(name + "." + field.name());
                }
                String currentName = null;
                for (Types.NestedField field : newRowType.fields()) {
                    String path = name + "." + field.name();
                    if (currentName == null) {
                        schemaUpdate.moveFirst(path);
                    } else {
                        schemaUpdate.moveAfter(path, currentName);
                    }
                    currentName = path;
                }
                return;
            }
        }
        throw new IllegalArgumentException("Cannot change type from %s to %s".formatted(sourceType, newType));
    }

    private static boolean fieldExists(Types.StructType structType, String fieldName) {
        for (Types.NestedField field : structType.fields()) {
            if (!field.name().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public void setFieldType(ConnectorSession session, ConnectorTableHandle tableHandle, List<String> fieldPath, io.trino.spi.type.Type type) {
        Types.StructType structType;
        BaseTable icebergTable = this.catalog.loadTable(session, ((IcebergTableHandle)tableHandle).getSchemaTableName());
        String parentPath = String.join((CharSequence)".", fieldPath.subList(0, fieldPath.size() - 1));
        Types.NestedField parent = icebergTable.schema().caseInsensitiveFindField(parentPath);
        Object caseSensitiveParentName = icebergTable.schema().findColumnName(parent.fieldId());
        if (parent.type().isListType()) {
            structType = parent.type().asListType().elementType().asStructType();
            caseSensitiveParentName = (String)caseSensitiveParentName + ".element";
        } else {
            structType = parent.type().asStructType();
        }
        Types.NestedField field = structType.caseInsensitiveField((String)Iterables.getLast(fieldPath));
        if (!field.type().isPrimitiveType()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Iceberg doesn't support changing field type from non-primitive types");
        }
        String name = (String)caseSensitiveParentName + "." + field.name();
        Type icebergType = TypeConverter.toIcebergTypeForNewColumn(type, new AtomicInteger());
        if (!icebergType.isPrimitiveType()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Iceberg doesn't support changing field type to non-primitive types");
        }
        try {
            icebergTable.updateSchema().updateColumn(name, icebergType.asPrimitiveType()).commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to set field type: " + String.valueOf(MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), (Throwable)e);
        }
    }

    public void dropNotNullConstraint(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        IcebergColumnHandle column = (IcebergColumnHandle)columnHandle;
        BaseTable icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Verify.verify((boolean)column.isBaseColumn(), (String)"Cannot drop a not null constraint on nested fields", (Object[])new Object[0]);
        try {
            icebergTable.updateSchema().makeColumnOptional(column.getName()).commit();
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_COMMIT_ERROR, "Failed to drop a not null constraint: " + String.valueOf(MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), (Throwable)e);
        }
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        long snapshotId;
        if (!IcebergSessionProperties.isExtendedStatisticsEnabled(session) || !IcebergSessionProperties.isCollectExtendedStatisticsOnWrite(session)) {
            return TableStatisticsMetadata.empty();
        }
        ConnectorTableHandle tableHandle = this.getTableHandle(session, tableMetadata.getTable(), Optional.empty(), Optional.empty());
        if (tableHandle == null) {
            return this.getStatisticsCollectionMetadata(tableMetadata, Optional.empty(), (Set<String> availableColumnNames) -> {});
        }
        IcebergTableHandle table = IcebergMetadata.checkValidTableHandle(tableHandle);
        if (table.getSnapshotId().isEmpty()) {
            return this.getStatisticsCollectionMetadata(tableMetadata, Optional.empty(), (Set<String> availableColumnNames) -> {});
        }
        BaseTable icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Snapshot snapshot = icebergTable.snapshot(snapshotId = table.getSnapshotId().orElseThrow().longValue());
        String totalRecords = (String)snapshot.summary().get("total-records");
        if (totalRecords != null && Long.parseLong(totalRecords) == 0L) {
            return this.getStatisticsCollectionMetadata(tableMetadata, Optional.empty(), (Set<String> availableColumnNames) -> {});
        }
        Schema schema = SchemaParser.fromJson((String)table.getTableSchemaJson());
        List<IcebergColumnHandle> columns = IcebergUtil.getTopLevelColumns(schema, this.typeManager);
        Set columnIds = (Set)columns.stream().map(IcebergColumnHandle::getId).collect(ImmutableSet.toImmutableSet());
        Map<Integer, Long> ndvs = TableStatisticsReader.readNdvs((Table)icebergTable, snapshotId, columnIds, true);
        Set columnsWithExtendedStatistics = (Set)columns.stream().filter(column -> ndvs.containsKey(column.getId())).map(IcebergColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
        return this.getStatisticsCollectionMetadata(tableMetadata, Optional.of(columnsWithExtendedStatistics), (Set<String> availableColumnNames) -> {});
    }

    public ConnectorAnalyzeMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Object> analyzeProperties) {
        IcebergTableHandle handle = IcebergMetadata.checkValidTableHandle(tableHandle);
        if (!IcebergSessionProperties.isExtendedStatisticsEnabled(session)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Analyze is not enabled. You can enable analyze using %s config or %s catalog session property".formatted("iceberg.extended-statistics.enabled", "extended_statistics_enabled"));
        }
        Preconditions.checkArgument((handle.getTableType() == TableType.DATA ? 1 : 0) != 0, (String)"Cannot analyze non-DATA table: %s", (Object)((Object)handle.getTableType()));
        if (handle.getSnapshotId().isEmpty()) {
            return new ConnectorAnalyzeMetadata(tableHandle, TableStatisticsMetadata.empty());
        }
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, handle);
        Optional<Set<String>> analyzeColumnNames = IcebergAnalyzeProperties.getColumnNames(analyzeProperties).map(columnNames -> {
            if (columnNames.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "Cannot specify empty list of columns for analysis");
            }
            return columnNames;
        });
        return new ConnectorAnalyzeMetadata((ConnectorTableHandle)handle.forAnalyze(), this.getStatisticsCollectionMetadata(tableMetadata, analyzeColumnNames, (Set<String> availableColumnNames) -> {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, String.format("Invalid columns specified for analysis: %s", Sets.difference((Set)((Set)analyzeColumnNames.orElseThrow()), (Set)availableColumnNames)));
        }));
    }

    private TableStatisticsMetadata getStatisticsCollectionMetadata(ConnectorTableMetadata tableMetadata, Optional<Set<String>> selectedColumnNames, Consumer<Set<String>> unsatisfiableSelectedColumnsHandler) {
        Set allScalarColumnNames = (Set)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).filter(column -> column.getType().getTypeParameters().isEmpty()).map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
        selectedColumnNames.ifPresent(columnNames -> {
            if (!allScalarColumnNames.containsAll((Collection<?>)columnNames)) {
                unsatisfiableSelectedColumnsHandler.accept(allScalarColumnNames);
            }
        });
        Set columnStatistics = (Set)tableMetadata.getColumns().stream().filter(columnMetadata -> allScalarColumnNames.contains(columnMetadata.getName())).filter(selectedColumnNames.map(columnNames -> columnMetadata -> columnNames.contains(columnMetadata.getName())).orElse(columnMetadata -> true)).map(column -> new ColumnStatisticMetadata(column.getName(), NUMBER_OF_DISTINCT_VALUES_NAME, NUMBER_OF_DISTINCT_VALUES_FUNCTION)).collect(ImmutableSet.toImmutableSet());
        return new TableStatisticsMetadata(columnStatistics, (Set)ImmutableSet.of(), (List)ImmutableList.of());
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        BaseTable icebergTable = this.catalog.loadTable(session, handle.getSchemaTableName());
        if (Locations.isS3Tables((String)icebergTable.location())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "S3 Tables does not support analyze");
        }
        this.beginTransaction((Table)icebergTable);
        return handle;
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Table table = this.transaction.table();
        if (handle.getSnapshotId().isEmpty()) {
            Verify.verify((computedStatistics.size() == 1 ? 1 : 0) != 0, (String)"The computedStatistics size must be 1: %s", computedStatistics);
            ComputedStatistics statistics = (ComputedStatistics)Iterables.getOnlyElement(computedStatistics);
            Verify.verify((statistics.getGroupingColumns().isEmpty() && statistics.getGroupingValues().isEmpty() && statistics.getColumnStatistics().isEmpty() && statistics.getTableStatistics().isEmpty() ? 1 : 0) != 0, (String)"Unexpected non-empty statistics that cannot be attached to a snapshot because none exists: %s", computedStatistics);
            IcebergMetadata.commitTransaction(this.transaction, "statistics collection");
            this.transaction = null;
            return;
        }
        long snapshotId = handle.getSnapshotId().orElseThrow();
        CollectedStatistics collectedStatistics = IcebergMetadata.processComputedTableStatistics(table, computedStatistics);
        StatisticsFile statisticsFile = this.tableStatisticsWriter.writeStatisticsFile(session, table, snapshotId, TableStatisticsWriter.StatsUpdateMode.REPLACE, collectedStatistics);
        this.transaction.updateStatistics().setStatistics(statisticsFile).commit();
        IcebergMetadata.commitTransaction(this.transaction, "statistics collection");
        this.transaction = null;
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        IcebergTableHandle table = (IcebergTableHandle)handle;
        TupleDomain medataColumnPredicate = table.getEnforcedPredicate().filter((column, domain) -> IcebergMetadataColumn.isMetadataColumnId(column.getId()));
        if (!medataColumnPredicate.isAll()) {
            return Optional.empty();
        }
        return Optional.of(handle);
    }

    public RowChangeParadigm getRowChangeParadigm(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return RowChangeParadigm.DELETE_ROW_AND_INSERT_ROW;
    }

    public ColumnHandle getMergeRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Types.StructType type = Types.StructType.of((List)ImmutableList.builder().add((Object)MetadataColumns.FILE_PATH).add((Object)MetadataColumns.ROW_POSITION).add((Object)Types.NestedField.required((int)-2147483647, (String)"partition_spec_id", (Type)Types.IntegerType.get())).add((Object)Types.NestedField.required((int)-2147483646, (String)"partition_data", (Type)Types.StringType.get())).build());
        Types.NestedField field = Types.NestedField.required((int)Integer.MIN_VALUE, (String)"$row_id", (Type)type);
        return IcebergUtil.getColumnHandle(field, this.typeManager);
    }

    public Optional<ConnectorPartitioningHandle> getUpdateLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.getInsertLayout(session, tableHandle).flatMap(ConnectorTableLayout::getPartitioning).map(IcebergPartitioningHandle.class::cast).map(IcebergPartitioningHandle::forUpdate);
    }

    public ConnectorMergeTableHandle beginMerge(ConnectorSession session, ConnectorTableHandle tableHandle, Map<Integer, Collection<ColumnHandle>> updateCaseColumns, RetryMode retryMode) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        IcebergMetadata.verifyTableVersionForUpdate(table);
        BaseTable icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        IcebergMetadata.validateNotModifyingOldSnapshot(table, (Table)icebergTable);
        this.beginTransaction((Table)icebergTable);
        IcebergWritableTableHandle insertHandle = this.newWritableTableHandle(table.getSchemaTableName(), (Table)icebergTable, retryMode);
        return new IcebergMergeTableHandle(table, insertHandle);
    }

    public void finishMerge(ConnectorSession session, ConnectorMergeTableHandle mergeTableHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        IcebergMergeTableHandle mergeHandle = (IcebergMergeTableHandle)mergeTableHandle;
        IcebergTableHandle handle = mergeHandle.getTableHandle();
        RetryMode retryMode = mergeHandle.getInsertTableHandle().retryMode();
        this.finishWrite(session, handle, fragments, retryMode);
    }

    private static void verifyTableVersionForUpdate(IcebergTableHandle table) {
        if (table.getFormatVersion() < 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Iceberg table updates require at least format version 2");
        }
    }

    private static void validateNotModifyingOldSnapshot(IcebergTableHandle table, Table icebergTable) {
        if (table.getSnapshotId().isPresent() && table.getSnapshotId().get().longValue() != icebergTable.currentSnapshot().snapshotId()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Modifying old snapshot is not supported in Iceberg");
        }
    }

    private void finishWrite(ConnectorSession session, IcebergTableHandle table, Collection<Slice> fragments, RetryMode retryMode) {
        IsolationLevel isolationLevel;
        Table icebergTable = this.transaction.table();
        List commitTasks = (List)fragments.stream().map(Slice::getInput).map(arg_0 -> this.commitTaskCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        if (commitTasks.isEmpty()) {
            this.transaction = null;
            return;
        }
        Schema schema = SchemaParser.fromJson((String)table.getTableSchemaJson());
        RowDelta rowDelta = this.transaction.newRowDelta();
        table.getSnapshotId().map(arg_0 -> ((Table)icebergTable).snapshot(arg_0)).ifPresent(s -> rowDelta.validateFromSnapshot(s.snapshotId()));
        TupleDomain dataColumnPredicate = table.getEnforcedPredicate().filter((column, domain) -> !IcebergMetadataColumn.isMetadataColumnId(column.getId()));
        TupleDomain effectivePredicate = dataColumnPredicate.intersect(table.getUnenforcedPredicate());
        if (IcebergSessionProperties.isFileBasedConflictDetectionEnabled(session)) {
            effectivePredicate = effectivePredicate.intersect(IcebergMetadata.extractTupleDomainsFromCommitTasks(table, icebergTable, commitTasks, this.typeManager));
        }
        if (!(effectivePredicate = effectivePredicate.filter((icebergColumnHandle, domain) -> ExpressionConverter.isConvertibleToIcebergExpression(domain))).isAll()) {
            rowDelta.conflictDetectionFilter(ExpressionConverter.toIcebergExpression((TupleDomain<IcebergColumnHandle>)effectivePredicate));
        }
        if ((isolationLevel = IsolationLevel.fromName((String)icebergTable.properties().getOrDefault("write.delete.isolation-level", "serializable"))) == IsolationLevel.SERIALIZABLE) {
            rowDelta.validateNoConflictingDataFiles();
        }
        rowDelta.validateDeletedFiles();
        rowDelta.validateNoConflictingDeleteFiles();
        ImmutableSet.Builder writtenFiles = ImmutableSet.builder();
        ImmutableSet.Builder referencedDataFiles = ImmutableSet.builder();
        block4: for (CommitTaskData task : commitTasks) {
            PartitionSpec partitionSpec = PartitionSpecParser.fromJson((Schema)schema, (String)task.partitionSpecJson());
            Type[] partitionColumnTypes = (Type[])partitionSpec.fields().stream().map(field -> field.transform().getResultType(schema.findType(field.sourceId()))).toArray(Type[]::new);
            switch (task.content()) {
                case POSITION_DELETES: {
                    String partitionDataJson;
                    FileMetadata.Builder deleteBuilder = FileMetadata.deleteFileBuilder((PartitionSpec)partitionSpec).withPath(task.path()).withFormat(task.fileFormat().toIceberg()).ofPositionDeletes().withFileSizeInBytes(task.fileSizeInBytes()).withMetrics(task.metrics().metrics());
                    task.fileSplitOffsets().ifPresent(arg_0 -> ((FileMetadata.Builder)deleteBuilder).withSplitOffsets(arg_0));
                    if (!partitionSpec.fields().isEmpty()) {
                        partitionDataJson = task.partitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                        deleteBuilder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
                    }
                    rowDelta.addDeletes(deleteBuilder.build());
                    writtenFiles.add((Object)task.path());
                    task.referencedDataFile().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedDataFiles).add(arg_0));
                    continue block4;
                }
                case DATA: {
                    String partitionDataJson;
                    DataFiles.Builder builder = DataFiles.builder((PartitionSpec)partitionSpec).withPath(task.path()).withFormat(task.fileFormat().toIceberg()).withFileSizeInBytes(task.fileSizeInBytes()).withMetrics(task.metrics().metrics());
                    if (!icebergTable.spec().fields().isEmpty()) {
                        partitionDataJson = task.partitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                        builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
                    }
                    rowDelta.addRows(builder.build());
                    writtenFiles.add((Object)task.path());
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unsupported task content: " + String.valueOf(task.content()));
        }
        if (retryMode != RetryMode.NO_RETRIES) {
            this.cleanExtraOutputFiles(session, (Set<String>)writtenFiles.build());
        }
        rowDelta.validateDataFilesExist((Iterable)referencedDataFiles.build());
        IcebergMetadata.commitUpdateAndTransaction(rowDelta, session, this.transaction, "write");
    }

    static TupleDomain<IcebergColumnHandle> extractTupleDomainsFromCommitTasks(IcebergTableHandle table, Table icebergTable, List<CommitTaskData> commitTasks, TypeManager typeManager) {
        HashSet<IcebergColumnHandle> partitionColumns = new HashSet<IcebergColumnHandle>(IcebergUtil.getProjectedColumns(icebergTable.schema(), typeManager, IcebergMetadata.identityPartitionColumnsInAllSpecs(icebergTable)));
        PartitionSpec partitionSpec = icebergTable.spec();
        Type[] partitionColumnTypes = (Type[])partitionSpec.fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        Schema schema = SchemaParser.fromJson((String)table.getTableSchemaJson());
        HashMap<IcebergColumnHandle, List> domainsFromTasks = new HashMap<IcebergColumnHandle, List>();
        for (CommitTaskData commitTask : commitTasks) {
            PartitionSpec taskPartitionSpec = PartitionSpecParser.fromJson((Schema)schema, (String)commitTask.partitionSpecJson());
            if (commitTask.partitionDataJson().isEmpty() || taskPartitionSpec.isUnpartitioned() || !taskPartitionSpec.equals((Object)partitionSpec)) {
                return TupleDomain.all();
            }
            PartitionData partitionData = PartitionData.fromJson(commitTask.partitionDataJson().get(), partitionColumnTypes);
            Map<Integer, Optional<String>> partitionKeys = IcebergUtil.getPartitionKeys(partitionData, partitionSpec);
            Map<ColumnHandle, NullableValue> partitionValues = IcebergUtil.getPartitionValues(partitionColumns, partitionKeys);
            for (Map.Entry<ColumnHandle, NullableValue> entry2 : partitionValues.entrySet()) {
                IcebergColumnHandle columnHandle = (IcebergColumnHandle)entry2.getKey();
                NullableValue value = entry2.getValue();
                Domain newDomain = value.isNull() ? Domain.onlyNull((io.trino.spi.type.Type)columnHandle.getType()) : Domain.singleValue((io.trino.spi.type.Type)columnHandle.getType(), (Object)value.getValue());
                domainsFromTasks.computeIfAbsent(columnHandle, icebergColumnHandle -> new ArrayList()).add(newDomain);
            }
        }
        return TupleDomain.withColumnDomains((Map)((Map)domainsFromTasks.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Domain.union((List)((List)entry.getValue()))))));
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, Map<String, Object> viewProperties, boolean replace) {
        Preconditions.checkArgument((boolean)viewProperties.isEmpty(), (Object)"This connector does not support creating views with properties");
        this.catalog.createView(session, viewName, definition, replace);
    }

    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        this.catalog.renameView(session, source, target);
    }

    public void setViewAuthorization(ConnectorSession session, SchemaTableName viewName, TrinoPrincipal principal) {
        this.catalog.setViewPrincipal(session, viewName, principal);
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        this.catalog.dropView(session, viewName);
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.listViews(session, schemaName);
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.getViews(session, schemaName);
    }

    public boolean isView(ConnectorSession session, SchemaTableName viewName) {
        try {
            return this.catalog.getView(session, viewName).isPresent();
        }
        catch (TrinoException e) {
            if (e.getErrorCode() == IcebergErrorCode.ICEBERG_UNSUPPORTED_VIEW_DIALECT.toErrorCode()) {
                return true;
            }
            throw e;
        }
    }

    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return this.catalog.getView(session, viewName);
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        BaseTable icebergTable = this.catalog.loadTable(session, handle.getSchemaTableName());
        DeleteFiles deleteFiles = icebergTable.newDelete().deleteFromRowFilter(ExpressionConverter.toIcebergExpression(handle.getEnforcedPredicate()));
        IcebergMetadata.commitUpdate(deleteFiles, session, "delete");
        Map summary = icebergTable.currentSnapshot().summary();
        String deletedRowsStr = (String)summary.get("deleted-records");
        if (deletedRowsStr == null) {
            return OptionalLong.empty();
        }
        long deletedRecords = Long.parseLong(deletedRowsStr);
        long removedPositionDeletes = Long.parseLong(summary.getOrDefault("removed-position-deletes", "0"));
        long removedEqualityDeletes = Long.parseLong(summary.getOrDefault("removed-equality-deletes", "0"));
        return OptionalLong.of(deletedRecords - removedPositionDeletes - removedEqualityDeletes);
    }

    public void truncateTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = IcebergMetadata.checkValidTableHandle(tableHandle);
        BaseTable icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        DeleteFiles deleteFiles = icebergTable.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue());
        IcebergMetadata.commitUpdate(deleteFiles, session, "truncate");
    }

    public void rollback() {
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle handle, long limit) {
        IcebergTableHandle table = (IcebergTableHandle)handle;
        if (table.getLimit().isPresent() && table.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        if (!table.getUnenforcedPredicate().isAll()) {
            return Optional.empty();
        }
        table = new IcebergTableHandle(table.getCatalog(), table.getSchemaName(), table.getTableName(), table.getTableType(), table.getSnapshotId(), table.getTableSchemaJson(), table.getPartitionSpecJson(), table.getFormatVersion(), table.getUnenforcedPredicate(), table.getEnforcedPredicate(), OptionalLong.of(limit), table.getProjectedColumns(), table.getNameMappingJson(), table.getTableLocation(), table.getStorageProperties(), table.getTablePartitioning(), table.isRecordScannedFiles(), table.getMaxScannedFileSize(), table.getConstraintColumns(), table.getForAnalyze());
        return Optional.of(new LimitApplicationResult((Object)table, false, false));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        TupleDomain remainingConstraint;
        TupleDomain newUnenforcedConstraint;
        TupleDomain newEnforcedConstraint;
        IcebergTableHandle table = (IcebergTableHandle)handle;
        UtcConstraintExtractor.ExtractionResult extractionResult = UtcConstraintExtractor.extractTupleDomain((Constraint)constraint);
        TupleDomain predicate = extractionResult.tupleDomain().transformKeys(IcebergColumnHandle.class::cast);
        if (predicate.isAll() && constraint.getPredicateColumns().isEmpty()) {
            return Optional.empty();
        }
        if (table.getLimit().isPresent()) {
            return Optional.empty();
        }
        if (predicate.isNone()) {
            newEnforcedConstraint = TupleDomain.none();
            newUnenforcedConstraint = TupleDomain.all();
            remainingConstraint = TupleDomain.all();
        } else {
            BaseTable icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
            Set partitionSpecIds = (Set)table.getSnapshotId().map(arg_0 -> IcebergMetadata.lambda$applyFilter$0((Table)icebergTable, arg_0)).orElseGet(() -> IcebergMetadata.lambda$applyFilter$1((Table)icebergTable));
            LinkedHashMap unsupported = new LinkedHashMap();
            LinkedHashMap newEnforced = new LinkedHashMap();
            LinkedHashMap newUnenforced = new LinkedHashMap();
            Map domains = (Map)predicate.getDomains().orElseThrow(() -> new VerifyException("No domains"));
            domains.forEach((arg_0, arg_1) -> this.lambda$applyFilter$3(unsupported, (Table)icebergTable, partitionSpecIds, newEnforced, newUnenforced, arg_0, arg_1));
            newEnforcedConstraint = TupleDomain.withColumnDomains(newEnforced).intersect(table.getEnforcedPredicate());
            newUnenforcedConstraint = TupleDomain.withColumnDomains(newUnenforced).intersect(table.getUnenforcedPredicate());
            remainingConstraint = TupleDomain.withColumnDomains(newUnenforced).intersect(TupleDomain.withColumnDomains(unsupported));
        }
        Set newConstraintColumns = (Set)Streams.concat((Stream[])new Stream[]{table.getConstraintColumns().stream(), constraint.getPredicateColumns().orElseGet(ImmutableSet::of).stream().map(columnHandle -> (IcebergColumnHandle)columnHandle)}).collect(ImmutableSet.toImmutableSet());
        if (newEnforcedConstraint.equals(table.getEnforcedPredicate()) && newUnenforcedConstraint.equals(table.getUnenforcedPredicate()) && newConstraintColumns.equals(table.getConstraintColumns())) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintApplicationResult((Object)new IcebergTableHandle(table.getCatalog(), table.getSchemaName(), table.getTableName(), table.getTableType(), table.getSnapshotId(), table.getTableSchemaJson(), table.getPartitionSpecJson(), table.getFormatVersion(), (TupleDomain<IcebergColumnHandle>)newUnenforcedConstraint, (TupleDomain<IcebergColumnHandle>)newEnforcedConstraint, table.getLimit(), table.getProjectedColumns(), table.getNameMappingJson(), table.getTableLocation(), table.getStorageProperties(), table.getTablePartitioning(), table.isRecordScannedFiles(), table.getMaxScannedFileSize(), newConstraintColumns, table.getForAnalyze()), remainingConstraint.transformKeys(ColumnHandle.class::cast), extractionResult.remainingExpression(), false));
    }

    private static List<ManifestFile> loadAllManifestsFromSnapshot(Table icebergTable, Snapshot snapshot) {
        try {
            return snapshot.allManifests(icebergTable.io());
        }
        catch (UncheckedIOException | NotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, "Error accessing manifest file for table %s".formatted(icebergTable.name()), e);
        }
    }

    private static Set<Integer> identityPartitionColumnsInAllSpecs(Table table) {
        return (Set)table.spec().fields().stream().filter(field -> field.transform().isIdentity()).filter(field -> table.specs().values().stream().allMatch(spec -> spec.fields().contains(field))).map(PartitionField::sourceId).collect(ImmutableSet.toImmutableSet());
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle handle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        if (!IcebergSessionProperties.isProjectionPushdownEnabled(session)) {
            return Optional.empty();
        }
        Set projectedExpressions = (Set)projections.stream().flatMap(expression -> ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)expression).stream()).collect(ImmutableSet.toImmutableSet());
        Map columnProjections = (Map)projectedExpressions.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), ApplyProjectionUtil::createProjectedColumnRepresentation));
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)handle;
        if (columnProjections.values().stream().allMatch(ApplyProjectionUtil.ProjectedColumnRepresentation::isVariable)) {
            Set projectedColumns = (Set)assignments.values().stream().map(IcebergColumnHandle.class::cast).collect(ImmutableSet.toImmutableSet());
            if (icebergTableHandle.getProjectedColumns().equals(projectedColumns)) {
                return Optional.empty();
            }
            List assignmentsList = (List)assignments.entrySet().stream().map(assignment -> new Assignment((String)assignment.getKey(), (ColumnHandle)assignment.getValue(), ((IcebergColumnHandle)assignment.getValue()).getType())).collect(ImmutableList.toImmutableList());
            return Optional.of(new ProjectionApplicationResult((Object)icebergTableHandle.withProjectedColumns(projectedColumns), projections, assignmentsList, false));
        }
        HashMap<String, Assignment> newAssignments = new HashMap<String, Assignment>();
        ImmutableMap.Builder newVariablesBuilder = ImmutableMap.builder();
        ImmutableSet.Builder projectedColumnsBuilder = ImmutableSet.builder();
        for (Map.Entry entry : columnProjections.entrySet()) {
            ConnectorExpression expression2 = (ConnectorExpression)entry.getKey();
            ApplyProjectionUtil.ProjectedColumnRepresentation projectedColumn = (ApplyProjectionUtil.ProjectedColumnRepresentation)entry.getValue();
            IcebergColumnHandle baseColumnHandle = (IcebergColumnHandle)assignments.get(projectedColumn.getVariable().getName());
            IcebergColumnHandle projectedColumnHandle = IcebergMetadata.createProjectedColumnHandle(baseColumnHandle, projectedColumn.getDereferenceIndices(), expression2.getType());
            String projectedColumnName = projectedColumnHandle.getQualifiedName();
            Variable projectedColumnVariable = new Variable(projectedColumnName, expression2.getType());
            Assignment newAssignment = new Assignment(projectedColumnName, (ColumnHandle)projectedColumnHandle, expression2.getType());
            newAssignments.putIfAbsent(projectedColumnName, newAssignment);
            newVariablesBuilder.put((Object)expression2, (Object)projectedColumnVariable);
            projectedColumnsBuilder.add((Object)projectedColumnHandle);
        }
        ImmutableMap newVariables = newVariablesBuilder.buildOrThrow();
        List newProjections = (List)projections.stream().map(arg_0 -> IcebergMetadata.lambda$applyProjection$2((Map)newVariables, arg_0)).collect(ImmutableList.toImmutableList());
        ImmutableList outputAssignments = ImmutableList.copyOf(newAssignments.values());
        return Optional.of(new ProjectionApplicationResult((Object)icebergTableHandle.withProjectedColumns((Set<IcebergColumnHandle>)projectedColumnsBuilder.build()), newProjections, (List)outputAssignments, false));
    }

    private static IcebergColumnHandle createProjectedColumnHandle(IcebergColumnHandle column, List<Integer> indices, io.trino.spi.type.Type projectedColumnType) {
        if (indices.isEmpty()) {
            return column;
        }
        ImmutableList.Builder fullPath = ImmutableList.builder();
        fullPath.addAll(column.getPath());
        ColumnIdentity projectedColumnIdentity = column.getColumnIdentity();
        for (int index : indices) {
            projectedColumnIdentity = projectedColumnIdentity.getChildren().get(index);
            fullPath.add((Object)projectedColumnIdentity.getId());
        }
        return new IcebergColumnHandle(column.getBaseColumnIdentity(), column.getBaseType(), (List<Integer>)fullPath.build(), projectedColumnType, true, Optional.empty());
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle) {
        if (!IcebergSessionProperties.isStatisticsEnabled(session)) {
            return TableStatistics.empty();
        }
        IcebergTableHandle originalHandle = (IcebergTableHandle)tableHandle;
        Preconditions.checkArgument((!originalHandle.isRecordScannedFiles() ? 1 : 0) != 0, (Object)"Unexpected scanned files recording set");
        Preconditions.checkArgument((boolean)originalHandle.getMaxScannedFileSize().isEmpty(), (Object)"Unexpected max scanned file size set");
        IcebergTableHandle cacheKey = new IcebergTableHandle(originalHandle.getCatalog(), originalHandle.getSchemaName(), originalHandle.getTableName(), originalHandle.getTableType(), originalHandle.getSnapshotId(), originalHandle.getTableSchemaJson(), originalHandle.getPartitionSpecJson(), originalHandle.getFormatVersion(), originalHandle.getUnenforcedPredicate(), originalHandle.getEnforcedPredicate(), OptionalLong.empty(), (Set<IcebergColumnHandle>)ImmutableSet.of(), originalHandle.getNameMappingJson(), originalHandle.getTableLocation(), originalHandle.getStorageProperties(), Optional.empty(), false, originalHandle.getMaxScannedFileSize(), (Set<IcebergColumnHandle>)ImmutableSet.of(), Optional.empty());
        return IcebergMetadata.getIncrementally(this.tableStatisticsCache, cacheKey, currentStatistics -> currentStatistics.getColumnStatistics().keySet().containsAll(originalHandle.getProjectedColumns()), projectedColumns -> {
            BaseTable icebergTable = this.catalog.loadTable(session, originalHandle.getSchemaTableName());
            return TableStatisticsReader.getTableStatistics(this.typeManager, session, originalHandle, projectedColumns, (Table)icebergTable, this.icebergPlanningExecutor, this.fileSystemFactory.create(session.getIdentity(), icebergTable.io().properties()));
        }, originalHandle.getProjectedColumns());
    }

    public void setTableAuthorization(ConnectorSession session, SchemaTableName tableName, TrinoPrincipal principal) {
        this.catalog.setTablePrincipal(session, tableName, principal);
    }

    private Optional<Long> getCurrentSnapshotId(Table table) {
        return Optional.ofNullable(table.currentSnapshot()).map(Snapshot::snapshotId);
    }

    Table getIcebergTable(ConnectorSession session, SchemaTableName schemaTableName) {
        return this.catalog.loadTable(session, schemaTableName);
    }

    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> properties, boolean replace, boolean ignoreExisting) {
        this.catalog.createMaterializedView(session, viewName, definition, properties, replace, ignoreExisting);
    }

    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        this.catalog.dropMaterializedView(session, viewName);
    }

    public boolean delegateMaterializedViewRefreshToConnector(ConnectorSession session, SchemaTableName viewName) {
        return false;
    }

    public ConnectorInsertTableHandle beginRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorTableHandle> sourceTableHandles, RetryMode retryMode, RefreshType refreshType) {
        IcebergTableHandle handle;
        Object object;
        boolean shouldUseIncremental;
        Preconditions.checkState((boolean)this.fromSnapshotForRefresh.isEmpty(), (Object)"From Snapshot must be empty at the start of MV refresh operation.");
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        BaseTable icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        this.beginTransaction((Table)icebergTable);
        Optional<String> dependencies = Optional.ofNullable(icebergTable.currentSnapshot()).map(Snapshot::summary).map(summary -> (String)summary.get(DEPENDS_ON_TABLES));
        boolean bl = shouldUseIncremental = IcebergSessionProperties.isIncrementalRefreshEnabled(session) && refreshType == RefreshType.INCREMENTAL && sourceTableHandles.size() == 1 && (object = Iterables.getOnlyElement(sourceTableHandles)) instanceof IcebergTableHandle && (handle = (IcebergTableHandle)object).getCatalog().equals((Object)this.trinoCatalogHandle) && dependencies.isPresent() && !dependencies.get().equals(UNKNOWN_SNAPSHOT_TOKEN);
        if (shouldUseIncremental) {
            Map sourceTableToSnapshot = MAP_SPLITTER.split((CharSequence)dependencies.get());
            Preconditions.checkState((sourceTableToSnapshot.size() == 1 ? 1 : 0) != 0, (String)"Expected %s to contain only single source table in snapshot summary", (Object)sourceTableToSnapshot);
            Map.Entry sourceTable = (Map.Entry)Iterables.getOnlyElement(sourceTableToSnapshot.entrySet());
            String[] schemaTable = ((String)sourceTable.getKey()).split("\\.");
            IcebergTableHandle handle2 = (IcebergTableHandle)Iterables.getOnlyElement(sourceTableHandles);
            SchemaTableName sourceSchemaTable = new SchemaTableName(schemaTable[0], schemaTable[1]);
            Preconditions.checkState((boolean)sourceSchemaTable.equals((Object)handle2.getSchemaTableName()), (String)"Source table name %s doesn't match handle table name %s", (Object)sourceSchemaTable, (Object)handle2.getSchemaTableName());
            this.fromSnapshotForRefresh = Optional.of(Long.parseLong((String)sourceTable.getValue()));
        }
        return this.newWritableTableHandle(table.getSchemaTableName(), (Table)icebergTable, retryMode);
    }

    public Optional<ConnectorOutputMetadata> finishRefreshMaterializedView(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, List<ConnectorTableHandle> sourceTableHandles, List<String> sourceTableFunctions) {
        IcebergWritableTableHandle table = (IcebergWritableTableHandle)insertHandle;
        Table icebergTable = this.transaction.table();
        boolean isFullRefresh = this.fromSnapshotForRefresh.isEmpty();
        if (isFullRefresh) {
            log.info("Performing full MV refresh for storage table: %s", new Object[]{table.name()});
            this.transaction.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
        } else {
            log.info("Performing incremental MV refresh for storage table: %s", new Object[]{table.name()});
        }
        List commitTasks = (List)fragments.stream().map(Slice::getInput).map(arg_0 -> this.commitTaskCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        AppendFiles appendFiles = this.transaction.newFastAppend();
        ImmutableSet.Builder writtenFiles = ImmutableSet.builder();
        for (CommitTaskData task : commitTasks) {
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(task.path()).withFileSizeInBytes(task.fileSizeInBytes()).withFormat(table.fileFormat().toIceberg()).withMetrics(task.metrics().metrics());
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.partitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            appendFiles.appendFile(builder.build());
            writtenFiles.add((Object)task.path());
        }
        String tableDependencies = sourceTableHandles.stream().map(handle -> {
            if (!(handle instanceof IcebergTableHandle)) {
                return UNKNOWN_SNAPSHOT_TOKEN;
            }
            IcebergTableHandle icebergHandle = (IcebergTableHandle)handle;
            if (!this.trinoCatalogHandle.equals((Object)icebergHandle.getCatalog())) {
                return UNKNOWN_SNAPSHOT_TOKEN;
            }
            return String.valueOf(icebergHandle.getSchemaTableName()) + "=" + String.valueOf(icebergHandle.getSnapshotId().map(Object.class::cast).orElse(""));
        }).distinct().collect(Collectors.joining(","));
        if (table.retryMode() != RetryMode.NO_RETRIES) {
            this.cleanExtraOutputFiles(session, (Set<String>)writtenFiles.build());
        }
        appendFiles.set(DEPENDS_ON_TABLES, tableDependencies);
        appendFiles.set(DEPENDS_ON_TABLE_FUNCTIONS, Boolean.toString(!sourceTableFunctions.isEmpty()));
        appendFiles.set(TRINO_QUERY_START_TIME, session.getStart().toString());
        IcebergMetadata.commitUpdateAndTransaction(appendFiles, session, this.transaction, "refresh materialized view");
        this.transaction = null;
        this.fromSnapshotForRefresh = Optional.empty();
        try {
            this.executeExpireSnapshots(icebergTable, session, System.currentTimeMillis());
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to delete old snapshot files during materialized view refresh");
        }
        return Optional.of(new HiveWrittenPartitions((List)commitTasks.stream().map(CommitTaskData::path).collect(ImmutableList.toImmutableList())));
    }

    public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
        return this.catalog.listTables(session, schemaName).stream().filter(info -> info.extendedRelationType() == TableInfo.ExtendedRelationType.TRINO_MATERIALIZED_VIEW).map(TableInfo::tableName).toList();
    }

    public Map<SchemaTableName, ConnectorMaterializedViewDefinition> getMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
        HashMap<SchemaTableName, ConnectorMaterializedViewDefinition> materializedViews = new HashMap<SchemaTableName, ConnectorMaterializedViewDefinition>();
        for (SchemaTableName name : this.listMaterializedViews(session, schemaName)) {
            try {
                this.getMaterializedView(session, name).ifPresent(view -> materializedViews.put(name, (ConnectorMaterializedViewDefinition)view));
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Failed to access metadata of materialized view %s during listing", new Object[]{name});
            }
        }
        return materializedViews;
    }

    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        return this.catalog.getMaterializedView(session, viewName);
    }

    public Map<String, Object> getMaterializedViewProperties(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition) {
        return this.catalog.getMaterializedViewProperties(session, viewName, definition);
    }

    public void renameMaterializedView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        if (!source.getSchemaName().equals(target.getSchemaName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Materialized View rename across schemas is not supported");
        }
        this.catalog.renameMaterializedView(session, source, target);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MaterializedViewFreshness getMaterializedViewFreshness(ConnectorSession session, SchemaTableName materializedViewName) {
        List tableChangeInfos;
        Optional<ConnectorMaterializedViewDefinition> materializedViewDefinition = this.getMaterializedView(session, materializedViewName);
        if (materializedViewDefinition.isEmpty()) {
            return new MaterializedViewFreshness(MaterializedViewFreshness.Freshness.STALE, Optional.empty());
        }
        SchemaTableName storageTableName = materializedViewDefinition.get().getStorageTable().map(CatalogSchemaTableName::getSchemaTableName).orElseThrow(() -> new IllegalStateException("Storage table missing in definition of materialized view " + String.valueOf(materializedViewName)));
        BaseTable icebergTable = this.catalog.loadTable(session, storageTableName);
        Optional<Snapshot> currentSnapshot = Optional.ofNullable(icebergTable.currentSnapshot());
        String dependsOnTables = currentSnapshot.map(snapshot -> snapshot.summary().getOrDefault(DEPENDS_ON_TABLES, "")).orElse("");
        boolean dependsOnTableFunctions = currentSnapshot.map(snapshot -> Boolean.valueOf(snapshot.summary().getOrDefault(DEPENDS_ON_TABLE_FUNCTIONS, "false"))).orElse(false);
        Optional<Instant> refreshTime = currentSnapshot.map(snapshot -> (String)snapshot.summary().get(TRINO_QUERY_START_TIME)).map(Instant::parse).or(() -> currentSnapshot.map(snapshot -> Instant.ofEpochMilli(snapshot.timestampMillis())));
        if (dependsOnTableFunctions) {
            return new MaterializedViewFreshness(MaterializedViewFreshness.Freshness.UNKNOWN, refreshTime);
        }
        if (dependsOnTables.isEmpty()) {
            return new MaterializedViewFreshness(MaterializedViewFreshness.Freshness.STALE, Optional.empty());
        }
        boolean hasUnknownTables = false;
        Optional<Long> firstTableChange = Optional.of(Long.MAX_VALUE);
        ImmutableList.Builder tableChangeInfoTasks = ImmutableList.builder();
        for (String tableToSnapShot : Splitter.on((char)',').split((CharSequence)dependsOnTables)) {
            if (tableToSnapShot.equals(UNKNOWN_SNAPSHOT_TOKEN)) {
                hasUnknownTables = true;
                firstTableChange = Optional.empty();
                continue;
            }
            tableChangeInfoTasks.add(() -> this.getTableChangeInfo(session, tableToSnapShot));
        }
        boolean hasStaleIcebergTables = false;
        try {
            tableChangeInfos = ExecutorUtil.processWithAdditionalThreads((Collection)tableChangeInfoTasks.build(), (Executor)this.metadataFetchingExecutor);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        Verify.verifyNotNull((Object)tableChangeInfos);
        block11: for (TableChangeInfo tableChangeInfo : tableChangeInfos) {
            TableChangeInfo tableChangeInfo2;
            Objects.requireNonNull(tableChangeInfo);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NoTableChange.class, FirstChangeSnapshot.class, UnknownTableChange.class, CorruptedTableChange.class}, (TableChangeInfo)tableChangeInfo2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    NoTableChange noTableChange = (NoTableChange)tableChangeInfo2;
                    continue block11;
                }
                case 1: {
                    UnknownTableChange unknownTableChange;
                    FirstChangeSnapshot firstChangeSnapshot = (FirstChangeSnapshot)tableChangeInfo2;
                    try {
                        UnknownTableChange snapshot2 = unknownTableChange = firstChangeSnapshot.snapshot();
                        hasStaleIcebergTables = true;
                        firstTableChange = firstTableChange.map(arg_0 -> IcebergMetadata.lambda$getMaterializedViewFreshness$7((Snapshot)snapshot2, arg_0));
                        continue block11;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 2: {
                    UnknownTableChange unknownTableChange = (UnknownTableChange)tableChangeInfo2;
                    hasStaleIcebergTables = true;
                    firstTableChange = Optional.empty();
                    continue block11;
                }
                case 3: 
            }
            CorruptedTableChange corruptedTableChange = (CorruptedTableChange)tableChangeInfo2;
            return new MaterializedViewFreshness(MaterializedViewFreshness.Freshness.STALE, Optional.empty());
        }
        Optional<Instant> lastFreshTime = firstTableChange.map(Instant::ofEpochMilli).or(() -> refreshTime);
        if (hasStaleIcebergTables) {
            return new MaterializedViewFreshness(MaterializedViewFreshness.Freshness.STALE, lastFreshTime);
        }
        if (hasUnknownTables) {
            return new MaterializedViewFreshness(MaterializedViewFreshness.Freshness.UNKNOWN, lastFreshTime);
        }
        return new MaterializedViewFreshness(MaterializedViewFreshness.Freshness.FRESH, Optional.empty());
    }

    private TableChangeInfo getTableChangeInfo(ConnectorSession session, String entry) {
        List keyValue = Splitter.on((String)"=").splitToList((CharSequence)entry);
        if (keyValue.size() != 2) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Invalid entry in '%s' property: %s'", DEPENDS_ON_TABLES, entry));
        }
        String tableName = (String)keyValue.get(0);
        String value = (String)keyValue.get(1);
        List strings = Splitter.on((String)".").splitToList((CharSequence)tableName);
        if (strings.size() == 3) {
            strings = strings.subList(1, 3);
        } else if (strings.size() != 2) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Invalid table name in '%s' property: %s'", DEPENDS_ON_TABLES, strings));
        }
        String schema = (String)strings.get(0);
        String name = (String)strings.get(1);
        SchemaTableName schemaTableName = new SchemaTableName(schema, name);
        ConnectorTableHandle tableHandle = this.getTableHandle(session, schemaTableName, Optional.empty(), Optional.empty());
        if (tableHandle == null || tableHandle instanceof CorruptedIcebergTableHandle) {
            return new CorruptedTableChange();
        }
        Optional<Object> snapshotAtRefresh = value.isEmpty() ? Optional.empty() : Optional.of(Long.parseLong(value));
        return this.getTableChangeInfo(session, (IcebergTableHandle)tableHandle, snapshotAtRefresh);
    }

    private TableChangeInfo getTableChangeInfo(ConnectorSession session, IcebergTableHandle table, Optional<Long> snapshotAtRefresh) {
        BaseTable icebergTable = this.catalog.loadTable(session, table.getSchemaTableName());
        Snapshot currentSnapshot = icebergTable.currentSnapshot();
        if (snapshotAtRefresh.isEmpty()) {
            if (currentSnapshot == null) {
                return new NoTableChange();
            }
            return IcebergUtil.firstSnapshot((Table)icebergTable).map(FirstChangeSnapshot::new).orElse(new UnknownTableChange());
        }
        if (snapshotAtRefresh.get().longValue() == currentSnapshot.snapshotId()) {
            return new NoTableChange();
        }
        return IcebergUtil.firstSnapshotAfter((Table)icebergTable, snapshotAtRefresh.get()).map(FirstChangeSnapshot::new).orElse(new UnknownTableChange());
    }

    public void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        this.catalog.updateColumnComment(session, ((IcebergTableHandle)tableHandle).getSchemaTableName(), ((IcebergColumnHandle)column).getColumnIdentity(), comment);
    }

    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName) {
        Optional<String> targetCatalogName = IcebergSessionProperties.getHiveCatalogName(session);
        if (targetCatalogName.isEmpty()) {
            return Optional.empty();
        }
        return this.catalog.redirectTable(session, tableName, targetCatalogName.get());
    }

    public boolean allowSplittingReadIntoMultipleSubQueries(ConnectorSession session, ConnectorTableHandle connectorTableHandle) {
        IcebergTableHandle tableHandle = (IcebergTableHandle)connectorTableHandle;
        IcebergFileFormat storageFormat = IcebergUtil.getFileFormat(tableHandle.getStorageProperties());
        return storageFormat == IcebergFileFormat.ORC || storageFormat == IcebergFileFormat.PARQUET;
    }

    public WriterScalingOptions getNewTableWriterScalingOptions(ConnectorSession session, SchemaTableName tableName, Map<String, Object> tableProperties) {
        return WriterScalingOptions.ENABLED;
    }

    public WriterScalingOptions getInsertWriterScalingOptions(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return WriterScalingOptions.ENABLED;
    }

    public Optional<Long> getIncrementalRefreshFromSnapshot() {
        return this.fromSnapshotForRefresh;
    }

    public void disableIncrementalRefresh() {
        this.fromSnapshotForRefresh = Optional.empty();
    }

    private static CollectedStatistics processComputedTableStatistics(Table table, Collection<ComputedStatistics> computedStatistics) {
        Map columnNameToId = (Map)table.schema().columns().stream().collect(ImmutableMap.toImmutableMap(nestedField -> nestedField.name().toLowerCase(Locale.ENGLISH), Types.NestedField::fieldId));
        ImmutableMap.Builder ndvSketches = ImmutableMap.builder();
        for (ComputedStatistics computedStatistic : computedStatistics) {
            Verify.verify((computedStatistic.getGroupingColumns().isEmpty() && computedStatistic.getGroupingValues().isEmpty() ? 1 : 0) != 0, (String)"Unexpected grouping", (Object[])new Object[0]);
            Verify.verify((boolean)computedStatistic.getTableStatistics().isEmpty(), (String)"Unexpected table statistics", (Object[])new Object[0]);
            for (Map.Entry entry : computedStatistic.getColumnStatistics().entrySet()) {
                ColumnStatisticMetadata statisticMetadata = (ColumnStatisticMetadata)entry.getKey();
                if (statisticMetadata.getConnectorAggregationId().equals(NUMBER_OF_DISTINCT_VALUES_NAME)) {
                    Integer columnId = (Integer)Verify.verifyNotNull((Object)((Integer)columnNameToId.get(statisticMetadata.getColumnName())), (String)"Column not found in table: [%s]", (Object[])new Object[]{statisticMetadata.getColumnName()});
                    CompactSketch sketch = DataSketchStateSerializer.deserialize((Block)entry.getValue(), 0);
                    ndvSketches.put((Object)columnId, (Object)sketch);
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported statistic: " + String.valueOf(statisticMetadata));
            }
        }
        return new CollectedStatistics((Map<Integer, CompactSketch>)ndvSketches.buildOrThrow());
    }

    private void beginTransaction(Table icebergTable) {
        Verify.verify((this.transaction == null ? 1 : 0) != 0, (String)"transaction already set", (Object[])new Object[0]);
        this.transaction = this.catalog.newTransaction(icebergTable);
    }

    private void executeExpireSnapshots(Table icebergTable, ConnectorSession session, long expireTimestampMillis) {
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session.getIdentity(), icebergTable.io().properties());
        ArrayList pathsToDelete = new ArrayList();
        Consumer<String> deleteFunction = path -> {
            pathsToDelete.add(Location.of((String)path));
            if (pathsToDelete.size() == DELETE_BATCH_SIZE.intValue()) {
                try {
                    fileSystem.deleteFiles((Collection)pathsToDelete);
                    pathsToDelete.clear();
                }
                catch (IOException | UncheckedIOException e) {
                    throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed to delete files during snapshot expiration", (Throwable)e);
                }
            }
        };
        try {
            icebergTable.expireSnapshots().expireOlderThan(expireTimestampMillis).deleteWith(deleteFunction).commit();
            fileSystem.deleteFiles(pathsToDelete);
        }
        catch (IOException | UncheckedIOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed to delete files during snapshot expiration", (Throwable)e);
        }
    }

    private static IcebergTableHandle checkValidTableHandle(ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        if (tableHandle instanceof CorruptedIcebergTableHandle) {
            CorruptedIcebergTableHandle corruptedTableHandle = (CorruptedIcebergTableHandle)tableHandle;
            throw corruptedTableHandle.createException();
        }
        return (IcebergTableHandle)tableHandle;
    }

    private static TableStatistics getIncrementally(Map<IcebergTableHandle, AtomicReference<TableStatistics>> cache, IcebergTableHandle key, Predicate<TableStatistics> isSufficient, Function<Set<IcebergColumnHandle>, TableStatistics> columnStatisticsLoader, Set<IcebergColumnHandle> projectedColumns) {
        TableStatistics newValue;
        AtomicReference valueHolder = cache.computeIfAbsent(key, icebergTableHandle -> new AtomicReference());
        TableStatistics oldValue = (TableStatistics)valueHolder.get();
        if (oldValue != null && isSufficient.test(oldValue)) {
            return oldValue;
        }
        if (oldValue == null) {
            newValue = columnStatisticsLoader.apply(projectedColumns);
        } else {
            Sets.SetView missingColumns = Sets.difference(projectedColumns, oldValue.getColumnStatistics().keySet());
            newValue = columnStatisticsLoader.apply((Set<IcebergColumnHandle>)missingColumns);
        }
        Verify.verifyNotNull((Object)newValue, (String)"loader returned null for %s", (Object[])new Object[]{key});
        TableStatistics merged = IcebergMetadata.mergeColumnStatistics(oldValue, newValue);
        if (!valueHolder.compareAndSet(oldValue, merged)) {
            valueHolder.accumulateAndGet(newValue, IcebergMetadata::mergeColumnStatistics);
        }
        return merged;
    }

    private static TableStatistics mergeColumnStatistics(TableStatistics currentStats, TableStatistics newStats) {
        Objects.requireNonNull(newStats, "newStats is null");
        TableStatistics.Builder statisticsBuilder = TableStatistics.builder();
        if (currentStats != null) {
            currentStats.getColumnStatistics().forEach((arg_0, arg_1) -> ((TableStatistics.Builder)statisticsBuilder).setColumnStatistics(arg_0, arg_1));
        }
        statisticsBuilder.setRowCount(newStats.getRowCount());
        newStats.getColumnStatistics().forEach((arg_0, arg_1) -> ((TableStatistics.Builder)statisticsBuilder).setColumnStatistics(arg_0, arg_1));
        return statisticsBuilder.build();
    }

    private static /* synthetic */ Long lambda$getMaterializedViewFreshness$7(Snapshot snapshot, Long epochMilli) {
        return Math.min(epochMilli, snapshot.timestampMillis());
    }

    private static /* synthetic */ ConnectorExpression lambda$applyProjection$2(Map newVariables, ConnectorExpression expression) {
        return ApplyProjectionUtil.replaceWithNewVariables((ConnectorExpression)expression, (Map)newVariables);
    }

    private /* synthetic */ void lambda$applyFilter$3(Map unsupported, Table icebergTable, Set partitionSpecIds, Map newEnforced, Map newUnenforced, IcebergColumnHandle columnHandle, Domain domain) {
        if (!ExpressionConverter.isConvertibleToIcebergExpression(domain)) {
            unsupported.put(columnHandle, domain);
        } else if (IcebergUtil.canEnforceColumnConstraintInSpecs(this.typeManager.getTypeOperators(), icebergTable, partitionSpecIds, columnHandle, domain)) {
            newEnforced.put(columnHandle, domain);
        } else if (IcebergMetadataColumn.isMetadataColumnId(columnHandle.getId())) {
            if (columnHandle.isPartitionColumn() || columnHandle.isPathColumn() || columnHandle.isFileModifiedTimeColumn()) {
                newEnforced.put(columnHandle, domain);
            } else {
                unsupported.put(columnHandle, domain);
            }
        } else {
            newUnenforced.put(columnHandle, domain);
        }
    }

    private static /* synthetic */ ImmutableSet lambda$applyFilter$1(Table icebergTable) {
        return ImmutableSet.copyOf(icebergTable.specs().keySet());
    }

    private static /* synthetic */ ImmutableSet lambda$applyFilter$0(Table icebergTable, Long snapshot) {
        return (ImmutableSet)IcebergMetadata.loadAllManifestsFromSnapshot(icebergTable, icebergTable.snapshot(snapshot.longValue())).stream().map(ManifestFile::partitionSpecId).collect(ImmutableSet.toImmutableSet());
    }

    private /* synthetic */ void lambda$getTableHandleForAddFilesFromTable$2(Table icebergTable, io.trino.metastore.Table sourceTable, Set missingDataColumns, Column sourceColumn) {
        Types.NestedField targetColumn = icebergTable.schema().caseInsensitiveFindField(sourceColumn.getName());
        if (targetColumn == null) {
            if (sourceTable.getPartitionColumns().contains(sourceColumn)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, "Partition column '%s' does not exist".formatted(sourceColumn.getName()));
            }
            missingDataColumns.add(sourceColumn.getName());
            return;
        }
        ColumnIdentity columnIdentity = ColumnIdentity.createColumnIdentity(targetColumn);
        Type sourceColumnType = TypeConverter.toIcebergType(this.typeManager.getType(HiveTypeUtil.getTypeSignature((HiveType)sourceColumn.getType(), (HiveTimestampPrecision)HiveTimestampPrecision.DEFAULT_PRECISION)), columnIdentity);
        if (!targetColumn.type().equals((Object)sourceColumnType)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, "Target '%s' column is '%s' type, but got source '%s' type".formatted(targetColumn.name(), targetColumn.type(), sourceColumnType));
        }
    }

    private static /* synthetic */ Iterator lambda$getTableProperties$1(Supplier lazyUniquePartitions) {
        return ((Map)lazyUniquePartitions.get()).entrySet().iterator();
    }

    private /* synthetic */ Map lambda$getTableProperties$0(Table icebergTable, IcebergTableHandle table, TupleDomain enforcedPredicate) {
        Object i$;
        block9: {
            TableScan tableScan = (TableScan)((TableScan)icebergTable.newScan().useSnapshot(table.getSnapshotId().get().longValue()).filter(ExpressionConverter.toIcebergExpression((TupleDomain<IcebergColumnHandle>)enforcedPredicate))).planWith(this.icebergPlanningExecutor);
            CloseableIterable fileScanTasks = tableScan.planFiles();
            try {
                HashMap<StructLikeWrapperWithFieldIdToIndex, PartitionSpec> partitions = new HashMap<StructLikeWrapperWithFieldIdToIndex, PartitionSpec>();
                for (FileScanTask fileScanTask : fileScanTasks) {
                    StructLikeWrapperWithFieldIdToIndex structLikeWrapperWithFieldIdToIndex = StructLikeWrapperWithFieldIdToIndex.createStructLikeWrapper(fileScanTask);
                    partitions.putIfAbsent(structLikeWrapperWithFieldIdToIndex, fileScanTask.spec());
                }
                i$ = partitions;
                if (fileScanTasks == null) break block9;
            }
            catch (Throwable t$) {
                try {
                    if (fileScanTasks != null) {
                        try {
                            fileScanTasks.close();
                        }
                        catch (Throwable x2) {
                            t$.addSuppressed(x2);
                        }
                    }
                    throw t$;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            fileScanTasks.close();
        }
        return i$;
    }

    private static sealed interface TableChangeInfo
    permits NoTableChange, FirstChangeSnapshot, UnknownTableChange, CorruptedTableChange {
    }

    private record NoTableChange() implements TableChangeInfo
    {
    }

    private record FirstChangeSnapshot(Snapshot snapshot) implements TableChangeInfo
    {
        FirstChangeSnapshot {
            Objects.requireNonNull(snapshot, "snapshot is null");
        }
    }

    private record UnknownTableChange() implements TableChangeInfo
    {
    }

    private record CorruptedTableChange() implements TableChangeInfo
    {
    }
}

