/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.json.JsonCodec;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.RawHiveMetastoreFactory;
import io.trino.plugin.iceberg.CommitTaskData;
import io.trino.plugin.iceberg.ForIcebergMetadata;
import io.trino.plugin.iceberg.ForIcebergPlanning;
import io.trino.plugin.iceberg.ForIcebergSplitManager;
import io.trino.plugin.iceberg.IcebergConfig;
import io.trino.plugin.iceberg.IcebergFileSystemFactory;
import io.trino.plugin.iceberg.IcebergMetadata;
import io.trino.plugin.iceberg.TableStatisticsWriter;
import io.trino.plugin.iceberg.catalog.TrinoCatalogFactory;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;

public class IcebergMetadataFactory {
    private final TypeManager typeManager;
    private final CatalogHandle trinoCatalogHandle;
    private final JsonCodec<CommitTaskData> commitTaskCodec;
    private final TrinoCatalogFactory catalogFactory;
    private final IcebergFileSystemFactory fileSystemFactory;
    private final TableStatisticsWriter tableStatisticsWriter;
    private final Optional<HiveMetastoreFactory> metastoreFactory;
    private final boolean addFilesProcedureEnabled;
    private final Predicate<String> allowedExtraProperties;
    private final ExecutorService icebergScanExecutor;
    private final Executor metadataFetchingExecutor;
    private final ExecutorService icebergPlanningExecutor;

    @Inject
    public IcebergMetadataFactory(TypeManager typeManager, CatalogHandle trinoCatalogHandle, JsonCodec<CommitTaskData> commitTaskCodec, TrinoCatalogFactory catalogFactory, IcebergFileSystemFactory fileSystemFactory, TableStatisticsWriter tableStatisticsWriter, @RawHiveMetastoreFactory Optional<HiveMetastoreFactory> metastoreFactory, @ForIcebergSplitManager ExecutorService icebergScanExecutor, @ForIcebergMetadata ExecutorService metadataExecutorService, @ForIcebergPlanning ExecutorService icebergPlanningExecutor, IcebergConfig config) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.trinoCatalogHandle = Objects.requireNonNull(trinoCatalogHandle, "trinoCatalogHandle is null");
        this.commitTaskCodec = Objects.requireNonNull(commitTaskCodec, "commitTaskCodec is null");
        this.catalogFactory = Objects.requireNonNull(catalogFactory, "catalogFactory is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.tableStatisticsWriter = Objects.requireNonNull(tableStatisticsWriter, "tableStatisticsWriter is null");
        this.metastoreFactory = Objects.requireNonNull(metastoreFactory, "metastoreFactory is null");
        this.icebergScanExecutor = Objects.requireNonNull(icebergScanExecutor, "icebergScanExecutor is null");
        this.addFilesProcedureEnabled = config.isAddFilesProcedureEnabled();
        this.allowedExtraProperties = config.getAllowedExtraProperties().equals(ImmutableList.of((Object)"*")) ? string -> true : arg_0 -> ((ImmutableSet)ImmutableSet.copyOf((Collection)Objects.requireNonNull(config.getAllowedExtraProperties(), "allowedExtraProperties is null"))).contains(arg_0);
        this.metadataFetchingExecutor = config.getMetadataParallelism() == 1 ? MoreExecutors.directExecutor() : new BoundedExecutor((Executor)metadataExecutorService, config.getMetadataParallelism());
        this.icebergPlanningExecutor = Objects.requireNonNull(icebergPlanningExecutor, "icebergPlanningExecutor is null");
    }

    public IcebergMetadata create(ConnectorIdentity identity) {
        return new IcebergMetadata(this.typeManager, this.trinoCatalogHandle, this.commitTaskCodec, this.catalogFactory.create(identity), this.fileSystemFactory, this.tableStatisticsWriter, this.metastoreFactory, this.addFilesProcedureEnabled, this.allowedExtraProperties, this.icebergScanExecutor, this.metadataFetchingExecutor, this.icebergPlanningExecutor);
    }
}

