/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.inject.Inject;
import io.trino.plugin.iceberg.IcebergBucketFunction;
import io.trino.plugin.iceberg.IcebergPartitionFunction;
import io.trino.plugin.iceberg.IcebergPartitioningHandle;
import io.trino.plugin.iceberg.IcebergUpdateBucketFunction;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;

public class IcebergNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final TypeOperators typeOperators;

    @Inject
    public IcebergNodePartitioningProvider(TypeManager typeManager) {
        this.typeOperators = typeManager.getTypeOperators();
    }

    public Optional<ConnectorBucketNodeMap> getBucketNodeMapping(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        IcebergPartitioningHandle handle = (IcebergPartitioningHandle)partitioningHandle;
        List<IcebergPartitionFunction> partitionFunctions = handle.partitionFunctions();
        if (partitionFunctions.size() == 1 && partitionFunctions.getFirst().transform() == IcebergPartitionFunction.Transform.BUCKET) {
            return Optional.of(ConnectorBucketNodeMap.createBucketNodeMap((int)partitionFunctions.getFirst().size().orElseThrow()).withCacheKeyHint(handle.getCacheKeyHint()));
        }
        return Optional.empty();
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        IcebergPartitioningHandle handle = (IcebergPartitioningHandle)partitioningHandle;
        if (handle.update()) {
            return new IcebergUpdateBucketFunction(bucketCount);
        }
        return new IcebergBucketFunction(handle, this.typeOperators, bucketCount);
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, int bucketCount) {
        return new IcebergBucketFunction((IcebergPartitioningHandle)partitioningHandle, this.typeOperators, bucketCount);
    }
}

