/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcPredicate;
import io.trino.orc.OrcReader;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcRecordReader;
import io.trino.orc.TupleDomainOrcPredicate;
import io.trino.parquet.Column;
import io.trino.parquet.Field;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.metadata.FileMetadata;
import io.trino.parquet.metadata.ParquetMetadata;
import io.trino.parquet.predicate.PredicateUtils;
import io.trino.parquet.predicate.TupleDomainParquetPredicate;
import io.trino.parquet.reader.MetadataReader;
import io.trino.parquet.reader.ParquetReader;
import io.trino.parquet.reader.RowGroupInfo;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.hive.TransformConnectorPageSource;
import io.trino.plugin.hive.orc.OrcPageSource;
import io.trino.plugin.hive.parquet.ParquetPageSource;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.iceberg.ColumnIdentity;
import io.trino.plugin.iceberg.IcebergAvroPageSource;
import io.trino.plugin.iceberg.IcebergColumnHandle;
import io.trino.plugin.iceberg.IcebergErrorCode;
import io.trino.plugin.iceberg.IcebergFileFormat;
import io.trino.plugin.iceberg.IcebergFileSystemFactory;
import io.trino.plugin.iceberg.IcebergMetadataColumn;
import io.trino.plugin.iceberg.IcebergParquetColumnIOConverter;
import io.trino.plugin.iceberg.IcebergSessionProperties;
import io.trino.plugin.iceberg.IcebergSplit;
import io.trino.plugin.iceberg.IcebergSplitSource;
import io.trino.plugin.iceberg.IcebergTableHandle;
import io.trino.plugin.iceberg.IcebergUtil;
import io.trino.plugin.iceberg.PartitionData;
import io.trino.plugin.iceberg.TrinoOrcDataSource;
import io.trino.plugin.iceberg.delete.DeleteFile;
import io.trino.plugin.iceberg.delete.DeleteManager;
import io.trino.plugin.iceberg.fileio.ForwardingInputFile;
import io.trino.plugin.iceberg.util.OrcIcebergIds;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.ObjLongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.MappedFields;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.joda.time.DateTimeZone;

public class IcebergPageSourceProvider
implements ConnectorPageSourceProvider {
    private static final String AVRO_FIELD_ID = "field-id";
    private static final int MAX_RLE_PAGE_SIZE = 131072;
    private final IcebergFileSystemFactory fileSystemFactory;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final OrcReaderOptions orcReaderOptions;
    private final ParquetReaderOptions parquetReaderOptions;
    private final TypeManager typeManager;
    private final DeleteManager unpartitionedTableDeleteManager;
    private final Map<Integer, Function<PartitionData, PartitionKey>> partitionKeyFactories = new ConcurrentHashMap<Integer, Function<PartitionData, PartitionKey>>();
    private final Map<PartitionKey, DeleteManager> partitionedDeleteManagers = new ConcurrentHashMap<PartitionKey, DeleteManager>();

    public IcebergPageSourceProvider(IcebergFileSystemFactory fileSystemFactory, FileFormatDataSourceStats fileFormatDataSourceStats, OrcReaderOptions orcReaderOptions, ParquetReaderOptions parquetReaderOptions, TypeManager typeManager) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.orcReaderOptions = Objects.requireNonNull(orcReaderOptions, "orcReaderOptions is null");
        this.parquetReaderOptions = Objects.requireNonNull(parquetReaderOptions, "parquetReaderOptions is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.unpartitionedTableDeleteManager = new DeleteManager(typeManager);
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit connectorSplit, ConnectorTableHandle connectorTable, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        IcebergSplit split = (IcebergSplit)connectorSplit;
        List icebergColumns = (List)columns.stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        IcebergTableHandle tableHandle = (IcebergTableHandle)connectorTable;
        org.apache.iceberg.Schema schema = SchemaParser.fromJson((String)tableHandle.getTableSchemaJson());
        PartitionSpec partitionSpec = PartitionSpecParser.fromJson((org.apache.iceberg.Schema)schema, (String)split.getPartitionSpecJson());
        Type[] partitionColumnTypes = (Type[])partitionSpec.fields().stream().map(field -> field.transform().getResultType(schema.findType(field.sourceId()))).toArray(Type[]::new);
        return this.createPageSource(session, icebergColumns, schema, partitionSpec, PartitionData.fromJson(split.getPartitionDataJson(), partitionColumnTypes), split.getDeletes(), dynamicFilter, tableHandle.getUnenforcedPredicate(), split.getFileStatisticsDomain(), split.getPath(), split.getStart(), split.getLength(), split.getFileSize(), split.getFileRecordCount(), split.getPartitionDataJson(), split.getFileFormat(), split.getFileIoProperties(), split.getDataSequenceNumber(), tableHandle.getNameMappingJson().map(NameMappingParser::fromJson));
    }

    public ConnectorPageSource createPageSource(ConnectorSession session, List<IcebergColumnHandle> icebergColumns, org.apache.iceberg.Schema tableSchema, PartitionSpec partitionSpec, PartitionData partitionData, List<DeleteFile> deletes, DynamicFilter dynamicFilter, TupleDomain<IcebergColumnHandle> unenforcedPredicate, TupleDomain<IcebergColumnHandle> fileStatisticsDomain, String path, long start, long length, long fileSize, long fileRecordCount, String partitionDataJson, IcebergFileFormat fileFormat, Map<String, String> fileIoProperties, long dataSequenceNumber, Optional<NameMapping> nameMapping) {
        Map<Integer, Optional<String>> partitionKeys = IcebergUtil.getPartitionKeys(partitionData, partitionSpec);
        TupleDomain<IcebergColumnHandle> effectivePredicate = this.getUnenforcedPredicate(tableSchema, partitionKeys, dynamicFilter, unenforcedPredicate, fileStatisticsDomain);
        if (effectivePredicate.isNone()) {
            return new EmptyPageSource();
        }
        String partition = partitionSpec.partitionToPath((StructLike)partitionData);
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session.getIdentity(), fileIoProperties);
        TrinoInputFile inputFile = IcebergSessionProperties.isUseFileSizeFromMetadata(session) ? fileSystem.newInputFile(Location.of((String)path), fileSize) : fileSystem.newInputFile(Location.of((String)path));
        try {
            if (effectivePredicate.isAll() && start == 0L && length == inputFile.length() && deletes.isEmpty() && icebergColumns.stream().allMatch(column -> partitionKeys.containsKey(column.getId()))) {
                return IcebergPageSourceProvider.generatePages(fileRecordCount, icebergColumns, partitionKeys);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ArrayList<IcebergColumnHandle> requiredColumns = new ArrayList<IcebergColumnHandle>(icebergColumns);
        Set<IcebergColumnHandle> deleteFilterRequiredColumns = this.requiredColumnsForDeletes(tableSchema, deletes);
        deleteFilterRequiredColumns.stream().filter(Predicate.not(icebergColumns::contains)).forEach(requiredColumns::add);
        ReaderPageSourceWithRowPositions readerPageSourceWithRowPositions = this.createDataPageSource(session, inputFile, start, length, fileSize, partitionSpec.specId(), partitionDataJson, fileFormat, tableSchema, requiredColumns, effectivePredicate, nameMapping, partition, partitionKeys);
        ConnectorPageSource pageSource = readerPageSourceWithRowPositions.pageSource();
        if (!deletes.isEmpty()) {
            com.google.common.base.Supplier deletePredicate = Suppliers.memoize(() -> this.getDeleteManager(partitionSpec, partitionData).getDeletePredicate(path, dataSequenceNumber, deletes, requiredColumns, tableSchema, readerPageSourceWithRowPositions, (deleteFile, deleteColumns, tupleDomain) -> this.openDeletes(session, fileSystem, deleteFile, deleteColumns, (TupleDomain<IcebergColumnHandle>)tupleDomain)));
            pageSource = TransformConnectorPageSource.create((ConnectorPageSource)pageSource, arg_0 -> IcebergPageSourceProvider.lambda$createPageSource$5((Supplier)deletePredicate, icebergColumns, arg_0));
        }
        return pageSource;
    }

    private DeleteManager getDeleteManager(PartitionSpec partitionSpec, PartitionData partitionData) {
        if (partitionSpec.isUnpartitioned()) {
            return this.unpartitionedTableDeleteManager;
        }
        Types.StructType structType = partitionSpec.partitionType();
        PartitionKey partitionKey = (PartitionKey)this.partitionKeyFactories.computeIfAbsent(partitionSpec.specId(), key -> {
            StructLikeWrapper templateWrapper = StructLikeWrapper.forType((Types.StructType)structType);
            return data -> new PartitionKey((int)key, templateWrapper.copyFor((StructLike)data));
        }).apply(partitionData);
        return this.partitionedDeleteManagers.computeIfAbsent(partitionKey, ignored -> new DeleteManager(this.typeManager));
    }

    private TupleDomain<IcebergColumnHandle> getUnenforcedPredicate(org.apache.iceberg.Schema tableSchema, Map<Integer, Optional<String>> partitionKeys, DynamicFilter dynamicFilter, TupleDomain<IcebergColumnHandle> unenforcedPredicate, TupleDomain<IcebergColumnHandle> fileStatisticsDomain) {
        return this.prunePredicate(tableSchema, partitionKeys, (TupleDomain<IcebergColumnHandle>)TupleDomain.intersect((List)ImmutableList.of(unenforcedPredicate, fileStatisticsDomain, (Object)dynamicFilter.getCurrentPredicate().transformKeys(IcebergColumnHandle.class::cast))), fileStatisticsDomain).simplify(1000);
    }

    private TupleDomain<IcebergColumnHandle> prunePredicate(org.apache.iceberg.Schema tableSchema, Map<Integer, Optional<String>> partitionKeys, TupleDomain<IcebergColumnHandle> unenforcedPredicate, TupleDomain<IcebergColumnHandle> fileStatisticsDomain) {
        com.google.common.base.Supplier partitionValues;
        if (unenforcedPredicate.isAll() || unenforcedPredicate.isNone()) {
            return unenforcedPredicate;
        }
        Set partitionColumns = (Set)partitionKeys.keySet().stream().map(fieldId -> IcebergUtil.getColumnHandle(tableSchema.findField(fieldId.intValue()), this.typeManager)).collect(ImmutableSet.toImmutableSet());
        if (!IcebergSplitSource.partitionMatchesPredicate(partitionColumns, (Supplier<Map<ColumnHandle, NullableValue>>)(partitionValues = Suppliers.memoize(() -> IcebergUtil.getPartitionValues(partitionColumns, partitionKeys))), unenforcedPredicate)) {
            return TupleDomain.none();
        }
        return unenforcedPredicate.filter((columnHandle, domain) -> !partitionKeys.containsKey(columnHandle.getId())).filter((handle, domain) -> !domain.contains(fileStatisticsDomain.getDomain(handle, domain.getType())));
    }

    private Set<IcebergColumnHandle> requiredColumnsForDeletes(org.apache.iceberg.Schema schema, List<DeleteFile> deletes) {
        ImmutableSet.Builder requiredColumns = ImmutableSet.builder();
        for (DeleteFile deleteFile : deletes) {
            if (deleteFile.content() == FileContent.POSITION_DELETES) {
                requiredColumns.add((Object)IcebergUtil.getColumnHandle(MetadataColumns.ROW_POSITION, this.typeManager));
                continue;
            }
            if (deleteFile.content() != FileContent.EQUALITY_DELETES) continue;
            deleteFile.equalityFieldIds().stream().map(id -> IcebergUtil.getColumnHandle(schema.findField(id.intValue()), this.typeManager)).forEach(arg_0 -> ((ImmutableSet.Builder)requiredColumns).add(arg_0));
        }
        return requiredColumns.build();
    }

    private ConnectorPageSource openDeletes(ConnectorSession session, TrinoFileSystem fileSystem, DeleteFile delete, List<IcebergColumnHandle> columns, TupleDomain<IcebergColumnHandle> tupleDomain) {
        return this.createDataPageSource(session, fileSystem.newInputFile(Location.of((String)delete.path()), delete.fileSizeInBytes()), 0L, delete.fileSizeInBytes(), delete.fileSizeInBytes(), 0, "", IcebergFileFormat.fromIceberg(delete.format()), IcebergUtil.schemaFromHandles(columns), columns, tupleDomain, Optional.empty(), "", (Map<Integer, Optional<String>>)ImmutableMap.of()).pageSource();
    }

    private ReaderPageSourceWithRowPositions createDataPageSource(ConnectorSession session, TrinoInputFile inputFile, long start, long length, long fileSize, int partitionSpecId, String partitionData, IcebergFileFormat fileFormat, org.apache.iceberg.Schema fileSchema, List<IcebergColumnHandle> dataColumns, TupleDomain<IcebergColumnHandle> predicate, Optional<NameMapping> nameMapping, String partition, Map<Integer, Optional<String>> partitionKeys) {
        return switch (fileFormat) {
            default -> throw new MatchException(null, null);
            case IcebergFileFormat.ORC -> IcebergPageSourceProvider.createOrcPageSource(inputFile, start, length, partitionSpecId, partitionData, dataColumns, predicate, this.orcReaderOptions.withMaxMergeDistance(IcebergSessionProperties.getOrcMaxMergeDistance(session)).withMaxBufferSize(IcebergSessionProperties.getOrcMaxBufferSize(session)).withStreamBufferSize(IcebergSessionProperties.getOrcStreamBufferSize(session)).withTinyStripeThreshold(IcebergSessionProperties.getOrcTinyStripeThreshold(session)).withMaxReadBlockSize(IcebergSessionProperties.getOrcMaxReadBlockSize(session)).withLazyReadSmallRanges(IcebergSessionProperties.getOrcLazyReadSmallRanges(session)).withNestedLazy(IcebergSessionProperties.isOrcNestedLazy(session)).withBloomFiltersEnabled(IcebergSessionProperties.isOrcBloomFiltersEnabled(session)), this.fileFormatDataSourceStats, this.typeManager, nameMapping, partition, partitionKeys);
            case IcebergFileFormat.PARQUET -> IcebergPageSourceProvider.createParquetPageSource(inputFile, start, length, fileSize, partitionSpecId, partitionData, dataColumns, ParquetReaderOptions.builder((ParquetReaderOptions)this.parquetReaderOptions).withMaxReadBlockSize(IcebergSessionProperties.getParquetMaxReadBlockSize(session)).withMaxReadBlockRowCount(IcebergSessionProperties.getParquetMaxReadBlockRowCount(session)).withSmallFileThreshold(IcebergSessionProperties.getParquetSmallFileThreshold(session)).withIgnoreStatistics(IcebergSessionProperties.isParquetIgnoreStatistics(session)).withBloomFilter(IcebergSessionProperties.useParquetBloomFilter(session)).withUseColumnIndex(false).withVectorizedDecodingEnabled(IcebergSessionProperties.isParquetVectorizedDecodingEnabled(session)).build(), predicate, this.fileFormatDataSourceStats, nameMapping, partition, partitionKeys);
            case IcebergFileFormat.AVRO -> IcebergPageSourceProvider.createAvroPageSource(inputFile, start, length, partitionSpecId, partitionData, fileSchema, nameMapping, partition, dataColumns);
        };
    }

    private static ConnectorPageSource generatePages(final long totalRowCount, List<IcebergColumnHandle> icebergColumns, Map<Integer, Optional<String>> partitionKeys) {
        final int maxPageSize = 131072;
        Block[] pageBlocks = new Block[icebergColumns.size()];
        for (int i = 0; i < icebergColumns.size(); ++i) {
            IcebergColumnHandle column = icebergColumns.get(i);
            io.trino.spi.type.Type trinoType = column.getType();
            Object partitionValue = IcebergUtil.deserializePartitionValue(trinoType, partitionKeys.get(column.getId()).orElse(null), column.getName());
            pageBlocks[i] = RunLengthEncodedBlock.create((Block)Utils.nativeValueToBlock((io.trino.spi.type.Type)trinoType, (Object)partitionValue), (int)maxPageSize);
        }
        final Page maxPage = new Page(maxPageSize, pageBlocks);
        return new FixedPageSource((Iterator)new AbstractIterator<Page>(){
            private long rowIndex;

            protected Page computeNext() {
                if (this.rowIndex == totalRowCount) {
                    return (Page)this.endOfData();
                }
                int pageSize = Math.toIntExact(Math.min((long)maxPageSize, totalRowCount - this.rowIndex));
                Page page = maxPage.getRegion(0, pageSize);
                this.rowIndex += (long)pageSize;
                return page;
            }
        }, maxPage.getRetainedSizeInBytes());
    }

    private static ReaderPageSourceWithRowPositions createOrcPageSource(TrinoInputFile inputFile, long start, long length, int partitionSpecId, String partitionData, List<IcebergColumnHandle> columns, TupleDomain<IcebergColumnHandle> effectivePredicate, OrcReaderOptions options, FileFormatDataSourceStats stats, TypeManager typeManager, Optional<NameMapping> nameMapping, String partition, Map<Integer, Optional<String>> partitionKeys) {
        TrinoOrcDataSource orcDataSource = null;
        try {
            orcDataSource = new TrinoOrcDataSource(inputFile, options, stats);
            OrcReader reader = (OrcReader)OrcReader.createOrcReader((OrcDataSource)orcDataSource, (OrcReaderOptions)options).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, "ORC file is zero length"));
            Map<Integer, OrcColumn> fileColumnsByIcebergId = OrcIcebergIds.fileColumnsByIcebergId(reader, nameMapping);
            TupleDomainOrcPredicate.TupleDomainOrcPredicateBuilder predicateBuilder = TupleDomainOrcPredicate.builder().setBloomFiltersEnabled(options.isBloomFiltersEnabled());
            Map effectivePredicateDomains = (Map)effectivePredicate.getDomains().orElseThrow(() -> new IllegalArgumentException("Effective predicate is none"));
            for (IcebergColumnHandle column2 : columns) {
                for (Map.Entry domainEntry : effectivePredicateDomains.entrySet()) {
                    IcebergColumnHandle predicateColumn = (IcebergColumnHandle)domainEntry.getKey();
                    OrcColumn predicateOrcColumn = fileColumnsByIcebergId.get(predicateColumn.getId());
                    if (predicateOrcColumn == null || !column2.getBaseColumnIdentity().equals(predicateColumn.getBaseColumnIdentity())) continue;
                    predicateBuilder.addColumn(predicateOrcColumn.getColumnId(), (Domain)domainEntry.getValue());
                }
            }
            Map projectionsByFieldId = columns.stream().collect(Collectors.groupingBy(column -> column.getBaseColumnIdentity().getId(), Collectors.mapping(IcebergColumnHandle::getPath, Collectors.toUnmodifiableList())));
            ArrayList<IcebergColumnHandle> baseColumns = new ArrayList<IcebergColumnHandle>(columns.size());
            HashMap<Integer, Integer> baseColumnIdToOrdinal = new HashMap<Integer, Integer>();
            ArrayList<OrcColumn> fileReadColumns = new ArrayList<OrcColumn>(columns.size());
            ArrayList<io.trino.spi.type.Type> fileReadTypes = new ArrayList<io.trino.spi.type.Type>(columns.size());
            ArrayList<OrcReader.ProjectedLayout> projectedLayouts = new ArrayList<OrcReader.ProjectedLayout>(columns.size());
            TransformConnectorPageSource.Builder transforms = TransformConnectorPageSource.builder();
            boolean appendRowNumberColumn = false;
            for (IcebergColumnHandle column3 : columns) {
                if (column3.isIsDeletedColumn()) {
                    transforms.constantValue(Utils.nativeValueToBlock((io.trino.spi.type.Type)BooleanType.BOOLEAN, (Object)false));
                    continue;
                }
                if (partitionKeys.containsKey(column3.getId())) {
                    io.trino.spi.type.Type trinoType = column3.getType();
                    transforms.constantValue(Utils.nativeValueToBlock((io.trino.spi.type.Type)trinoType, (Object)IcebergUtil.deserializePartitionValue(trinoType, partitionKeys.get(column3.getId()).orElse(null), column3.getName())));
                    continue;
                }
                if (column3.isPartitionColumn()) {
                    transforms.constantValue(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.PARTITION.getType(), (Object)Slices.utf8Slice((String)partition)));
                    continue;
                }
                if (column3.isPathColumn()) {
                    transforms.constantValue(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_PATH.getType(), (Object)Slices.utf8Slice((String)inputFile.location().toString())));
                    continue;
                }
                if (column3.isFileModifiedTimeColumn()) {
                    transforms.constantValue(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_MODIFIED_TIME.getType(), (Object)DateTimeEncoding.packDateTimeWithZone((long)inputFile.lastModified().toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY)));
                    continue;
                }
                if (column3.isMergeRowIdColumn()) {
                    appendRowNumberColumn = true;
                    transforms.transform(MergeRowIdTransform.create(Slices.utf8Slice((String)inputFile.location().toString()), partitionSpecId, Slices.utf8Slice((String)partitionData)));
                    continue;
                }
                if (column3.isRowPositionColumn()) {
                    appendRowNumberColumn = true;
                    transforms.transform((Function)new GetRowPositionFromSource());
                    continue;
                }
                if (!fileColumnsByIcebergId.containsKey(column3.getBaseColumnIdentity().getId())) {
                    transforms.constantValue((Block)column3.getType().createNullBlock());
                    continue;
                }
                IcebergColumnHandle baseColumn = column3.getBaseColumn();
                Integer ordinal = (Integer)baseColumnIdToOrdinal.get(baseColumn.getId());
                if (ordinal == null) {
                    ordinal = baseColumns.size();
                    baseColumns.add(baseColumn);
                    baseColumnIdToOrdinal.put(baseColumn.getId(), ordinal);
                    OrcColumn orcBaseColumn = Objects.requireNonNull(fileColumnsByIcebergId.get(baseColumn.getId()));
                    fileReadColumns.add(orcBaseColumn);
                    fileReadTypes.add(IcebergPageSourceProvider.getOrcReadType(baseColumn.getType(), typeManager));
                    projectedLayouts.add(IcebergOrcProjectedLayout.createProjectedLayout(orcBaseColumn, projectionsByFieldId.get(baseColumn.getId())));
                }
                if (column3.isBaseColumn()) {
                    transforms.column(ordinal.intValue());
                    continue;
                }
                transforms.dereferenceField((List)ImmutableList.builder().add((Object)ordinal).addAll(IcebergPageSourceProvider.applyProjection(column3, baseColumn)).build());
            }
            AggregatedMemoryContext memoryUsage = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
            OrcDataSourceId orcDataSourceId = orcDataSource.getId();
            OrcRecordReader recordReader = reader.createRecordReader(fileReadColumns, fileReadTypes, projectedLayouts, appendRowNumberColumn, (OrcPredicate)predicateBuilder.build(), start, length, DateTimeZone.UTC, memoryUsage, 1, exception -> IcebergPageSourceProvider.handleException(orcDataSourceId, exception), (OrcReader.FieldMapperFactory)new IdBasedFieldMapperFactory(baseColumns));
            OrcPageSource pageSource = new OrcPageSource(recordReader, (OrcDataSource)orcDataSource, Optional.empty(), Optional.empty(), memoryUsage, stats, reader.getCompressionKind());
            pageSource = transforms.build((ConnectorPageSource)pageSource);
            return new ReaderPageSourceWithRowPositions((ConnectorPageSource)pageSource, recordReader.getStartRowPosition(), recordReader.getEndRowPosition());
        }
        catch (IOException | RuntimeException e) {
            block20: {
                if (orcDataSource != null) {
                    try {
                        orcDataSource.close();
                    }
                    catch (IOException ex) {
                        if (e.equals(ex)) break block20;
                        e.addSuppressed(ex);
                    }
                }
            }
            if (e instanceof TrinoException) {
                TrinoException trinoException = (TrinoException)((Object)e);
                throw trinoException;
            }
            if (e instanceof OrcCorruptionException) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)e);
            }
            String message = "Error opening Iceberg split %s (offset=%s, length=%s): %s".formatted(inputFile.location(), start, length, e.getMessage());
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static List<Integer> applyProjection(ColumnHandle expectedColumnHandle, ColumnHandle readColumnHandle) {
        IcebergColumnHandle expectedColumn = (IcebergColumnHandle)expectedColumnHandle;
        IcebergColumnHandle readColumn = (IcebergColumnHandle)readColumnHandle;
        Preconditions.checkState((boolean)readColumn.isBaseColumn(), (Object)"Read column path must be a base column");
        ImmutableList.Builder dereferenceChain = ImmutableList.builder();
        ColumnIdentity columnIdentity = readColumn.getColumnIdentity();
        for (Integer fieldId : expectedColumn.getPath()) {
            ColumnIdentity nextChild = columnIdentity.getChildByFieldId(fieldId);
            dereferenceChain.add((Object)columnIdentity.getChildIndexByFieldId(fieldId));
            columnIdentity = nextChild;
        }
        return dereferenceChain.build();
    }

    private static Integer getIcebergFieldId(OrcColumn column) {
        String icebergId = (String)column.getAttributes().get("iceberg.id");
        Verify.verify((icebergId != null ? 1 : 0) != 0, (String)String.format("column %s does not have %s property", column, "iceberg.id"), (Object[])new Object[0]);
        return Integer.valueOf(icebergId);
    }

    private static io.trino.spi.type.Type getOrcReadType(io.trino.spi.type.Type columnType, TypeManager typeManager) {
        if (columnType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)columnType;
            return new ArrayType(IcebergPageSourceProvider.getOrcReadType(arrayType.getElementType(), typeManager));
        }
        if (columnType instanceof MapType) {
            MapType mapType = (MapType)columnType;
            io.trino.spi.type.Type keyType = IcebergPageSourceProvider.getOrcReadType(mapType.getKeyType(), typeManager);
            io.trino.spi.type.Type valueType = IcebergPageSourceProvider.getOrcReadType(mapType.getValueType(), typeManager);
            return new MapType(keyType, valueType, typeManager.getTypeOperators());
        }
        if (columnType instanceof RowType) {
            RowType rowType = (RowType)columnType;
            return RowType.from((List)((List)rowType.getFields().stream().map(field -> new RowType.Field(field.getName(), IcebergPageSourceProvider.getOrcReadType(field.getType(), typeManager))).collect(ImmutableList.toImmutableList())));
        }
        return columnType;
    }

    private static ReaderPageSourceWithRowPositions createParquetPageSource(TrinoInputFile inputFile, long start, long length, long fileSize, int partitionSpecId, String partitionData, List<IcebergColumnHandle> columns, ParquetReaderOptions options, TupleDomain<IcebergColumnHandle> effectivePredicate, FileFormatDataSourceStats fileFormatDataSourceStats, Optional<NameMapping> nameMapping, String partition, Map<Integer, Optional<String>> partitionKeys) {
        AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        ParquetDataSource dataSource = null;
        try {
            dataSource = ParquetPageSourceFactory.createDataSource((TrinoInputFile)inputFile, (OptionalLong)OptionalLong.of(fileSize), (ParquetReaderOptions)options, (AggregatedMemoryContext)memoryContext, (FileFormatDataSourceStats)fileFormatDataSourceStats);
            ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)dataSource, Optional.empty());
            FileMetadata fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            if (nameMapping.isPresent() && !ParquetSchemaUtil.hasIds((MessageType)fileSchema)) {
                fileSchema = ParquetSchemaUtil.applyNameMapping((MessageType)fileSchema, (NameMapping)IcebergPageSourceProvider.convertToLowercase(nameMapping.get()));
            }
            Map<Integer, org.apache.parquet.schema.Type> parquetIdToFieldName = IcebergPageSourceProvider.createParquetIdToFieldMapping(fileSchema);
            MessageType requestedSchema = IcebergPageSourceProvider.getMessageType(columns, fileSchema.getName(), parquetIdToFieldName);
            Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)requestedSchema);
            TupleDomain<ColumnDescriptor> parquetTupleDomain = options.isIgnoreStatistics() ? TupleDomain.all() : IcebergPageSourceProvider.getParquetTupleDomain(descriptorsByPath, effectivePredicate);
            TupleDomainParquetPredicate parquetPredicate = PredicateUtils.buildPredicate((MessageType)requestedSchema, parquetTupleDomain, (Map)descriptorsByPath, (DateTimeZone)DateTimeZone.UTC);
            MessageColumnIO messageColumnIO = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)requestedSchema);
            HashMap<Integer, Integer> baseColumnIdToOrdinal = new HashMap<Integer, Integer>();
            TransformConnectorPageSource.Builder transforms = TransformConnectorPageSource.builder();
            boolean appendRowNumberColumn = false;
            int nextOrdinal = 0;
            ImmutableList.Builder parquetColumnFieldsBuilder = ImmutableList.builder();
            for (IcebergColumnHandle column : columns) {
                if (column.isIsDeletedColumn()) {
                    transforms.constantValue(Utils.nativeValueToBlock((io.trino.spi.type.Type)BooleanType.BOOLEAN, (Object)false));
                    continue;
                }
                if (partitionKeys.containsKey(column.getId())) {
                    io.trino.spi.type.Type trinoType = column.getType();
                    transforms.constantValue(Utils.nativeValueToBlock((io.trino.spi.type.Type)trinoType, (Object)IcebergUtil.deserializePartitionValue(trinoType, partitionKeys.get(column.getId()).orElse(null), column.getName())));
                    continue;
                }
                if (column.isPartitionColumn()) {
                    transforms.constantValue(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.PARTITION.getType(), (Object)Slices.utf8Slice((String)partition)));
                    continue;
                }
                if (column.isPathColumn()) {
                    transforms.constantValue(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_PATH.getType(), (Object)Slices.utf8Slice((String)inputFile.location().toString())));
                    continue;
                }
                if (column.isFileModifiedTimeColumn()) {
                    transforms.constantValue(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_MODIFIED_TIME.getType(), (Object)DateTimeEncoding.packDateTimeWithZone((long)inputFile.lastModified().toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY)));
                    continue;
                }
                if (column.isMergeRowIdColumn()) {
                    appendRowNumberColumn = true;
                    transforms.transform(MergeRowIdTransform.create(Slices.utf8Slice((String)inputFile.location().toString()), partitionSpecId, Slices.utf8Slice((String)partitionData)));
                    continue;
                }
                if (column.isRowPositionColumn()) {
                    appendRowNumberColumn = true;
                    transforms.transform((Function)new GetRowPositionFromSource());
                    continue;
                }
                if (!parquetIdToFieldName.containsKey(column.getBaseColumn().getId())) {
                    transforms.constantValue((Block)column.getType().createNullBlock());
                    continue;
                }
                IcebergColumnHandle baseColumn = column.getBaseColumn();
                Integer ordinal = (Integer)baseColumnIdToOrdinal.get(baseColumn.getId());
                if (ordinal == null) {
                    String parquetFieldName = Objects.requireNonNull(parquetIdToFieldName.get(baseColumn.getId())).getName();
                    Optional<Field> field = IcebergParquetColumnIOConverter.constructField(new IcebergParquetColumnIOConverter.FieldContext(baseColumn.getType(), baseColumn.getColumnIdentity()), messageColumnIO.getChild(parquetFieldName));
                    if (field.isEmpty()) {
                        transforms.constantValue((Block)column.getType().createNullBlock());
                        continue;
                    }
                    ordinal = nextOrdinal;
                    ++nextOrdinal;
                    baseColumnIdToOrdinal.put(baseColumn.getId(), ordinal);
                    parquetColumnFieldsBuilder.add((Object)new Column(parquetFieldName, field.get()));
                }
                if (column.isBaseColumn()) {
                    transforms.column(ordinal.intValue());
                    continue;
                }
                transforms.dereferenceField((List)ImmutableList.builder().add((Object)ordinal).addAll(IcebergPageSourceProvider.applyProjection(column, baseColumn)).build());
            }
            List rowGroups = PredicateUtils.getFilteredRowGroups((long)start, (long)length, (ParquetDataSource)dataSource, (ParquetMetadata)parquetMetadata, (List)ImmutableList.of(parquetTupleDomain), (List)ImmutableList.of((Object)parquetPredicate), (Map)descriptorsByPath, (DateTimeZone)DateTimeZone.UTC, (int)1000, (ParquetReaderOptions)options);
            ParquetDataSourceId dataSourceId = dataSource.getId();
            ParquetReader parquetReader = new ParquetReader(Optional.ofNullable(fileMetaData.getCreatedBy()), (List)parquetColumnFieldsBuilder.build(), appendRowNumberColumn, rowGroups, dataSource, DateTimeZone.UTC, memoryContext, options, exception -> IcebergPageSourceProvider.handleException(dataSourceId, exception), Optional.empty(), Optional.empty());
            ParquetPageSource pageSource = new ParquetPageSource(parquetReader);
            pageSource = transforms.build((ConnectorPageSource)pageSource);
            Optional<Long> startRowPosition = Optional.empty();
            Optional<Long> endRowPosition = Optional.empty();
            if (!rowGroups.isEmpty()) {
                startRowPosition = Optional.of(((RowGroupInfo)rowGroups.getFirst()).fileRowOffset());
                RowGroupInfo lastRowGroup = (RowGroupInfo)rowGroups.getLast();
                endRowPosition = Optional.of(lastRowGroup.fileRowOffset() + lastRowGroup.prunedBlockMetadata().getRowCount());
            }
            return new ReaderPageSourceWithRowPositions((ConnectorPageSource)pageSource, startRowPosition, endRowPosition);
        }
        catch (IOException | RuntimeException e) {
            block21: {
                try {
                    if (dataSource != null) {
                        dataSource.close();
                    }
                }
                catch (IOException ex) {
                    if (e.equals(ex)) break block21;
                    e.addSuppressed(ex);
                }
            }
            if (e instanceof TrinoException) {
                TrinoException trinoException = (TrinoException)((Object)e);
                throw trinoException;
            }
            if (e instanceof ParquetCorruptionException) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)e);
            }
            String message = "Error opening Iceberg split %s (offset=%s, length=%s): %s".formatted(inputFile.location(), start, length, e.getMessage());
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static Map<Integer, org.apache.parquet.schema.Type> createParquetIdToFieldMapping(MessageType fileSchema) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        IcebergPageSourceProvider.addParquetIdToFieldMapping((org.apache.parquet.schema.Type)fileSchema, (ImmutableMap.Builder<Integer, org.apache.parquet.schema.Type>)builder);
        return builder.buildOrThrow();
    }

    private static void addParquetIdToFieldMapping(org.apache.parquet.schema.Type type, ImmutableMap.Builder<Integer, org.apache.parquet.schema.Type> builder) {
        if (type.getId() != null) {
            builder.put((Object)type.getId().intValue(), (Object)type);
        }
        if (!(type instanceof PrimitiveType)) {
            if (type instanceof GroupType) {
                GroupType groupType = (GroupType)type;
                for (org.apache.parquet.schema.Type field : groupType.getFields()) {
                    IcebergPageSourceProvider.addParquetIdToFieldMapping(field, builder);
                }
            } else {
                throw new IllegalStateException("Unsupported field type: " + String.valueOf(type));
            }
        }
    }

    private static MessageType getMessageType(List<IcebergColumnHandle> regularColumns, String fileSchemaName, Map<Integer, org.apache.parquet.schema.Type> parquetIdToField) {
        return IcebergPageSourceProvider.projectSufficientColumns(regularColumns).stream().map(column -> IcebergPageSourceProvider.getColumnType(column, parquetIdToField)).filter(Optional::isPresent).map(Optional::get).map(type -> new MessageType(fileSchemaName, new org.apache.parquet.schema.Type[]{type})).reduce(MessageType::union).orElse(new MessageType(fileSchemaName, (List)ImmutableList.of()));
    }

    private static ReaderPageSourceWithRowPositions createAvroPageSource(TrinoInputFile inputFile, long start, long length, int partitionSpecId, String partitionData, org.apache.iceberg.Schema fileSchema, Optional<NameMapping> nameMapping, String partition, List<IcebergColumnHandle> columns) {
        ReaderPageSourceWithRowPositions readerPageSourceWithRowPositions;
        ForwardingInputFile file = new ForwardingInputFile(inputFile);
        OptionalLong fileModifiedTime = OptionalLong.empty();
        try {
            if (columns.stream().anyMatch(IcebergColumnHandle::isFileModifiedTimeColumn)) {
                fileModifiedTime = OptionalLong.of(inputFile.lastModified().toEpochMilli());
            }
        }
        catch (IOException | UncheckedIOException e) {
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, (Throwable)e);
        }
        DataFileStream avroFileReader = new DataFileStream((InputStream)file.newStream(), (DatumReader)new GenericDatumReader());
        try {
            Schema avroSchema = avroFileReader.getSchema();
            List fileFields = avroSchema.getFields();
            if (nameMapping.isPresent() && fileFields.stream().noneMatch(IcebergPageSourceProvider::hasId)) {
                fileFields = (List)fileFields.stream().map(field -> IcebergPageSourceProvider.setMissingFieldId(field, (NameMapping)nameMapping.get(), (List<String>)ImmutableList.of((Object)field.name()))).collect(ImmutableList.toImmutableList());
            }
            Map<Integer, Schema.Field> fileColumnsByIcebergId = IcebergPageSourceProvider.mapIdsToAvroFields(fileFields);
            ImmutableList.Builder columnNames = ImmutableList.builder();
            ImmutableList.Builder columnTypes = ImmutableList.builder();
            TransformConnectorPageSource.Builder transforms = TransformConnectorPageSource.builder();
            boolean appendRowNumberColumn = false;
            HashMap<Integer, Integer> baseColumnIdToOrdinal = new HashMap<Integer, Integer>();
            int nextOrdinal = 0;
            for (IcebergColumnHandle column : columns) {
                if (column.isPartitionColumn()) {
                    transforms.constantValue(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.PARTITION.getType(), (Object)Slices.utf8Slice((String)partition)));
                    continue;
                }
                if (column.isPathColumn()) {
                    transforms.constantValue(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_PATH.getType(), (Object)Slices.utf8Slice((String)file.location())));
                    continue;
                }
                if (column.isFileModifiedTimeColumn()) {
                    transforms.constantValue(Utils.nativeValueToBlock((io.trino.spi.type.Type)IcebergMetadataColumn.FILE_MODIFIED_TIME.getType(), (Object)DateTimeEncoding.packDateTimeWithZone((long)fileModifiedTime.orElseThrow(), (TimeZoneKey)TimeZoneKey.UTC_KEY)));
                    continue;
                }
                if (column.isMergeRowIdColumn()) {
                    appendRowNumberColumn = true;
                    transforms.transform(MergeRowIdTransform.create(Slices.utf8Slice((String)file.location()), partitionSpecId, Slices.utf8Slice((String)partitionData)));
                    continue;
                }
                if (column.isRowPositionColumn()) {
                    appendRowNumberColumn = true;
                    transforms.transform((Function)new GetRowPositionFromSource());
                    continue;
                }
                if (!fileColumnsByIcebergId.containsKey(column.getBaseColumn().getId())) {
                    transforms.constantValue(Utils.nativeValueToBlock((io.trino.spi.type.Type)column.getType(), null));
                    continue;
                }
                IcebergColumnHandle baseColumn = column.getBaseColumn();
                Integer ordinal = (Integer)baseColumnIdToOrdinal.get(baseColumn.getId());
                if (ordinal == null) {
                    ordinal = nextOrdinal;
                    ++nextOrdinal;
                    baseColumnIdToOrdinal.put(baseColumn.getId(), ordinal);
                    columnNames.add((Object)baseColumn.getName());
                    columnTypes.add((Object)baseColumn.getType());
                }
                if (column.isBaseColumn()) {
                    transforms.column(ordinal.intValue());
                    continue;
                }
                transforms.dereferenceField((List)ImmutableList.builder().add((Object)ordinal).addAll(IcebergPageSourceProvider.applyProjection(column, baseColumn)).build());
            }
            IcebergAvroPageSource pageSource = new IcebergAvroPageSource(file, start, length, fileSchema, nameMapping, (List<String>)columnNames.build(), (List<io.trino.spi.type.Type>)columnTypes.build(), appendRowNumberColumn, AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
            pageSource = transforms.build((ConnectorPageSource)pageSource);
            readerPageSourceWithRowPositions = new ReaderPageSourceWithRowPositions(pageSource, Optional.empty(), Optional.empty());
        }
        catch (Throwable throwable) {
            try {
                try {
                    avroFileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | UncheckedIOException e) {
                throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
        }
        avroFileReader.close();
        return readerPageSourceWithRowPositions;
    }

    private static boolean hasId(Schema.Field field) {
        return AvroSchemaUtil.hasFieldId((Schema.Field)field);
    }

    private static Schema.Field setMissingFieldId(Schema.Field field, NameMapping nameMapping, List<String> qualifiedPath) {
        MappedField mappedField = nameMapping.find(qualifiedPath);
        Schema schema = field.schema();
        if (mappedField != null && mappedField.id() != null) {
            field.addProp(AVRO_FIELD_ID, (Object)mappedField.id());
        }
        return new Schema.Field(field, schema);
    }

    private static Map<Integer, Schema.Field> mapIdsToAvroFields(List<Schema.Field> fields) {
        ImmutableMap.Builder fieldsById = ImmutableMap.builder();
        for (Schema.Field field : fields) {
            if (!AvroSchemaUtil.hasFieldId((Schema.Field)field)) continue;
            fieldsById.put((Object)AvroSchemaUtil.getFieldId((Schema.Field)field), (Object)field);
        }
        return fieldsById.buildOrThrow();
    }

    private static NameMapping convertToLowercase(NameMapping nameMapping) {
        return NameMapping.of(IcebergPageSourceProvider.convertToLowercase(nameMapping.asMappedFields().fields()));
    }

    private static MappedFields convertToLowercase(MappedFields mappedFields) {
        if (mappedFields == null) {
            return null;
        }
        return MappedFields.of(IcebergPageSourceProvider.convertToLowercase(mappedFields.fields()));
    }

    private static List<MappedField> convertToLowercase(List<MappedField> fields) {
        return (List)fields.stream().map(mappedField -> {
            Set lowercaseNames = (Set)mappedField.names().stream().map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
            return MappedField.of((Integer)mappedField.id(), (Iterable)lowercaseNames, (MappedFields)IcebergPageSourceProvider.convertToLowercase(mappedField.nestedMapping()));
        }).collect(ImmutableList.toImmutableList());
    }

    private static List<IcebergColumnHandle> projectSufficientColumns(List<IcebergColumnHandle> columns) {
        Objects.requireNonNull(columns, "columns is null");
        if (columns.stream().allMatch(IcebergColumnHandle::isBaseColumn)) {
            return columns;
        }
        ImmutableBiMap.Builder dereferenceChainsBuilder = ImmutableBiMap.builder();
        for (IcebergColumnHandle column : columns) {
            DereferenceChain dereferenceChain = new DereferenceChain(column.getBaseColumnIdentity(), column.getPath());
            dereferenceChainsBuilder.put((Object)dereferenceChain, (Object)column);
        }
        ImmutableBiMap dereferenceChains = dereferenceChainsBuilder.build();
        ArrayList<IcebergColumnHandle> sufficientColumns = new ArrayList<IcebergColumnHandle>();
        HashMap<DereferenceChain, Integer> pickedColumns = new HashMap<DereferenceChain, Integer>();
        for (IcebergColumnHandle columnHandle : columns) {
            DereferenceChain dereferenceChain = Objects.requireNonNull((DereferenceChain)dereferenceChains.inverse().get((Object)columnHandle));
            DereferenceChain chosenColumn = null;
            for (DereferenceChain prefix : dereferenceChain.orderedPrefixes()) {
                if (!dereferenceChains.containsKey((Object)prefix)) continue;
                chosenColumn = prefix;
                break;
            }
            Preconditions.checkState((chosenColumn != null ? 1 : 0) != 0, (Object)"chosenColumn is null");
            if (pickedColumns.containsKey(chosenColumn)) continue;
            sufficientColumns.add((IcebergColumnHandle)dereferenceChains.get((Object)chosenColumn));
            pickedColumns.put(chosenColumn, sufficientColumns.size() - 1);
        }
        return sufficientColumns;
    }

    private static Optional<org.apache.parquet.schema.Type> getColumnType(IcebergColumnHandle column, Map<Integer, org.apache.parquet.schema.Type> parquetIdToField) {
        Optional<org.apache.parquet.schema.Type> baseColumnType = Optional.ofNullable(parquetIdToField.get(column.getBaseColumn().getId()));
        if (baseColumnType.isEmpty() || column.getPath().isEmpty()) {
            return baseColumnType;
        }
        GroupType baseType = baseColumnType.get().asGroupType();
        List subfieldTypes = (List)column.getPath().stream().filter(parquetIdToField::containsKey).map(parquetIdToField::get).collect(ImmutableList.toImmutableList());
        if (subfieldTypes.isEmpty()) {
            return Optional.empty();
        }
        org.apache.parquet.schema.Type type = (org.apache.parquet.schema.Type)subfieldTypes.getLast();
        for (int i = subfieldTypes.size() - 2; i >= 0; --i) {
            GroupType groupType = ((org.apache.parquet.schema.Type)subfieldTypes.get(i)).asGroupType();
            type = new GroupType(groupType.getRepetition(), groupType.getName(), (List)ImmutableList.of((Object)type));
        }
        return Optional.of(new GroupType(baseType.getRepetition(), baseType.getName(), (List)ImmutableList.of((Object)type)));
    }

    @VisibleForTesting
    static TupleDomain<ColumnDescriptor> getParquetTupleDomain(Map<List<String>, ColumnDescriptor> descriptorsByPath, TupleDomain<IcebergColumnHandle> effectivePredicate) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        Map descriptorsById = (Map)descriptorsByPath.values().stream().filter(descriptor -> descriptor.getPrimitiveType().getId() != null).collect(ImmutableMap.toImmutableMap(descriptor -> descriptor.getPrimitiveType().getId().intValue(), Function.identity()));
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        ((Map)effectivePredicate.getDomains().orElseThrow()).forEach((columnHandle, domain) -> {
            ColumnDescriptor descriptor;
            ColumnIdentity columnIdentity = columnHandle.getColumnIdentity();
            if (ColumnIdentity.TypeCategory.PRIMITIVE == columnIdentity.getTypeCategory() && (descriptor = (ColumnDescriptor)descriptorsById.get(columnHandle.getId())) != null) {
                predicate.put((Object)descriptor, domain);
            }
        });
        return TupleDomain.withColumnDomains((Map)predicate.buildOrThrow());
    }

    private static TrinoException handleException(OrcDataSourceId dataSourceId, Exception exception) {
        if (exception instanceof TrinoException) {
            TrinoException trinoException = (TrinoException)((Object)exception);
            return trinoException;
        }
        if (exception instanceof OrcCorruptionException) {
            return new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)exception);
        }
        return new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CURSOR_ERROR, String.format("Failed to read ORC file: %s", dataSourceId), (Throwable)exception);
    }

    private static TrinoException handleException(ParquetDataSourceId dataSourceId, Exception exception) {
        if (exception instanceof TrinoException) {
            TrinoException trinoException = (TrinoException)((Object)exception);
            return trinoException;
        }
        if (exception instanceof ParquetCorruptionException) {
            return new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)exception);
        }
        return new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CURSOR_ERROR, String.format("Failed to read Parquet file: %s", dataSourceId), (Throwable)exception);
    }

    private static /* synthetic */ SourcePage lambda$createPageSource$5(Supplier deletePredicate, List icebergColumns, SourcePage page) {
        try {
            Optional rowPredicate = (Optional)deletePredicate.get();
            rowPredicate.ifPresent(predicate -> predicate.applyFilter(page));
            if (icebergColumns.size() == page.getChannelCount()) {
                return page;
            }
            return new PrefixColumnsSourcePage(page, icebergColumns.size());
        }
        catch (RuntimeException e) {
            Throwables.throwIfInstanceOf((Throwable)e, TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, (Throwable)e);
        }
    }

    public record ReaderPageSourceWithRowPositions(ConnectorPageSource pageSource, Optional<Long> startRowPosition, Optional<Long> endRowPosition) {
        public ReaderPageSourceWithRowPositions {
            Objects.requireNonNull(pageSource, "pageSource is null");
            Objects.requireNonNull(startRowPosition, "startRowPosition is null");
            Objects.requireNonNull(endRowPosition, "endRowPosition is null");
        }
    }

    private record PartitionKey(int specId, StructLikeWrapper partitionData) {
    }

    private record MergeRowIdTransform(VariableWidthBlock filePath, IntArrayBlock partitionSpecId, VariableWidthBlock partitionData) implements Function<SourcePage, Block>
    {
        private static Function<SourcePage, Block> create(Slice filePath, int partitionSpecId, Slice partitionData) {
            return new MergeRowIdTransform(new VariableWidthBlock(1, filePath, new int[]{0, filePath.length()}, Optional.empty()), new IntArrayBlock(1, Optional.empty(), new int[]{partitionSpecId}), new VariableWidthBlock(1, partitionData, new int[]{0, partitionData.length()}, Optional.empty()));
        }

        @Override
        public Block apply(SourcePage page) {
            Block rowPosition = page.getBlock(page.getChannelCount() - 1);
            Block[] fields = new Block[]{RunLengthEncodedBlock.create((Block)this.filePath, (int)rowPosition.getPositionCount()), rowPosition, RunLengthEncodedBlock.create((Block)this.partitionSpecId, (int)rowPosition.getPositionCount()), RunLengthEncodedBlock.create((Block)this.partitionData, (int)rowPosition.getPositionCount())};
            return RowBlock.fromFieldBlocks((int)rowPosition.getPositionCount(), (Block[])fields);
        }
    }

    private record GetRowPositionFromSource() implements Function<SourcePage, Block>
    {
        @Override
        public Block apply(SourcePage page) {
            return page.getBlock(page.getChannelCount() - 1);
        }
    }

    private static class IcebergOrcProjectedLayout
    implements OrcReader.ProjectedLayout {
        private final Map<Integer, OrcReader.ProjectedLayout> projectedLayoutForFieldId;

        private IcebergOrcProjectedLayout(Map<Integer, OrcReader.ProjectedLayout> projectedLayoutForFieldId) {
            this.projectedLayoutForFieldId = ImmutableMap.copyOf(Objects.requireNonNull(projectedLayoutForFieldId, "projectedLayoutForFieldId is null"));
        }

        public static OrcReader.ProjectedLayout createProjectedLayout(OrcColumn root, List<List<Integer>> fieldIdDereferences) {
            if (fieldIdDereferences.stream().anyMatch(List::isEmpty)) {
                return OrcReader.fullyProjectedLayout();
            }
            Map dereferencesByField = fieldIdDereferences.stream().collect(Collectors.groupingBy(List::getFirst, Collectors.mapping(sequence -> sequence.subList(1, sequence.size()), Collectors.toUnmodifiableList())));
            ImmutableMap.Builder fieldLayouts = ImmutableMap.builder();
            for (OrcColumn nestedColumn : root.getNestedColumns()) {
                Integer fieldId = IcebergPageSourceProvider.getIcebergFieldId(nestedColumn);
                if (!dereferencesByField.containsKey(fieldId)) continue;
                fieldLayouts.put((Object)fieldId, (Object)IcebergOrcProjectedLayout.createProjectedLayout(nestedColumn, dereferencesByField.get(fieldId)));
            }
            return new IcebergOrcProjectedLayout((Map<Integer, OrcReader.ProjectedLayout>)fieldLayouts.buildOrThrow());
        }

        public OrcReader.ProjectedLayout getFieldLayout(OrcColumn orcColumn) {
            int fieldId = IcebergPageSourceProvider.getIcebergFieldId(orcColumn);
            return this.projectedLayoutForFieldId.getOrDefault(fieldId, OrcReader.fullyProjectedLayout());
        }
    }

    private static class IdBasedFieldMapperFactory
    implements OrcReader.FieldMapperFactory {
        private final Map<Integer, Map<String, Integer>> fieldNameToIdMappingForTableColumns;

        public IdBasedFieldMapperFactory(List<IcebergColumnHandle> columns) {
            Objects.requireNonNull(columns, "columns is null");
            ImmutableMap.Builder mapping = ImmutableMap.builder();
            for (IcebergColumnHandle column : columns) {
                if (column.isMergeRowIdColumn()) continue;
                IdBasedFieldMapperFactory.populateMapping(column.getColumnIdentity(), (ImmutableMap.Builder<Integer, Map<String, Integer>>)mapping);
            }
            this.fieldNameToIdMappingForTableColumns = mapping.buildOrThrow();
        }

        public OrcReader.FieldMapper create(OrcColumn column) {
            ImmutableMap nestedColumns = Maps.uniqueIndex((Iterable)column.getNestedColumns(), IcebergPageSourceProvider::getIcebergFieldId);
            int icebergId = IcebergPageSourceProvider.getIcebergFieldId(column);
            return new IdBasedFieldMapper((Map<Integer, OrcColumn>)nestedColumns, this.fieldNameToIdMappingForTableColumns.get(icebergId));
        }

        private static void populateMapping(ColumnIdentity identity, ImmutableMap.Builder<Integer, Map<String, Integer>> fieldNameToIdMappingForTableColumns) {
            List<ColumnIdentity> children = identity.getChildren();
            fieldNameToIdMappingForTableColumns.put((Object)identity.getId(), (Object)((Map)children.stream().collect(ImmutableMap.toImmutableMap(child -> child.getName().toLowerCase(Locale.ENGLISH), ColumnIdentity::getId))));
            for (ColumnIdentity child2 : children) {
                IdBasedFieldMapperFactory.populateMapping(child2, fieldNameToIdMappingForTableColumns);
            }
        }
    }

    private static class DereferenceChain {
        private final ColumnIdentity baseColumnIdentity;
        private final List<Integer> path;

        public DereferenceChain(ColumnIdentity baseColumnIdentity, List<Integer> path) {
            this.baseColumnIdentity = Objects.requireNonNull(baseColumnIdentity, "baseColumnIdentity is null");
            this.path = ImmutableList.copyOf((Collection)Objects.requireNonNull(path, "path is null"));
        }

        public Iterable<DereferenceChain> orderedPrefixes() {
            return () -> new AbstractIterator<DereferenceChain>(){
                private int prefixLength;

                public DereferenceChain computeNext() {
                    if (this.prefixLength > path.size()) {
                        return (DereferenceChain)this.endOfData();
                    }
                    return new DereferenceChain(baseColumnIdentity, path.subList(0, this.prefixLength++));
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DereferenceChain that = (DereferenceChain)o;
            return Objects.equals(this.baseColumnIdentity, that.baseColumnIdentity) && Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return Objects.hash(this.baseColumnIdentity, this.path);
        }
    }

    private record PrefixColumnsSourcePage(SourcePage sourcePage, int channelCount, int[] channels) implements SourcePage
    {
        private static final long INSTANCE_SIZE = SizeOf.instanceSize(PrefixColumnsSourcePage.class);

        private PrefixColumnsSourcePage {
            Objects.requireNonNull(sourcePage, "sourcePage is null");
            Preconditions.checkArgument((channelCount >= 0 ? 1 : 0) != 0, (Object)"channelCount is negative");
            Preconditions.checkArgument((channelCount < sourcePage.getChannelCount() ? 1 : 0) != 0, (Object)"channelCount is greater than or equal to sourcePage channel count");
            Preconditions.checkArgument((channels.length == channelCount ? 1 : 0) != 0, (Object)"channels length does not match channelCount");
        }

        private PrefixColumnsSourcePage(SourcePage sourcePage, int channelCount) {
            this(sourcePage, channelCount, IntStream.range(0, channelCount).toArray());
        }

        public int getPositionCount() {
            return this.sourcePage.getPositionCount();
        }

        public long getSizeInBytes() {
            return this.sourcePage.getSizeInBytes();
        }

        public long getRetainedSizeInBytes() {
            return INSTANCE_SIZE + SizeOf.sizeOf((int[])this.channels) + this.sourcePage.getRetainedSizeInBytes();
        }

        public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
            consumer.accept(this, INSTANCE_SIZE);
            consumer.accept(this.channels, SizeOf.sizeOf((int[])this.channels));
            this.sourcePage.retainedBytesForEachPart(consumer);
        }

        public int getChannelCount() {
            return this.channelCount;
        }

        public Block getBlock(int channel) {
            Objects.checkIndex(channel, this.channelCount);
            return this.sourcePage.getBlock(channel);
        }

        public Page getPage() {
            return this.sourcePage.getColumns(this.channels);
        }

        public Page getColumns(int[] channels) {
            for (int channel : channels) {
                Objects.checkIndex(channel, this.channelCount);
            }
            return this.sourcePage.getColumns(channels);
        }

        public void selectPositions(int[] positions, int offset, int size) {
            this.sourcePage.selectPositions(positions, offset, size);
        }
    }

    private static class IdBasedFieldMapper
    implements OrcReader.FieldMapper {
        private final Map<Integer, OrcColumn> idToColumnMappingForFile;
        private final Map<String, Integer> nameToIdMappingForTableColumns;

        public IdBasedFieldMapper(Map<Integer, OrcColumn> idToColumnMappingForFile, Map<String, Integer> nameToIdMappingForTableColumns) {
            this.idToColumnMappingForFile = Objects.requireNonNull(idToColumnMappingForFile, "idToColumnMappingForFile is null");
            this.nameToIdMappingForTableColumns = Objects.requireNonNull(nameToIdMappingForTableColumns, "nameToIdMappingForTableColumns is null");
        }

        public OrcColumn get(String fieldName) {
            int fieldId = Objects.requireNonNull(this.nameToIdMappingForTableColumns.get(fieldName), () -> String.format("Id mapping for field %s not found", fieldName));
            return this.idToColumnMappingForFile.get(fieldId);
        }
    }
}

