/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.iceberg;

import com.google.inject.Inject;
import io.trino.orc.OrcReaderOptions;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.iceberg.IcebergFileSystemFactory;
import io.trino.plugin.iceberg.IcebergPageSourceProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorPageSourceProviderFactory;
import io.trino.spi.type.TypeManager;
import java.util.Objects;

public class IcebergPageSourceProviderFactory
implements ConnectorPageSourceProviderFactory {
    private final IcebergFileSystemFactory fileSystemFactory;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final OrcReaderOptions orcReaderOptions;
    private final ParquetReaderOptions parquetReaderOptions;
    private final TypeManager typeManager;

    @Inject
    public IcebergPageSourceProviderFactory(IcebergFileSystemFactory fileSystemFactory, FileFormatDataSourceStats fileFormatDataSourceStats, OrcReaderConfig orcReaderConfig, ParquetReaderConfig parquetReaderConfig, TypeManager typeManager) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.orcReaderOptions = orcReaderConfig.toOrcReaderOptions();
        this.parquetReaderOptions = parquetReaderConfig.toParquetReaderOptions();
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorPageSourceProvider createPageSourceProvider() {
        return new IcebergPageSourceProvider(this.fileSystemFactory, this.fileFormatDataSourceStats, this.orcReaderOptions, this.parquetReaderOptions, this.typeManager);
    }
}

